/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.util;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTTransferHandler {
    private static final int TRANSFER_QUEUE_MAX = 128;
    private static final long MAX_TRANSFER_QUEUE_BYTES = 0x800000L;
    private static final long WRITE_XFER_RESEND_DELAY_BASE = 12500L;
    private static final long READ_XFER_REREQUEST_DELAY_BASE = 5000L;
    private static final long WRITE_REPLY_TIMEOUT_BASE = 60000L;
    private final long WRITE_XFER_RESEND_DELAY;
    private final long READ_XFER_REREQUEST_DELAY;
    private final long WRITE_REPLY_TIMEOUT;
    private static boolean XFER_TRACE = false;
    private Map<HashWrapper, transferHandlerInterceptor> transfer_handlers = new HashMap<HashWrapper, transferHandlerInterceptor>();
    private Map<Long, transferQueue> read_transfers = new HashMap<Long, transferQueue>();
    private Map<Long, transferQueue> write_transfers = new HashMap<Long, transferQueue>();
    private long last_xferq_log;
    private int active_write_queue_processor_count;
    private long total_bytes_on_transfer_queues;
    private Map<HashWrapper, Object> call_transfers = new HashMap<HashWrapper, Object>();
    private final Adapter adapter;
    private final int max_data;
    private final DHTLogger logger;
    private AEMonitor this_mon = new AEMonitor("DHTTransferHandler");

    public DHTTransferHandler(Adapter _adapter, int _max_data, DHTLogger _logger) {
        this(_adapter, _max_data, 2.0f, _logger);
    }

    public DHTTransferHandler(Adapter _adapter, int _max_data, float _latency_indicator, DHTLogger _logger) {
        this.adapter = _adapter;
        this.max_data = _max_data;
        this.logger = _logger;
        this.WRITE_XFER_RESEND_DELAY = (long)(_latency_indicator * 12500.0f);
        this.READ_XFER_REREQUEST_DELAY = (long)(_latency_indicator * 5000.0f);
        this.WRITE_REPLY_TIMEOUT = (long)(_latency_indicator * 60000.0f);
    }

    public void registerTransferHandler(byte[] handler_key, DHTTransportTransferHandler handler) {
        this.registerTransferHandler(handler_key, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTransferHandler(byte[] handler_key, DHTTransportTransferHandler handler, Map<String, Object> options) {
        if (XFER_TRACE) {
            this.logger.log("Transfer handler (" + handler.getName() + ") registered for key '" + ByteFormatter.encodeString(handler_key));
        }
        Map<HashWrapper, transferHandlerInterceptor> map = this.transfer_handlers;
        synchronized (map) {
            transferHandlerInterceptor existing = this.transfer_handlers.put(new HashWrapper(handler_key), new transferHandlerInterceptor(handler, options));
            if (existing != null) {
                Debug.out("Duplicate transfer handler: existing=" + existing.getName() + ", new=" + handler.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTransferHandler(byte[] handler_key, DHTTransportTransferHandler handler) {
        if (XFER_TRACE) {
            this.logger.log("Transfer handler (" + handler.getName() + ") unregistered for key '" + ByteFormatter.encodeString(handler_key));
        }
        Map<HashWrapper, transferHandlerInterceptor> map = this.transfer_handlers;
        synchronized (map) {
            this.transfer_handlers.remove(new HashWrapper(handler_key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int handleTransferRequest(DHTTransportContact target, long connection_id, byte[] transfer_key, byte[] request_key, byte[] data, int start, int length, boolean write_request, boolean first_packet_only) throws DHTTransportException {
        transferHandlerInterceptor handler;
        Map<HashWrapper, transferHandlerInterceptor> map = this.transfer_handlers;
        synchronized (map) {
            handler = this.transfer_handlers.get(new HashWrapper(transfer_key));
        }
        if (handler == null) {
            return -1;
        }
        if (data == null) {
            data = handler.handleRead(target, request_key);
        }
        if (data == null) {
            return -1;
        }
        if (data.length == 0) {
            if (write_request) {
                this.sendWriteRequest(connection_id, target, transfer_key, request_key, data, 0, 0, 0);
            } else {
                this.sendReadReply(connection_id, target, transfer_key, request_key, data, 0, 0, 0);
            }
        } else {
            if (start < 0) {
                start = 0;
            } else if (start >= data.length) {
                this.logger.log("dataRequest: invalid start position");
                return data.length;
            }
            if (length <= 0) {
                length = data.length;
            } else if (start + length > data.length) {
                this.logger.log("dataRequest: invalid length");
                return data.length;
            }
            int end = start + length;
            while (start < end) {
                int chunk = end - start;
                if (chunk > this.max_data) {
                    chunk = this.max_data;
                }
                if (write_request) {
                    this.sendWriteRequest(connection_id, target, transfer_key, request_key, data, start, chunk, data.length);
                    if (first_packet_only) {
                        break;
                    }
                } else {
                    this.sendReadReply(connection_id, target, transfer_key, request_key, data, start, chunk, data.length);
                }
                start += chunk;
            }
        }
        return data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivePacket(final DHTTransportContact originator, final Packet req) {
        block30: {
            byte packet_type = req.getPacketType();
            if (XFER_TRACE) {
                System.out.println("dataRequest: originator=" + originator.getAddress() + ",packet=" + req.getString());
            }
            if (packet_type == 1) {
                transferQueue queue = this.lookupTransferQueue(this.read_transfers, req.getConnectionId());
                if (queue != null) {
                    queue.add(req);
                }
            } else if (packet_type == 3) {
                transferQueue queue = this.lookupTransferQueue(this.write_transfers, req.getConnectionId());
                if (queue != null) {
                    queue.add(req);
                }
            } else {
                byte[] transfer_key = req.getTransferKey();
                if (packet_type == 0) {
                    try {
                        this.handleTransferRequest(originator, req.getConnectionId(), transfer_key, req.getRequestKey(), null, req.getStartPosition(), req.getLength(), false, false);
                    }
                    catch (DHTTransportException e) {
                        this.logger.log(e);
                    }
                } else {
                    transferQueue old_queue = this.lookupTransferQueue(this.read_transfers, req.getConnectionId());
                    if (old_queue != null) {
                        old_queue.add(req);
                    } else {
                        transferHandlerInterceptor handler;
                        Map<HashWrapper, transferHandlerInterceptor> map = this.transfer_handlers;
                        synchronized (map) {
                            handler = this.transfer_handlers.get(new HashWrapper(transfer_key));
                        }
                        if (handler != null) {
                            try {
                                int req_total_len = req.getTotalLength();
                                if (handler.getBooleanOption("disable_call_acks", false) && req_total_len == req.getLength()) {
                                    byte[] reply_data;
                                    byte[] write_data = req.getData();
                                    if (write_data.length != req_total_len) {
                                        byte[] temp = new byte[req_total_len];
                                        System.arraycopy(write_data, 0, temp, 0, req_total_len);
                                        write_data = temp;
                                    }
                                    if ((reply_data = handler.handleWrite(originator, req.getConnectionId(), req.getRequestKey(), write_data)) == null) break block30;
                                    if (reply_data.length <= this.max_data) {
                                        long write_connection_id = this.adapter.getConnectionID();
                                        this.sendWriteRequest(write_connection_id, originator, transfer_key, req.getRequestKey(), reply_data, 0, reply_data.length, reply_data.length);
                                        break block30;
                                    }
                                    try {
                                        this.this_mon.enter();
                                        if (this.active_write_queue_processor_count >= 128) {
                                            throw new DHTTransportException("Active write queue process thread limit exceeded");
                                        }
                                        ++this.active_write_queue_processor_count;
                                        if (XFER_TRACE) {
                                            System.out.println("active_write_queue_processor_count=" + this.active_write_queue_processor_count);
                                        }
                                        Object var13_19 = null;
                                        this.this_mon.exit();
                                    }
                                    catch (Throwable throwable) {
                                        Object var13_20 = null;
                                        this.this_mon.exit();
                                        throw throwable;
                                    }
                                    new AEThread2("DHTTransportUDP:writeQueueProcessor", true){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         * Enabled aggressive block sorting
                                         * Enabled unnecessary exception pruning
                                         * Enabled aggressive exception aggregation
                                         */
                                        public void run() {
                                            try {
                                                try {
                                                    DHTTransferHandler.this.writeTransfer(new DHTTransportProgressListener(){

                                                        public void reportSize(long size) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXferReply: size=" + size);
                                                            }
                                                        }

                                                        public void reportActivity(String str) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXferReply: act=" + str);
                                                            }
                                                        }

                                                        public void reportCompleteness(int percent) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXferReply: %=" + percent);
                                                            }
                                                        }
                                                    }, originator, req.getTransferKey(), req.getRequestKey(), reply_data, DHTTransferHandler.this.WRITE_REPLY_TIMEOUT);
                                                }
                                                catch (DHTTransportException e) {
                                                    DHTTransferHandler.this.logger.log("Failed to process transfer queue: " + Debug.getNestedExceptionMessage(e));
                                                    Object var3_2 = null;
                                                    try {}
                                                    catch (Throwable throwable) {
                                                        Object var5_7 = null;
                                                        DHTTransferHandler.this.this_mon.exit();
                                                        throw throwable;
                                                    }
                                                    DHTTransferHandler.this.this_mon.enter();
                                                    DHTTransferHandler.this.active_write_queue_processor_count--;
                                                    if (XFER_TRACE) {
                                                        System.out.println("active_write_queue_processor_count=" + DHTTransferHandler.this.active_write_queue_processor_count);
                                                    }
                                                    Object var5_6 = null;
                                                    DHTTransferHandler.this.this_mon.exit();
                                                    return;
                                                }
                                                Object var3_1 = null;
                                                try {
                                                    DHTTransferHandler.this.this_mon.enter();
                                                    DHTTransferHandler.this.active_write_queue_processor_count--;
                                                    if (XFER_TRACE) {
                                                        System.out.println("active_write_queue_processor_count=" + DHTTransferHandler.this.active_write_queue_processor_count);
                                                    }
                                                    Object var5_4 = null;
                                                    DHTTransferHandler.this.this_mon.exit();
                                                    return;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var5_5 = null;
                                                    DHTTransferHandler.this.this_mon.exit();
                                                    throw throwable;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var3_3 = null;
                                                try {}
                                                catch (Throwable throwable2) {
                                                    Object var5_9 = null;
                                                    DHTTransferHandler.this.this_mon.exit();
                                                    throw throwable2;
                                                }
                                                DHTTransferHandler.this.this_mon.enter();
                                                DHTTransferHandler.this.active_write_queue_processor_count--;
                                                if (XFER_TRACE) {
                                                    System.out.println("active_write_queue_processor_count=" + DHTTransferHandler.this.active_write_queue_processor_count);
                                                }
                                                Object var5_8 = null;
                                                DHTTransferHandler.this.this_mon.exit();
                                                throw throwable;
                                            }
                                        }
                                    }.start();
                                    this.sendWriteReply(req.getConnectionId(), originator, req.getTransferKey(), req.getRequestKey(), req.getStartPosition(), req.getLength());
                                    break block30;
                                }
                                final transferQueue new_queue = new transferQueue(this.read_transfers, req.getConnectionId());
                                new_queue.add(req);
                                try {
                                    this.this_mon.enter();
                                    if (this.active_write_queue_processor_count >= 128) {
                                        new_queue.destroy();
                                        throw new DHTTransportException("Active write queue process thread limit exceeded");
                                    }
                                    ++this.active_write_queue_processor_count;
                                    if (XFER_TRACE) {
                                        System.out.println("active_write_queue_processor_count=" + this.active_write_queue_processor_count);
                                    }
                                    Object var15_22 = null;
                                    this.this_mon.exit();
                                }
                                catch (Throwable throwable) {
                                    Object var15_23 = null;
                                    this.this_mon.exit();
                                    throw throwable;
                                }
                                new AEThread2("DHTTransportUDP:writeQueueProcessor", true){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     * Enabled aggressive block sorting
                                     * Enabled unnecessary exception pruning
                                     * Enabled aggressive exception aggregation
                                     */
                                    public void run() {
                                        try {
                                            block12: {
                                                try {
                                                    byte[] reply_data;
                                                    byte[] write_data = DHTTransferHandler.this.runTransferQueue(new_queue, new DHTTransportProgressListener(){

                                                        public void reportSize(long size) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXfer: size=" + size);
                                                            }
                                                        }

                                                        public void reportActivity(String str) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXfer: act=" + str);
                                                            }
                                                        }

                                                        public void reportCompleteness(int percent) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXfer: %=" + percent);
                                                            }
                                                        }
                                                    }, originator, req.getTransferKey(), req.getRequestKey(), 60000L, false);
                                                    if (write_data == null) break block12;
                                                    if (req.getStartPosition() != 0 || req.getLength() != req.getTotalLength()) {
                                                        DHTTransferHandler.this.sendWriteReply(req.getConnectionId(), originator, req.getTransferKey(), req.getRequestKey(), 0, req.getTotalLength());
                                                    }
                                                    if ((reply_data = handler.handleWrite(originator, req.getConnectionId(), req.getRequestKey(), write_data)) == null) break block12;
                                                    DHTTransferHandler.this.writeTransfer(new DHTTransportProgressListener(){

                                                        public void reportSize(long size) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXferReply: size=" + size);
                                                            }
                                                        }

                                                        public void reportActivity(String str) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXferReply: act=" + str);
                                                            }
                                                        }

                                                        public void reportCompleteness(int percent) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXferReply: %=" + percent);
                                                            }
                                                        }
                                                    }, originator, req.getTransferKey(), req.getRequestKey(), reply_data, DHTTransferHandler.this.WRITE_REPLY_TIMEOUT);
                                                }
                                                catch (DHTTransportException e) {
                                                    DHTTransferHandler.this.logger.log("Failed to process transfer queue: " + Debug.getNestedExceptionMessage(e));
                                                    Object var4_5 = null;
                                                    try {}
                                                    catch (Throwable throwable) {
                                                        Object var6_10 = null;
                                                        DHTTransferHandler.this.this_mon.exit();
                                                        throw throwable;
                                                    }
                                                    DHTTransferHandler.this.this_mon.enter();
                                                    DHTTransferHandler.this.active_write_queue_processor_count--;
                                                    if (XFER_TRACE) {
                                                        System.out.println("active_write_queue_processor_count=" + DHTTransferHandler.this.active_write_queue_processor_count);
                                                    }
                                                    Object var6_9 = null;
                                                    DHTTransferHandler.this.this_mon.exit();
                                                    return;
                                                }
                                            }
                                            Object var4_4 = null;
                                            try {
                                                DHTTransferHandler.this.this_mon.enter();
                                                DHTTransferHandler.this.active_write_queue_processor_count--;
                                                if (XFER_TRACE) {
                                                    System.out.println("active_write_queue_processor_count=" + DHTTransferHandler.this.active_write_queue_processor_count);
                                                }
                                                Object var6_7 = null;
                                                DHTTransferHandler.this.this_mon.exit();
                                                return;
                                            }
                                            catch (Throwable throwable) {
                                                Object var6_8 = null;
                                                DHTTransferHandler.this.this_mon.exit();
                                                throw throwable;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var4_6 = null;
                                            try {}
                                            catch (Throwable throwable2) {
                                                Object var6_12 = null;
                                                DHTTransferHandler.this.this_mon.exit();
                                                throw throwable2;
                                            }
                                            DHTTransferHandler.this.this_mon.enter();
                                            DHTTransferHandler.this.active_write_queue_processor_count--;
                                            if (XFER_TRACE) {
                                                System.out.println("active_write_queue_processor_count=" + DHTTransferHandler.this.active_write_queue_processor_count);
                                            }
                                            Object var6_11 = null;
                                            DHTTransferHandler.this.this_mon.exit();
                                            throw throwable;
                                        }
                                    }
                                }.start();
                                this.sendWriteReply(req.getConnectionId(), originator, req.getTransferKey(), req.getRequestKey(), req.getStartPosition(), req.getLength());
                            }
                            catch (DHTTransportException e) {
                                long now = SystemTime.getMonotonousTime();
                                if (this.last_xferq_log != 0L && now - this.last_xferq_log <= 300000L) break block30;
                                this.last_xferq_log = now;
                                this.logger.log("Failed to create transfer queue");
                                this.logger.log(e);
                            }
                        }
                    }
                }
            }
        }
    }

    public byte[] readTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] key, long timeout) throws DHTTransportException {
        long connection_id = this.adapter.getConnectionID();
        transferQueue transfer_queue = new transferQueue(this.read_transfers, connection_id);
        return this.runTransferQueue(transfer_queue, listener, target, handler_key, key, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] runTransferQueue(transferQueue transfer_queue, DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] key, long timeout, boolean read_transfer) throws DHTTransportException {
        byte[] byArray;
        block21: {
            Iterator it;
            block20: {
                TreeSet<Packet> packets = new TreeSet<Packet>(new Comparator<Packet>(){

                    @Override
                    public int compare(Packet p1, Packet p2) {
                        return p1.getStartPosition() - p2.getStartPosition();
                    }
                });
                int entire_request_count = 0;
                int transfer_size = -1;
                int transferred = 0;
                String target_name = DHTLog.getString2(target.getID());
                try {
                    long start = SystemTime.getCurrentTime();
                    if (read_transfer) {
                        listener.reportActivity(this.getMessageText("request_all", target_name));
                        ++entire_request_count;
                        this.sendReadRequest(transfer_queue.getConnectionID(), target, handler_key, key, 0, 0);
                    } else {
                        ++entire_request_count;
                    }
                    block2: while (SystemTime.getCurrentTime() - start <= timeout) {
                        Packet reply = transfer_queue.receive(this.READ_XFER_REREQUEST_DELAY);
                        if (reply != null) {
                            if (transfer_size == -1) {
                                transfer_size = reply.getTotalLength();
                                listener.reportSize(transfer_size);
                            }
                            it = packets.iterator();
                            boolean duplicate = false;
                            while (it.hasNext()) {
                                Packet p = (Packet)it.next();
                                if (p.getStartPosition() >= reply.getStartPosition() + reply.getLength() || p.getStartPosition() + p.getLength() <= reply.getStartPosition()) continue;
                                duplicate = true;
                                break;
                            }
                            if (duplicate) continue;
                            listener.reportActivity(this.getMessageText("received_bit", new String[]{String.valueOf(reply.getStartPosition()), String.valueOf(reply.getStartPosition() + reply.getLength()), target_name}));
                            listener.reportCompleteness(transfer_size == 0 ? 100 : 100 * (transferred += reply.getLength()) / transfer_size);
                            packets.add(reply);
                            it = packets.iterator();
                            int pos = 0;
                            int actual_end = -1;
                            while (it.hasNext()) {
                                Packet p = (Packet)it.next();
                                if (actual_end == -1) {
                                    actual_end = p.getTotalLength();
                                }
                                if (p.getStartPosition() != pos) continue block2;
                                if ((pos += p.getLength()) != actual_end) continue;
                                listener.reportActivity(this.getMessageText("complete"));
                                byte[] result = new byte[actual_end];
                                it = packets.iterator();
                                pos = 0;
                                while (true) {
                                    if (!it.hasNext()) {
                                        byte[] byArray2 = result;
                                        Object var25_25 = null;
                                        transfer_queue.destroy();
                                        return byArray2;
                                    }
                                    p = (Packet)it.next();
                                    System.arraycopy(p.getData(), 0, result, pos, p.getLength());
                                    pos += p.getLength();
                                }
                            }
                            continue;
                        }
                        if (packets.size() == 0) {
                            if (entire_request_count == 2) {
                                listener.reportActivity(this.getMessageText("timeout", target_name));
                                it = null;
                                break block20;
                            } else {
                                ++entire_request_count;
                                listener.reportActivity(this.getMessageText("rerequest_all", target_name));
                                this.sendReadRequest(transfer_queue.getConnectionID(), target, handler_key, key, 0, 0);
                                continue;
                            }
                        }
                        it = packets.iterator();
                        int pos = 0;
                        int actual_end = -1;
                        while (it.hasNext()) {
                            Packet p = (Packet)it.next();
                            if (actual_end == -1) {
                                actual_end = p.getTotalLength();
                            }
                            if (p.getStartPosition() != pos) {
                                listener.reportActivity(this.getMessageText("rerequest_bit", new String[]{String.valueOf(pos), String.valueOf(p.getStartPosition()), target_name}));
                                this.sendReadRequest(transfer_queue.getConnectionID(), target, handler_key, key, pos, p.getStartPosition() - pos);
                            }
                            pos = p.getStartPosition() + p.getLength();
                        }
                        if (pos == actual_end) continue;
                        listener.reportActivity(this.getMessageText("rerequest_bit", new String[]{String.valueOf(pos), String.valueOf(actual_end), target_name}));
                        this.sendReadRequest(transfer_queue.getConnectionID(), target, handler_key, key, pos, actual_end - pos);
                    }
                    if (packets.size() == 0) {
                        listener.reportActivity(this.getMessageText("timeout", target_name));
                    } else {
                        listener.reportActivity(this.getMessageText("timeout_some", new String[]{String.valueOf(packets.size()), target_name}));
                    }
                    byArray = null;
                    break block21;
                }
                catch (Throwable throwable) {
                    Object var25_28 = null;
                    transfer_queue.destroy();
                    throw throwable;
                }
            }
            Object var25_26 = null;
            transfer_queue.destroy();
            return it;
        }
        Object var25_27 = null;
        transfer_queue.destroy();
        return byArray;
    }

    public void writeTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] key, byte[] data, long timeout) throws DHTTransportException {
        long connection_id = this.adapter.getConnectionID();
        this.writeTransfer(listener, target, connection_id, handler_key, key, data, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTransfer(DHTTransportProgressListener listener, DHTTransportContact target, long connection_id, byte[] handler_key, byte[] key, byte[] data, long timeout) throws DHTTransportException {
        transferQueue transfer_queue = null;
        try {
            boolean ok;
            block9: {
                transfer_queue = new transferQueue(this.write_transfers, connection_id);
                ok = false;
                boolean reply_received = false;
                int loop = 0;
                int total_length = data.length;
                long start = SystemTime.getCurrentTime();
                long last_packet_time = 0L;
                while (true) {
                    Packet packet;
                    long now;
                    if ((now = SystemTime.getCurrentTime()) < start) {
                        start = now;
                        last_packet_time = 0L;
                    } else if (now - start > timeout) break block9;
                    long time_since_last_packet = now - last_packet_time;
                    if (time_since_last_packet >= this.WRITE_XFER_RESEND_DELAY) {
                        listener.reportActivity(this.getMessageText(loop == 0 ? "sending" : "resending"));
                        ++loop;
                        total_length = this.handleTransferRequest(target, connection_id, handler_key, key, data, -1, -1, true, reply_received);
                        last_packet_time = now;
                        time_since_last_packet = 0L;
                    }
                    if ((packet = transfer_queue.receive(this.WRITE_XFER_RESEND_DELAY - time_since_last_packet)) == null) continue;
                    last_packet_time = now;
                    reply_received = true;
                    if (packet.getStartPosition() == 0 && packet.getLength() == total_length) break;
                }
                ok = true;
            }
            if (!ok) {
                listener.reportActivity(this.getMessageText("send_timeout"));
                throw new DHTTransportException("Timeout");
            }
            listener.reportCompleteness(100);
            listener.reportActivity(this.getMessageText("send_complete"));
            Object var25_18 = null;
            if (transfer_queue != null) {
                transfer_queue.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var25_19 = null;
            if (transfer_queue != null) {
                transfer_queue.destroy();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public byte[] writeReadTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] transfer_key, byte[] data, long timeout) throws DHTTransportException {
        boolean removed;
        HashWrapper wrapped_key;
        block22: {
            long start;
            int retry_count;
            AESemaphore call_sem;
            byte[] call_key;
            long connection_id;
            block21: {
                Map<HashWrapper, transferHandlerInterceptor> map = this.transfer_handlers;
                // MONITORENTER : map
                transferHandlerInterceptor handler = this.transfer_handlers.get(new HashWrapper(transfer_key));
                // MONITOREXIT : map
                if (handler == null) {
                    return null;
                }
                boolean no_acks = handler.getBooleanOption("disable_call_acks", false) && data.length <= this.max_data;
                connection_id = this.adapter.getConnectionID();
                call_key = new byte[20];
                RandomUtils.SECURE_RANDOM.nextBytes(call_key);
                call_sem = new AESemaphore("DHTTransportUDP:calSem");
                wrapped_key = new HashWrapper(call_key);
                try {
                    this.this_mon.enter();
                    this.call_transfers.put(wrapped_key, new Object[]{call_sem, connection_id});
                    Object var15_13 = null;
                    this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var15_14 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
                removed = false;
                try {
                    block23: {
                        byte[] byArray;
                        if (no_acks) {
                            retry_count = 0;
                            break block21;
                        }
                        this.writeTransfer(listener, target, connection_id, transfer_key, call_key, data, timeout);
                        if (!call_sem.reserve(timeout)) break block22;
                        try {
                            this.this_mon.enter();
                            Object res = this.call_transfers.remove(wrapped_key);
                            removed = true;
                            if (!(res instanceof byte[])) break block23;
                            byArray = (byte[])res;
                            Object var25_43 = null;
                            this.this_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var25_45 = null;
                            this.this_mon.exit();
                            throw throwable;
                        }
                        Object var27_27 = null;
                        if (removed) return byArray;
                        try {
                            this.this_mon.enter();
                            this.call_transfers.remove(wrapped_key);
                            Object var29_32 = null;
                            this.this_mon.exit();
                            return byArray;
                        }
                        catch (Throwable throwable) {
                            Object var29_33 = null;
                            this.this_mon.exit();
                            throw throwable;
                        }
                    }
                    Object var25_44 = null;
                    this.this_mon.exit();
                    break block22;
                }
                catch (Throwable throwable) {
                    Object var27_29 = null;
                    if (removed) throw throwable;
                    try {}
                    catch (Throwable throwable2) {
                        Object var29_37 = null;
                        this.this_mon.exit();
                        throw throwable2;
                    }
                    this.this_mon.enter();
                    this.call_transfers.remove(wrapped_key);
                    Object var29_36 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            do {
                start = SystemTime.getMonotonousTime();
                this.sendWriteRequest(connection_id, target, transfer_key, call_key, data, 0, data.length, data.length);
                long timeout_to_use = Math.min(timeout, this.WRITE_XFER_RESEND_DELAY);
                if (call_sem.reserve(timeout_to_use)) {
                    block24: {
                        byte[] byArray;
                        try {
                            this.this_mon.enter();
                            Object res = this.call_transfers.remove(wrapped_key);
                            removed = true;
                            if (!(res instanceof byte[])) break block24;
                            byArray = (byte[])res;
                            Object var23_23 = null;
                            this.this_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var23_25 = null;
                            this.this_mon.exit();
                            throw throwable;
                        }
                        Object var27_26 = null;
                        if (removed) return byArray;
                        try {}
                        catch (Throwable throwable) {
                            Object var29_31 = null;
                            this.this_mon.exit();
                            throw throwable;
                        }
                        this.this_mon.enter();
                        this.call_transfers.remove(wrapped_key);
                        Object var29_30 = null;
                        this.this_mon.exit();
                        return byArray;
                    }
                    Object var23_24 = null;
                    this.this_mon.exit();
                    break;
                }
                if (retry_count > 0) break;
                ++retry_count;
            } while ((timeout -= SystemTime.getMonotonousTime() - start) >= 1000L);
        }
        Object var27_28 = null;
        if (removed) throw new DHTTransportException("timeout");
        try {}
        catch (Throwable throwable) {
            Object var29_35 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.this_mon.enter();
        this.call_transfers.remove(wrapped_key);
        Object var29_34 = null;
        this.this_mon.exit();
        throw new DHTTransportException("timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected transferQueue lookupTransferQueue(Map<Long, transferQueue> transfers, long id) {
        try {
            this.this_mon.enter();
            transferQueue transferQueue2 = transfers.get(new Long(id));
            Object var6_4 = null;
            this.this_mon.exit();
            return transferQueue2;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected String getMessageText(String resource) {
        return MessageText.getString("DHTTransport.report." + resource);
    }

    protected String getMessageText(String resource, String param) {
        return MessageText.getString("DHTTransport.report." + resource, new String[]{param});
    }

    protected String getMessageText(String resource, String[] params) {
        return MessageText.getString("DHTTransport.report." + resource, params);
    }

    public void sendReadRequest(long connection_id, DHTTransportContact contact, byte[] transfer_key, byte[] key, int start_pos, int len) {
        if (XFER_TRACE) {
            this.logger.log("Transfer read request: key = " + DHTLog.getFullString(key) + ", contact = " + contact.getString());
        }
        this.adapter.sendRequest(contact, new Packet(connection_id, 0, transfer_key, key, new byte[0], start_pos, len, 0));
    }

    public void sendReadReply(long connection_id, DHTTransportContact contact, byte[] transfer_key, byte[] key, byte[] data, int start_position, int length, int total_length) {
        if (XFER_TRACE) {
            this.logger.log("Transfer read reply: key = " + DHTLog.getFullString(key) + ", contact = " + contact.getString());
        }
        this.adapter.sendRequest(contact, new Packet(connection_id, 1, transfer_key, key, data, start_position, length, total_length));
    }

    public void sendWriteRequest(long connection_id, DHTTransportContact contact, byte[] transfer_key, byte[] key, byte[] data, int start_position, int length, int total_length) {
        if (XFER_TRACE) {
            this.logger.log("Transfer write request: key = " + DHTLog.getFullString(key) + ", contact = " + contact.getString());
        }
        this.adapter.sendRequest(contact, new Packet(connection_id, 2, transfer_key, key, data, start_position, length, total_length));
    }

    public void sendWriteReply(long connection_id, DHTTransportContact contact, byte[] transfer_key, byte[] key, int start_position, int length) {
        if (XFER_TRACE) {
            this.logger.log("Transfer write reply: key = " + DHTLog.getFullString(key) + ", contact = " + contact.getString());
        }
        this.adapter.sendRequest(contact, new Packet(connection_id, 3, transfer_key, key, new byte[0], start_position, length, 0));
    }

    public static interface Adapter {
        public long getConnectionID();

        public void sendRequest(DHTTransportContact var1, Packet var2);
    }

    public static class Packet {
        public static final byte PT_READ_REQUEST = 0;
        public static final byte PT_READ_REPLY = 1;
        public static final byte PT_WRITE_REQUEST = 2;
        public static final byte PT_WRITE_REPLY = 3;
        private long connection_id;
        private byte packet_type;
        private byte[] transfer_key;
        private byte[] key;
        private byte[] data;
        private int start_position;
        private int length;
        private int total_length;
        private int flags;

        public Packet(long _connection_id, byte _packet_type, byte[] _transfer_key, byte[] _key, byte[] _data, int _start_position, int _length, int _total_length) {
            this.connection_id = _connection_id;
            this.packet_type = _packet_type;
            this.transfer_key = _transfer_key;
            this.key = _key;
            this.data = _data;
            this.start_position = _start_position;
            this.length = _length;
            this.total_length = _total_length;
        }

        public Packet(long _connection_id, byte _packet_type, byte[] _transfer_key, byte[] _key, byte[] _data, int _start_position, int _length, int _total_length, int _flags) {
            this.connection_id = _connection_id;
            this.packet_type = _packet_type;
            this.transfer_key = _transfer_key;
            this.key = _key;
            this.data = _data;
            this.start_position = _start_position;
            this.length = _length;
            this.total_length = _total_length;
            this.flags = _flags;
        }

        public long getConnectionId() {
            return this.connection_id;
        }

        public byte getPacketType() {
            return this.packet_type;
        }

        public byte[] getTransferKey() {
            return this.transfer_key;
        }

        public byte[] getRequestKey() {
            return this.key;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getStartPosition() {
            return this.start_position;
        }

        public int getLength() {
            return this.length;
        }

        public int getTotalLength() {
            return this.total_length;
        }

        public int getFlags() {
            return this.flags;
        }

        public String getString() {
            return "tk=" + DHTLog.getString2(this.transfer_key) + ",rk=" + DHTLog.getString2(this.key) + ",data=" + this.data.length + ",st=" + this.start_position + ",len=" + this.length + ",tot=" + this.total_length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class transferHandlerInterceptor
    implements DHTTransportTransferHandler {
        private DHTTransportTransferHandler handler;
        private Map<String, Object> options;

        protected transferHandlerInterceptor(DHTTransportTransferHandler _handler, Map<String, Object> _options) {
            this.handler = _handler;
            this.options = _options;
        }

        @Override
        public String getName() {
            return this.handler.getName();
        }

        public boolean getBooleanOption(String name, boolean def) {
            if (this.options == null) {
                return def;
            }
            Boolean b = (Boolean)this.options.get(name);
            return b == null ? def : b;
        }

        @Override
        public byte[] handleRead(DHTTransportContact originator, byte[] key) {
            return this.handler.handleRead(originator, key);
        }

        @Override
        public byte[] handleWrite(DHTTransportContact originator, byte[] key, byte[] value) {
            return this.handleWrite(originator, 0L, key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] handleWrite(DHTTransportContact originator, long connection_id, byte[] key, byte[] value) {
            block3: {
                HashWrapper key_wrapper = new HashWrapper(key);
                try {
                    Object[] obj;
                    DHTTransferHandler.this.this_mon.enter();
                    Object _obj = DHTTransferHandler.this.call_transfers.get(key_wrapper);
                    if (!(_obj instanceof Object[]) || (Long)(obj = (Object[])_obj)[1] == connection_id) break block3;
                    AESemaphore sem = (AESemaphore)obj[0];
                    DHTTransferHandler.this.call_transfers.put(key_wrapper, value);
                    sem.release();
                    byte[] byArray = null;
                    Object var12_10 = null;
                    DHTTransferHandler.this.this_mon.exit();
                    return byArray;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    DHTTransferHandler.this.this_mon.exit();
                    throw throwable;
                }
            }
            Object var12_11 = null;
            DHTTransferHandler.this.this_mon.exit();
            return this.handler.handleWrite(originator, key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class transferQueue {
        private Map<Long, transferQueue> transfers;
        private long connection_id;
        private boolean destroyed;
        private List<Packet> packets = new ArrayList<Packet>();
        private AESemaphore packets_sem = new AESemaphore("DHTUDPTransport:transferQueue");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected transferQueue(Map<Long, transferQueue> _transfers, long _connection_id) throws DHTTransportException {
            this.transfers = _transfers;
            this.connection_id = _connection_id;
            try {
                DHTTransferHandler.this.this_mon.enter();
                if (this.transfers.size() > 128) {
                    Debug.out("Transfer queue count limit exceeded");
                    throw new DHTTransportException("Transfer queue limit exceeded");
                }
                Long l_id = new Long(this.connection_id);
                transferQueue existing = this.transfers.get(l_id);
                if (existing != null) {
                    existing.destroy();
                }
                this.transfers.put(l_id, this);
                Object var8_6 = null;
                DHTTransferHandler.this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                DHTTransferHandler.this.this_mon.exit();
                throw throwable;
            }
        }

        protected long getConnectionID() {
            return this.connection_id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void add(Packet packet) {
            block6: {
                block5: {
                    try {
                        DHTTransferHandler.this.this_mon.enter();
                        if (this.destroyed) {
                            Object var4_2 = null;
                            DHTTransferHandler.this.this_mon.exit();
                            return;
                        }
                        if (DHTTransferHandler.this.total_bytes_on_transfer_queues > 0x800000L) {
                            Debug.out("Transfer queue byte limit exceeded");
                            break block5;
                        }
                        int length = packet.getLength();
                        DHTTransferHandler.this.total_bytes_on_transfer_queues += length;
                        if (XFER_TRACE) {
                            System.out.println("total_bytes_on_transfer_queues=" + DHTTransferHandler.this.total_bytes_on_transfer_queues);
                        }
                        this.packets.add(packet);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        DHTTransferHandler.this.this_mon.exit();
                        throw throwable;
                    }
                }
                Object var4_3 = null;
                DHTTransferHandler.this.this_mon.exit();
                return;
            }
            Object var4_4 = null;
            DHTTransferHandler.this.this_mon.exit();
            this.packets_sem.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Packet receive(long timeout) {
            if (this.packets_sem.reserve(timeout)) {
                block5: {
                    try {
                        DHTTransferHandler.this.this_mon.enter();
                        if (!this.destroyed) break block5;
                        Packet packet = null;
                        Object var7_4 = null;
                        DHTTransferHandler.this.this_mon.exit();
                        return packet;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        DHTTransferHandler.this.this_mon.exit();
                        throw throwable;
                    }
                }
                Packet packet = this.packets.remove(0);
                int length = packet.getLength();
                DHTTransferHandler.this.total_bytes_on_transfer_queues -= length;
                if (XFER_TRACE) {
                    System.out.println("total_bytes_on_transfer_queues=" + DHTTransferHandler.this.total_bytes_on_transfer_queues);
                }
                Packet packet2 = packet;
                Object var7_5 = null;
                DHTTransferHandler.this.this_mon.exit();
                return packet2;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            try {
                DHTTransferHandler.this.this_mon.enter();
                this.destroyed = true;
                this.transfers.remove(new Long(this.connection_id));
                for (int i = 0; i < this.packets.size(); ++i) {
                    Packet packet = this.packets.get(i);
                    int length = packet.getLength();
                    DHTTransferHandler.this.total_bytes_on_transfer_queues -= length;
                    if (!XFER_TRACE) continue;
                    System.out.println("total_bytes_on_transfer_queues=" + DHTTransferHandler.this.total_bytes_on_transfer_queues);
                }
                this.packets.clear();
                this.packets_sem.releaseForever();
                Object var5_4 = null;
                DHTTransferHandler.this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                DHTTransferHandler.this.this_mon.exit();
                throw throwable;
            }
        }
    }
}

