/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;

public class FMFileAccessCompact
implements FMFileAccess {
    private static final byte SS = 4;
    private TOTorrentFile torrent_file;
    private int piece_size;
    private File controlFileDir;
    private String controlFileName;
    private FMFileAccess delegate;
    private volatile long current_length;
    private long version = 0L;
    private volatile boolean write_required;
    private long first_piece_start;
    private long first_piece_length;
    private long last_piece_start;
    private long last_piece_length;

    protected FMFileAccessCompact(TOTorrentFile _torrent_file, File _controlFileDir, String _controlFileName, FMFileAccess _delegate) throws FMFileManagerException {
        this.torrent_file = _torrent_file;
        this.controlFileDir = _controlFileDir;
        this.controlFileName = _controlFileName;
        this.delegate = _delegate;
        try {
            TOTorrentFile f;
            this.piece_size = (int)this.torrent_file.getTorrent().getPieceLength();
            TOTorrent torrent = this.torrent_file.getTorrent();
            long file_length = this.torrent_file.getLength();
            long file_offset_in_torrent = 0L;
            for (int i = 0; i < torrent.getFiles().length && (f = torrent.getFiles()[i]) != this.torrent_file; ++i) {
                file_offset_in_torrent += f.getLength();
            }
            int piece_offset = this.piece_size - (int)(file_offset_in_torrent % (long)this.piece_size);
            if (piece_offset == this.piece_size) {
                piece_offset = 0;
            }
            this.first_piece_length = piece_offset;
            this.first_piece_start = 0L;
            if (this.first_piece_length >= file_length) {
                this.first_piece_length = file_length;
                this.last_piece_start = file_length;
                this.last_piece_length = 0L;
            } else {
                this.last_piece_length = (file_length - (long)piece_offset) % (long)this.piece_size;
                this.last_piece_start = file_length - this.last_piece_length;
            }
            if (!new File(this.controlFileDir, this.controlFileName).exists()) {
                if (!this.controlFileDir.isDirectory() && !FileUtil.mkdirs(this.controlFileDir)) {
                    throw new FMFileManagerException("Directory creation failed: " + this.controlFileDir);
                }
            } else {
                this.readState();
            }
        }
        catch (Throwable e) {
            throw new FMFileManagerException("Compact file init fail", e);
        }
    }

    protected long getFirstPieceStart() {
        return this.first_piece_start;
    }

    protected long getFirstPieceLength() {
        return this.first_piece_length;
    }

    protected long getLastPieceStart() {
        return this.last_piece_start;
    }

    protected long getLastPieceLength() {
        return this.last_piece_length;
    }

    public void aboutToOpen() throws FMFileManagerException {
        this.delegate.aboutToOpen();
    }

    public long getLength(RandomAccessFile raf) throws FMFileManagerException {
        return this.current_length;
    }

    public void setLength(RandomAccessFile raf, long length) throws FMFileManagerException {
        if (length != this.current_length) {
            this.current_length = length;
            this.write_required = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void read(RandomAccessFile raf, DirectByteBuffer buffer, long position) throws FMFileManagerException {
        int original_limit;
        block11: {
            block10: {
                original_limit = buffer.limit((byte)4);
                try {
                    int len = original_limit - buffer.position((byte)4);
                    if (position < this.first_piece_start + this.first_piece_length) {
                        int available = (int)(this.first_piece_start + this.first_piece_length - position);
                        if (available >= len) {
                            this.delegate.read(raf, new DirectByteBuffer[]{buffer}, position);
                            position += (long)len;
                            len = 0;
                        } else {
                            buffer.limit((byte)4, buffer.position((byte)4) + available);
                            this.delegate.read(raf, new DirectByteBuffer[]{buffer}, position);
                            buffer.limit((byte)4, original_limit);
                            position += (long)available;
                            len -= available;
                        }
                    }
                    if (len == 0) {
                        Object var10_8 = null;
                        buffer.limit((byte)4, original_limit);
                        return;
                    }
                    long space = this.last_piece_start - position;
                    if (space > 0L) {
                        if (space >= (long)len) {
                            buffer.position((byte)4, original_limit);
                            position += (long)len;
                            len = 0;
                        } else {
                            buffer.position((byte)4, buffer.position((byte)4) + (int)space);
                            position += space;
                            len = (int)((long)len - space);
                        }
                    }
                    if (len == 0) {
                        break block10;
                    }
                    this.delegate.read(raf, new DirectByteBuffer[]{buffer}, position - this.last_piece_start + this.first_piece_length);
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    buffer.limit((byte)4, original_limit);
                    throw throwable;
                }
            }
            Object var10_9 = null;
            buffer.limit((byte)4, original_limit);
            return;
        }
        Object var10_10 = null;
        buffer.limit((byte)4, original_limit);
    }

    public void read(RandomAccessFile raf, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        for (int i = 0; i < buffers.length; ++i) {
            DirectByteBuffer buffer = buffers[i];
            int len = buffers[i].limit((byte)4) - buffers[i].position((byte)4);
            this.read(raf, buffer, position);
            int rem = buffers[i].remaining((byte)4);
            position += (long)(len - rem);
            if (rem > 0) break;
        }
        if (position > this.current_length) {
            this.setLength(raf, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void write(RandomAccessFile raf, DirectByteBuffer buffer, long position) throws FMFileManagerException {
        int original_limit;
        block11: {
            block10: {
                original_limit = buffer.limit((byte)4);
                try {
                    int len = original_limit - buffer.position((byte)4);
                    if (position < this.first_piece_start + this.first_piece_length) {
                        int available = (int)(this.first_piece_start + this.first_piece_length - position);
                        if (available >= len) {
                            this.delegate.write(raf, new DirectByteBuffer[]{buffer}, position);
                            position += (long)len;
                            len = 0;
                        } else {
                            buffer.limit((byte)4, buffer.position((byte)4) + available);
                            this.delegate.write(raf, new DirectByteBuffer[]{buffer}, position);
                            buffer.limit((byte)4, original_limit);
                            position += (long)available;
                            len -= available;
                        }
                    }
                    if (len == 0) {
                        Object var10_8 = null;
                        buffer.limit((byte)4, original_limit);
                        return;
                    }
                    long space = this.last_piece_start - position;
                    if (space > 0L) {
                        if (space >= (long)len) {
                            buffer.position((byte)4, original_limit);
                            position += (long)len;
                            len = 0;
                        } else {
                            buffer.position((byte)4, buffer.position((byte)4) + (int)space);
                            position += space;
                            len = (int)((long)len - space);
                        }
                    }
                    if (len == 0) {
                        break block10;
                    }
                    this.delegate.write(raf, new DirectByteBuffer[]{buffer}, position - this.last_piece_start + this.first_piece_length);
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    buffer.limit((byte)4, original_limit);
                    throw throwable;
                }
            }
            Object var10_9 = null;
            buffer.limit((byte)4, original_limit);
            return;
        }
        Object var10_10 = null;
        buffer.limit((byte)4, original_limit);
    }

    public void write(RandomAccessFile raf, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        for (int i = 0; i < buffers.length; ++i) {
            DirectByteBuffer buffer = buffers[i];
            int len = buffers[i].limit((byte)4) - buffers[i].position((byte)4);
            this.write(raf, buffer, position);
            position += (long)len;
        }
        if (position > this.current_length) {
            this.setLength(raf, position);
        }
    }

    public void flush() throws FMFileManagerException {
        this.writeState();
    }

    public boolean isPieceCompleteProcessingNeeded(int piece_number) {
        return false;
    }

    public void setPieceComplete(RandomAccessFile raf, int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
    }

    protected void readState() throws FMFileManagerException {
        try {
            Map data = FileUtil.readResilientFile(this.controlFileDir, this.controlFileName, false);
            if (data != null && data.size() > 0) {
                Long version = (Long)data.get("version");
                Long length = (Long)data.get("length");
                this.current_length = length;
            }
        }
        catch (Throwable e) {
            throw new FMFileManagerException("Failed to read control file state", e);
        }
    }

    protected void writeState() throws FMFileManagerException {
        boolean write = this.write_required;
        if (write) {
            this.write_required = false;
            try {
                HashMap<String, Long> data = new HashMap<String, Long>();
                data.put("version", new Long(this.version));
                data.put("length", new Long(this.current_length));
                FileUtil.writeResilientFile(this.controlFileDir, this.controlFileName, data, false);
            }
            catch (Throwable e) {
                throw new FMFileManagerException("Failed to write control file state", e);
            }
        }
    }

    public FMFileImpl getFile() {
        return this.delegate.getFile();
    }

    public String getString() {
        return "compact";
    }
}

