/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderAdapter;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderPHE;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterTransparent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class ProtocolDecoderInitial
extends ProtocolDecoder {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private ProtocolDecoderAdapter adapter;
    private TransportHelperFilter filter;
    private TransportHelper transport;
    private byte[][] shared_secrets;
    private ByteBuffer initial_data;
    private ByteBuffer decode_buffer;
    private int decode_read;
    private long start_time = SystemTime.getCurrentTime();
    private ProtocolDecoderPHE phe_decoder;
    private long last_read_time = 0L;
    private boolean processing_complete;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtocolDecoderInitial(TransportHelper _transport, byte[][] _shared_secrets, boolean _outgoing, ByteBuffer _initial_data, ProtocolDecoderAdapter _adapter) throws IOException {
        super(true);
        this.transport = _transport;
        this.shared_secrets = _shared_secrets;
        this.initial_data = _initial_data;
        this.adapter = _adapter;
        final TransportHelperFilterTransparent transparent_filter = new TransportHelperFilterTransparent(this.transport, false);
        this.filter = transparent_filter;
        if (_outgoing) {
            if (!ProtocolDecoderPHE.isCryptoOK()) throw new IOException("Crypto required but unavailable");
            this.decodePHE(null);
            return;
        } else {
            this.decode_buffer = ByteBuffer.allocate(this.adapter.getMaximumPlainHeaderLength());
            this.transport.registerForReadSelects(new TransportHelper.selectListener(){

                public boolean selectSuccess(TransportHelper helper, Object attachment) {
                    try {
                        int len = helper.read(ProtocolDecoderInitial.this.decode_buffer);
                        if (len < 0) {
                            ProtocolDecoderInitial.this.failed(new IOException("end of stream on socket read: in=" + ProtocolDecoderInitial.this.decode_buffer.position()));
                        } else if (len == 0) {
                            return false;
                        }
                        ProtocolDecoderInitial.this.last_read_time = SystemTime.getCurrentTime();
                        ProtocolDecoderInitial.this.decode_read += len;
                        int match = ProtocolDecoderInitial.this.adapter.matchPlainHeader(ProtocolDecoderInitial.this.decode_buffer);
                        if (match != 1) {
                            helper.cancelReadSelects();
                            if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE && match == 2) {
                                InetSocketAddress isa = ProtocolDecoderInitial.this.transport.getAddress();
                                if (NetworkManager.INCOMING_HANDSHAKE_FALLBACK_ALLOWED) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, "Incoming connection [" + isa + "] is not encrypted but has been accepted as fallback is enabled"));
                                    }
                                } else if (AddressUtils.isLANLocalAddress(AddressUtils.getHostAddress(isa)) == 1) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, "Incoming connection [" + isa + "] is not encrypted but has been accepted as lan-local"));
                                    }
                                } else if (AENetworkClassifier.categoriseAddress(isa) != "Public") {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, "Incoming connection [" + isa + "] is not encrypted but has been accepted as not a public network"));
                                    }
                                } else {
                                    throw new IOException("Crypto required but incoming connection has none");
                                }
                            }
                            ProtocolDecoderInitial.this.decode_buffer.flip();
                            transparent_filter.insertRead(ProtocolDecoderInitial.this.decode_buffer);
                            ProtocolDecoderInitial.this.complete(ProtocolDecoderInitial.this.initial_data);
                        } else if (!ProtocolDecoderInitial.this.decode_buffer.hasRemaining()) {
                            helper.cancelReadSelects();
                            if (NetworkManager.INCOMING_CRYPTO_ALLOWED) {
                                ProtocolDecoderInitial.this.decode_buffer.flip();
                                ProtocolDecoderInitial.this.decodePHE(ProtocolDecoderInitial.this.decode_buffer);
                            } else {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, "Incoming connection [" + ProtocolDecoderInitial.this.transport.getAddress() + "] encrypted but rejected as not permitted"));
                                }
                                throw new IOException("Incoming crypto connection not permitted");
                            }
                        }
                        return true;
                    }
                    catch (Throwable e) {
                        this.selectFailure(helper, attachment, e);
                        return false;
                    }
                }

                public void selectFailure(TransportHelper helper, Object attachment, Throwable msg) {
                    helper.cancelReadSelects();
                    ProtocolDecoderInitial.this.failed(msg);
                }
            }, this);
        }
    }

    protected void decodePHE(ByteBuffer buffer) throws IOException {
        ProtocolDecoderAdapter phe_adapter = new ProtocolDecoderAdapter(){

            public void decodeComplete(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                ProtocolDecoderInitial.this.filter = decoder.getFilter();
                ProtocolDecoderInitial.this.complete(remaining_initial_data);
            }

            public void decodeFailed(ProtocolDecoder decoder, Throwable cause) {
                ProtocolDecoderInitial.this.failed(cause);
            }

            public void gotSecret(byte[] session_secret) {
                ProtocolDecoderInitial.this.adapter.gotSecret(session_secret);
            }

            public int getMaximumPlainHeaderLength() {
                throw new RuntimeException();
            }

            public int matchPlainHeader(ByteBuffer buffer) {
                throw new RuntimeException();
            }
        };
        this.phe_decoder = new ProtocolDecoderPHE(this.transport, this.shared_secrets, buffer, this.initial_data, phe_adapter);
    }

    public boolean isComplete(long now) {
        if (this.transport == null) {
            return false;
        }
        if (!this.processing_complete) {
            long time;
            long timeout;
            if (this.start_time > now) {
                this.start_time = now;
            }
            if (this.last_read_time > now) {
                this.last_read_time = now;
            }
            if (this.phe_decoder != null) {
                this.last_read_time = this.phe_decoder.getLastReadTime();
            }
            if (this.last_read_time == 0L) {
                timeout = this.transport.getConnectTimeout();
                time = this.start_time;
            } else {
                timeout = this.transport.getReadTimeout();
                time = this.last_read_time;
            }
            if (now - time > timeout) {
                try {
                    this.transport.cancelReadSelects();
                    this.transport.cancelWriteSelects();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                String phe_str = "";
                if (this.phe_decoder != null) {
                    phe_str = ", crypto: " + this.phe_decoder.getString();
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Connection [" + this.transport.getAddress() + "] forcibly timed out after " + timeout / 1000L + "sec due to socket inactivity"));
                }
                this.failed(new Throwable("Protocol decode aborted: timed out after " + timeout / 1000L + "sec: " + this.decode_read + " bytes read" + phe_str));
            }
        }
        return this.processing_complete;
    }

    public TransportHelperFilter getFilter() {
        return this.filter;
    }

    protected void complete(ByteBuffer remaining_initial_data) {
        if (!this.processing_complete) {
            this.processing_complete = true;
            this.adapter.decodeComplete(this, remaining_initial_data);
        }
    }

    protected void failed(Throwable reason) {
        if (!this.processing_complete) {
            this.processing_complete = true;
            this.adapter.decodeFailed(this, reason);
        }
    }
}

