/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZGenericMapPayload
implements AZMessage {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private final String type_id;
    private final Map msg_map;

    public AZGenericMapPayload(String message_type, Map message, byte version) {
        this.type_id = message_type;
        this.msg_map = message;
        this.version = version;
    }

    public String getID() {
        return this.type_id;
    }

    public byte[] getIDBytes() {
        return this.type_id.getBytes();
    }

    public String getFeatureID() {
        return "AZ1";
    }

    public int getFeatureSubID() {
        return 2;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public Map getMapPayload() {
        return this.msg_map;
    }

    public String getDescription() {
        return this.getID();
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(this.msg_map, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        Map payload = MessagingUtil.convertBencodedByteStreamToPayload(data, 1, this.getID());
        return new AZGenericMapPayload(this.getID(), payload, version);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

