/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;

public class FeatureAvailability {
    private static final long FT_DISABLE_REQUEST_LIMITING = 1L;
    private static final long FT_DISABLE_PEER_GENERAL_RECONNECT = 2L;
    private static final long FT_DISABLE_PEER_UDP_RECONNECT = 4L;
    private static final long FT_AUTO_SPEED_DEFAULT_CLASSIC = 8L;
    private static final long FT_DISABLE_RCM = 16L;
    private static final long FT_DISABLE_DHT_REP_V2 = 32L;
    private static final long FT_DISABLE_MAGNET_SL = 64L;
    private static final long FT_ENABLE_ALL_FE_CLIENTS = 128L;
    private static final long FT_ENABLE_INTERNAL_FEATURES = 256L;
    private static final long FT_TRIGGER_SPEED_TEST_V1 = 512L;
    private static final long FT_DISABLE_GAMES = 1024L;
    private static final long FT_DISABLE_MAGNET_MD = 2048L;
    private static VersionCheckClient vcc = VersionCheckClient.getSingleton();

    public static boolean areInternalFeaturesEnabled() {
        boolean result = (vcc.getFeatureFlags() & 0x100L) != 0L;
        return result;
    }

    public static boolean isRequestLimitingEnabled() {
        boolean result = (vcc.getFeatureFlags() & 1L) == 0L;
        return result;
    }

    public static boolean isGeneralPeerReconnectEnabled() {
        boolean result = (vcc.getFeatureFlags() & 2L) == 0L;
        return result;
    }

    public static boolean isUDPPeerReconnectEnabled() {
        boolean result = (vcc.getFeatureFlags() & 4L) == 0L;
        return result;
    }

    public static boolean isAutoSpeedDefaultClassic() {
        boolean result = (vcc.getFeatureFlags() & 8L) != 0L;
        return result;
    }

    public static boolean isRCMEnabled() {
        boolean result = (vcc.getFeatureFlags() & 0x10L) == 0L;
        return result;
    }

    public static boolean isDHTRepV2Enabled() {
        boolean result = (vcc.getFeatureFlags() & 0x20L) == 0L;
        return result;
    }

    public static boolean isMagnetSLEnabled() {
        boolean result = (vcc.getFeatureFlags() & 0x40L) == 0L;
        return result;
    }

    public static boolean isMagnetMDEnabled() {
        boolean result = (vcc.getFeatureFlags() & 0x800L) == 0L;
        return result;
    }

    public static boolean allowAllFEClients() {
        boolean result = (vcc.getFeatureFlags() & 0x80L) != 0L;
        return result;
    }

    public static boolean triggerSpeedTestV1() {
        boolean result = (vcc.getFeatureFlags() & 0x200L) != 0L;
        return result;
    }

    public static boolean isGamesEnabled() {
        boolean result = (vcc.getFeatureFlags() & 0x400L) == 0L;
        return result;
    }
}

