/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiChildCloseListener;
import com.aelitis.azureus.ui.mdi.MdiCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryDatasourceListener;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MdiEntryLogIdListener;
import com.aelitis.azureus.ui.mdi.MdiEntryOpenListener;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MdiSWTMenuHackListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarEnablerBase;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.PluginUISWTSkinObject;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginViewImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventCancelledException;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMdiEntry
extends UISWTViewImpl
implements MdiEntrySWT,
ViewTitleInfoListener,
AEDiagnosticsEvidenceGenerator {
    protected final MultipleDocumentInterface mdi;
    protected String logID;
    private String skinRef;
    private List<MdiCloseListener> listCloseListeners = null;
    private List<MdiChildCloseListener> listChildCloseListeners = null;
    private List<MdiEntryLogIdListener> listLogIDListeners = null;
    private List<MdiEntryOpenListener> listOpenListeners = null;
    private List<MdiEntryDropListener> listDropListeners = null;
    private List<MdiEntryDatasourceListener> listDatasourceListeners = null;
    private List<MdiSWTMenuHackListener> listMenuHackListners;
    protected ViewTitleInfo viewTitleInfo;
    private String parentEntryID;
    private boolean closeable;
    private Boolean isExpanded = null;
    private boolean disposed = false;
    private boolean added = false;
    private String imageLeftID;
    private Image imageLeft;
    private boolean collapseDisabled = false;
    private SWTSkinObject soMaster;
    private String preferredAfterID;
    private boolean hasBeenOpened;

    private BaseMdiEntry() {
        super(null, null, false);
        this.mdi = null;
        this.setDefaultExpanded(false);
        AEDiagnostics.addEvidenceGenerator(this);
    }

    public BaseMdiEntry(MultipleDocumentInterface mdi, String id, String parentViewID) {
        super(id, parentViewID, true);
        int i;
        this.mdi = mdi;
        AEDiagnostics.addEvidenceGenerator(this);
        this.logID = id == null ? "null" : ((i = id.indexOf(95)) > 0 ? id.substring(0, i) : id);
        this.setDefaultExpanded(false);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public MdiEntryVitalityImage addVitalityImage(String imageID) {
        return null;
    }

    @Override
    public boolean close(boolean forceClose) {
        if (!forceClose && !this.requestClose()) {
            return false;
        }
        this.setCloseable(this.closeable);
        this.disposed = true;
        ViewTitleInfoManager.removeListener(this);
        return true;
    }

    public Object getDatasourceCore() {
        return this.datasource;
    }

    @Override
    public String getExportableDatasource() {
        Object ds;
        if (this.viewTitleInfo != null && (ds = this.viewTitleInfo.getTitleInfoProperty(10)) != null) {
            return ds.toString();
        }
        return null;
    }

    @Override
    public Object getDatasource() {
        return PluginCoreUtils.convert(this.datasource, false);
    }

    @Override
    public String getLogID() {
        return this.logID;
    }

    @Override
    public MultipleDocumentInterface getMDI() {
        return this.mdi;
    }

    @Override
    public String getParentID() {
        return this.parentEntryID;
    }

    @Override
    public void setParentID(String id) {
        if (id == null || "Tools".equals(id)) {
            id = this.getId().equals("header.dvd") && id == null ? "" : "header.plugins";
        }
        if (id.equals(this.getId())) {
            Debug.out("Setting Parent to same ID as child! " + id);
            return;
        }
        this.parentEntryID = id;
        if (this.mdi != null) {
            this.mdi.loadEntryByID(this.parentEntryID, false);
        }
    }

    @Override
    public MdiEntryVitalityImage[] getVitalityImages() {
        return null;
    }

    @Override
    public boolean isCloseable() {
        return this.closeable;
    }

    public boolean isCollapseDisabled() {
        return this.collapseDisabled;
    }

    @Override
    public void setCollapseDisabled(boolean collapseDisabled) {
        this.collapseDisabled = collapseDisabled;
        this.setExpanded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listCloseListeners == null) {
                this.listCloseListeners = new ArrayList<MdiCloseListener>(1);
            }
            this.listCloseListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listCloseListeners != null) {
                this.listCloseListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerCloseListeners(boolean user) {
        MdiEntry parentEntry;
        Object[] list = new Object[]{};
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listCloseListeners != null) {
                list = this.listCloseListeners.toArray();
            }
        }
        for (int i = 0; i < list.length; ++i) {
            MdiCloseListener l = (MdiCloseListener)list[i];
            try {
                l.mdiEntryClosed(this, user);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        if (this.parentEntryID != null && this.mdi != null && (parentEntry = this.mdi.getEntry(this.parentEntryID)) instanceof BaseMdiEntry) {
            ((BaseMdiEntry)parentEntry).triggerChildCloseListeners(this, user);
        }
        this.triggerEvent(7, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiChildCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listChildCloseListeners == null) {
                this.listChildCloseListeners = new ArrayList<MdiChildCloseListener>(1);
            }
            this.listChildCloseListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiChildCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listChildCloseListeners != null) {
                this.listChildCloseListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerChildCloseListeners(MdiEntry child, boolean user) {
        Object[] list;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listChildCloseListeners == null) {
                return;
            }
            list = this.listChildCloseListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiChildCloseListener l = (MdiChildCloseListener)list[i];
            try {
                l.mdiChildEntryClosed(this, child, user);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryLogIdListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listLogIDListeners == null) {
                this.listLogIDListeners = new ArrayList<MdiEntryLogIdListener>(1);
            }
            this.listLogIDListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryLogIdListener sideBarLogIdListener) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listLogIDListeners != null) {
                this.listLogIDListeners.remove(sideBarLogIdListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerLogIDListeners(String oldID) {
        Object[] list;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listLogIDListeners == null) {
                return;
            }
            list = this.listLogIDListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiEntryLogIdListener l = (MdiEntryLogIdListener)list[i];
            l.mdiEntryLogIdChanged(this, oldID, this.logID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryOpenListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listOpenListeners == null) {
                this.listOpenListeners = new ArrayList<MdiEntryOpenListener>(1);
            }
            this.listOpenListeners.add(l);
        }
        if (this.hasBeenOpened) {
            l.mdiEntryOpen(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryOpenListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listOpenListeners != null) {
                this.listOpenListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerOpenListeners() {
        Object[] list;
        this.hasBeenOpened = true;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listOpenListeners == null) {
                return;
            }
            list = this.listOpenListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiEntryOpenListener l = (MdiEntryOpenListener)list[i];
            try {
                l.mdiEntryOpen(this);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryDatasourceListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDatasourceListeners == null) {
                this.listDatasourceListeners = new ArrayList<MdiEntryDatasourceListener>(1);
            }
            this.listDatasourceListeners.add(l);
        }
        l.mdiEntryDatasourceChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryDatasourceListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDatasourceListeners != null) {
                this.listDatasourceListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerDatasourceListeners() {
        Object[] list;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDatasourceListeners == null) {
                return;
            }
            list = this.listDatasourceListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiEntryDatasourceListener l = (MdiEntryDatasourceListener)list[i];
            try {
                l.mdiEntryDatasourceChanged(this);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryDropListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDropListeners == null) {
                this.listDropListeners = new ArrayList<MdiEntryDropListener>(1);
            }
            this.listDropListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryDropListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDropListeners != null) {
                this.listDropListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDropListeners() {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            return this.listDropListeners != null && this.listDropListeners.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerDropListeners(Object o) {
        MdiEntryDropListener l;
        Object[] list;
        boolean handled = false;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDropListeners == null) {
                return handled;
            }
            list = this.listDropListeners.toArray();
        }
        for (int i = 0; i < list.length && !(handled = (l = (MdiEntryDropListener)list[i]).mdiEntryDrop(this, o)); ++i) {
        }
        return handled;
    }

    @Override
    public void setLogID(String logID) {
        if (logID == null || logID.equals("" + this.logID)) {
            return;
        }
        String oldID = this.logID;
        this.logID = logID;
        this.triggerLogIDListeners(oldID);
    }

    @Override
    public ViewTitleInfo getViewTitleInfo() {
        return this.viewTitleInfo;
    }

    @Override
    public void setViewTitleInfo(ViewTitleInfo viewTitleInfo) {
        if (this.viewTitleInfo == viewTitleInfo) {
            return;
        }
        this.viewTitleInfo = viewTitleInfo;
        if (viewTitleInfo != null) {
            String imageID;
            if (viewTitleInfo instanceof ViewTitleInfo2) {
                ViewTitleInfo2 vti2 = (ViewTitleInfo2)viewTitleInfo;
                try {
                    vti2.titleInfoLinked(this.mdi, this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            if ((imageID = (String)viewTitleInfo.getTitleInfoProperty(2)) != null) {
                this.setImageLeftID(imageID.length() == 0 ? null : imageID);
            }
            ViewTitleInfoManager.addListener(this);
            if (this.getEventListener() == null && viewTitleInfo instanceof UISWTViewEventListener) {
                try {
                    this.setEventListener((UISWTViewEventListener)((Object)viewTitleInfo), true);
                }
                catch (UISWTViewEventCancelledException uISWTViewEventCancelledException) {
                    // empty catch block
                }
            }
        }
        this.redraw();
    }

    @Override
    public void setPluginSkinObject(PluginUISWTSkinObject skinObject) {
        Object initialDataSource;
        super.setPluginSkinObject(skinObject);
        Object object = initialDataSource = this.datasource == null || this.datasource instanceof Object[] && ((Object[])this.datasource).length == 0 ? this.getInitialDataSource() : this.datasource;
        if (initialDataSource != null) {
            if (skinObject instanceof SWTSkinObject) {
                ((SWTSkinObject)skinObject).triggerListeners(7, initialDataSource);
            }
            this.triggerEvent(1, initialDataSource);
        }
    }

    public void setSkinObjectMaster(SWTSkinObject soMaster) {
        this.soMaster = soMaster;
    }

    public SWTSkinObject getSkinObject() {
        return (SWTSkinObject)this.getPluginSkinObject();
    }

    public SWTSkinObject getSkinObjectMaster() {
        if (this.soMaster == null) {
            return this.getSkinObject();
        }
        return this.soMaster;
    }

    public void setSkinRef(String configID, Object params) {
        this.skinRef = configID;
        if (params != null) {
            this.setDatasource(params);
        }
    }

    public String getSkinRef() {
        return this.skinRef;
    }

    @Override
    public String getTitle() {
        String viewTitle;
        if (this.viewTitleInfo != null && (viewTitle = (String)this.viewTitleInfo.getTitleInfoProperty(5)) != null && viewTitle.length() > 0) {
            return viewTitle;
        }
        return super.getFullTitle();
    }

    public void updateLanguage() {
        this.triggerEvent(6, null);
    }

    @Override
    public void triggerEvent(int eventType, Object data) {
        super.triggerEvent(eventType, data);
        if (eventType == 6) {
            if (this.getTitleID() != null) {
                this.setTitleID(this.getTitleID());
            } else {
                if (this.viewTitleInfo != null) {
                    this.viewTitleInfoRefresh(this.viewTitleInfo);
                }
                this.updateUI();
            }
            SWTSkinObject skinObjectMaster = this.getSkinObjectMaster();
            if (skinObjectMaster != null) {
                skinObjectMaster.triggerListeners(6);
            }
        }
    }

    public void show() {
        Composite c;
        SWTSkinObjectContainer container;
        Composite composite;
        if (this.skinObject == null) {
            return;
        }
        SelectedContentManager.clearCurrentlySelectedContent();
        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uif != null) {
            uif.refreshTorrentMenu();
        }
        SWTSkinObject skinObject = this.getSkinObjectMaster();
        skinObject.setVisible(true);
        if (skinObject instanceof SWTSkinObjectContainer && (composite = (container = (SWTSkinObjectContainer)skinObject).getComposite()) != null && !composite.isDisposed()) {
            composite.setVisible(true);
            composite.moveAbove(null);
            composite.getParent().layout();
        }
        if ((c = this.getComposite()) != null && !c.isDisposed()) {
            c.setData("BaseMDIEntry", (Object)this);
            c.setVisible(true);
            c.getParent().layout();
        }
        try {
            this.triggerEvent(3, null);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        this.setToolbarVisibility(this.hasToolbarEnableers());
    }

    @Override
    public void hide() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                BaseMdiEntry.this.swt_hide();
            }
        });
        this.setToolbarVisibility(false);
    }

    @Override
    public void requestAttention() {
    }

    protected void swt_hide() {
        Composite oldComposite;
        SWTSkinObject skinObjectMaster = this.getSkinObjectMaster();
        if (skinObjectMaster instanceof SWTSkinObjectContainer) {
            SWTSkinObjectContainer container = (SWTSkinObjectContainer)skinObjectMaster;
            Control oldComposite2 = container.getControl();
            container.setVisible(false);
            if (oldComposite2 != null && !oldComposite2.isDisposed()) {
                oldComposite2.getShell().update();
            }
        }
        if ((oldComposite = this.getComposite()) != null && !oldComposite.isDisposed()) {
            oldComposite.setVisible(false);
            oldComposite.getShell().update();
        }
        try {
            this.triggerEvent(4, null);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    @Override
    public void updateUI() {
        if (this.getEventListener() == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!BaseMdiEntry.this.isDisposed()) {
                    BaseMdiEntry.this.triggerEvent(5, null);
                }
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public Map<String, Object> getAutoOpenInfo() {
        String eds;
        LightHashMap<String, Object> autoOpenInfo = new LightHashMap<String, Object>();
        if (this.getParentID() != null) {
            autoOpenInfo.put("parentID", this.getParentID());
        }
        autoOpenInfo.put("title", this.getTitle());
        Object datasource = this.getDatasourceCore();
        if (datasource instanceof DownloadManager) {
            try {
                autoOpenInfo.put("dm", ((DownloadManager)datasource).getTorrent().getHashWrapper().toBase32String());
            }
            catch (Throwable t) {}
        } else if (datasource instanceof DownloadManager[]) {
            DownloadManager[] dms = (DownloadManager[])datasource;
            ArrayList<String> list = new ArrayList<String>();
            for (DownloadManager dm : dms) {
                try {
                    list.add(dm.getTorrent().getHashWrapper().toBase32String());
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            autoOpenInfo.put("dms", list);
        }
        if ((eds = this.getExportableDatasource()) != null) {
            autoOpenInfo.put("datasource", eds.toString());
        }
        return autoOpenInfo;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
        if (this.mdi != null) {
            if (closeable) {
                this.mdi.informAutoOpenSet(this, this.getAutoOpenInfo());
            } else {
                this.mdi.removeEntryAutoOpen(this.id);
            }
        }
    }

    @Override
    public void setDefaultExpanded(boolean defaultExpanded) {
        COConfigurationManager.setBooleanDefault("SideBar.Expanded." + this.id, defaultExpanded);
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded == null ? COConfigurationManager.getBooleanParameter("SideBar.Expanded." + this.id) : this.isExpanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        boolean defExpanded = true;
        try {
            defExpanded = ConfigurationDefaults.getInstance().getBooleanParameter("SideBar.Expanded." + this.id);
        }
        catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
            // empty catch block
        }
        if (this.isExpanded == defExpanded) {
            COConfigurationManager.removeParameter("SideBar.Expanded." + this.id);
        } else {
            COConfigurationManager.setParameter("SideBar.Expanded." + this.id, this.isExpanded);
        }
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    public void setDisposed(boolean b) {
        this.disposed = b;
        boolean bl = this.added = !b;
        if (this.added && this.getSkinObject() != null) {
            this.getSkinObject().triggerListeners(7, this.datasource);
        }
    }

    @Override
    public void setImageLeftID(String id) {
        this.imageLeftID = id;
        this.imageLeft = null;
        this.redraw();
    }

    @Override
    public String getImageLeftID() {
        return this.imageLeftID;
    }

    @Override
    public void setImageLeft(Image imageLeft) {
        this.imageLeft = imageLeft;
        this.imageLeftID = null;
        this.redraw();
    }

    public Image getImageLeft(String suffix) {
        if (this.imageLeft != null) {
            return this.imageLeft;
        }
        if (this.imageLeftID == null) {
            return null;
        }
        Image img = null;
        img = suffix == null ? ImageLoader.getInstance().getImage(this.imageLeftID) : ImageLoader.getInstance().getImage(this.imageLeftID + suffix);
        if (ImageLoader.isRealImage(img)) {
            return img;
        }
        return null;
    }

    public void releaseImageLeft(String suffix) {
        if (this.imageLeft != null) {
            ImageLoader.getInstance().releaseImage(this.imageLeftID + (suffix == null ? "" : suffix));
        }
    }

    @Override
    public void viewTitleInfoRefresh(ViewTitleInfo titleInfoToRefresh) {
        if (titleInfoToRefresh == null || this.viewTitleInfo != titleInfoToRefresh) {
            return;
        }
        if (this.isDisposed()) {
            return;
        }
        String imageID = (String)this.viewTitleInfo.getTitleInfoProperty(2);
        if (imageID != null) {
            this.setImageLeftID(imageID.length() == 0 ? null : imageID);
        }
        this.redraw();
        String logID = (String)this.viewTitleInfo.getTitleInfoProperty(7);
        if (logID != null) {
            this.setLogID(logID);
        }
    }

    public void build() {
    }

    @Override
    public void setPreferredAfterID(String preferredAfterID) {
        this.preferredAfterID = preferredAfterID;
    }

    @Override
    public String getPreferredAfterID() {
        return this.preferredAfterID;
    }

    public boolean requestClose() {
        return this.triggerEventRaw(8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("View: " + this.id + ": " + this.getTitle());
        try {
            try {
                writer.indent();
                writer.println("Parent: " + this.getParentID());
                writer.println("Added: " + this.added);
                writer.println("closeable: " + this.closeable);
                writer.println("Disposed: " + this.disposed);
                writer.println("hasBeenOpened: " + this.hasBeenOpened);
                writer.println("control type: " + this.getControlType());
                writer.println("hasEventListener: " + (this.getEventListener() != null));
                writer.println("hasViewTitleInfo: " + (this.viewTitleInfo != null));
                writer.println("skinRef: " + this.skinRef);
            }
            catch (Exception e) {
                Object var4_3 = null;
                writer.exdent();
            }
            Object var4_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            writer.exdent();
            throw throwable;
        }
        if (this.getEventListener() instanceof AEDiagnosticsEvidenceGenerator) {
            try {
                try {
                    writer.indent();
                    ((AEDiagnosticsEvidenceGenerator)((Object)this.getEventListener())).generate(writer);
                }
                catch (Exception exception) {
                    Object var6_9 = null;
                    writer.exdent();
                }
                Object var6_8 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                writer.exdent();
                throw throwable;
            }
        }
    }

    @Override
    public void closeView() {
        if (this.mdi != null) {
            this.mdi.closeEntry(this.id);
        }
        super.closeView();
    }

    @Override
    public void setEventListener(UISWTViewEventListener _eventListener, boolean doCreate) throws UISWTViewEventCancelledException {
        String existing_id;
        UISWTViewEventListenerHolder h;
        UISWTViewEventListener delegatedEventListener;
        UISWTViewEventListener eventListener = this.getEventListener();
        if (eventListener instanceof UIToolBarEnablerBase) {
            this.removeToolbarEnabler((UIToolBarEnablerBase)((Object)eventListener));
        }
        if (eventListener instanceof ViewTitleInfo && this.viewTitleInfo == eventListener) {
            this.setViewTitleInfo(null);
        }
        if (_eventListener instanceof UISWTViewEventListenerHolder && (delegatedEventListener = (h = (UISWTViewEventListenerHolder)_eventListener).getDelegatedEventListener(this)) != null) {
            _eventListener = delegatedEventListener;
        }
        if (_eventListener instanceof UIToolBarEnablerBase) {
            this.addToolbarEnabler((UIToolBarEnablerBase)((Object)_eventListener));
        }
        if (_eventListener instanceof ViewTitleInfo && this.viewTitleInfo == null) {
            this.setViewTitleInfo((ViewTitleInfo)((Object)_eventListener));
        }
        if (_eventListener instanceof BasicPluginViewImpl && ((existing_id = this.getImageLeftID()) == null || "image.sidebar.plugin".equals(existing_id))) {
            this.setImageLeftID("image.sidebar.logview");
        }
        super.setEventListener(_eventListener, doCreate);
    }

    @Override
    public void setDatasource(Object datasource) {
        super.setDatasource(datasource);
        this.triggerDatasourceListeners();
        if (this.isAdded() && this.getSkinObject() != null) {
            this.getSkinObject().triggerListeners(7, datasource);
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiSWTMenuHackListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listMenuHackListners == null) {
                this.listMenuHackListners = new ArrayList<MdiSWTMenuHackListener>(1);
            }
            if (!this.listMenuHackListners.contains(l)) {
                this.listMenuHackListners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiSWTMenuHackListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listMenuHackListners == null) {
                this.listMenuHackListners = new ArrayList<MdiSWTMenuHackListener>(1);
            }
            this.listMenuHackListners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdiSWTMenuHackListener[] getMenuHackListeners() {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listMenuHackListners == null) {
                return new MdiSWTMenuHackListener[0];
            }
            return this.listMenuHackListners.toArray(new MdiSWTMenuHackListener[0]);
        }
    }
}

