/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.platform.macosx.NativeInvocationBridge;
import org.gudy.azureus2.platform.macosx.PListEditor;
import org.gudy.azureus2.platform.macosx.access.jnilib.OSXAccess;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformManagerImpl
implements PlatformManager,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String BUNDLE_ID = "com.azureus.vuze";
    private static final String[] SCHEMES = new String[]{"magnet", "dht", "vuze", "bc", "bctp"};
    private static final String[] MIMETYPES = new String[]{"application/x-bittorrent", "application/x-vuze", "application/x-bctp-uri", "application/x-bc-uri"};
    private static final String[] EXTENSIONS = new String[]{"torrent", "tor", "vuze", "vuz", "bctpuri", "bcuri"};
    protected static PlatformManagerImpl singleton;
    protected static AEMonitor class_mon;
    private static String fileBrowserName;
    private final HashSet capabilitySet;
    private volatile String computer_name;
    private volatile boolean computer_name_tried;
    private Class<?> claFileManager;
    private AzureusCore azureus_core;
    private boolean prevent_computer_sleep_pending;
    private boolean prevent_computer_sleep;
    private Process prevent_computer_proc;

    public static PlatformManagerImpl getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSingleton() {
        try {
            try {
                class_mon.enter();
                singleton = new PlatformManagerImpl();
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "Failed to initialize platform manager for Mac OS X", e));
                Object var2_1 = null;
                class_mon.exit();
            }
            Object var2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
        COConfigurationManager.addAndFireParameterListener("FileBrowse.usePathFinder", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                fileBrowserName = COConfigurationManager.getBooleanParameter("FileBrowse.usePathFinder") ? "Path Finder" : "Finder";
            }
        });
    }

    public PlatformManagerImpl() {
        block14: {
            this.capabilitySet = new HashSet();
            this.prevent_computer_sleep_pending = false;
            this.prevent_computer_sleep = false;
            this.capabilitySet.add(PlatformManagerCapabilities.RecoverableFileDelete);
            this.capabilitySet.add(PlatformManagerCapabilities.ShowFileInBrowser);
            this.capabilitySet.add(PlatformManagerCapabilities.ShowPathInCommandLine);
            this.capabilitySet.add(PlatformManagerCapabilities.CreateCommandLineProcess);
            this.capabilitySet.add(PlatformManagerCapabilities.GetUserDataDirectory);
            this.capabilitySet.add(PlatformManagerCapabilities.UseNativeScripting);
            this.capabilitySet.add(PlatformManagerCapabilities.PlaySystemAlert);
            this.capabilitySet.add(PlatformManagerCapabilities.RequestUserAttention);
            if (OSXAccess.isLoaded()) {
                this.capabilitySet.add(PlatformManagerCapabilities.GetVersion);
                try {
                    if (OSXAccess.canSetDefaultApp()) {
                        this.capabilitySet.add(PlatformManagerCapabilities.RegisterFileAssociations);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (this.checkPList()) {
                // empty if block
            }
            this.capabilitySet.add(PlatformManagerCapabilities.RunAtLogin);
            this.capabilitySet.add(PlatformManagerCapabilities.GetMaxOpenFiles);
            if (new File("/usr/bin/pmset").canRead() || new File("/usr/bin/caffeinate").canRead()) {
                this.capabilitySet.add(PlatformManagerCapabilities.PreventComputerSleep);
            }
            try {
                if (new File("/usr/bin/defaults").exists()) {
                    boolean found;
                    block13: {
                        found = false;
                        try {
                            String line;
                            String[] read_command = new String[]{"/usr/bin/defaults", "read", BUNDLE_ID};
                            Process p = Runtime.getRuntime().exec(read_command);
                            if (p.waitFor() != 0) break block13;
                            InputStream is = p.getInputStream();
                            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is, "UTF-8"));
                            while ((line = lnr.readLine()) != null) {
                                if (!line.contains("NSAppSleepDisabled")) continue;
                                found = true;
                                break;
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    if (!found) {
                        String[] write_command = new String[]{"/usr/bin/defaults", "write", BUNDLE_ID, "NSAppSleepDisabled", "-bool", "YES"};
                        Runtime.getRuntime().exec(write_command);
                    }
                    break block14;
                }
                System.err.println("/usr/bin/defaults missing");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        AEDiagnostics.addEvidenceGenerator(this);
    }

    @Override
    public int getPlatformType() {
        return 3;
    }

    @Override
    public String getVersion() throws PlatformManagerException {
        if (!OSXAccess.isLoaded()) {
            throw new PlatformManagerException("Unsupported capability called on platform manager");
        }
        return OSXAccess.getVersion();
    }

    protected PListEditor getPList() throws IOException {
        String plist = SystemProperties.getApplicationPath() + SystemProperties.getApplicationName() + ".app/Contents/Info.plist";
        File plist_file = new File(plist);
        if (!plist_file.canWrite()) {
            return null;
        }
        PListEditor editor = new PListEditor(plist);
        return editor;
    }

    protected boolean checkPList() {
        try {
            PListEditor editor = this.getPList();
            if (editor == null) {
                return false;
            }
            editor.setFileTypeExtensions(EXTENSIONS);
            editor.setSimpleStringValue("CFBundleName", "Vuze");
            editor.setSimpleStringValue("CFBundleTypeName", "Vuze Download");
            editor.setSimpleStringValue("CFBundleGetInfoString", "Vuze");
            editor.setSimpleStringValue("CFBundleShortVersionString", "5.6.1.3_B01");
            editor.setSimpleStringValue("CFBundleVersion", "5.6.1.3_B01");
            editor.setArrayValues("CFBundleURLSchemes", "string", SCHEMES);
            editor.touchFile();
            return true;
        }
        catch (Throwable e) {
            System.err.println("Failed to update plist");
            e.printStackTrace();
            return false;
        }
    }

    protected void touchPList() {
        try {
            PListEditor editor = this.getPList();
            if (editor != null) {
                editor.touchFile();
            }
        }
        catch (Throwable e) {
            System.err.println("Failed to touch plist");
            e.printStackTrace();
        }
    }

    @Override
    public File getVMOptionFile() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public String[] getExplicitVMOptions() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void setExplicitVMOptions(String[] options) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup(AzureusCore _azureus_core) throws PlatformManagerException {
        PlatformManagerImpl platformManagerImpl = this;
        synchronized (platformManagerImpl) {
            this.azureus_core = _azureus_core;
            if (this.prevent_computer_sleep_pending) {
                this.prevent_computer_sleep_pending = false;
                this.setPreventComputerSleep(true);
            }
        }
        this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stopping(AzureusCore core) {
                PlatformManagerImpl platformManagerImpl = PlatformManagerImpl.this;
                synchronized (platformManagerImpl) {
                    try {
                        PlatformManagerImpl.this.setPreventComputerSleep(false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    PlatformManagerImpl.this.azureus_core = null;
                }
            }
        });
    }

    @Override
    public int getShutdownTypes() {
        return 0;
    }

    @Override
    public void shutdown(int type) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPreventComputerSleep(boolean prevent_it) throws PlatformManagerException {
        PlatformManagerImpl platformManagerImpl = this;
        synchronized (platformManagerImpl) {
            if (this.azureus_core == null) {
                this.prevent_computer_sleep_pending = prevent_it;
                return;
            }
            if (this.prevent_computer_sleep == prevent_it) {
                return;
            }
            this.prevent_computer_sleep = prevent_it;
            if (prevent_it) {
                String[] command;
                File binary = new File("/usr/bin/caffeinate");
                if (binary.canRead()) {
                    command = new String[]{binary.getAbsolutePath(), "-i"};
                } else {
                    binary = new File("/usr/bin/pmset");
                    if (binary.canRead()) {
                        command = new String[]{binary.getAbsolutePath(), "noidle"};
                    } else {
                        throw new PlatformManagerException("Unsupported capability called on platform manager");
                    }
                }
                if (this.prevent_computer_proc != null) {
                    Debug.out("eh?");
                    this.prevent_computer_proc.destroy();
                }
                try {
                    System.out.println("Starting idle sleep preventer: " + command[0]);
                    this.prevent_computer_proc = Runtime.getRuntime().exec(command);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            } else if (this.prevent_computer_proc != null) {
                System.out.println("Stopping idle sleep preventer");
                this.prevent_computer_proc.destroy();
                this.prevent_computer_proc = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPreventComputerSleep() {
        PlatformManagerImpl platformManagerImpl = this;
        synchronized (platformManagerImpl) {
            return this.prevent_computer_sleep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getRunAtLogin() throws PlatformManagerException {
        LineNumberReader lnr;
        block15: {
            String target;
            boolean state;
            if (Constants.isOSX_10_8_OrHigher) {
                String item_name = SystemProperties.getApplicationName();
                try {
                    String[] items;
                    StringBuffer sb = new StringBuffer();
                    sb.append("tell application \"");
                    sb.append("System Events");
                    sb.append("\" to get the name of every login item");
                    String[] arr$ = items = PlatformManagerImpl.performOSAScript(sb).split(",");
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) {
                            return false;
                        }
                        String item = arr$[i$];
                        if (item.trim().equalsIgnoreCase(item_name)) {
                            return true;
                        }
                        ++i$;
                    }
                }
                catch (Throwable e) {
                    throw new PlatformManagerException("Failed to get login items", e);
                }
            }
            File f = this.getLoginPList();
            if (!f.exists()) {
                return false;
            }
            File bundle_file = this.getAbsoluteBundleFile();
            if (!bundle_file.exists()) {
                return false;
            }
            try {
                this.convertToXML(f);
                lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                state = false;
                target = bundle_file.getAbsolutePath();
                try {}
                catch (Throwable throwable) {
                    Object var9_20 = null;
                    lnr.close();
                    throw throwable;
                }
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to read input file", e);
            }
            while (true) {
                String line;
                if ((line = lnr.readLine()) == null) break block15;
                if (!state) {
                    if (!this.containsTag(line, "AutoLaunchedApplicationDictionary")) continue;
                    state = true;
                    continue;
                }
                if (line.contains(target)) break;
            }
            boolean bl = true;
            Object var9_18 = null;
            lnr.close();
            return bl;
        }
        boolean bl = false;
        Object var9_19 = null;
        lnr.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setRunAtLogin(boolean run) throws PlatformManagerException {
        if (this.getRunAtLogin() == run) {
            return;
        }
        File bundle_file = this.getAbsoluteBundleFile();
        if (!bundle_file.exists()) {
            throw new PlatformManagerException("Failed to write set run-at-login, bundle not found");
        }
        String abs_target = bundle_file.getAbsolutePath();
        if (Constants.isOSX_10_8_OrHigher) {
            if (run) {
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append("tell application \"");
                    sb.append("System Events");
                    sb.append("\" to make login item at end with properties {path:\"");
                    sb.append(abs_target);
                    sb.append("\", hidden:false}");
                    System.out.println(PlatformManagerImpl.performOSAScript(sb));
                    return;
                }
                catch (Throwable e) {
                    throw new PlatformManagerException("Failed to add login item", e);
                }
            }
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("tell application \"");
                sb.append("System Events");
                sb.append("\" to delete login item \"");
                sb.append(SystemProperties.getApplicationName());
                sb.append("\"");
                System.out.println(PlatformManagerImpl.performOSAScript(sb));
                return;
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to delete login item", e);
            }
        }
        File f = this.getLoginPList();
        if (f.exists()) {
            this.convertToXML(f);
        } else {
            try {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
                try {
                    pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    pw.println("<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">");
                    pw.println("<plist version=\"1.0\">");
                    pw.println("<dict>");
                    pw.println("</dict>");
                    pw.println("</plist>");
                    Object var7_13 = null;
                    pw.close();
                }
                catch (Throwable throwable) {
                    Object var7_14 = null;
                    pw.close();
                    throw throwable;
                }
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to write output file", e);
            }
        }
        try {
            ArrayList<String> lines = new ArrayList<String>();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            int dict_line = -1;
            int auto_launch_line = -1;
            int target_index = -1;
            try {
                String line;
                while ((line = lnr.readLine()) != null) {
                    lines.add(line);
                    if (dict_line == -1 && this.containsTag(line, "<dict>")) {
                        dict_line = lines.size();
                    }
                    if (auto_launch_line == -1 && this.containsTag(line, "AutoLaunchedApplicationDictionary")) {
                        auto_launch_line = lines.size();
                    }
                    if (!line.contains(abs_target)) continue;
                    target_index = lines.size();
                }
                if (dict_line == -1) {
                    throw new PlatformManagerException("Malformed plist - no 'dict' entry");
                }
                if (auto_launch_line == -1) {
                    lines.add(dict_line, "\t<key>AutoLaunchedApplicationDictionary</key>");
                    auto_launch_line = dict_line + 1;
                    lines.add(auto_launch_line, "\t<array>");
                    lines.add(auto_launch_line + 1, "\t</array>");
                }
                Object var12_21 = null;
            }
            catch (Throwable throwable) {
                Object var12_22 = null;
                lnr.close();
                throw throwable;
            }
            lnr.close();
            if (run) {
                if (target_index != -1) return;
                if (auto_launch_line == -1) {
                    return;
                }
                target_index = auto_launch_line + 1;
                lines.add(target_index++, "\t\t<dict>");
                lines.add(target_index++, "\t\t\t<key>Path</key>");
                lines.add(target_index++, "\t\t\t<string>" + abs_target + "</string>");
                lines.add(target_index++, "\t\t</dict>");
            } else {
                if (target_index == -1) {
                    return;
                }
                while (!this.containsTag((String)lines.get(target_index), "</dict>")) {
                    lines.remove(target_index);
                }
                lines.remove(target_index);
                --target_index;
                while (!this.containsTag((String)lines.get(target_index), "<dict>")) {
                    lines.remove(target_index);
                    --target_index;
                }
                lines.remove(target_index);
            }
            File backup = new File(f.getParentFile(), f.getName() + ".bak");
            if (backup.exists()) {
                backup.delete();
            }
            if (!f.renameTo(backup)) {
                throw new PlatformManagerException("Failed to backup " + f);
            }
            boolean ok = false;
            try {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
                try {
                    for (String line : lines) {
                        pw.println(line);
                    }
                    Object var16_27 = null;
                    pw.close();
                    if (!pw.checkError()) return;
                }
                catch (Throwable throwable) {
                    Object var16_28 = null;
                    pw.close();
                    if (pw.checkError()) {
                        throw new PlatformManagerException("Failed to write output file");
                    }
                    ok = true;
                    throw throwable;
                }
                throw new PlatformManagerException("Failed to write output file");
            }
            catch (Throwable throwable) {
                Object var18_31 = null;
                if (ok) throw throwable;
                backup.renameTo(f);
                throw throwable;
            }
        }
        catch (PlatformManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to write output file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void convertToXML(File file) throws PlatformManagerException {
        try {
            LineNumberReader lnr;
            block8: {
                block7: {
                    block6: {
                        lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        try {
                            String line = lnr.readLine();
                            if (line == null) {
                                Object var5_5 = null;
                                break block6;
                            }
                            if (line.trim().toLowerCase().startsWith("<?xml")) {
                                break block7;
                            }
                            Runtime.getRuntime().exec(new String[]{this.findCommand("plutil"), "-convert", "xml1", file.getAbsolutePath()}).waitFor();
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            lnr.close();
                            throw throwable;
                        }
                    }
                    lnr.close();
                    return;
                }
                Object var5_6 = null;
                lnr.close();
                return;
            }
            Object var5_7 = null;
            lnr.close();
            return;
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to convert plist to xml");
        }
    }

    private String findCommand(String name) {
        String[] locations;
        for (String s : locations = new String[]{"/bin", "/usr/bin"}) {
            File f = new File(s, name);
            if (!f.exists() || !f.canRead()) continue;
            return f.getAbsolutePath();
        }
        return name;
    }

    private boolean containsTag(String line, String tag) {
        line = line.trim().toLowerCase(Locale.US);
        tag = tag.toLowerCase(Locale.US);
        StringBuffer line2 = new StringBuffer(line.length());
        for (char c : line.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            line2.append(c);
        }
        return line2.toString().contains(tag);
    }

    private File getLoginPList() throws PlatformManagerException {
        return new File(System.getProperty("user.home"), "/Library/Preferences/loginwindow.plist");
    }

    @Override
    public String getUserDataDirectory() throws PlatformManagerException {
        return new File(System.getProperty("user.home") + "/Library/Application Support/" + SystemProperties.APPLICATION_NAME).getPath() + SystemProperties.SEP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getComputerName() {
        if (this.computer_name_tried) {
            return this.computer_name;
        }
        try {
            String host;
            String result = null;
            String hostname = System.getenv("HOSTNAME");
            if (hostname != null && hostname.length() > 0) {
                result = hostname;
            }
            if (result == null && (host = System.getenv("HOST")) != null && host.length() > 0) {
                result = host;
            }
            if (result == null) {
                try {
                    String[] to_run = new String[]{"/bin/sh", "-c", "echo $HOSTNAME"};
                    Process p = Runtime.getRuntime().exec(to_run);
                    if (p.waitFor() == 0) {
                        int pos;
                        byte[] buffer;
                        int len;
                        String output = "";
                        InputStream is = p.getInputStream();
                        while ((len = is.read(buffer = new byte[1024])) > 0 && (output = output + new String(buffer, 0, len)).length() <= 64) {
                        }
                        if (output.length() > 0 && (pos = (result = output.trim()).indexOf(32)) != -1) {
                            result = result.substring(0, pos).trim();
                        }
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (result != null) {
                int pos = result.lastIndexOf(46);
                if (pos != -1) {
                    result = result.substring(0, pos);
                }
                if (result.length() > 0) {
                    if (result.length() > 32) {
                        result = result.substring(0, 32);
                    }
                    this.computer_name = result;
                }
            }
            String string = this.computer_name;
            Object var10_13 = null;
            this.computer_name_tried = true;
            return string;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.computer_name_tried = true;
            throw throwable;
        }
    }

    @Override
    public File getLocation(long location_id) throws PlatformManagerException {
        switch ((int)location_id) {
            case 1: {
                return new File(this.getUserDataDirectory());
            }
            case 3: {
                try {
                    return new File(OSXAccess.getDocDir());
                }
                catch (Throwable e) {
                    return new File(System.getProperty("user.home"), "Documents");
                }
            }
        }
        return null;
    }

    @Override
    public boolean isApplicationRegistered() throws PlatformManagerException {
        try {
            if (OSXAccess.canSetDefaultApp()) {
                for (String ext : EXTENSIONS) {
                    if (this.isOurExt(ext)) continue;
                    return false;
                }
                for (String mimeType : MIMETYPES) {
                    if (this.isOurMimeType(mimeType)) continue;
                    return false;
                }
                for (String scheme : SCHEMES) {
                    if (this.isOurScheme(scheme)) continue;
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private boolean isOurExt(String ext) {
        try {
            String appForExt = OSXAccess.getDefaultAppForExt(ext);
            return BUNDLE_ID.equals(appForExt);
        }
        catch (Throwable e) {
            return true;
        }
    }

    private boolean isOurScheme(String scheme) {
        try {
            String appForScheme = OSXAccess.getDefaultAppForScheme(scheme);
            return BUNDLE_ID.equals(appForScheme);
        }
        catch (Throwable e) {
            return true;
        }
    }

    private boolean isOurMimeType(String mimetype) {
        try {
            String appForMimeType = OSXAccess.getDefaultAppForMime(mimetype);
            return BUNDLE_ID.equals(appForMimeType);
        }
        catch (Throwable e) {
            return true;
        }
    }

    private String getBundlePath() {
        return SystemProperties.getApplicationPath() + SystemProperties.getApplicationName() + ".app";
    }

    private File getAbsoluteBundleFile() {
        return new File(this.getBundlePath()).getAbsoluteFile();
    }

    @Override
    public String getApplicationCommandLine() throws PlatformManagerException {
        try {
            File osx_app_bundle = this.getAbsoluteBundleFile();
            if (!osx_app_bundle.exists()) {
                String msg = "OSX app bundle not found: [" + osx_app_bundle.toString() + "]";
                System.out.println(msg);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, msg));
                }
                throw new PlatformManagerException(msg);
            }
            return "open -a \"" + osx_app_bundle.toString() + "\"";
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isAdditionalFileTypeRegistered(String name, String type) throws PlatformManagerException {
        String osxType = type.startsWith(".") ? type.substring(1) : type;
        return this.isOurExt(osxType);
    }

    @Override
    public void unregisterAdditionalFileType(String name, String type) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void registerAdditionalFileType(String name, String description, String type, String content_type) throws PlatformManagerException {
        try {
            if (OSXAccess.canSetDefaultApp()) {
                if (type != null) {
                    String osxType = type.startsWith(".") ? type.substring(1) : type;
                    OSXAccess.setDefaultAppForExt(BUNDLE_ID, osxType);
                }
                if (content_type != null) {
                    OSXAccess.setDefaultAppForMime(BUNDLE_ID, content_type);
                }
            }
        }
        catch (Throwable t) {
            throw new PlatformManagerException("registerAdditionalFileType failed on platform manager", t);
        }
    }

    @Override
    public void registerApplication() throws PlatformManagerException {
        this.touchPList();
        try {
            if (OSXAccess.canSetDefaultApp()) {
                for (String ext : EXTENSIONS) {
                    OSXAccess.setDefaultAppForExt(BUNDLE_ID, ext);
                }
                for (String mimeType : MIMETYPES) {
                    OSXAccess.setDefaultAppForMime(BUNDLE_ID, mimeType);
                }
                for (String scheme : SCHEMES) {
                    OSXAccess.setDefaultAppForScheme(BUNDLE_ID, scheme);
                }
                this.isApplicationRegistered();
            }
        }
        catch (Throwable t) {
            throw new PlatformManagerException("registerApplication failed on platform manager", t);
        }
    }

    @Override
    public void createProcess(String cmd, boolean inheritsHandles) throws PlatformManagerException {
        try {
            PlatformManagerImpl.performRuntimeExec(cmd.split(" "));
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to create process", e);
        }
    }

    private Class<?> getFileManagerClass() {
        if (this.claFileManager != null) {
            return this.claFileManager;
        }
        try {
            Class<?> claCocoaUIEnhancer = Class.forName("org.gudy.azureus2.ui.swt.osx.CocoaUIEnhancer");
            if (((Boolean)claCocoaUIEnhancer.getMethod("isInitialized", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                this.claFileManager = Class.forName("com.apple.eio.FileManager");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.claFileManager;
    }

    @Override
    public void performRecoverableFileDelete(String path) throws PlatformManagerException {
        boolean useOSA;
        File file = new File(path);
        if (!file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Cannot find " + file.getName()));
            }
            return;
        }
        try {
            Object result;
            Method methMoveToTrash;
            Class<?> claFileManager = this.getFileManagerClass();
            if (claFileManager != null && (methMoveToTrash = claFileManager.getMethod("moveToTrash", File.class)) != null && (result = methMoveToTrash.invoke(null, file)) instanceof Boolean && ((Boolean)result).booleanValue()) {
                return;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        boolean bl = useOSA = !NativeInvocationBridge.sharedInstance().isEnabled() || !NativeInvocationBridge.sharedInstance().performRecoverableFileDelete(file);
        if (useOSA) {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("tell application \"");
                sb.append("Finder");
                sb.append("\" to move (posix file \"");
                sb.append(path);
                sb.append("\" as alias) to the trash");
                PlatformManagerImpl.performOSAScript(sb);
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to move file", e);
            }
        }
    }

    @Override
    public boolean hasCapability(PlatformManagerCapabilities capability) {
        return this.capabilitySet.contains(capability);
    }

    @Override
    public void dispose() {
        try {
            if (NativeInvocationBridge.hasSharedInstance()) {
                NativeInvocationBridge.sharedInstance().dispose();
            }
        }
        catch (Throwable t) {
            Debug.out("Problem disposing NativeInvocationBridge", t);
        }
    }

    @Override
    public void setTCPTOSEnabled(boolean enabled) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void copyFilePermissions(String from_file_name, String to_file_name) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void showFile(String path) throws PlatformManagerException {
        File file = new File(path);
        if (!file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Cannot find " + file.getName()));
            }
            throw new PlatformManagerException("File not found");
        }
        this.showInFinder(file);
    }

    public void playSystemAlert() {
        try {
            PlatformManagerImpl.performRuntimeExec(new String[]{"beep"});
        }
        catch (IOException e) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Cannot play system alert"));
            }
            Logger.log(new LogEvent(LOGID, "", e));
        }
    }

    public void showInFinder(File path) {
        boolean useOSA;
        try {
            Object result;
            Method methRevealInFinder;
            Class<?> claFileManager = this.getFileManagerClass();
            if (claFileManager != null && PlatformManagerImpl.getFileBrowserName().equals("Finder") && (methRevealInFinder = claFileManager.getMethod("revealInFinder", File.class)) != null && (result = methRevealInFinder.invoke(null, path)) instanceof Boolean && ((Boolean)result).booleanValue()) {
                return;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        boolean bl = useOSA = !NativeInvocationBridge.sharedInstance().isEnabled() || !NativeInvocationBridge.sharedInstance().showInFinder(path, fileBrowserName);
        if (useOSA) {
            StringBuffer sb = new StringBuffer();
            sb.append("tell application \"");
            sb.append(PlatformManagerImpl.getFileBrowserName());
            sb.append("\"\n");
            sb.append("reveal (posix file \"");
            sb.append(path);
            sb.append("\" as alias)\n");
            sb.append("activate\n");
            sb.append("end tell\n");
            try {
                PlatformManagerImpl.performOSAScript(sb);
            }
            catch (IOException e) {
                Logger.log(new LogAlert(false, 3, e.getMessage()));
            }
        }
    }

    public void showInTerminal(String path) {
        this.showInTerminal(new File(path));
    }

    public void showInTerminal(File path) {
        if (path.isFile()) {
            path = path.getParentFile();
        }
        if (path != null && path.isDirectory()) {
            StringBuffer sb = new StringBuffer();
            sb.append("tell application \"");
            sb.append("Terminal");
            sb.append("\" to do script \"cd ");
            sb.append(path.getAbsolutePath().replaceAll(" ", "\\ "));
            sb.append("\"");
            try {
                PlatformManagerImpl.performOSAScript(sb);
            }
            catch (IOException e) {
                Logger.log(new LogAlert(false, 3, e.getMessage()));
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, 1, "Cannot find " + (path == null ? "null" : path.getName())));
        }
    }

    protected static String performOSAScript(CharSequence cmd) throws IOException {
        return PlatformManagerImpl.performOSAScript(new CharSequence[]{cmd});
    }

    protected static String performOSAScript(CharSequence[] cmds) throws IOException {
        String[] cmdargs = new String[2 * cmds.length + 1];
        cmdargs[0] = "osascript";
        for (int i = 0; i < cmds.length; ++i) {
            cmdargs[i * 2 + 1] = "-e";
            cmdargs[i * 2 + 2] = String.valueOf(cmds[i]);
        }
        Process osaProcess = PlatformManagerImpl.performRuntimeExec(cmdargs);
        BufferedReader reader = new BufferedReader(new InputStreamReader(osaProcess.getInputStream()));
        String line = reader.readLine();
        reader.close();
        reader = new BufferedReader(new InputStreamReader(osaProcess.getErrorStream()));
        String errorMsg = reader.readLine();
        reader.close();
        try {
            osaProcess.destroy();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (errorMsg != null) {
            throw new IOException(errorMsg);
        }
        return line;
    }

    protected static String performOSAScript(File script) throws IOException {
        Process osaProcess = PlatformManagerImpl.performRuntimeExec(new String[]{"osascript", script.getPath()});
        BufferedReader reader = new BufferedReader(new InputStreamReader(osaProcess.getInputStream()));
        String line = reader.readLine();
        reader.close();
        reader = new BufferedReader(new InputStreamReader(osaProcess.getErrorStream()));
        String errorMsg = reader.readLine();
        reader.close();
        try {
            osaProcess.destroy();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (errorMsg != null) {
            throw new IOException(errorMsg);
        }
        return line;
    }

    protected static boolean compileOSAScript(CharSequence cmd, File destination) {
        return PlatformManagerImpl.compileOSAScript(new CharSequence[]{cmd}, destination);
    }

    protected static boolean compileOSAScript(CharSequence[] cmds, File destination) {
        String errorMsg;
        String[] cmdargs = new String[2 * cmds.length + 3];
        cmdargs[0] = "osacompile";
        for (int i = 0; i < cmds.length; ++i) {
            cmdargs[i * 2 + 1] = "-e";
            cmdargs[i * 2 + 2] = String.valueOf(cmds[i]);
        }
        cmdargs[cmdargs.length - 2] = "-o";
        cmdargs[cmdargs.length - 1] = destination.getPath();
        try {
            Process osaProcess = PlatformManagerImpl.performRuntimeExec(cmdargs);
            BufferedReader reader = new BufferedReader(new InputStreamReader(osaProcess.getErrorStream()));
            errorMsg = reader.readLine();
            reader.close();
        }
        catch (IOException e) {
            Debug.outNoStack("OSACompile Execution Failed: " + e.getMessage());
            Debug.printStackTrace(e);
            return false;
        }
        return errorMsg == null;
    }

    protected static Process performRuntimeExec(String[] cmdargs) throws IOException {
        try {
            return Runtime.getRuntime().exec(cmdargs);
        }
        catch (IOException e) {
            Logger.log(new LogAlert(false, e.getMessage(), e));
            throw e;
        }
    }

    private static String getFileBrowserName() {
        return fileBrowserName;
    }

    @Override
    public boolean testNativeAvailability(String name) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void traceRoute(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void ping(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getMaxOpenFiles() throws PlatformManagerException {
        block18: {
            block20: {
                block19: {
                    lnr = null;
                    try {
                        try {
                            p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "ulimit -a"});
                            lnr = new LineNumberReader(new InputStreamReader(p.getInputStream()));
                            map = new HashMap<String, String>();
                            while (true) {
                                if ((line = lnr.readLine()) == null) {
                                    open_files = (String)map.get("open files");
                                    if (open_files != null) {
                                        break;
                                    }
                                    break block18;
                                }
                                pos1 = line.indexOf(40);
                                pos2 = line.indexOf(41, pos1 + 1);
                                keyword = line.substring(0, pos1).trim().toLowerCase();
                                value = line.substring(pos2 + 1).trim();
                                map.put(keyword, value);
                            }
                            if (open_files.equalsIgnoreCase("unlimited")) {
                                pos1 = 0;
                                var10_11 = null;
                                if (lnr == null) return pos1;
                                break block19;
                            }
                            try {
                                pos1 = Integer.parseInt(open_files);
                                break block20;
                            }
                            catch (Throwable e) {
                                Debug.out("open files invalid: " + open_files);
                                break block18;
                            }
                        }
                        catch (Throwable var2_3) {
                            var10_14 = null;
                            if (lnr == null) return -1;
                            try {
                                lnr.close();
                                return -1;
                            }
                            catch (Throwable e) {
                                return -1;
                            }
                        }
                    }
                    catch (Throwable var9_21) {
                        var10_15 = null;
                        if (lnr == null) throw var9_21;
                        ** try [egrp 3[TRYBLOCK] [9 : 241->248)] { 
lbl47:
                        // 1 sources

                        lnr.close();
                        throw var9_21;
lbl49:
                        // 1 sources

                        catch (Throwable e) {
                            // empty catch block
                        }
                        throw var9_21;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [9 : 241->248)] { 
lbl54:
                // 1 sources

                lnr.close();
                return pos1;
lbl56:
                // 1 sources

                catch (Throwable e) {
                    // empty catch block
                }
                return pos1;
            }
            var10_12 = null;
            if (lnr == null) return pos1;
            try {}
            catch (Throwable e) {
                // empty catch block
                return pos1;
            }
            lnr.close();
            return pos1;
        }
        var10_13 = null;
        if (lnr == null) return -1;
        try {}
        catch (Throwable e) {}
        lnr.close();
        return -1;
        return -1;
    }

    @Override
    public void addListener(PlatformManagerListener listener) {
    }

    @Override
    public void removeListener(PlatformManagerListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("PlatformManager: MacOSX");
        try {
            writer.indent();
            if (OSXAccess.isLoaded()) {
                try {
                    writer.println("Version " + this.getVersion());
                    writer.println("User Data Dir: " + this.getLocation(1L));
                    writer.println("User Doc Dir: " + this.getLocation(3L));
                }
                catch (PlatformManagerException e) {}
            } else {
                writer.println("Not loaded");
            }
            writer.println("Computer Name: " + this.getComputerName());
            try {
                writer.println("Max Open Files: " + this.getMaxOpenFiles());
            }
            catch (Throwable e) {
                writer.println("Max Open Files: " + Debug.getNestedExceptionMessage(e));
            }
            Object var4_4 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            writer.exdent();
            throw throwable;
        }
    }

    public String getAzComputerID() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void requestUserAttention(int type, Object data) throws PlatformManagerException {
        if (type == 3) {
            return;
        }
        try {
            Class<?> claNSApplication = Class.forName("com.apple.eawt.Application");
            Method methGetApplication = claNSApplication.getMethod("getApplication", new Class[0]);
            Object app = methGetApplication.invoke(null, new Object[0]);
            Method methRequestUserAttention = claNSApplication.getMethod("requestUserAttention", Boolean.class);
            if (type == 1) {
                methRequestUserAttention.invoke(app, false);
            } else if (type == 2) {
                methRequestUserAttention.invoke(app, true);
            }
        }
        catch (Exception e) {
            throw new PlatformManagerException("Failed to request user attention", e);
        }
    }

    @Override
    public Class<?> loadClass(ClassLoader loader, String class_name) throws PlatformManagerException {
        try {
            return loader.loadClass(class_name);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("load of '" + class_name + "' failed", e);
        }
    }

    public static void main(String[] args) {
        try {
            SystemProperties.setApplicationName("Vuze");
            PlatformManagerImpl pm = new PlatformManagerImpl();
            pm.getRunAtLogin();
            pm.setRunAtLogin(false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        class_mon = new AEMonitor("PlatformManager");
        fileBrowserName = "Finder";
        PlatformManagerImpl.initializeSingleton();
    }
}

