/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class TrackerChangerWindow {
    public TrackerChangerWindow(final DownloadManager[] dms) {
        final Shell shell = ShellFactory.createMainShell(2144);
        shell.setText(MessageText.getString("TrackerChangerWindow.title"));
        Utils.setShellIcon(shell);
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)label, "TrackerChangerWindow.newtracker");
        GridData gridData = new GridData();
        gridData.widthHint = 400;
        label.setLayoutData((Object)gridData);
        final Text url = new Text((Composite)shell, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 400;
        url.setLayoutData((Object)gridData);
        Utils.setTextLinkFromClipboard(shell, url, false, false);
        Label labelSeparator = new Label((Composite)shell, 258);
        gridData = new GridData(768);
        labelSeparator.setLayoutData((Object)gridData);
        Composite panel = new Composite((Composite)shell, 0);
        gridData = new GridData(768);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        label = new Label(panel, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Button ok = new Button(panel, 8);
        ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.horizontalAlignment = 3;
        ok.setLayoutData((Object)gridData);
        shell.setDefaultButton(ok);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    String[] _urls = url.getText().split(",");
                    ArrayList<String> urls = new ArrayList<String>();
                    for (String url2 : _urls) {
                        if ((url2 = url2.trim()).length() <= 0) continue;
                        try {
                            new URL(url2);
                            urls.add(0, url2);
                        }
                        catch (Throwable e) {
                            Debug.out("Invalid URL: " + url2);
                        }
                    }
                    for (DownloadManager dm : dms) {
                        TOTorrent torrent = dm.getTorrent();
                        if (torrent == null) continue;
                        for (String url3 : urls) {
                            TorrentUtils.announceGroupsInsertFirst(torrent, url3);
                        }
                        TorrentUtils.writeToFile(torrent);
                        TRTrackerAnnouncer announcer = dm.getTrackerClient();
                        if (announcer == null) continue;
                        announcer.resetTrackerUrl(false);
                    }
                    shell.dispose();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        Button cancel = new Button(panel, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.horizontalAlignment = 3;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                shell.dispose();
            }
        });
        shell.pack();
        Utils.centreWindow(shell);
        Utils.createURLDropTarget((Composite)shell, url);
        shell.open();
    }
}

