/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.AnnounceCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.AverageBytesInItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.AverageBytesOutItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.BadNATCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.CompletedCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.DateAddedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.DownloadedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.LeftItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.PassiveItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.PeerCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.ScrapeCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.SeedCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.StatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.TotalBytesInItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.TotalBytesOutItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.TrackerItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.UploadedItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyTrackerView
extends TableViewTab<TRHostTorrent>
implements TRHostListener,
CategoryManagerListener,
TableLifeCycleListener,
TableSelectionListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
UIPluginViewToolBarListener {
    private static TableColumnCore[] basicItems = null;
    protected static final TorrentAttribute category_attribute = TorrentManagerImpl.getSingleton().getAttribute("Category");
    private Menu menuCategory;
    private TableViewSWT<TRHostTorrent> tv;

    public MyTrackerView() {
        super("MyTrackerView");
        if (basicItems == null) {
            basicItems = new TableColumnCore[]{new NameItem(), new TrackerItem(), new StatusItem(), new CategoryItem(), new PassiveItem(), new SeedCountItem(), new PeerCountItem(), new BadNATCountItem(), new AnnounceCountItem(), new ScrapeCountItem(), new CompletedCountItem(), new UploadedItem(), new DownloadedItem(), new LeftItem(), new TotalBytesInItem(), new AverageBytesInItem(), new TotalBytesOutItem(), new AverageBytesOutItem(), new DateAddedItem()};
        }
        this.tv = TableViewFactory.createTableViewSWT(TrackerTorrent.class, "MyTracker", this.getPropertiesPrefix(), basicItems, "name", 268503042);
        this.tv.addLifeCycleListener(this);
        this.tv.addSelectionListener(this, false);
        this.tv.addMenuFillListener(this);
        this.tv.addRefreshListener(this, false);
    }

    @Override
    public TableViewSWT<TRHostTorrent> initYourTableView() {
        return this.tv;
    }

    @Override
    public void tableViewInitialized() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getTrackerHost().addListener(MyTrackerView.this);
            }
        });
    }

    @Override
    public void tableViewDestroyed() {
        try {
            AzureusCoreFactory.getSingleton().getTrackerHost().removeListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        final TRHostTorrent torrent = (TRHostTorrent)this.tv.getFirstSelectedDataSource();
        if (torrent == null) {
            return;
        }
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                UIFunctions uiFunctions;
                DownloadManager dm = core.getGlobalManager().getDownloadManager(torrent.getTorrent());
                if (dm != null && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                    uiFunctions.getMDI().showEntryByID("DMDetails", dm);
                }
            }
        });
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        this.menuCategory = new Menu((Decorations)this.getComposite().getShell(), 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(this.menuCategory);
        this.addCategorySubMenu();
        new MenuItem(menu, 2);
        MenuItem itemStart = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStart, "MyTorrentsView.menu.start");
        Utils.setMenuItemImage(itemStart, "start");
        MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        Utils.setMenuItemImage(itemStop, "stop");
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MyTorrentsView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        Object[] hostTorrents = this.tv.getSelectedDataSources().toArray();
        itemStart.setEnabled(false);
        itemStop.setEnabled(false);
        itemRemove.setEnabled(false);
        if (hostTorrents.length > 0) {
            boolean start_ok = true;
            boolean stop_ok = true;
            boolean remove_ok = true;
            for (int i = 0; i < hostTorrents.length; ++i) {
                TRHostTorrent host_torrent = (TRHostTorrent)hostTorrents[i];
                int status = host_torrent.getStatus();
                if (status != 1) {
                    start_ok = false;
                }
                if (status == 2) continue;
                stop_ok = false;
            }
            itemStart.setEnabled(start_ok);
            itemStop.setEnabled(stop_ok);
            itemRemove.setEnabled(remove_ok);
        }
        itemStart.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.startSelectedTorrents();
            }
        });
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.stopSelectedTorrents();
            }
        });
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.removeSelectedTorrents();
            }
        });
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    @Override
    public void torrentAdded(TRHostTorrent host_torrent) {
        this.tv.addDataSource(host_torrent);
    }

    @Override
    public void torrentChanged(TRHostTorrent t) {
    }

    @Override
    public void torrentRemoved(TRHostTorrent host_torrent) {
        this.tv.removeDataSource(host_torrent);
    }

    @Override
    public boolean handleExternalRequest(InetSocketAddress client, String user, String url, URL absolute_url, String header, InputStream is, OutputStream os, AsyncController async) throws IOException {
        return false;
    }

    @Override
    public void tableRefresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
        TableRowCore[] rows = this.tv.getRows();
        for (int x = 0; x < rows.length; ++x) {
            Color fg;
            TRHostTorrent host_torrent;
            TableRowSWT row = (TableRowSWT)rows[x];
            if (row == null || (host_torrent = (TRHostTorrent)rows[x].getDataSource(true)) == null) continue;
            long uploaded = host_torrent.getTotalUploaded();
            long downloaded = host_torrent.getTotalDownloaded();
            long left = host_torrent.getTotalLeft();
            int seed_count = host_torrent.getSeedCount();
            host_torrent.setData("GUI_PeerCount", new Long(host_torrent.getLeecherCount()));
            host_torrent.setData("GUI_SeedCount", new Long(seed_count));
            host_torrent.setData("GUI_BadNATCount", new Long(host_torrent.getBadNATCount()));
            host_torrent.setData("GUI_Uploaded", new Long(uploaded));
            host_torrent.setData("GUI_Downloaded", new Long(downloaded));
            host_torrent.setData("GUI_Left", new Long(left));
            if (seed_count == 0 || (fg = row.getForeground()) == null || !fg.equals((Object)Colors.blues[7])) continue;
            row.setForeground(Colors.blues[7]);
        }
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        boolean start = false;
        boolean stop = false;
        boolean remove = false;
        Object[] hostTorrents = this.tv.getSelectedDataSources().toArray();
        if (hostTorrents.length > 0) {
            remove = true;
            for (int i = 0; i < hostTorrents.length; ++i) {
                TRHostTorrent host_torrent = (TRHostTorrent)hostTorrents[i];
                int status = host_torrent.getStatus();
                if (status == 1) {
                    start = true;
                }
                if (status != 2) continue;
                stop = true;
            }
        }
        list.put("start", start ? 1L : 0L);
        list.put("stop", stop ? 1L : 0L);
        list.put("remove", remove ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        String itemKey = item.getID();
        if (itemKey.equals("start")) {
            this.startSelectedTorrents();
            return true;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedTorrents();
            return true;
        }
        if (itemKey.equals("remove")) {
            this.removeSelectedTorrents();
            return true;
        }
        return false;
    }

    private void stopSelectedTorrents() {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                if (torrent.getStatus() == 2) {
                    torrent.stop();
                }
            }
        });
    }

    private void startSelectedTorrents() {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                if (torrent.getStatus() == 1) {
                    torrent.start();
                }
            }
        });
    }

    private void removeSelectedTorrents() {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                try {
                    torrent.remove();
                }
                catch (TRHostTorrentRemovalVetoException f) {
                    Logger.log(new LogAlert((Object)torrent, false, "{globalmanager.download.remove.veto}", (Throwable)f));
                }
            }
        });
    }

    private void addCategorySubMenu() {
        int i;
        MenuItem[] items = this.menuCategory.getItems();
        for (i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(this.menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MyTrackerView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(this.menuCategory, 2);
            }
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                itemCategory = new MenuItem(this.menuCategory, 8);
                itemCategory.setText(categories[i].getName());
                itemCategory.setData("Category", categories[i]);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MyTrackerView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
            }
            new MenuItem(this.menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(this.menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MyTrackerView.this.addCategory();
            }
        });
    }

    @Override
    public void categoryAdded(Category category) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTrackerView.this.addCategorySubMenu();
            }
        });
    }

    @Override
    public void categoryRemoved(Category category) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTrackerView.this.addCategorySubMenu();
            }
        });
    }

    @Override
    public void categoryChanged(Category category) {
    }

    private void addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(SWTThread.getInstance().getDisplay());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
    }

    private void assignSelectedToCategory(final Category category) {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                MyTrackerView.this.assignSelectedToCategory(core, category);
            }
        });
    }

    private void assignSelectedToCategory(final AzureusCore core, final Category category) {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                TRHostTorrent tr_torrent = (TRHostTorrent)row.getDataSource(true);
                TOTorrent torrent = tr_torrent.getTorrent();
                DownloadManager dm = core.getGlobalManager().getDownloadManager(torrent);
                if (dm != null) {
                    dm.getDownloadState().setCategory(category);
                } else {
                    String cat_str = category == null ? null : (category == CategoryManager.getCategory(2) ? null : category.getName());
                    TorrentUtils.setPluginStringProperty(torrent, "azcoreplugins.category", cat_str);
                    try {
                        TorrentUtils.writeToFile(torrent);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        });
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void selected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }
}

