/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableViewTab<DATASOURCETYPE>
implements UISWTViewCoreEventListener,
AEDiagnosticsEvidenceGenerator {
    private TableViewSWT<DATASOURCETYPE> tv;
    private Object parentDataSource;
    private final String propertiesPrefix;
    private Composite composite;
    private UISWTView swtView;
    private Text filterTextControl;
    private TableViewFilterCheck.TableViewFilterCheckEx<DATASOURCETYPE> filterCheck;

    public TableViewTab(String propertiesPrefix) {
        this.propertiesPrefix = propertiesPrefix;
    }

    public TableViewSWT<DATASOURCETYPE> getTableView() {
        return this.tv;
    }

    public final void initialize(Composite composite) {
        this.tv = this.initYourTableView();
        if (this.parentDataSource != null) {
            this.tv.setParentDataSource(this.parentDataSource);
        }
        Composite parent = this.initComposite(composite);
        this.tv.initialize(this.swtView, parent);
        this.composite = parent != composite ? composite : this.tv.getComposite();
        if (this.filterCheck != null) {
            this.tv.enableFilterCheck(this.filterTextControl, this.filterCheck);
        }
        this.tableViewTabInitComplete();
    }

    public void tableViewTabInitComplete() {
    }

    public Composite initComposite(Composite composite) {
        return composite;
    }

    public abstract TableViewSWT<DATASOURCETYPE> initYourTableView();

    public final void dataSourceChanged(Object newDataSource) {
        this.parentDataSource = newDataSource;
        if (this.tv != null) {
            this.tv.setParentDataSource(newDataSource);
        }
    }

    public final void refresh() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    private final void delete() {
        if (this.tv != null) {
            this.tv.delete();
        }
        this.tv = null;
    }

    public String getFullTitle() {
        return MessageText.getString(this.getPropertiesPrefix() + ".title.full");
    }

    @Override
    public void generate(IndentWriter writer) {
        if (this.tv != null) {
            this.tv.generate(writer);
        }
    }

    public Composite getComposite() {
        return this.composite;
    }

    public String getPropertiesPrefix() {
        return this.propertiesPrefix;
    }

    public Menu getPrivateMenu() {
        return null;
    }

    public void viewActivated() {
        if (this.tv instanceof TableViewSWT) {
            this.tv.isVisible();
        }
    }

    private void viewDeactivated() {
        if (this.tv instanceof TableViewSWT) {
            this.tv.isVisible();
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                this.swtView.setTitle(this.getFullTitle());
                this.updateLanguage();
                Messages.updateLanguageForControl((Widget)this.composite);
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    public void updateLanguage() {
    }

    public UISWTView getSWTView() {
        return this.swtView;
    }

    public void enableFilterCheck(Text textControl, TableViewFilterCheck.TableViewFilterCheckEx<DATASOURCETYPE> filter_check_handler) {
        if (this.tv != null) {
            this.tv.enableFilterCheck(textControl, filter_check_handler);
        } else {
            this.filterTextControl = textControl;
            this.filterCheck = filter_check_handler;
        }
    }
}

