/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.custom.impl;

import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationException;
import com.aelitis.azureus.core.custom.impl.CustomizationManagerImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.util.Debug;

public class CustomizationImpl
implements Customization {
    private CustomizationManagerImpl manager;
    private String name;
    private String version;
    private File contents;

    protected CustomizationImpl(CustomizationManagerImpl _manager, String _name, String _version, File _contents) throws CustomizationException {
        this.manager = _manager;
        this.name = _name;
        this.version = _version;
        this.contents = _contents;
        if (!this.contents.exists()) {
            throw new CustomizationException("Content file '" + this.contents + " not found");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    protected File getContents() {
        return this.contents;
    }

    public Object getProperty(String name) {
        return null;
    }

    public boolean isActive() {
        return true;
    }

    public void setActive(boolean active) {
    }

    public InputStream getResource(String resource_name) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream[] getResources(String resource_name) {
        ZipEntry entry;
        ArrayList<ByteArrayInputStream> result = new ArrayList<ByteArrayInputStream>();
        ZipInputStream zis = null;
        zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.contents)));
        while ((entry = zis.getNextEntry()) != null) {
            int len;
            String name = entry.getName();
            int pos = name.indexOf(resource_name + "/");
            if (pos == -1 || !name.endsWith(".vuze")) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
            byte[] buffer = new byte[16384];
            while ((len = zis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            result.add(new ByteArrayInputStream(baos.toByteArray()));
        }
        Object var11_11 = null;
        if (zis == null) return result.toArray(new InputStream[result.size()]);
        try {
            zis.close();
            return result.toArray(new InputStream[result.size()]);
        }
        catch (Throwable e2) {}
        return result.toArray(new InputStream[result.size()]);
        {
            catch (Throwable e) {
                Debug.out(e);
                Object var11_12 = null;
                if (zis == null) return result.toArray(new InputStream[result.size()]);
                try {
                    zis.close();
                    return result.toArray(new InputStream[result.size()]);
                }
                catch (Throwable e2) {}
                return result.toArray(new InputStream[result.size()]);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (zis == null) throw throwable;
            try {
                zis.close();
                throw throwable;
            }
            catch (Throwable e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void exportToVuzeFile(File file) throws CustomizationException {
        this.manager.exportCustomization(this, file);
    }
}

