/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.router.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.router.DHTRouterAdapter;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterContactAttachment;
import com.aelitis.azureus.core.dht.router.DHTRouterObserver;
import com.aelitis.azureus.core.dht.router.DHTRouterStats;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterContactImpl;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterNodeImpl;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterStatsImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class DHTRouterImpl
implements DHTRouter {
    private static final int SMALLEST_SUBTREE_MAX_EXCESS = 10240;
    private boolean is_bootstrap_proxy;
    private int K;
    private int B;
    private int max_rep_per_node;
    private DHTLogger logger;
    private int smallest_subtree_max;
    private DHTRouterAdapter adapter;
    private DHTRouterContactImpl local_contact;
    private byte[] router_node_id;
    private DHTRouterNodeImpl root;
    private DHTRouterNodeImpl smallest_subtree;
    private int consecutive_dead;
    private static long random_seed = SystemTime.getCurrentTime();
    private Random random;
    private List<DHTRouterContactImpl> outstanding_pings = new ArrayList<DHTRouterContactImpl>();
    private List<DHTRouterContactImpl> outstanding_adds = new ArrayList<DHTRouterContactImpl>();
    private DHTRouterStatsImpl stats = new DHTRouterStatsImpl(this);
    private AEMonitor this_mon = new AEMonitor("DHTRouter");
    private static AEMonitor class_mon = new AEMonitor("DHTRouter:class");
    private final CopyOnWriteList<DHTRouterObserver> observers = new CopyOnWriteList();
    private boolean sleeping;
    private boolean suspended;
    private BloomFilter recent_contact_bloom = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(10240), 2);
    private TimerEventPeriodic timer_event;
    private volatile int seed_in_ticks;
    private static final int TICK_PERIOD = 10000;
    private static final int SEED_DELAY_PERIOD = 60000;
    private static final int SEED_DELAY_TICKS = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTRouterImpl(int _K, int _B, int _max_rep_per_node, byte[] _router_node_id, DHTRouterContactAttachment _attachment, DHTLogger _logger) {
        try {
            class_mon.enter();
            this.random = new Random(random_seed++);
            Object var8_7 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            class_mon.exit();
            throw throwable;
        }
        this.is_bootstrap_proxy = COConfigurationManager.getBooleanParameter("dht.bootstrap.is.proxy", false);
        this.K = _K;
        this.B = _B;
        this.max_rep_per_node = _max_rep_per_node;
        this.logger = _logger;
        this.smallest_subtree_max = 1;
        for (int i = 0; i < this.B; ++i) {
            this.smallest_subtree_max *= 2;
        }
        this.smallest_subtree_max += 10240;
        this.router_node_id = _router_node_id;
        ArrayList<DHTRouterContactImpl> buckets = new ArrayList<DHTRouterContactImpl>();
        this.local_contact = new DHTRouterContactImpl(this.router_node_id, _attachment, true);
        buckets.add(this.local_contact);
        this.root = new DHTRouterNodeImpl(this, 0, true, buckets);
        this.timer_event = SimpleTimer.addPeriodicEvent("DHTRouter:pinger", 10000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (DHTRouterImpl.this.suspended) {
                    return;
                }
                DHTRouterImpl.this.pingeroonies();
                if (DHTRouterImpl.this.seed_in_ticks > 0) {
                    DHTRouterImpl.this.seed_in_ticks--;
                    if (DHTRouterImpl.this.seed_in_ticks == 0) {
                        DHTRouterImpl.this.seedSupport();
                    }
                }
            }
        });
    }

    protected void notifyAdded(DHTRouterContact contact) {
        for (DHTRouterObserver rto : this.observers) {
            try {
                rto.added(contact);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void notifyRemoved(DHTRouterContact contact) {
        for (DHTRouterObserver rto : this.observers) {
            try {
                rto.removed(contact);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void notifyLocationChanged(DHTRouterContact contact) {
        for (DHTRouterObserver rto : this.observers) {
            try {
                rto.locationChanged(contact);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void notifyNowAlive(DHTRouterContact contact) {
        for (DHTRouterObserver rto : this.observers) {
            try {
                rto.nowAlive(contact);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void notifyNowFailing(DHTRouterContact contact) {
        for (DHTRouterObserver rto : this.observers) {
            try {
                rto.nowFailing(contact);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void notifyDead() {
        for (DHTRouterObserver rto : this.observers) {
            try {
                rto.destroyed(this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean addObserver(DHTRouterObserver rto) {
        if (rto != null && !this.observers.contains(rto)) {
            this.observers.add(rto);
            return true;
        }
        return false;
    }

    public boolean containsObserver(DHTRouterObserver rto) {
        return rto != null && this.observers.contains(rto);
    }

    public boolean removeObserver(DHTRouterObserver rto) {
        return rto != null && this.observers.remove(rto);
    }

    public DHTRouterStats getStats() {
        return this.stats;
    }

    public int getK() {
        return this.K;
    }

    public byte[] getID() {
        return this.router_node_id;
    }

    public boolean isID(byte[] id) {
        return Arrays.equals(id, this.router_node_id);
    }

    public DHTRouterContact getLocalContact() {
        return this.local_contact;
    }

    public void setAdapter(DHTRouterAdapter _adapter) {
        this.adapter = _adapter;
    }

    public void setSleeping(boolean _sleeping) {
        this.sleeping = _sleeping;
    }

    public void setSuspended(boolean _suspended) {
        this.suspended = _suspended;
        if (!this.suspended) {
            this.seed_in_ticks = 1;
        }
    }

    public void contactKnown(byte[] node_id, DHTRouterContactAttachment attachment, boolean force) {
        if (SystemTime.getMonotonousTime() - this.recent_contact_bloom.getStartTimeMono() > 600000L) {
            this.recent_contact_bloom.clear();
        }
        if (this.recent_contact_bloom.contains(node_id) && !force) {
            return;
        }
        this.recent_contact_bloom.add(node_id);
        this.addContact(node_id, attachment, false);
    }

    public void contactAlive(byte[] node_id, DHTRouterContactAttachment attachment) {
        this.addContact(node_id, attachment, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DHTRouterContact contactDead(byte[] node_id, boolean force) {
        if (this.suspended) {
            return null;
        }
        if (Arrays.equals(this.router_node_id, node_id)) {
            Debug.out("DHTRouter: contactDead called on router node!");
            return this.local_contact;
        }
        try {
            DHTRouterContactImpl dHTRouterContactImpl;
            try {
                this.this_mon.enter();
                ++this.consecutive_dead;
                Object[] res = this.findContactSupport(node_id);
                DHTRouterNodeImpl node = (DHTRouterNodeImpl)res[0];
                DHTRouterContactImpl contact = (DHTRouterContactImpl)res[1];
                if (contact != null && (this.consecutive_dead < 100 || force)) {
                    this.contactDeadSupport(node, contact, force);
                }
                dHTRouterContactImpl = contact;
                Object var8_7 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.this_mon.exit();
                throw throwable;
            }
            Object var10_9 = null;
            this.dispatchPings();
            this.dispatchNodeAdds();
            return dHTRouterContactImpl;
        }
        catch (Throwable throwable2) {
            Object var10_10 = null;
            this.dispatchPings();
            this.dispatchNodeAdds();
            throw throwable2;
        }
    }

    private void contactDeadSupport(DHTRouterNodeImpl node, DHTRouterContactImpl contact, boolean force) {
        List<DHTRouterContactImpl> replacements;
        if (this.is_bootstrap_proxy && ((replacements = node.getReplacements()) == null || replacements.size() == 0)) {
            return;
        }
        node.dead(contact, force);
    }

    public void contactRemoved(byte[] node_id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContact(byte[] node_id, DHTRouterContactAttachment attachment, boolean known_to_be_alive) {
        if (attachment.isSleeping()) {
            if (Arrays.equals(this.router_node_id, node_id)) {
                return;
            }
            try {
                this.this_mon.enter();
                Object[] res = this.findContactSupport(node_id);
                DHTRouterNodeImpl node = (DHTRouterNodeImpl)res[0];
                DHTRouterContactImpl contact = (DHTRouterContactImpl)res[1];
                if (contact != null) {
                    this.contactDeadSupport(node, contact, true);
                }
                Object var8_7 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.this_mon.exit();
                throw throwable;
            }
            return;
        }
        try {
            try {
                this.this_mon.enter();
                if (known_to_be_alive) {
                    this.consecutive_dead = 0;
                }
                this.addContactSupport(node_id, attachment, known_to_be_alive);
                Object var10_10 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.this_mon.exit();
                throw throwable;
            }
            Object var12_13 = null;
            this.dispatchPings();
            this.dispatchNodeAdds();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.dispatchPings();
            this.dispatchNodeAdds();
            throw throwable;
        }
    }

    private DHTRouterContact addContactSupport(byte[] node_id, DHTRouterContactAttachment attachment, boolean known_to_be_alive) {
        if (Arrays.equals(this.router_node_id, node_id)) {
            return this.local_contact;
        }
        DHTRouterNodeImpl current_node = this.root;
        boolean part_of_smallest_subtree = false;
        for (int i = 0; i < node_id.length; ++i) {
            byte b = node_id[i];
            int j = 7;
            while (j >= 0) {
                boolean bit;
                DHTRouterNodeImpl next_node;
                if (current_node == this.smallest_subtree) {
                    part_of_smallest_subtree = true;
                }
                if ((next_node = (bit = (b >> j & 1) == 1) ? current_node.getLeft() : current_node.getRight()) == null) {
                    DHTRouterContactImpl existing_contact = current_node.updateExistingNode(node_id, attachment, known_to_be_alive);
                    if (existing_contact != null) {
                        return existing_contact;
                    }
                    List buckets = current_node.getBuckets();
                    int buckets_size = buckets.size();
                    if (this.sleeping && buckets_size >= this.K / 4 && !current_node.containsRouterNodeID()) {
                        DHTRouterContactImpl new_contact = new DHTRouterContactImpl(node_id, attachment, known_to_be_alive);
                        return current_node.addReplacement(new_contact, 1);
                    }
                    if (buckets_size == this.K) {
                        boolean too_deep_to_split;
                        boolean contains_router_node_id = current_node.containsRouterNodeID();
                        int depth = current_node.getDepth();
                        boolean bl = too_deep_to_split = depth % this.B == 0;
                        if (contains_router_node_id || !too_deep_to_split || part_of_smallest_subtree) {
                            if (part_of_smallest_subtree && too_deep_to_split && !contains_router_node_id && this.getContactCount(this.smallest_subtree) > (long)this.smallest_subtree_max) {
                                Debug.out("DHTRouter: smallest subtree max size violation");
                                return null;
                            }
                            ArrayList<DHTRouterContactImpl> left_buckets = new ArrayList<DHTRouterContactImpl>();
                            ArrayList<DHTRouterContactImpl> right_buckets = new ArrayList<DHTRouterContactImpl>();
                            for (int k = 0; k < buckets.size(); ++k) {
                                DHTRouterContactImpl contact = (DHTRouterContactImpl)buckets.get(k);
                                byte[] bucket_id = contact.getID();
                                if ((bucket_id[depth / 8] >> 7 - depth % 8 & 1) == 0) {
                                    right_buckets.add(contact);
                                    continue;
                                }
                                left_buckets.add(contact);
                            }
                            boolean right_contains_rid = false;
                            boolean left_contains_rid = false;
                            if (contains_router_node_id) {
                                right_contains_rid = (this.router_node_id[depth / 8] >> 7 - depth % 8 & 1) == 0;
                                left_contains_rid = !right_contains_rid;
                            }
                            DHTRouterNodeImpl new_left = new DHTRouterNodeImpl(this, depth + 1, left_contains_rid, left_buckets);
                            DHTRouterNodeImpl new_right = new DHTRouterNodeImpl(this, depth + 1, right_contains_rid, right_buckets);
                            current_node.split(new_left, new_right);
                            if (right_contains_rid) {
                                this.smallest_subtree = new_left;
                                continue;
                            }
                            if (!left_contains_rid) continue;
                            this.smallest_subtree = new_right;
                            continue;
                        }
                        DHTRouterContactImpl new_contact = new DHTRouterContactImpl(node_id, attachment, known_to_be_alive);
                        return current_node.addReplacement(new_contact, this.sleeping ? 1 : this.max_rep_per_node);
                    }
                    DHTRouterContactImpl new_contact = new DHTRouterContactImpl(node_id, attachment, known_to_be_alive);
                    current_node.addNode(new_contact);
                    return new_contact;
                }
                current_node = next_node;
                --j;
            }
        }
        Debug.out("DHTRouter inconsistency");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findClosestContacts(byte[] node_id, int num_to_return, boolean live_only) {
        try {
            this.this_mon.enter();
            ArrayList res = new ArrayList();
            this.findClosestContacts(node_id, num_to_return, 0, this.root, live_only, res);
            ArrayList arrayList = res;
            Object var7_6 = null;
            this.this_mon.exit();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void findClosestContacts(byte[] node_id, int num_to_return, int depth, DHTRouterNodeImpl current_node, boolean live_only, List res) {
        List buckets = current_node.getBuckets();
        if (buckets != null) {
            for (int i = 0; i < buckets.size(); ++i) {
                DHTRouterContactImpl contact = (DHTRouterContactImpl)buckets.get(i);
                if (live_only && contact.isFailing()) continue;
                res.add(contact);
            }
        } else {
            DHTRouterNodeImpl worse_node;
            DHTRouterNodeImpl best_node;
            boolean bit;
            boolean bl = bit = (node_id[depth / 8] >> 7 - depth % 8 & 1) == 1;
            if (bit) {
                best_node = current_node.getLeft();
                worse_node = current_node.getRight();
            } else {
                best_node = current_node.getRight();
                worse_node = current_node.getLeft();
            }
            this.findClosestContacts(node_id, num_to_return, depth + 1, best_node, live_only, res);
            if (res.size() < num_to_return) {
                this.findClosestContacts(node_id, num_to_return, depth + 1, worse_node, live_only, res);
            }
        }
    }

    public DHTRouterContact findContact(byte[] node_id) {
        Object[] res = this.findContactSupport(node_id);
        return (DHTRouterContact)res[1];
    }

    protected DHTRouterNodeImpl findNode(byte[] node_id) {
        Object[] res = this.findContactSupport(node_id);
        return (DHTRouterNodeImpl)res[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object[] findContactSupport(byte[] node_id) {
        Object[] objectArray;
        try {
            this.this_mon.enter();
            DHTRouterNodeImpl current_node = this.root;
            block2: for (int i = 0; i < node_id.length && current_node.getBuckets() == null; ++i) {
                byte b = node_id[i];
                for (int j = 7; j >= 0; --j) {
                    boolean bit;
                    boolean bl = bit = (b >> j & 1) == 1;
                    if (current_node.getBuckets() != null) continue block2;
                    current_node = bit ? current_node.getLeft() : current_node.getRight();
                }
            }
            List buckets = current_node.getBuckets();
            for (int k = 0; k < buckets.size(); ++k) {
                DHTRouterContactImpl contact = (DHTRouterContactImpl)buckets.get(k);
                if (!Arrays.equals(node_id, contact.getID())) continue;
                Object[] objectArray2 = new Object[]{current_node, contact};
                Object var8_12 = null;
                this.this_mon.exit();
                return objectArray2;
            }
            objectArray = new Object[]{current_node, null};
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var8_13 = null;
        this.this_mon.exit();
        return objectArray;
    }

    protected long getNodeCount() {
        return this.getNodeCount(this.root);
    }

    protected long getNodeCount(DHTRouterNodeImpl node) {
        if (node.getBuckets() != null) {
            return 1L;
        }
        return 1L + this.getNodeCount(node.getLeft()) + this.getNodeCount(node.getRight());
    }

    protected long getContactCount() {
        return this.getContactCount(this.root);
    }

    protected long getContactCount(DHTRouterNodeImpl node) {
        if (node.getBuckets() != null) {
            return node.getBuckets().size();
        }
        return this.getContactCount(node.getLeft()) + this.getContactCount(node.getRight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findBestContacts(int max) {
        TreeSet set = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                DHTRouterContactImpl c1 = (DHTRouterContactImpl)o1;
                DHTRouterContactImpl c2 = (DHTRouterContactImpl)o2;
                return (int)(c2.getTimeAlive() - c1.getTimeAlive());
            }
        });
        try {
            this.this_mon.enter();
            this.findAllContacts(set, this.root);
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        ArrayList result = new ArrayList(max);
        Iterator it = set.iterator();
        while (it.hasNext() && (max <= 0 || result.size() < max)) {
            result.add(it.next());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllContacts() {
        try {
            this.this_mon.enter();
            ArrayList l = new ArrayList();
            this.findAllContacts(l, this.root);
            ArrayList arrayList = l;
            Object var4_3 = null;
            this.this_mon.exit();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void findAllContacts(Set set, DHTRouterNodeImpl node) {
        List buckets = node.getBuckets();
        if (buckets == null) {
            this.findAllContacts(set, node.getLeft());
            this.findAllContacts(set, node.getRight());
        } else {
            for (int i = 0; i < buckets.size(); ++i) {
                DHTRouterContactImpl contact = (DHTRouterContactImpl)buckets.get(i);
                set.add(contact);
            }
        }
    }

    protected void findAllContacts(List list, DHTRouterNodeImpl node) {
        List buckets = node.getBuckets();
        if (buckets == null) {
            this.findAllContacts(list, node.getLeft());
            this.findAllContacts(list, node.getRight());
        } else {
            for (int i = 0; i < buckets.size(); ++i) {
                DHTRouterContactImpl contact = (DHTRouterContactImpl)buckets.get(i);
                list.add(contact);
            }
        }
    }

    public void seed() {
        this.seed_in_ticks = 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void seedSupport() {
        byte[] path = new byte[this.router_node_id.length];
        ArrayList ids = new ArrayList();
        try {
            this.this_mon.enter();
            this.refreshNodes(ids, this.root, path, true, 120000L);
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < ids.size(); ++i) {
            this.requestLookup((byte[])ids.get(i), "Seeding DHT");
        }
    }

    protected void refreshNodes(List nodes_to_refresh, DHTRouterNodeImpl node, byte[] path, boolean seeding, long max_permitted_idle) {
        if (seeding && node == this.smallest_subtree) {
            return;
        }
        if (max_permitted_idle != 0L && node.getTimeSinceLastLookup() <= max_permitted_idle) {
            return;
        }
        if (node.getBuckets() != null) {
            if (seeding && node.containsRouterNodeID()) {
                return;
            }
            this.refreshNode(nodes_to_refresh, node, path);
        }
        if (node.getBuckets() == null) {
            int depth = node.getDepth();
            byte mask = (byte)(1 << 7 - depth % 8);
            path[depth / 8] = (byte)(path[depth / 8] | mask);
            this.refreshNodes(nodes_to_refresh, node.getLeft(), path, seeding, max_permitted_idle);
            path[depth / 8] = (byte)(path[depth / 8] & ~mask);
            this.refreshNodes(nodes_to_refresh, node.getRight(), path, seeding, max_permitted_idle);
        }
    }

    protected void refreshNode(List nodes_to_refresh, DHTRouterNodeImpl node, byte[] path) {
        byte[] id = new byte[this.router_node_id.length];
        this.random.nextBytes(id);
        int depth = node.getDepth();
        for (int i = 0; i < depth; ++i) {
            byte mask = (byte)(1 << 7 - i % 8);
            boolean bit = (path[i / 8] >> 7 - i % 8 & 1) == 1;
            id[i / 8] = bit ? (byte)(id[i / 8] | mask) : (byte)(id[i / 8] & ~mask);
        }
        nodes_to_refresh.add(id);
    }

    protected DHTRouterNodeImpl getSmallestSubtree() {
        return this.smallest_subtree;
    }

    public void recordLookup(byte[] node_id) {
        this.findNode(node_id).setLastLookupTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIdleLeaves(long idle_max) {
        byte[] path = new byte[this.router_node_id.length];
        ArrayList ids = new ArrayList();
        try {
            this.this_mon.enter();
            this.refreshNodes(ids, this.root, path, false, idle_max);
            Object var6_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < ids.size(); ++i) {
            this.requestLookup((byte[])ids.get(i), "Idle leaf refresh");
        }
    }

    public boolean requestPing(byte[] node_id) {
        Object[] res = this.findContactSupport(node_id);
        DHTRouterContactImpl contact = (DHTRouterContactImpl)res[1];
        if (contact != null) {
            this.adapter.requestPing(contact);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestPing(DHTRouterContactImpl contact) {
        if (this.suspended) {
            return;
        }
        DHTLog.log("DHTRouter: requestPing:" + DHTLog.getString(contact.getID()));
        if (contact == this.local_contact) {
            Debug.out("pinging local contact");
        }
        try {
            this.this_mon.enter();
            if (!this.outstanding_pings.contains(contact)) {
                this.outstanding_pings.add(contact);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchPings() {
        List<DHTRouterContactImpl> pings;
        if (this.outstanding_pings.size() == 0) {
            return;
        }
        try {
            this.this_mon.enter();
            pings = this.outstanding_pings;
            this.outstanding_pings = new ArrayList<DHTRouterContactImpl>();
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (this.suspended) {
            return;
        }
        for (int i = 0; i < pings.size(); ++i) {
            this.adapter.requestPing(pings.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pingeroonies() {
        try {
            this.this_mon.enter();
            DHTRouterNodeImpl node = this.root;
            LinkedList<DHTRouterNodeImpl> stack = new LinkedList<DHTRouterNodeImpl>();
            while (true) {
                List buckets;
                if ((buckets = node.getBuckets()) == null) {
                    if (this.random.nextBoolean()) {
                        stack.add(node.getRight());
                        node = node.getLeft();
                        continue;
                    }
                    stack.add(node.getLeft());
                    node = node.getRight();
                    continue;
                }
                int max_fails = 0;
                DHTRouterContactImpl max_fails_contact = null;
                for (int i = 0; i < buckets.size(); ++i) {
                    int fails;
                    DHTRouterContactImpl contact = (DHTRouterContactImpl)buckets.get(i);
                    if (contact.getPingOutstanding() || (fails = contact.getFailCount()) <= max_fails) continue;
                    max_fails = fails;
                    max_fails_contact = contact;
                }
                if (max_fails_contact != null) {
                    this.requestPing(max_fails_contact);
                    Object var10_9 = null;
                    this.this_mon.exit();
                    this.dispatchPings();
                    return;
                }
                if (stack.size() == 0) break;
                node = (DHTRouterNodeImpl)stack.removeLast();
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.this_mon.exit();
            this.dispatchPings();
            throw throwable;
        }
        Object var10_10 = null;
        this.this_mon.exit();
        this.dispatchPings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestNodeAdd(DHTRouterContactImpl contact) {
        if (this.suspended) {
            return;
        }
        DHTLog.log("DHTRouter: requestNodeAdd:" + DHTLog.getString(contact.getID()));
        if (contact == this.local_contact) {
            Debug.out("adding local contact");
        }
        try {
            this.this_mon.enter();
            if (!this.outstanding_adds.contains(contact)) {
                this.outstanding_adds.add(contact);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchNodeAdds() {
        List<DHTRouterContactImpl> adds;
        if (this.outstanding_adds.size() == 0) {
            return;
        }
        try {
            this.this_mon.enter();
            adds = this.outstanding_adds;
            this.outstanding_adds = new ArrayList<DHTRouterContactImpl>();
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (this.suspended) {
            return;
        }
        for (int i = 0; i < adds.size(); ++i) {
            this.adapter.requestAdd(adds.get(i));
        }
    }

    public byte[] refreshRandom() {
        byte[] id = new byte[this.router_node_id.length];
        this.random.nextBytes(id);
        this.requestLookup(id, "Random Refresh");
        return id;
    }

    protected void requestLookup(byte[] id, String description) {
        DHTLog.log("DHTRouter: requestLookup:" + DHTLog.getString(id));
        this.adapter.requestLookup(id, description);
    }

    protected void getStatsSupport(long[] stats_array, DHTRouterNodeImpl node) {
        stats_array[0] = stats_array[0] + 1L;
        List buckets = node.getBuckets();
        if (buckets == null) {
            this.getStatsSupport(stats_array, node.getLeft());
            this.getStatsSupport(stats_array, node.getRight());
        } else {
            stats_array[1] = stats_array[1] + 1L;
            stats_array[2] = stats_array[2] + (long)buckets.size();
            for (int i = 0; i < buckets.size(); ++i) {
                DHTRouterContactImpl contact = (DHTRouterContactImpl)buckets.get(i);
                if (contact.getFirstFailTime() > 0L) {
                    stats_array[6] = stats_array[6] + 1L;
                    continue;
                }
                if (contact.hasBeenAlive()) {
                    stats_array[4] = stats_array[4] + 1L;
                    continue;
                }
                stats_array[5] = stats_array[5] + 1L;
            }
            List<DHTRouterContactImpl> rep = node.getReplacements();
            if (rep != null) {
                stats_array[3] = stats_array[3] + (long)rep.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] getStatsSupport() {
        try {
            this.this_mon.enter();
            long[] res = new long[7];
            this.getStatsSupport(res, this.root);
            long[] lArray = res;
            Object var4_3 = null;
            this.this_mon.exit();
            return lArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void log(String str) {
        this.logger.log(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        try {
            this.this_mon.enter();
            this.log("DHT: " + DHTLog.getString2(this.router_node_id) + ", node count=" + this.getNodeCount() + ", contacts=" + this.getContactCount());
            this.root.print("", "");
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void destroy() {
        this.timer_event.cancel();
        this.notifyDead();
    }
}

