/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageEncoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnectionFile;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnectionWebSeed;
import com.aelitis.azureus.core.networkmanager.impl.tcp.IncomingSocketChannelManager;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRoutingListener;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;

public class HTTPNetworkManager {
    private static final String NL = "\r\n";
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final HTTPNetworkManager instance = new HTTPNetworkManager();
    private final IncomingSocketChannelManager http_incoming_manager;
    private long total_requests;
    private long total_webseed_requests;
    private long total_getright_requests;
    private long total_invalid_requests;
    private long total_ok_requests;
    private CopyOnWriteList<URLHandler> url_handlers = new CopyOnWriteList();

    public static HTTPNetworkManager getSingleton() {
        return instance;
    }

    private HTTPNetworkManager() {
        HashSet<String> types = new HashSet<String>();
        types.add("net.http.inbound.request.count");
        types.add("net.http.inbound.request.ok.count");
        types.add("net.http.inbound.request.invalid.count");
        types.add("net.http.inbound.request.webseed.count");
        types.add("net.http.inbound.request.getright.count");
        AzureusCoreStats.registerProvider(types, new AzureusCoreStatsProvider(){

            public void updateStats(Set types, Map values) {
                if (types.contains("net.http.inbound.request.count")) {
                    values.put("net.http.inbound.request.count", new Long(HTTPNetworkManager.this.total_requests));
                }
                if (types.contains("net.http.inbound.request.ok.count")) {
                    values.put("net.http.inbound.request.ok.count", new Long(HTTPNetworkManager.this.total_ok_requests));
                }
                if (types.contains("net.http.inbound.request.invalid.count")) {
                    values.put("net.http.inbound.request.invalid.count", new Long(HTTPNetworkManager.this.total_invalid_requests));
                }
                if (types.contains("net.http.inbound.request.webseed.count")) {
                    values.put("net.http.inbound.request.webseed.count", new Long(HTTPNetworkManager.this.total_webseed_requests));
                }
                if (types.contains("net.http.inbound.request.getright.count")) {
                    values.put("net.http.inbound.request.getright.count", new Long(HTTPNetworkManager.this.total_getright_requests));
                }
            }
        });
        this.http_incoming_manager = new IncomingSocketChannelManager("HTTP.Data.Listen.Port", "HTTP.Data.Listen.Port.Enable");
        NetworkManager.ByteMatcher matcher = new NetworkManager.ByteMatcher(){

            public int matchThisSizeOrBigger() {
                return 16;
            }

            public int maxSize() {
                return 256;
            }

            public int minSize() {
                return 3;
            }

            /*
             * Exception decompiling
             */
            public Object matches(TransportHelper transport, ByteBuffer to_compare, int port) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[TRYBLOCK]], but top level block is 27[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public Object minMatches(TransportHelper transport, ByteBuffer to_compare, int port) {
                byte[] head = new byte[3];
                to_compare.get(head);
                if (head[0] != 71 || head[1] != 69 || head[2] != 84) {
                    return null;
                }
                return "";
            }

            public byte[][] getSharedSecrets() {
                return null;
            }

            public int getSpecificPort() {
                return HTTPNetworkManager.this.http_incoming_manager.getTCPListeningPortNumber();
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(matcher, new NetworkManager.RoutingListener(){

            public void connectionRouted(final NetworkConnection connection, Object _routing_data) {
                Object[] x = (Object[])_routing_data;
                Object entry1 = x[0];
                if (entry1 instanceof TransportHelper) {
                    HTTPNetworkManager.this.writeReply(connection, (TransportHelper)x[0], (String)x[1]);
                    return;
                }
                if (entry1 instanceof URLHandler) {
                    ((URLHandler)entry1).handle((TransportHelper)x[1], (String)x[2]);
                    return;
                }
                final String url = (String)entry1;
                PeerManagerRegistration routing_data = (PeerManagerRegistration)x[1];
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " routed successfully on '" + url + "'"));
                }
                PeerManager.getSingleton().manualRoute(routing_data, connection, new PeerManagerRoutingListener(){

                    public boolean routed(PEPeerTransport peer) {
                        if (url.indexOf("/webseed") != -1) {
                            HTTPNetworkManager.this.total_webseed_requests++;
                            new HTTPNetworkConnectionWebSeed(HTTPNetworkManager.this, connection, peer);
                            return true;
                        }
                        if (url.indexOf("/files/") != -1) {
                            HTTPNetworkManager.this.total_getright_requests++;
                            new HTTPNetworkConnectionFile(HTTPNetworkManager.this, connection, peer);
                            return true;
                        }
                        return false;
                    }
                });
            }

            public boolean autoCryptoFallback() {
                return false;
            }
        }, new MessageStreamFactory(){

            public MessageStreamEncoder createEncoder() {
                return new HTTPMessageEncoder();
            }

            public MessageStreamDecoder createDecoder() {
                return new HTTPMessageDecoder();
            }
        });
    }

    protected void reRoute(HTTPNetworkConnection old_http_connection, byte[] old_hash, byte[] new_hash, final String header) {
        NetworkConnection old_connection = old_http_connection.getConnection();
        PeerManagerRegistration reg_data = PeerManager.getSingleton().manualMatchHash(old_connection.getEndpoint().getNotionalAddress(), new_hash);
        if (reg_data == null) {
            old_http_connection.close("Re-routing failed - registration not found");
            return;
        }
        Transport transport = old_connection.detachTransport();
        old_http_connection.close("Switching torrents");
        final NetworkConnection new_connection = NetworkManager.getSingleton().bindTransport(transport, new HTTPMessageEncoder(), new HTTPMessageDecoder(header));
        PeerManager.getSingleton().manualRoute(reg_data, new_connection, new PeerManagerRoutingListener(){

            public boolean routed(PEPeerTransport peer) {
                HTTPNetworkConnection new_http_connection;
                if (header.indexOf("/webseed") != -1) {
                    new_http_connection = new HTTPNetworkConnectionWebSeed(HTTPNetworkManager.this, new_connection, peer);
                } else if (header.indexOf("/files/") != -1) {
                    new_http_connection = new HTTPNetworkConnectionFile(HTTPNetworkManager.this, new_connection, peer);
                } else {
                    return false;
                }
                new_http_connection.readWakeup();
                return true;
            }
        });
    }

    public boolean isHTTPListenerEnabled() {
        return this.http_incoming_manager.isEnabled();
    }

    public int getHTTPListeningPortNumber() {
        return this.http_incoming_manager.getTCPListeningPortNumber();
    }

    public void setExplicitBindAddress(InetAddress address) {
        this.http_incoming_manager.setExplicitBindAddress(address);
    }

    public void clearExplicitBindAddress() {
        this.http_incoming_manager.clearExplicitBindAddress();
    }

    public boolean isEffectiveBindAddress(InetAddress address) {
        return this.http_incoming_manager.isEffectiveBindAddress(address);
    }

    protected String getIndexPage() {
        return "HTTP/1.1 200 OK\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected String getPingPage(String url) {
        int pos = url.indexOf(32);
        if (pos != -1) {
            url = url.substring(0, pos);
        }
        pos = url.indexOf(63);
        HashMap<String, String> response = new HashMap<String, String>();
        boolean ok = false;
        if (pos != -1) {
            StringTokenizer tok = new StringTokenizer(url.substring(pos + 1), "&");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                pos = token.indexOf(61);
                if (pos == -1) continue;
                String lhs = token.substring(0, pos);
                String rhs = token.substring(pos + 1);
                if (!lhs.equals("check")) continue;
                response.put("check", rhs);
                ok = true;
            }
        }
        if (ok) {
            try {
                byte[] bytes = BEncoder.encode(response);
                byte[] length = new byte[4];
                ByteBuffer.wrap(length).putInt(bytes.length);
                return "HTTP/1.1 200 OK\r\nConnection: Close\r\nContent-Length: " + (bytes.length + 4) + NL + NL + new String(length, "ISO-8859-1") + new String(bytes, "ISO-8859-1");
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return this.getNotFound();
    }

    protected String getTest503() {
        return "HTTP/1.1 503 Service Unavailable\r\nConnection: Close\r\nContent-Length: 4\r\n\r\n1234";
    }

    protected String getNotFound() {
        return "HTTP/1.1 404 Not Found\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected String getRangeNotSatisfiable() {
        return "HTTP/1.1 416 Not Satisfiable\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected void writeReply(final NetworkConnection connection, TransportHelper transport, final String data) {
        byte[] bytes;
        try {
            bytes = data.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            bytes = data.getBytes();
        }
        final ByteBuffer bb = ByteBuffer.wrap(bytes);
        try {
            transport.write(bb, false);
            if (bb.remaining() > 0) {
                transport.registerForWriteSelects(new TransportHelper.selectListener(){

                    public boolean selectSuccess(TransportHelper helper, Object attachment) {
                        try {
                            int written = helper.write(bb, false);
                            if (bb.remaining() > 0) {
                                helper.registerForWriteSelects(this, null);
                            } else {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " closed"));
                                }
                                connection.close(null);
                            }
                            return written > 0;
                        }
                        catch (Throwable e) {
                            helper.cancelWriteSelects();
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " failed to write error '" + data + "'"));
                            }
                            connection.close(e == null ? null : Debug.getNestedExceptionMessage(e));
                            return false;
                        }
                    }

                    public void selectFailure(TransportHelper helper, Object attachment, Throwable msg) {
                        helper.cancelWriteSelects();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " failed to write error '" + data + "'"));
                        }
                        connection.close(msg == null ? null : Debug.getNestedExceptionMessage(msg));
                    }
                }, null);
            } else {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " closed"));
                }
                connection.close(null);
            }
        }
        catch (Throwable e) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " failed to write error '" + data + "'"));
            }
            connection.close(e == null ? null : Debug.getNestedExceptionMessage(e));
        }
    }

    public void addURLHandler(URLHandler handler) {
        this.url_handlers.add(handler);
    }

    public void removeURLHandler(URLHandler handler) {
        this.url_handlers.remove(handler);
    }

    static /* synthetic */ long access$008(HTTPNetworkManager x0) {
        return x0.total_requests++;
    }

    static /* synthetic */ CopyOnWriteList access$500(HTTPNetworkManager x0) {
        return x0.url_handlers;
    }

    static /* synthetic */ long access$108(HTTPNetworkManager x0) {
        return x0.total_ok_requests++;
    }

    static /* synthetic */ long access$208(HTTPNetworkManager x0) {
        return x0.total_invalid_requests++;
    }

    public static interface URLHandler {
        public boolean matches(String var1);

        public void handle(TransportHelper var1, String var2);
    }
}

