/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.dht.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTFactory;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageKeyStats;
import com.aelitis.azureus.core.dht.control.DHTControlStats;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.db.DHTDBStats;
import com.aelitis.azureus.core.dht.db.DHTDBValue;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.router.DHTRouterStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFactory;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.util.DNSUtils;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginInterface;
import com.aelitis.azureus.plugins.dht.DHTPluginKeyStats;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import com.aelitis.azureus.plugins.dht.DHTPluginTransferHandler;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginContactImpl;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginImplAdapter;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginStorageManager;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginValueImpl;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTPluginImpl
implements DHTPluginInterface.DHTInterface {
    private static final String SEED_ADDRESS_V4 = "dht.vuze.com";
    private static final String SEED_ADDRESS_V6 = "dht6.vuze.com";
    private static final int SEED_PORT = 6881;
    private static final long MIN_ROOT_SEED_IMPORT_PERIOD = 28800000L;
    private PluginInterface plugin_interface;
    private int status;
    private String status_text;
    private ActionParameter reseed_param;
    private BooleanParameter warn_user_param;
    private DHT dht;
    private int port;
    private byte protocol_version;
    private int network;
    private boolean v6;
    private DHTTransportUDP transport;
    private DHTPluginStorageManager storage_manager;
    private long last_root_seed_import_time;
    private LoggerChannel log;
    private DHTLogger dht_log;
    private int stats_ticks;
    private Map<DHTPluginTransferHandler, DHTTransportTransferHandler> handler_map = new HashMap<DHTPluginTransferHandler, DHTTransportTransferHandler>();

    public DHTPluginImpl(PluginInterface _plugin_interface, DHTNATPuncherAdapter _nat_adapter, DHTPluginImplAdapter _adapter, byte _protocol_version, int _network, boolean _v6, String _ip, int _port, ActionParameter _reseed, BooleanParameter _warn_user_param, boolean _logging, LoggerChannel _log, DHTLogger _dht_log) {
        this.plugin_interface = _plugin_interface;
        this.protocol_version = _protocol_version;
        this.network = _network;
        this.v6 = _v6;
        this.port = _port;
        this.reseed_param = _reseed;
        this.warn_user_param = _warn_user_param;
        this.log = _log;
        this.dht_log = _dht_log;
        final DHTPluginImplAdapter adapter = _adapter;
        try {
            this.storage_manager = new DHTPluginStorageManager(this.network, this.dht_log, this.getDataDir(_network));
            PluginConfig conf = this.plugin_interface.getPluginconfig();
            int send_delay = conf.getPluginIntParameter("dht.senddelay", 25);
            int recv_delay = conf.getPluginIntParameter("dht.recvdelay", 25);
            boolean bootstrap = conf.getPluginBooleanParameter("dht.bootstrapnode", false);
            boolean initial_reachable = conf.getPluginBooleanParameter("dht.reachable." + this.network, true);
            this.transport = DHTTransportFactory.createUDP(_protocol_version, _network, _v6, _ip, this.storage_manager.getMostRecentAddress(), _port, 3, 1, 10000L, send_delay, recv_delay, bootstrap, initial_reachable, this.dht_log);
            this.transport.addListener(new DHTTransportListener(){

                public void localContactChanged(DHTTransportContact local_contact) {
                    DHTPluginImpl.this.storage_manager.localContactChanged(local_contact);
                    if (adapter != null) {
                        adapter.localContactChanged(DHTPluginImpl.this.getLocalAddress());
                    }
                }

                public void resetNetworkPositions() {
                }

                public void currentAddress(String address) {
                    DHTPluginImpl.this.storage_manager.recordCurrentAddress(address);
                }

                public void reachabilityChanged(boolean reacheable) {
                }
            });
            Properties props = new Properties();
            if (_network == 1) {
                props.put("CacheRepublishInterval", new Integer(3600000));
            }
            this.dht = DHTFactory.create(this.transport, props, this.storage_manager, _nat_adapter, this.dht_log);
            this.plugin_interface.firePluginEvent(new PluginEvent(){

                public int getType() {
                    return 1024;
                }

                public Object getValue() {
                    return DHTPluginImpl.this.dht;
                }
            });
            this.dht.setLogging(_logging);
            DHTTransportContact root_seed = this.importRootSeed();
            this.storage_manager.importContacts(this.dht);
            this.plugin_interface.getUtilities().createTimer("DHTExport", true).addPeriodicEvent(120000L, new UTTimerEventPerformer(){
                private int tick_count = 0;

                public void perform(UTTimerEvent event2) {
                    ++this.tick_count;
                    if (this.tick_count == 1 || this.tick_count % 5 == 0) {
                        DHTPluginImpl.this.checkForReSeed(false);
                        DHTPluginImpl.this.storage_manager.exportContacts(DHTPluginImpl.this.dht);
                    }
                }
            });
            this.integrateDHT(true, root_seed);
            this.status = 3;
            this.status_text = "Running";
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.log.log("DHT integrtion fails", e);
            this.status_text = "DHT Integration fails: " + Debug.getNestedExceptionMessage(e);
            this.status = 4;
        }
    }

    public void updateStats(int sample_stats_ticks) {
        ++this.stats_ticks;
        if (this.transport != null) {
            PluginConfig conf = this.plugin_interface.getPluginconfig();
            boolean current_reachable = this.transport.isReachable();
            if (current_reachable != conf.getPluginBooleanParameter("dht.reachable." + this.network, true)) {
                conf.setPluginParameter("dht.reachable." + this.network, current_reachable);
                if (!current_reachable) {
                    String msg = "If you have a router/firewall, please check that you have port " + this.port + " UDP open.\nDecentralised tracking requires this.";
                    int warned_port = this.plugin_interface.getPluginconfig().getPluginIntParameter("udp_warned_port", 0);
                    if (warned_port == this.port || !this.warn_user_param.getValue()) {
                        this.log.log(msg);
                    } else {
                        this.plugin_interface.getPluginconfig().setPluginParameter("udp_warned_port", this.port);
                        this.log.logAlert(2, msg);
                    }
                } else {
                    this.log.log("Reachability changed for the better");
                }
            }
            if (this.stats_ticks % sample_stats_ticks == 0) {
                this.logStats();
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.status_text;
    }

    public boolean isReachable() {
        return this.transport.isReachable();
    }

    public void setLogging(boolean l) {
        this.dht.setLogging(l);
    }

    public void tick() {
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int new_port) {
        this.port = new_port;
        try {
            this.transport.setPort(this.port);
        }
        catch (Throwable e) {
            this.log.log(e);
        }
    }

    public long getClockSkew() {
        return this.transport.getStats().getSkewAverage();
    }

    public void logStats() {
        DHTDBStats d_stats = this.dht.getDataBase().getStats();
        DHTControlStats c_stats = this.dht.getControl().getStats();
        DHTRouterStats r_stats = this.dht.getRouter().getStats();
        DHTTransportStats t_stats = this.transport.getStats();
        long[] rs = r_stats.getStats();
        this.log.log("DHT:ip=" + this.transport.getLocalContact().getAddress() + ",net=" + this.transport.getNetwork() + ",prot=V" + this.transport.getProtocolVersion() + ",reach=" + this.transport.isReachable() + ",flags=" + Integer.toString(this.transport.getGenericFlags() & 0xFF, 16));
        this.log.log("Router:nodes=" + rs[0] + ",leaves=" + rs[1] + ",contacts=" + rs[2] + ",replacement=" + rs[3] + ",live=" + rs[4] + ",unknown=" + rs[5] + ",failing=" + rs[6]);
        this.log.log("Transport:" + t_stats.getString());
        int[] dbv_details = d_stats.getValueDetails();
        this.log.log("Control:dht=" + c_stats.getEstimatedDHTSize() + ", Database:keys=" + d_stats.getKeyCount() + ",vals=" + dbv_details[0] + ",loc=" + dbv_details[1] + ",dir=" + dbv_details[2] + ",ind=" + dbv_details[3] + ",div_f=" + dbv_details[4] + ",div_s=" + dbv_details[5]);
        DHTNATPuncher np = this.dht.getNATPuncher();
        if (np != null) {
            this.log.log("NAT: " + np.getStats());
        }
    }

    protected File getDataDir(int network) {
        File dir = new File(this.plugin_interface.getUtilities().getAzureusUserDir(), "dht");
        if (network != 0) {
            dir = new File(dir, "net" + network);
        }
        FileUtil.mkdirs(dir);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrateDHT(boolean first, DHTTransportContact remove_afterwards) {
        try {
            this.reseed_param.setEnabled(false);
            this.log.log("DHT " + (first ? "" : "re-") + "integration starts");
            long start = SystemTime.getCurrentTime();
            this.dht.integrate(false);
            if (remove_afterwards != null) {
                this.log.log("Removing seed " + remove_afterwards.getString());
                remove_afterwards.remove();
            }
            long end = SystemTime.getCurrentTime();
            this.log.log("DHT " + (first ? "" : "re-") + "integration complete: elapsed = " + (end - start));
            this.dht.print(false);
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.reseed_param.setEnabled(true);
            throw throwable;
        }
        this.reseed_param.setEnabled(true);
    }

    public void checkForReSeed(boolean force) {
        int seed_limit = 32;
        try {
            long[] router_stats = this.dht.getRouter().getStats().getStats();
            if (router_stats[4] < (long)seed_limit || force) {
                if (force) {
                    this.log.log("Reseeding");
                } else {
                    this.log.log("Less than 32 live contacts, reseeding");
                }
                int peers_imported = 0;
                if (this.network == 0 || this.network == 3) {
                    Download[] downloads = this.plugin_interface.getDownloadManager().getDownloads();
                    block2: for (int i = 0; i < downloads.length; ++i) {
                        Download download = downloads[i];
                        PeerManager pm = download.getPeerManager();
                        if (pm == null) continue;
                        Peer[] peers = pm.getPeers();
                        for (int j = 0; j < peers.length; ++j) {
                            String ip;
                            boolean is_v6;
                            Peer p = peers[j];
                            int peer_udp_port = p.getUDPNonDataListenPort();
                            if (peer_udp_port != 0 && (is_v6 = p.getIp().contains(":")) == this.v6 && AENetworkClassifier.categoriseAddress(ip = p.getIp()) == "Public" && this.importSeed(ip, peer_udp_port) != null && ++peers_imported > seed_limit) break block2;
                        }
                    }
                    if (peers_imported < 16) {
                        List<InetSocketAddress> list = VersionCheckClient.getSingleton().getDHTBootstrap(this.network == 0);
                        for (InetSocketAddress address : list) {
                            if (this.importSeed(address) != null && ++peers_imported > seed_limit) break;
                        }
                    }
                }
                DHTTransportContact root_to_remove = null;
                if (peers_imported == 0 && (root_to_remove = this.importRootSeed()) != null) {
                    ++peers_imported;
                }
                if (peers_imported > 0) {
                    this.integrateDHT(false, root_to_remove);
                } else {
                    this.log.log("No valid peers found to reseed from");
                }
            }
        }
        catch (Throwable e) {
            this.log.log(e);
        }
    }

    protected DHTTransportContact importRootSeed() {
        try {
            long now = SystemTime.getCurrentTime();
            if (now - this.last_root_seed_import_time > 28800000L) {
                this.last_root_seed_import_time = now;
                return this.importSeed(this.getSeedAddress());
            }
            this.log.log("    root seed imported too recently, ignoring");
        }
        catch (Throwable e) {
            this.log.log(e);
        }
        return null;
    }

    public DHTTransportContact importSeed(String ip, int port) {
        try {
            return this.transport.importContact(this.checkResolve(new InetSocketAddress(ip, port)), this.protocol_version, true);
        }
        catch (Throwable e) {
            this.log.log(e);
            return null;
        }
    }

    protected DHTTransportContact importSeed(InetAddress ia, int port) {
        try {
            return this.transport.importContact(new InetSocketAddress(ia, port), this.protocol_version, true);
        }
        catch (Throwable e) {
            this.log.log(e);
            return null;
        }
    }

    protected DHTTransportContact importSeed(InetSocketAddress ia) {
        try {
            return this.transport.importContact(ia, this.protocol_version, true);
        }
        catch (Throwable e) {
            this.log.log(e);
            return null;
        }
    }

    protected InetSocketAddress getSeedAddress() {
        return this.checkResolve(new InetSocketAddress(this.v6 ? SEED_ADDRESS_V6 : SEED_ADDRESS_V4, 6881));
    }

    private InetSocketAddress checkResolve(InetSocketAddress isa) {
        if (this.v6 && isa.isUnresolved()) {
            try {
                DNSUtils.DNSUtilsIntf dns_utils = DNSUtils.getSingleton();
                if (dns_utils != null) {
                    String host = dns_utils.getIPV6ByName(isa.getHostName()).getHostAddress();
                    isa = new InetSocketAddress(host, isa.getPort());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return isa;
    }

    public boolean isDiversified(byte[] key) {
        return this.dht.isDiversified(key);
    }

    public void put(byte[] key, String description, byte[] value, byte flags, DHTPluginOperationListener listener) {
        this.put(key, description, value, flags, true, listener);
    }

    public void put(final byte[] key, String description, byte[] value, byte flags, boolean high_priority, final DHTPluginOperationListener listener) {
        this.dht.put(key, description, value, flags, high_priority, new DHTOperationListener(){
            private boolean started;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searching(DHTTransportContact contact, int level, int active_searches) {
                if (listener != null) {
                    4 var4_4 = this;
                    synchronized (var4_4) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    listener.starts(key);
                }
            }

            public boolean diversified(String desc) {
                return true;
            }

            public void found(DHTTransportContact contact, boolean is_closest) {
            }

            public void read(DHTTransportContact _contact, DHTTransportValue _value) {
                Debug.out("read operation not supported for puts");
            }

            public void wrote(DHTTransportContact _contact, DHTTransportValue _value) {
                if (listener != null) {
                    listener.valueWritten(new DHTPluginContactImpl(DHTPluginImpl.this, _contact), DHTPluginImpl.this.mapValue(_value));
                }
            }

            public void complete(boolean timeout) {
                if (listener != null) {
                    listener.complete(key, timeout);
                }
            }
        });
    }

    public DHTPluginValue getLocalValue(byte[] key) {
        DHTTransportValue val = this.dht.getLocalValue(key);
        if (val == null) {
            return null;
        }
        return this.mapValue(val);
    }

    public List<DHTPluginValue> getValues() {
        DHTDB db = this.dht.getDataBase();
        Iterator<HashWrapper> keys = db.getKeys();
        ArrayList<DHTPluginValue> vals = new ArrayList<DHTPluginValue>();
        while (keys.hasNext()) {
            DHTDBValue val = db.getAnyValue(keys.next());
            if (val == null) continue;
            vals.add(this.mapValue(val));
        }
        return vals;
    }

    public void get(final byte[] key, String description, byte flags, int max_values, long timeout, boolean exhaustive, boolean high_priority, final DHTPluginOperationListener listener) {
        this.dht.get(key, description, flags, max_values, timeout, exhaustive, high_priority, new DHTOperationListener(){
            private boolean started = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searching(DHTTransportContact contact, int level, int active_searches) {
                if (listener != null) {
                    5 var4_4 = this;
                    synchronized (var4_4) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    listener.starts(key);
                }
            }

            public boolean diversified(String desc) {
                if (listener != null) {
                    return listener.diversified();
                }
                return true;
            }

            public void found(DHTTransportContact contact, boolean is_closest) {
            }

            public void read(DHTTransportContact contact, DHTTransportValue value) {
                if (listener != null) {
                    listener.valueRead(new DHTPluginContactImpl(DHTPluginImpl.this, value.getOriginator()), DHTPluginImpl.this.mapValue(value));
                }
            }

            public void wrote(DHTTransportContact contact, DHTTransportValue value) {
            }

            public void complete(boolean _timeout) {
                if (listener != null) {
                    listener.complete(key, _timeout);
                }
            }
        });
    }

    public void remove(final byte[] key, String description, final DHTPluginOperationListener listener) {
        this.dht.remove(key, description, new DHTOperationListener(){
            private boolean started;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searching(DHTTransportContact contact, int level, int active_searches) {
                if (listener != null) {
                    6 var4_4 = this;
                    synchronized (var4_4) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    listener.starts(key);
                }
            }

            public void found(DHTTransportContact contact, boolean is_closest) {
            }

            public boolean diversified(String desc) {
                return true;
            }

            public void read(DHTTransportContact contact, DHTTransportValue value) {
            }

            public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                if (listener != null) {
                    listener.valueWritten(new DHTPluginContactImpl(DHTPluginImpl.this, contact), DHTPluginImpl.this.mapValue(value));
                }
            }

            public void complete(boolean timeout) {
                if (listener != null) {
                    listener.complete(key, timeout);
                }
            }
        });
    }

    public void remove(DHTPluginContact[] targets, final byte[] key, String description, final DHTPluginOperationListener listener) {
        DHTTransportContact[] t_contacts = new DHTTransportContact[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            t_contacts[i] = ((DHTPluginContactImpl)targets[i]).getContact();
        }
        this.dht.remove(t_contacts, key, description, new DHTOperationListener(){
            private boolean started;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searching(DHTTransportContact contact, int level, int active_searches) {
                if (listener != null) {
                    7 var4_4 = this;
                    synchronized (var4_4) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    listener.starts(key);
                }
            }

            public void found(DHTTransportContact contact, boolean is_closest) {
            }

            public boolean diversified(String desc) {
                return true;
            }

            public void read(DHTTransportContact contact, DHTTransportValue value) {
            }

            public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                if (listener != null) {
                    listener.valueWritten(new DHTPluginContactImpl(DHTPluginImpl.this, contact), DHTPluginImpl.this.mapValue(value));
                }
            }

            public void complete(boolean timeout) {
                if (listener != null) {
                    listener.complete(key, timeout);
                }
            }
        });
    }

    public DHTPluginContact getLocalAddress() {
        return new DHTPluginContactImpl(this, this.transport.getLocalContact());
    }

    public DHTPluginContact importContact(Map<String, Object> map) {
        try {
            return new DHTPluginContactImpl(this, this.transport.importContact(map));
        }
        catch (DHTTransportException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public DHTPluginContact importContact(InetSocketAddress address) {
        try {
            return new DHTPluginContactImpl(this, this.transport.importContact(address, this.protocol_version, false));
        }
        catch (DHTTransportException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public DHTPluginContact importContact(InetSocketAddress address, byte version) {
        try {
            return new DHTPluginContactImpl(this, this.transport.importContact(address, version, false));
        }
        catch (DHTTransportException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(byte[] handler_key, final DHTPluginTransferHandler handler, Map<String, Object> options) {
        DHTTransportTransferHandler h = new DHTTransportTransferHandler(){

            public String getName() {
                return handler.getName();
            }

            public byte[] handleRead(DHTTransportContact originator, byte[] key) {
                return handler.handleRead(new DHTPluginContactImpl(DHTPluginImpl.this, originator), key);
            }

            public byte[] handleWrite(DHTTransportContact originator, byte[] key, byte[] value) {
                return handler.handleWrite(new DHTPluginContactImpl(DHTPluginImpl.this, originator), key, value);
            }
        };
        Map<DHTPluginTransferHandler, DHTTransportTransferHandler> map = this.handler_map;
        synchronized (map) {
            if (this.handler_map.containsKey(handler)) {
                Debug.out("Warning: handler already exists");
            } else {
                this.handler_map.put(handler, h);
            }
        }
        this.dht.getTransport().registerTransferHandler(handler_key, h, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(byte[] handler_key, DHTPluginTransferHandler handler) {
        DHTTransportTransferHandler h;
        Map<DHTPluginTransferHandler, DHTTransportTransferHandler> map = this.handler_map;
        synchronized (map) {
            h = this.handler_map.remove(handler);
        }
        if (h == null) {
            Debug.out("Mapping not found for handler");
        } else {
            try {
                this.getDHT().getTransport().unregisterTransferHandler(handler_key, h);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public byte[] read(final DHTPluginProgressListener listener, DHTPluginContact target, byte[] handler_key, byte[] key, long timeout) {
        try {
            return this.dht.getTransport().readTransfer(new DHTTransportProgressListener(){

                public void reportSize(long size) {
                    listener.reportSize(size);
                }

                public void reportActivity(String str) {
                    listener.reportActivity(str);
                }

                public void reportCompleteness(int percent) {
                    listener.reportCompleteness(percent);
                }
            }, ((DHTPluginContactImpl)target).getContact(), handler_key, key, timeout);
        }
        catch (DHTTransportException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(final DHTPluginProgressListener listener, DHTPluginContact target, byte[] handler_key, byte[] key, byte[] data, long timeout) {
        try {
            this.dht.getTransport().writeTransfer(new DHTTransportProgressListener(){

                public void reportSize(long size) {
                    listener.reportSize(size);
                }

                public void reportActivity(String str) {
                    listener.reportActivity(str);
                }

                public void reportCompleteness(int percent) {
                    listener.reportCompleteness(percent);
                }
            }, ((DHTPluginContactImpl)target).getContact(), handler_key, key, data, timeout);
        }
        catch (DHTTransportException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] call(final DHTPluginProgressListener listener, DHTPluginContact target, byte[] handler_key, byte[] data, long timeout) {
        try {
            return this.dht.getTransport().writeReadTransfer(new DHTTransportProgressListener(){

                public void reportSize(long size) {
                    listener.reportSize(size);
                }

                public void reportActivity(String str) {
                    listener.reportActivity(str);
                }

                public void reportCompleteness(int percent) {
                    listener.reportCompleteness(percent);
                }
            }, ((DHTPluginContactImpl)target).getContact(), handler_key, data, timeout);
        }
        catch (DHTTransportException e) {
            throw new RuntimeException(e);
        }
    }

    public DHT getDHT() {
        return this.dht;
    }

    public void setSuspended(boolean susp) {
        this.dht.setSuspended(susp);
    }

    public void closedownInitiated() {
        this.storage_manager.exportContacts(this.dht);
        this.dht.destroy();
    }

    public boolean isRecentAddress(String address) {
        return this.storage_manager.isRecentAddress(address);
    }

    protected DHTPluginValue mapValue(DHTTransportValue value) {
        if (value == null) {
            return null;
        }
        return new DHTPluginValueImpl(value);
    }

    public DHTPluginKeyStats decodeStats(DHTPluginValue value) {
        if ((value.getFlags() & 8) == 0) {
            return null;
        }
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(value.getValue()));
            final DHTStorageKeyStats stats2 = this.storage_manager.deserialiseStats(dis);
            return new DHTPluginKeyStats(){

                public int getEntryCount() {
                    return stats2.getEntryCount();
                }

                public int getSize() {
                    return stats2.getSize();
                }

                public int getReadsPerMinute() {
                    return stats2.getReadsPerMinute();
                }

                public byte getDiversification() {
                    return stats2.getDiversification();
                }
            };
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    @Override
    public byte[] getID() {
        return this.dht.getRouter().getID();
    }

    @Override
    public boolean isIPV6() {
        return this.dht.getTransport().isIPV6();
    }

    @Override
    public int getNetwork() {
        return this.dht.getTransport().getNetwork();
    }

    @Override
    public DHTPluginContact[] getReachableContacts() {
        DHTTransportContact[] contacts = this.dht.getTransport().getReachableContacts();
        DHTPluginContact[] result = new DHTPluginContact[contacts.length];
        for (int i = 0; i < contacts.length; ++i) {
            result[i] = new DHTPluginContactImpl(this, contacts[i]);
        }
        return result;
    }

    @Override
    public DHTPluginContact[] getRecentContacts() {
        DHTTransportContact[] contacts = this.dht.getTransport().getRecentContacts();
        DHTPluginContact[] result = new DHTPluginContact[contacts.length];
        for (int i = 0; i < contacts.length; ++i) {
            result[i] = new DHTPluginContactImpl(this, contacts[i]);
        }
        return result;
    }

    @Override
    public List<DHTPluginContact> getClosestContacts(byte[] to_id, boolean live_only) {
        List<DHTTransportContact> contacts = this.dht.getControl().getClosestKContactsList(to_id, live_only);
        ArrayList<DHTPluginContact> result = new ArrayList<DHTPluginContact>(contacts.size());
        for (DHTTransportContact contact : contacts) {
            result.add(new DHTPluginContactImpl(this, contact));
        }
        return result;
    }
}

