/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.toolbar;

import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIToolBarItemImpl;

public class ToolBarItemSO {
    private static final boolean DEBUG_TUX = false;
    private SWTSkinButtonUtility skinButton;
    private SWTSkinObjectText skinTitle;
    private boolean isDown;
    private UIToolBarItemImpl base;
    private SWTSkinObject so;

    public ToolBarItemSO(UIToolBarItemImpl base, SWTSkinObject so) {
        this.base = base;
        this.so = so;
    }

    public SWTSkinObject getSO() {
        return this.so;
    }

    public void setSkinButton(SWTSkinButtonUtility btn) {
        this.skinButton = btn;
        this.updateUI();
    }

    public SWTSkinButtonUtility getSkinButton() {
        return this.skinButton;
    }

    public void setSkinTitle(SWTSkinObjectText s) {
        this.skinTitle = s;
        this.skinTitle.setTextID(this.base.getTextID());
    }

    private void setEnabled(boolean enabled) {
        if (this.base.isAlwaysAvailable() && !enabled) {
            return;
        }
        if (this.skinButton != null) {
            this.skinButton.setDisabled(!enabled);
        }
    }

    public void dispose() {
        this.skinButton = null;
        this.skinTitle = null;
    }

    public ToolBarItem getBase() {
        return this.base;
    }

    public void updateUI() {
        if (this.skinButton != null) {
            this.skinButton.setImage(this.base.getImageID());
        }
        if (this.skinTitle != null) {
            this.skinTitle.setTextID(this.base.getTextID());
        }
        if (this.base.isAlwaysAvailable()) {
            this.setEnabled(true);
        } else {
            long state = this.base.getState();
            this.setEnabled((state & 1L) > 0L);
            boolean bl = this.isDown = (state & 2L) > 0L;
            if (this.skinButton != null) {
                this.skinButton.getSkinObject().switchSuffix(this.isDown ? "-selected" : "", 4, false);
            }
        }
    }

    public void setSO(SWTSkinObject so) {
        this.so = so;
    }
}

