/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnpms.impl;

import com.aelitis.net.upnpms.UPNPMSContainer;
import com.aelitis.net.upnpms.UPNPMSNode;
import com.aelitis.net.upnpms.UPnPMSException;
import com.aelitis.net.upnpms.impl.UPNPMSBrowserImpl;
import com.aelitis.net.upnpms.impl.UPNPMSItemImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPNPMSContainerImpl
implements UPNPMSContainer {
    private UPNPMSBrowserImpl browser;
    private String id;
    private String title;
    private List<UPNPMSNode> children;

    protected UPNPMSContainerImpl(UPNPMSBrowserImpl _browser, String _id, String _title) {
        this.browser = _browser;
        this.id = _id;
        this.title = _title;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate() throws UPnPMSException {
        UPNPMSContainerImpl uPNPMSContainerImpl = this;
        synchronized (uPNPMSContainerImpl) {
            if (this.children == null) {
                this.children = new ArrayList<UPNPMSNode>();
                List<SimpleXMLParserDocumentNode> results = this.browser.getContainerContents(this.id);
                for (SimpleXMLParserDocumentNode result : results) {
                    SimpleXMLParserDocumentNode[] kids;
                    for (SimpleXMLParserDocumentNode kid : kids = result.getChildren()) {
                        SimpleXMLParserDocumentNode[] sub;
                        String title;
                        String id;
                        String name = kid.getName();
                        if (name.equalsIgnoreCase("container")) {
                            id = kid.getAttribute("id").getValue();
                            title = kid.getChild("title").getValue();
                            this.children.add(new UPNPMSContainerImpl(this.browser, id, title));
                            continue;
                        }
                        if (!name.equalsIgnoreCase("item")) continue;
                        id = kid.getAttribute("id").getValue();
                        title = kid.getChild("title").getValue();
                        String cla = kid.getChild("class").getValue();
                        String item_class = cla.contains(".imageItem") ? "image" : (cla.contains(".audioItem") ? "audio" : (cla.contains(".videoItem") ? "video" : "other"));
                        URL url = null;
                        long size = 0L;
                        for (SimpleXMLParserDocumentNode x : sub = kid.getChildren()) {
                            String pi_str;
                            SimpleXMLParserDocumentAttribute pi;
                            if (!x.getName().equalsIgnoreCase("res")) continue;
                            SimpleXMLParserDocumentAttribute a_size = x.getAttribute("size");
                            long this_size = 0L;
                            if (a_size != null) {
                                try {
                                    this_size = Long.parseLong(a_size.getValue().trim());
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                            if ((pi = x.getAttribute("protocolInfo")) == null || !(pi_str = pi.getValue().trim()).toLowerCase().startsWith("http-get")) continue;
                            try {
                                if (size != 0L && this_size <= size) continue;
                                url = new URL(x.getValue().trim());
                                size = this_size;
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                        if (url == null) continue;
                        this.children.add(new UPNPMSItemImpl(id, title, item_class, size, url));
                    }
                }
            }
        }
    }

    @Override
    public List<UPNPMSNode> getChildren() throws UPnPMSException {
        this.populate();
        return this.children;
    }
}

