/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.util.Arrays;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.util.Debug;

public class DiskManagerFileInfoSetImpl
implements DiskManagerFileInfoSet {
    final DiskManagerFileInfoImpl[] files;
    final DiskManagerHelper diskManager;

    public DiskManagerFileInfoSetImpl(DiskManagerFileInfoImpl[] files, DiskManagerHelper dm) {
        this.files = files;
        this.diskManager = dm;
    }

    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    public int nbFiles() {
        return this.files.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int[] toChange) {
        if (toChange.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState dmState = this.diskManager.getDownloadState();
        try {
            dmState.suppressStateSave(true);
            for (int i = 0; i < this.files.length; ++i) {
                if (toChange[i] == 0) continue;
                this.files[i].setPriority(toChange[i]);
            }
            Object var5_4 = null;
            dmState.suppressStateSave(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dmState.suppressStateSave(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSkipped(boolean[] toChange, boolean setSkipped) {
        DownloadManagerState dmState;
        block11: {
            block10: {
                if (toChange.length != this.files.length) {
                    throw new IllegalArgumentException("array length mismatches the number of files");
                }
                dmState = this.diskManager.getDownloadState();
                try {
                    dmState.suppressStateSave(true);
                    if (!setSkipped) {
                        String[] types = this.diskManager.getStorageTypes();
                        boolean[] toLinear = new boolean[toChange.length];
                        boolean[] toReorder = new boolean[toChange.length];
                        int num_linear = 0;
                        int num_reorder = 0;
                        for (int i = 0; i < toChange.length; ++i) {
                            if (!toChange[i]) continue;
                            int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                            if (old_type == 2) {
                                toLinear[i] = true;
                                ++num_linear;
                                continue;
                            }
                            if (old_type != 4) continue;
                            toReorder[i] = true;
                            ++num_reorder;
                        }
                        if (num_linear > 0 && !Arrays.equals(toLinear, this.setStorageTypes(toLinear, 1))) {
                            Object var12_12 = null;
                            dmState.suppressStateSave(false);
                            return;
                        }
                        if (num_reorder > 0 && !Arrays.equals(toReorder, this.setStorageTypes(toReorder, 3))) {
                            break block10;
                        }
                    }
                    for (int i = 0; i < this.files.length; ++i) {
                        if (!toChange[i]) continue;
                        this.files[i].setSkippedInternal(setSkipped);
                        this.diskManager.skippedFileSetChanged(this.files[i]);
                    }
                    if (!setSkipped) {
                        DiskManagerUtil.doFileExistenceChecks(this, toChange, this.diskManager.getDownloadState().getDownloadManager(), true);
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    dmState.suppressStateSave(false);
                    throw throwable;
                }
            }
            Object var12_13 = null;
            dmState.suppressStateSave(false);
            return;
        }
        Object var12_14 = null;
        dmState.suppressStateSave(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean[] setStorageTypes(boolean[] toChange, int newStroageType) {
        if (toChange.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        if (this.files.length == 0) {
            return new boolean[0];
        }
        String[] types = this.diskManager.getStorageTypes();
        boolean[] modified = new boolean[this.files.length];
        DownloadManagerState dm_state = this.diskManager.getDownloadState();
        if (newStroageType == 2 || newStroageType == 4) {
            Debug.out("Download must be stopped for linear -> compact conversion");
            return modified;
        }
        try {
            dm_state.suppressStateSave(true);
            for (int i = 0; i < this.files.length; ++i) {
                Object var11_9;
                if (!toChange[i]) continue;
                int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                if (newStroageType == old_type) {
                    modified[i] = true;
                    continue;
                }
                DiskManagerFileInfoImpl file = this.files[i];
                try {
                    try {
                        file.getCacheFile().setStorageType(DiskManagerUtil.convertDMStorageTypeToCache(newStroageType));
                        modified[i] = true;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.diskManager.setFailed(file, "Failed to change storage type for '" + file.getFile(true) + "': " + Debug.getNestedExceptionMessage(e));
                        var11_9 = null;
                        types[i] = DiskManagerUtil.convertCacheStorageTypeToString(file.getCacheFile().getStorageType());
                        break;
                    }
                    var11_9 = null;
                }
                catch (Throwable throwable) {
                    var11_9 = null;
                    types[i] = DiskManagerUtil.convertCacheStorageTypeToString(file.getCacheFile().getStorageType());
                    throw throwable;
                }
                types[i] = DiskManagerUtil.convertCacheStorageTypeToString(file.getCacheFile().getStorageType());
            }
            dm_state.setListAttribute("storetypes", types);
            DiskManagerUtil.doFileExistenceChecks(this, toChange, dm_state.getDownloadManager(), true);
            Object var13_12 = null;
            dm_state.suppressStateSave(false);
            dm_state.save();
            return modified;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            dm_state.suppressStateSave(false);
            dm_state.save();
            throw throwable;
        }
    }
}

