/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebPageRequestImpl;

public class TrackerWebPageResponseImpl
implements TrackerWebPageResponse {
    private static final String NL = "\r\n";
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    private String content_type = "text/html";
    private int reply_status = 200;
    private Map<String, Object> header_map = new LinkedHashMap<String, Object>();
    private TrackerWebPageRequestImpl request;
    private boolean raw_output;
    private boolean is_async;
    private int explicit_gzip = 0;
    private boolean is_gzipped;

    protected TrackerWebPageResponseImpl(TrackerWebPageRequestImpl _request) {
        this.request = _request;
        String formatted_date_now = TimeFormatter.getHTTPDate(SystemTime.getCurrentTime());
        this.setHeader("Last-Modified", formatted_date_now);
        this.setHeader("Expires", formatted_date_now);
    }

    public void setLastModified(long time) {
        String formatted_date = TimeFormatter.getHTTPDate(time);
        this.setHeader("Last-Modified", formatted_date);
    }

    public void setExpires(long time) {
        String formatted_date = TimeFormatter.getHTTPDate(time);
        this.setHeader("Expires", formatted_date);
    }

    public void setContentType(String type) {
        this.content_type = type;
    }

    public void setReplyStatus(int status) {
        this.reply_status = status;
    }

    public void setHeader(String name, String value) {
        if (name.equalsIgnoreCase("set-cookie")) {
            for (String key : this.header_map.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                Object existing = this.header_map.get(key);
                if (existing instanceof String) {
                    String old = (String)existing;
                    ArrayList<String> l = new ArrayList<String>(3);
                    l.add(old);
                    l.add(value);
                    this.header_map.put(name, l);
                } else {
                    List l = (List)existing;
                    if (!l.contains(value)) {
                        l.add(value);
                    }
                }
                return;
            }
            this.header_map.put(name, value);
        } else {
            this.addHeader(name, value, true);
        }
    }

    public void setGZIP(boolean gzip) {
        this.explicit_gzip = gzip ? 1 : 2;
    }

    protected String addHeader(String name, String value, boolean replace) {
        Iterator<String> it = this.header_map.keySet().iterator();
        while (it.hasNext()) {
            List l;
            String key = it.next();
            if (!key.equalsIgnoreCase(name)) continue;
            if (replace) {
                it.remove();
                continue;
            }
            Object existing = this.header_map.get(key);
            if (existing instanceof String) {
                return (String)existing;
            }
            if (existing instanceof List && (l = (List)existing).size() > 0) {
                return (String)l.get(0);
            }
            return null;
        }
        this.header_map.put(name, value);
        return value;
    }

    public OutputStream getOutputStream() {
        return this.baos;
    }

    public OutputStream getRawOutputStream() throws IOException {
        this.raw_output = true;
        return this.request.getOutputStream();
    }

    public boolean isActive() {
        return this.request.isActive();
    }

    protected void complete() throws IOException {
        GZIPOutputStream gzos;
        Map headers;
        String accept_encoding;
        if (this.is_async || this.raw_output) {
            return;
        }
        byte[] reply_bytes = this.baos.toByteArray();
        String status_string = "BAD";
        if (this.reply_status == 200) {
            status_string = "OK";
        } else if (this.reply_status == 204) {
            status_string = "No Content";
        } else if (this.reply_status == 206) {
            status_string = "Partial Content";
        } else if (this.reply_status == 401) {
            status_string = "Unauthorized";
        } else if (this.reply_status == 404) {
            status_string = "Not Found";
        } else if (this.reply_status == 501) {
            status_string = "Not Implemented";
        }
        String reply_header = "HTTP/1.1 " + this.reply_status + " " + status_string + NL;
        this.addHeader("Server", "Azureus 5.6.1.3_B02", false);
        if (this.request.canKeepAlive()) {
            String applied_value = this.addHeader("Connection", "keep-alive", false);
            if (applied_value.equalsIgnoreCase("keep-alive")) {
                this.request.setKeepAlive(true);
            }
        } else {
            this.addHeader("Connection", "close", true);
        }
        this.addHeader("Content-Type", this.content_type, false);
        boolean do_gzip = false;
        if (this.explicit_gzip == 1 && !this.is_gzipped && HTTPUtils.canGZIP(accept_encoding = (String)(headers = this.request.getHeaders()).get("accept-encoding"))) {
            do_gzip = true;
            this.is_gzipped = true;
            this.header_map.put("Content-Encoding", "gzip");
        }
        for (String name : this.header_map.keySet()) {
            Object value = this.header_map.get(name);
            if (value instanceof String) {
                reply_header = reply_header + name + ": " + value + NL;
                continue;
            }
            List l = (List)value;
            for (String v : l) {
                reply_header = reply_header + name + ": " + v + NL;
            }
        }
        if (do_gzip && reply_bytes.length < 524288) {
            ByteArrayOutputStream temp = new ByteArrayOutputStream(reply_bytes.length);
            gzos = new GZIPOutputStream(temp);
            gzos.write(reply_bytes);
            gzos.finish();
            reply_bytes = temp.toByteArray();
            do_gzip = false;
        }
        reply_header = reply_header + "Content-Length: " + reply_bytes.length + NL + NL;
        OutputStream os = this.request.getOutputStream();
        os.write(reply_header.getBytes());
        if (do_gzip) {
            gzos = new GZIPOutputStream(os);
            gzos.write(reply_bytes);
            gzos.finish();
        } else {
            os.write(reply_bytes);
        }
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useFile(String root_dir, String relative_url) throws IOException {
        String target = root_dir + relative_url.replace('/', File.separatorChar);
        File canonical_file = new File(target).getCanonicalFile();
        if (!canonical_file.toString().toLowerCase().startsWith(root_dir.toLowerCase())) {
            return false;
        }
        if (canonical_file.isDirectory()) {
            return false;
        }
        if (canonical_file.canRead()) {
            boolean bl;
            block7: {
                String str = canonical_file.toString().toLowerCase();
                int pos = str.lastIndexOf(".");
                if (pos == -1) {
                    return false;
                }
                String file_type = str.substring(pos + 1);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(canonical_file);
                    this.useStream(file_type, fis);
                    bl = true;
                    Object var11_10 = null;
                    if (fis == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (fis != null) {
                        fis.close();
                    }
                    throw throwable;
                }
                fis.close();
            }
            return bl;
        }
        return false;
    }

    public void useStream(String file_type, InputStream input_stream) throws IOException {
        int len;
        Map headers;
        String accept_encoding;
        OutputStream os = this.getOutputStream();
        String response_type = HTTPUtils.guessContentTypeFromFileType(file_type);
        if (this.explicit_gzip != 2 && HTTPUtils.useCompressionForFileType(response_type) && HTTPUtils.canGZIP(accept_encoding = (String)(headers = this.request.getHeaders()).get("accept-encoding"))) {
            this.is_gzipped = true;
            os = new GZIPOutputStream(os);
            this.header_map.put("Content-Encoding", "gzip");
        }
        this.setContentType(response_type);
        byte[] buffer = new byte[4096];
        while ((len = input_stream.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        if (os instanceof GZIPOutputStream) {
            ((GZIPOutputStream)os).finish();
        }
    }

    public void writeTorrent(TrackerTorrent tracker_torrent) throws IOException {
        try {
            TRHostTorrent host_torrent = ((TrackerTorrentImpl)tracker_torrent).getHostTorrent();
            TOTorrent torrent = host_torrent.getTorrent();
            TOTorrent torrent_to_send = TOTorrentFactory.deserialiseFromMap(torrent.serialiseToMap());
            torrent_to_send.removeAdditionalProperties();
            if (!TorrentUtils.isDecentralised(torrent_to_send)) {
                URL[][] url_sets = TRTrackerUtils.getAnnounceURLs();
                if (host_torrent.getStatus() != 3 && url_sets.length > 0 && COConfigurationManager.getBooleanParameter("Tracker Host Add Our Announce URLs")) {
                    String protocol = torrent_to_send.getAnnounceURL().getProtocol();
                    for (int i = 0; i < url_sets.length; ++i) {
                        URL[] urls = url_sets[i];
                        if (!urls[0].getProtocol().equalsIgnoreCase(protocol)) continue;
                        torrent_to_send.setAnnounceURL(urls[0]);
                        torrent_to_send.getAnnounceURLGroup().setAnnounceURLSets(new TOTorrentAnnounceURLSet[0]);
                        for (int j = 1; j < urls.length; ++j) {
                            TorrentUtils.announceGroupsInsertLast(torrent_to_send, new URL[]{urls[j]});
                        }
                        break;
                    }
                }
            }
            this.baos.write(BEncoder.encode(torrent_to_send.serialiseToMap()));
            this.setContentType("application/x-bittorrent");
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            throw new IOException(e.toString());
        }
    }

    public void setAsynchronous(boolean a) throws IOException {
        AsyncController async_control = this.request.getAsyncController();
        if (async_control == null) {
            throw new IOException("Request is not non-blocking");
        }
        if (a) {
            this.is_async = true;
            async_control.setAsyncStart();
        } else {
            this.is_async = false;
            this.complete();
            async_control.setAsyncComplete();
        }
    }

    public boolean getAsynchronous() {
        return this.is_async;
    }
}

