/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.rss;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSChannel;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSItem;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSItemImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSUtils;

public class RSSChannelImpl
implements RSSChannel {
    private SimpleXMLParserDocumentNode node;
    private RSSItem[] items;
    private boolean is_atom;

    protected RSSChannelImpl(SimpleXMLParserDocumentNode _node, boolean _is_atom) {
        this.node = _node;
        this.is_atom = _is_atom;
        SimpleXMLParserDocumentNode[] xml_items = this.node.getChildren();
        ArrayList<RSSItemImpl> its = new ArrayList<RSSItemImpl>();
        for (int i = 0; i < xml_items.length; ++i) {
            SimpleXMLParserDocumentNode xml_item = xml_items[i];
            if (!xml_item.getName().equalsIgnoreCase(this.is_atom ? "entry" : "item")) continue;
            its.add(new RSSItemImpl(xml_item, this.is_atom));
        }
        this.items = new RSSItem[its.size()];
        its.toArray(this.items);
    }

    public String getTitle() {
        return this.node.getChild("title").getValue();
    }

    public String getDescription() {
        String[] fields = this.is_atom ? new String[]{"summary", "description"} : new String[]{"description", "summary"};
        for (String field : fields) {
            SimpleXMLParserDocumentNode x = this.node.getChild(field);
            if (x == null) continue;
            return x.getValue();
        }
        return null;
    }

    public URL getLink() {
        try {
            return new URL(this.node.getChild("link").getValue());
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public Date getPublicationDate() {
        SimpleXMLParserDocumentNode pd = this.node.getChild(this.is_atom ? "updated" : "pubdate");
        if (pd == null) {
            return null;
        }
        if (this.is_atom) {
            return RSSUtils.parseAtomDate(pd.getValue());
        }
        return RSSUtils.parseRSSDate(pd.getValue());
    }

    public RSSItem[] getItems() {
        return this.items;
    }

    public SimpleXMLParserDocumentNode getNode() {
        return this.node;
    }
}

