/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TorrentCommand
extends IConsoleCommand {
    private final String action;

    public TorrentCommand(String main_name, String short_name, String action) {
        super(main_name, short_name);
        this.action = action;
    }

    protected String getAction() {
        return this.action;
    }

    protected abstract boolean performCommand(ConsoleInput var1, DownloadManager var2, List<String> var3);

    protected boolean performCommand(ConsoleInput ci, TRHostTorrent torrent, List<String> args) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(String commandName, ConsoleInput ci, List<String> args) {
        if (!args.isEmpty()) {
            String subcommand = args.remove(0);
            if (ci.torrents.isEmpty()) {
                ci.out.println("> Command '" + this.getCommandName() + "': No torrents in list (Maybe you forgot to 'show torrents' first).");
                return;
            }
            try {
                int number = Integer.parseInt(subcommand);
                if (number > 0 && number <= ci.torrents.size()) {
                    DownloadManager dm = (DownloadManager)ci.torrents.get(number - 1);
                    String name = dm.getDisplayName() == null ? "?" : dm.getDisplayName();
                    this.performCommandIfAllowed(ci, args, dm, "#" + subcommand, name);
                    return;
                }
                ci.out.println("> Command '" + this.getCommandName() + "': Torrent #" + subcommand + " unknown.");
                return;
            }
            catch (NumberFormatException e) {
                if ("all".equalsIgnoreCase(subcommand)) {
                    Iterator torrent = ci.torrents.iterator();
                    while (torrent.hasNext()) {
                        DownloadManager dm = (DownloadManager)torrent.next();
                        String name = dm.getDisplayName() == null ? "?" : dm.getDisplayName();
                        this.performCommandIfAllowed(ci, args, dm, subcommand, name);
                    }
                    return;
                }
                if ("hash".equalsIgnoreCase(subcommand)) {
                    TRHost host;
                    String name;
                    String hash = args.remove(0);
                    List<DownloadManager> torrents = ci.getGlobalManager().getDownloadManagers();
                    boolean foundit = false;
                    for (DownloadManager dm : torrents) {
                        if (!hash.equals(TorrentUtils.nicePrintTorrentHash(dm.getTorrent(), true))) continue;
                        name = dm.getDisplayName() == null ? "?" : dm.getDisplayName();
                        this.performCommandIfAllowed(ci, args, dm, hash, name);
                        return;
                    }
                    if (!foundit && (host = ci.getCore().getTrackerHost()) != null) {
                        TRHostTorrent[] h_torrents = host.getTorrents();
                        for (int i = 0; i < h_torrents.length; ++i) {
                            TRHostTorrent ht = h_torrents[i];
                            if (!hash.equals(TorrentUtils.nicePrintTorrentHash(ht.getTorrent(), true))) continue;
                            name = TorrentUtils.getLocalisedName(ht.getTorrent());
                            this.performCommandIfAllowed(ci, args, ht, hash, name);
                            return;
                        }
                    }
                    if (foundit) return;
                    ci.out.println("> Command '" + this.getCommandName() + "': Hash '" + hash + "' unknown.");
                    return;
                }
                ci.out.println("> Command '" + this.getCommandName() + "': Subcommand '" + subcommand + "' unknown.");
            }
            return;
        }
        ci.out.println("> Missing subcommand for '" + this.getCommandName() + "'");
        this.printHelp(ci.out, args);
    }

    private void performCommandIfAllowed(ConsoleInput ci, List args, DownloadManager dm, String desc, String name) {
        if (!"admin".equals(ci.getUserProfile().getUserType())) {
            if ("user".equals(ci.getUserProfile().getUserType())) {
                String owner = dm.getDownloadState().getAttribute("user");
                if (!ci.getUserProfile().getUsername().equals(owner)) {
                    ci.out.println("> " + this.getAction() + " torrent " + desc + " (" + name + ") failed: Permission Denied. Users can only modify their own torrents");
                    return;
                }
            } else {
                ci.out.println("> " + this.getAction() + " torrent " + desc + " (" + name + ") failed: Permission Denied. Guests cannot modify torrents");
                return;
            }
        }
        if (this.performCommand(ci, dm, (List<String>)args)) {
            ci.out.println("> " + this.getAction() + " Torrent " + desc + " (" + name + ") succeeded.");
        } else {
            ci.out.println("> " + this.getAction() + " Torrent " + desc + " (" + name + ") failed.");
        }
    }

    private void performCommandIfAllowed(ConsoleInput ci, List args, TRHostTorrent torrent, String desc, String name) {
        if (!"admin".equals(ci.getUserProfile().getUserType()) && !"user".equals(ci.getUserProfile().getUserType())) {
            ci.out.println("> " + this.getAction() + " torrent " + desc + " (" + name + ") failed: Permission Denied. Guests cannot modify torrents");
            return;
        }
        if (this.performCommand(ci, torrent, (List<String>)args)) {
            ci.out.println("> " + this.getAction() + " Torrent " + desc + " (" + name + ") succeeded.");
        } else {
            ci.out.println("> " + this.getAction() + " Torrent " + desc + " (" + name + ") failed.");
        }
    }

    public void printHelpExtra(PrintStream out, List args) {
        out.println("> " + this.getCommandName() + " syntax: " + this.getCommandName() + " (<#>|all|hash <hash>)");
    }
}

