/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;

public class DirectoryParameter
extends Parameter {
    Control[] controls = new Control[2];
    StringParameter sp;

    public DirectoryParameter(final Composite pluginGroup, String name, String defaultValue) {
        super(name);
        this.sp = new StringParameter(pluginGroup, name, defaultValue);
        this.controls[0] = this.sp.getControl();
        GridData gridData = new GridData(768);
        this.controls[0].setLayoutData((Object)gridData);
        Button browse = new Button(pluginGroup, 8);
        ImageLoader.getInstance().setButtonImage(browse, this.getBrowseImageResource());
        browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                String path = DirectoryParameter.this.openDialog(pluginGroup.getShell(), DirectoryParameter.this.sp.getValue());
                if (path != null) {
                    DirectoryParameter.this.sp.setValue(path);
                }
            }
        });
        this.controls[1] = browse;
    }

    public void setLayoutData(Object layoutData) {
    }

    public Control getControl() {
        return this.controls[0];
    }

    public Control[] getControls() {
        return this.controls;
    }

    protected String getBrowseImageResource() {
        return "openFolderButton";
    }

    protected String openDialog(Shell shell, String old_value) {
        DirectoryDialog dialog = new DirectoryDialog(shell, 65536);
        dialog.setFilterPath(old_value);
        return dialog.open();
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.sp.setValue((String)value);
        }
    }
}

