/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.maketorrent.ProgressPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavePathPanel
extends AbstractWizardPanel<NewTorrentWizard> {
    protected long file_size;
    protected long piece_size;
    protected long piece_count;

    public SavePathPanel(NewTorrentWizard wizard, AbstractWizardPanel<NewTorrentWizard> _previousPanel) {
        super(wizard, _previousPanel);
    }

    @Override
    public void show() {
        boolean privateTorrent;
        File temp;
        String existing_parent;
        String target_file;
        try {
            this.file_size = ((NewTorrentWizard)this.wizard).create_mode == 3 ? TOTorrentFactory.getTorrentDataSizeFromFileOrDir(((NewTorrentWizard)this.wizard).byo_desc_file, true) : TOTorrentFactory.getTorrentDataSizeFromFileOrDir(new File(((NewTorrentWizard)this.wizard).create_mode == 2 ? ((NewTorrentWizard)this.wizard).directoryPath : ((NewTorrentWizard)this.wizard).singlePath), false);
            this.piece_size = TOTorrentFactory.getComputedPieceSize(this.file_size);
            this.piece_count = TOTorrentFactory.getPieceCount(this.file_size, this.piece_size);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        ((NewTorrentWizard)this.wizard).setTitle(MessageText.getString("wizard.torrentFile"));
        ((NewTorrentWizard)this.wizard).setCurrentInfo(MessageText.getString("wizard.choosetorrent"));
        Composite panel = ((NewTorrentWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        final Text file = new Text(panel, 2048);
        file.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String fName;
                ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).savePath = fName = file.getText();
                String error = "";
                if (!fName.equals("")) {
                    File f = new File(file.getText());
                    if (f.isDirectory() || f.getParentFile() != null && !f.getParentFile().canWrite()) {
                        error = MessageText.getString("wizard.invalidfile");
                    } else {
                        String parent = f.getParent();
                        if (parent != null) {
                            ((NewTorrentWizard)SavePathPanel.this.wizard).setDefaultSaveDir(parent);
                        }
                    }
                }
                ((NewTorrentWizard)SavePathPanel.this.wizard).setErrorMessage(error);
                ((NewTorrentWizard)SavePathPanel.this.wizard).setFinishEnabled(!((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).savePath.equals("") && error.equals(""));
            }
        });
        String default_save = ((NewTorrentWizard)this.wizard).getDefaultSaveDir();
        if (((NewTorrentWizard)this.wizard).create_mode == 3) {
            List path;
            Map map;
            List list;
            target_file = "";
            if (((NewTorrentWizard)this.wizard).byo_map != null && (list = (List)((NewTorrentWizard)this.wizard).byo_map.get("file_map")) != null && (map = (Map)list.get(0)) != null && (path = (List)map.get("logical_path")) != null) {
                target_file = new File(COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory"), (String)path.get(0) + ".torrent").getAbsolutePath();
            }
        } else {
            target_file = ((NewTorrentWizard)this.wizard).create_mode == 2 ? ((NewTorrentWizard)this.wizard).directoryPath + ".torrent" : ((NewTorrentWizard)this.wizard).singlePath + ".torrent";
        }
        if (default_save.length() > 0 && target_file.length() > 0 && (existing_parent = (temp = new File(target_file)).getParent()) != null) {
            target_file = new File(default_save, temp.getName()).toString();
        }
        ((NewTorrentWizard)this.wizard).savePath = target_file;
        file.setText(((NewTorrentWizard)this.wizard).savePath);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        file.setLayoutData((Object)gridData);
        Button browse = new Button(panel, 8);
        browse.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String f;
                FileDialog fd = new FileDialog(((NewTorrentWizard)SavePathPanel.this.wizard).getWizardWindow(), 8192);
                String path = ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).savePath;
                if (((NewTorrentWizard)SavePathPanel.this.wizard).getErrorMessage().equals("") && !path.equals("")) {
                    File fsPath = new File(path);
                    if (!path.endsWith(File.separator)) {
                        fd.setFilterPath(fsPath.getParent());
                        fd.setFileName(fsPath.getName());
                    } else {
                        fd.setFileName(path);
                    }
                }
                if ((f = fd.open()) != null) {
                    file.setText(f);
                    File ff = new File(f);
                    String parent = ff.getParent();
                    if (parent != null) {
                        ((NewTorrentWizard)SavePathPanel.this.wizard).setDefaultSaveDir(parent);
                    }
                }
            }
        });
        Messages.setLanguageText((Widget)browse, "wizard.browse");
        Label label = new Label(panel, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        Composite gFileStuff = new Composite(panel, 0);
        gridData = new GridData(272);
        gridData.horizontalSpan = 3;
        gFileStuff.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        gFileStuff.setLayout((Layout)layout);
        label = new Label(gFileStuff, 0);
        Messages.setLanguageText((Widget)label, "wizard.maketorrent.filesize");
        Label file_size_label = new Label(gFileStuff, 0);
        file_size_label.setText(DisplayFormatters.formatByteCountToKiBEtc(this.file_size));
        label = new Label(gFileStuff, 0);
        label = new Label(gFileStuff, 0);
        label = new Label(gFileStuff, 0);
        Messages.setLanguageText((Widget)label, "wizard.maketorrent.piececount");
        final Label piece_count_label = new Label(gFileStuff, 0);
        piece_count_label.setText("" + this.piece_count);
        label = new Label(gFileStuff, 0);
        label = new Label(gFileStuff, 0);
        label = new Label(gFileStuff, 0);
        Messages.setLanguageText((Widget)label, "wizard.maketorrent.piecesize");
        final Label piece_size_label = new Label(gFileStuff, 0);
        gridData = new GridData();
        gridData.widthHint = 75;
        piece_size_label.setLayoutData((Object)gridData);
        piece_size_label.setText(DisplayFormatters.formatByteCountToKiBEtc(this.piece_size));
        final Combo manual = new Combo(gFileStuff, 12);
        final long[] sizes = TOTorrentFactory.STANDARD_PIECE_SIZES;
        manual.add(MessageText.getString("wizard.maketorrent.auto"));
        for (int i = 0; i < sizes.length; ++i) {
            manual.add(DisplayFormatters.formatByteCountToKiBEtc(sizes[i]));
        }
        manual.select(0);
        manual.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = manual.getSelectionIndex();
                if (index == 0) {
                    ((NewTorrentWizard)SavePathPanel.this.wizard).setPieceSizeComputed();
                    SavePathPanel.this.piece_size = TOTorrentFactory.getComputedPieceSize(SavePathPanel.this.file_size);
                } else {
                    SavePathPanel.this.piece_size = sizes[index - 1];
                    ((NewTorrentWizard)SavePathPanel.this.wizard).setPieceSizeManual(SavePathPanel.this.piece_size);
                }
                SavePathPanel.this.piece_count = TOTorrentFactory.getPieceCount(SavePathPanel.this.file_size, SavePathPanel.this.piece_size);
                piece_size_label.setText(DisplayFormatters.formatByteCountToKiBEtc(SavePathPanel.this.piece_size));
                piece_count_label.setText("" + SavePathPanel.this.piece_count);
            }
        });
        label = new Label(gFileStuff, 0);
        label = new Label(panel, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        final Button bAutoOpen = new Button(panel, 32);
        Messages.setLanguageText((Widget)bAutoOpen, "wizard.maketorrents.autoopen");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bAutoOpen.setLayoutData((Object)gridData);
        final Button bforce = new Button(panel, 32);
        Messages.setLanguageText((Widget)bforce, "wizard.maketorrents.force");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bforce.setLayoutData((Object)gridData);
        final Button bSuperSeed = new Button(panel, 32);
        Messages.setLanguageText((Widget)bSuperSeed, "wizard.maketorrents.superseed");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bSuperSeed.setLayoutData((Object)gridData);
        final Button bAutoHost = new Button(panel, 32);
        Messages.setLanguageText((Widget)bAutoHost, "wizard.maketorrents.autohost");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bAutoHost.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "wizard.maketorrents.init.tags");
        final Text tag_area = new Text(panel, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        tag_area.setLayoutData((Object)gridData);
        bforce.setEnabled(false);
        tag_area.setEnabled(false);
        bSuperSeed.setEnabled(false);
        bAutoHost.setEnabled(false);
        bAutoOpen.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).autoOpen = bAutoOpen.getSelection();
                boolean autoOpen = ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).autoOpen;
                boolean enable = autoOpen && ((NewTorrentWizard)SavePathPanel.this.wizard).getTrackerType() != 2;
                bforce.setEnabled(autoOpen);
                tag_area.setEnabled(autoOpen);
                bSuperSeed.setEnabled(autoOpen);
                bAutoHost.setEnabled(enable);
            }
        });
        bforce.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).forceStart = bforce.getSelection();
            }
        });
        tag_area.setText(((NewTorrentWizard)this.wizard).getInitialTags(false));
        tag_area.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ((NewTorrentWizard)SavePathPanel.this.wizard).setInitialTags(tag_area.getText().trim());
            }
        });
        bSuperSeed.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).superseed = bSuperSeed.getSelection();
            }
        });
        bAutoHost.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).autoHost = bAutoHost.getSelection();
            }
        });
        final Button bPrivateTorrent = new Button(panel, 32);
        Messages.setLanguageText((Widget)bPrivateTorrent, "ConfigView.section.sharing.privatetorrent");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bPrivateTorrent.setLayoutData((Object)gridData);
        final Button bAllowDHT = new Button(panel, 32);
        Messages.setLanguageText((Widget)bAllowDHT, "ConfigView.section.sharing.permitdht");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bAllowDHT.setLayoutData((Object)gridData);
        bAllowDHT.setSelection(true);
        bAllowDHT.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).permitDHT = bAllowDHT.getSelection();
            }
        });
        if (((NewTorrentWizard)this.wizard).getTrackerType() == 3) {
            ((NewTorrentWizard)this.wizard).setPrivateTorrent(false);
        }
        bAllowDHT.setEnabled(!(privateTorrent = ((NewTorrentWizard)this.wizard).getPrivateTorrent()));
        if (privateTorrent) {
            bAllowDHT.setSelection(false);
            ((NewTorrentWizard)this.wizard).permitDHT = false;
        }
        bPrivateTorrent.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                boolean privateTorrent = bPrivateTorrent.getSelection();
                ((NewTorrentWizard)SavePathPanel.this.wizard).setPrivateTorrent(privateTorrent);
                if (privateTorrent) {
                    bAllowDHT.setSelection(false);
                    ((NewTorrentWizard)((SavePathPanel)SavePathPanel.this).wizard).permitDHT = false;
                }
                bAllowDHT.setEnabled(!privateTorrent);
            }
        });
        if (((NewTorrentWizard)this.wizard).getTrackerType() == 3) {
            bAllowDHT.setEnabled(false);
            bPrivateTorrent.setEnabled(false);
        } else {
            bPrivateTorrent.setSelection(privateTorrent);
        }
    }

    @Override
    public IWizardPanel<NewTorrentWizard> getFinishPanel() {
        return new ProgressPanel((NewTorrentWizard)this.wizard, this);
    }

    @Override
    public boolean isFinishSelectionOK() {
        String save_path = ((NewTorrentWizard)this.wizard).savePath;
        File f = new File(save_path);
        if (f.isFile()) {
            MessageBox mb = new MessageBox(((NewTorrentWizard)this.wizard).getWizardWindow(), 196);
            mb.setText(MessageText.getString("exportTorrentWizard.process.outputfileexists.title"));
            mb.setMessage(MessageText.getString("exportTorrentWizard.process.outputfileexists.message"));
            int result = mb.open();
            if (result == 128) {
                return false;
            }
        }
        return true;
    }
}

