/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.UISkinnableManagerSWT;
import com.aelitis.azureus.ui.swt.UISkinnableSWTListener;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.shells.ShellSlider;

public class MessageSlideShell {
    private static final boolean DEBUG = false;
    private static final int EDGE_GAP = 0;
    private static final int SHELL_DEF_WIDTH = 280;
    private static final int SHELL_MIN_HEIGHT = 150;
    private static final int SHELL_MAX_HEIGHT = 330;
    private static final int DETAILS_WIDTH = 550;
    private static final int DETAILS_HEIGHT = 180;
    private static final AEMonitor monitor = new AEMonitor("slidey_mon");
    private static ArrayList<PopupParams> historyList = new ArrayList();
    private static int currentPopupIndex = -1;
    private static int firstUnreadMessage = -1;
    private Shell shell;
    private Composite cShell;
    private Label lblCloseIn;
    private Button btnHideAll;
    private Button btnNext;
    private boolean bDelayPaused = false;
    private ArrayList<Object> disposeList = new ArrayList();
    private String sDetails;
    private int idxHistory;
    protected Color colorURL;
    private Color colorFG;
    private int shellWidth;

    public MessageSlideShell(Display display, int iconID, String keyPrefix, String details, String[] textParams, int timeoutSecs) {
        this(display, iconID, MessageText.getString(keyPrefix + ".title"), MessageText.getString(keyPrefix + ".text", textParams), details, timeoutSecs);
    }

    public MessageSlideShell(Display display, int iconID, String keyPrefix, String details, String[] textParams, Object[] relatedObjects, int timeoutSecs) {
        this(display, iconID, MessageText.getString(keyPrefix + ".title"), MessageText.getString(keyPrefix + ".text", textParams), details, relatedObjects, timeoutSecs);
    }

    public MessageSlideShell(Display display, int iconID, String title, String text, String details, int timeoutSecs) {
        this(display, iconID, title, text, details, null, timeoutSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageSlideShell(Display display, int iconID, String title, String text, String details, Object[] relatedObjects, int timeoutSecs) {
        try {
            block4: {
                try {
                    monitor.enter();
                    PopupParams popupParams = new PopupParams(iconID, title, text, details, relatedObjects, timeoutSecs);
                    MessageSlideShell.addToHistory(popupParams);
                    if (currentPopupIndex >= 0) break block4;
                    this.create(display, popupParams, true);
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LogIDs.GUI, "Mr. Slidey Init", e));
                    this.disposeShell(this.shell);
                    Utils.disposeSWTObjects(this.disposeList);
                    Object var10_11 = null;
                    monitor.exit();
                }
            }
            Object var10_10 = null;
            monitor.exit();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToHistory(PopupParams popupParams) {
        monitor.enter();
        try {
            historyList.add(popupParams);
            Object var2_1 = null;
            monitor.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            monitor.exit();
            throw throwable;
        }
    }

    private MessageSlideShell(Display display, PopupParams popupParams, boolean bSlide) {
        this.create(display, popupParams, bSlide);
    }

    public static void displayLastMessage(final Display display, final boolean last_unread) {
        display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (historyList.isEmpty()) {
                    return;
                }
                if (currentPopupIndex >= 0) {
                    return;
                }
                int msg_index = firstUnreadMessage;
                if (!last_unread || msg_index == -1) {
                    msg_index = historyList.size() - 1;
                }
                new MessageSlideShell(display, (PopupParams)historyList.get(msg_index), true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordMessage(int iconID, String title, String text, String details, Object[] relatedTo, int timeoutSecs) {
        try {
            monitor.enter();
            MessageSlideShell.addToHistory(new PopupParams(iconID, title, text, details, relatedTo, timeoutSecs));
            if (firstUnreadMessage == -1) {
                firstUnreadMessage = historyList.size() - 1;
            }
            Object var7_6 = null;
            monitor.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(final Display display, final PopupParams popupParams, boolean bSlide) {
        Rectangle endBounds;
        GridData gridData;
        Shell mainShell;
        UIFunctionsSWT uiFunctions;
        MouseTrackAdapter mouseAdapter;
        firstUnreadMessage = -1;
        int style = 16384;
        boolean bDisableSliding = COConfigurationManager.getBooleanParameter("GUI_SWT_DisableAlertSliding");
        if (bDisableSliding) {
            bSlide = false;
            style = 0;
        }
        this.idxHistory = historyList.indexOf(popupParams);
        if (this.idxHistory < 0) {
            System.err.println("Not in popup history list");
            return;
        }
        if (currentPopupIndex == this.idxHistory) {
            System.err.println("Trying to open already opened!! " + this.idxHistory);
            return;
        }
        try {
            monitor.enter();
            currentPopupIndex = this.idxHistory;
            Object var8_6 = null;
            monitor.exit();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            monitor.exit();
            throw throwable;
        }
        this.sDetails = popupParams.details;
        Image imgIcon = popupParams.iconID <= 0 ? null : display.getSystemImage(popupParams.iconID);
        this.bDelayPaused = popupParams.iconID != 2 || !bSlide;
        MouseTrackAdapter mouseTrackAdapter = mouseAdapter = this.bDelayPaused ? null : new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                MessageSlideShell.this.bDelayPaused = true;
            }

            public void mouseExit(MouseEvent e) {
                MessageSlideShell.this.bDelayPaused = false;
            }
        };
        if (bDisableSliding && (uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null && (mainShell = uiFunctions.getMainShell()) != null) {
            this.shell = new Shell(mainShell, style);
        }
        if (this.shell == null) {
            this.shell = new Shell(display, style);
        }
        try {
            this.shell.setBackgroundMode(1);
        }
        catch (NoSuchMethodError e) {
        }
        catch (NoSuchFieldError e2) {
            // empty catch block
        }
        Utils.setShellIcon(this.shell);
        if (popupParams.title != null) {
            this.shell.setText(popupParams.title);
        }
        this.shellWidth = 280;
        UISkinnableSWTListener[] listeners = UISkinnableManagerSWT.getInstance().getSkinnableListeners(MessageSlideShell.class.toString());
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].skinBeforeComponents((Composite)this.shell, this, popupParams.relatedTo);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        if (this.colorFG == null) {
            this.colorFG = display.getSystemColor(2);
        }
        FormLayout shellLayout = new FormLayout();
        this.shell.setLayout((Layout)shellLayout);
        this.cShell = new Composite((Composite)this.shell, 0);
        GridLayout layout = new GridLayout(3, false);
        this.cShell.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.cShell.setLayoutData((Object)formData);
        Label lblIcon = new Label(this.cShell, 0);
        lblIcon.setImage(imgIcon);
        lblIcon.setLayoutData((Object)new GridData());
        if (popupParams.title != null) {
            Label lblTitle = new Label(this.cShell, SWT.getVersion() < 3100 ? 0 : 64);
            gridData = new GridData(768);
            if (SWT.getVersion() < 3100) {
                gridData.widthHint = 140;
            }
            lblTitle.setLayoutData((Object)gridData);
            lblTitle.setForeground(this.colorFG);
            lblTitle.setText(popupParams.title);
            FontData[] fontData = lblTitle.getFont().getFontData();
            fontData[0].setStyle(1);
            fontData[0].setHeight((int)((double)fontData[0].getHeight() * 1.5));
            Font boldFont = new Font((Device)display, fontData);
            this.disposeList.add(boldFont);
            lblTitle.setFont(boldFont);
        }
        final Button btnDetails = new Button(this.cShell, 2);
        btnDetails.setForeground(this.colorFG);
        Messages.setLanguageText((Widget)btnDetails, "popup.error.details");
        gridData = new GridData();
        btnDetails.setLayoutData((Object)gridData);
        btnDetails.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                try {
                    boolean bShow = btnDetails.getSelection();
                    if (bShow) {
                        Shell detailsShell = new Shell(display, 18432);
                        Utils.setShellIcon(detailsShell);
                        detailsShell.setLayout((Layout)new FillLayout());
                        StyledText textDetails = new StyledText((Composite)detailsShell, 2824);
                        textDetails.setBackground(display.getSystemColor(25));
                        textDetails.setForeground(display.getSystemColor(24));
                        textDetails.setWordWrap(true);
                        textDetails.setText(MessageSlideShell.this.sDetails);
                        detailsShell.layout();
                        Rectangle shellBounds = MessageSlideShell.this.shell.getBounds();
                        detailsShell.setBounds(shellBounds.x + shellBounds.width - 550, shellBounds.y - 180, 550, 180);
                        detailsShell.open();
                        MessageSlideShell.this.shell.setData("detailsShell", (Object)detailsShell);
                        MessageSlideShell.this.shell.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                Shell detailsShell = (Shell)MessageSlideShell.this.shell.getData("detailsShell");
                                if (detailsShell != null && !detailsShell.isDisposed()) {
                                    detailsShell.dispose();
                                }
                            }
                        });
                        MessageSlideShell.this.bDelayPaused = true;
                        MessageSlideShell.this.removeMouseTrackListener((Composite)MessageSlideShell.this.shell, (MouseTrackListener)mouseAdapter);
                    } else {
                        Shell detailsShell = (Shell)MessageSlideShell.this.shell.getData("detailsShell");
                        if (detailsShell != null && !detailsShell.isDisposed()) {
                            detailsShell.dispose();
                        }
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LogIDs.GUI, "Mr. Slidey DetailsButton", e));
                }
            }
        });
        this.createLinkLabel(this.cShell, popupParams);
        this.lblCloseIn = new Label(this.cShell, 131072);
        this.lblCloseIn.setForeground(this.colorFG);
        this.lblCloseIn.setText(" \n ");
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 3;
        this.lblCloseIn.setLayoutData((Object)gridData);
        final Composite cButtons = new Composite(this.cShell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        if (Constants.isOSX) {
            gridLayout.horizontalSpacing = 0;
        }
        gridLayout.numColumns = this.idxHistory > 0 ? 3 : 2;
        cButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(132);
        gridData.horizontalSpan = 3;
        cButtons.setLayoutData((Object)gridData);
        this.btnHideAll = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)this.btnHideAll, "popup.error.hideall");
        this.btnHideAll.setVisible(false);
        this.btnHideAll.setForeground(display.getSystemColor(2));
        this.btnHideAll.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                cButtons.setEnabled(false);
                MessageSlideShell.this.shell.dispose();
            }
        });
        if (this.idxHistory > 0) {
            Button btnPrev = new Button(cButtons, 8);
            btnPrev.setForeground(display.getSystemColor(2));
            btnPrev.setText(MessageText.getString("popup.previous", new String[]{"" + this.idxHistory}));
            btnPrev.addListener(4, new Listener(){

                public void handleEvent(Event arg0) {
                    MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
                    int idx = historyList.indexOf(popupParams) - 1;
                    if (idx >= 0) {
                        PopupParams item = (PopupParams)historyList.get(idx);
                        MessageSlideShell.this.showPopup(display, item, false);
                        MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
                    }
                }
            });
        }
        this.btnNext = new Button(cButtons, 8);
        this.btnNext.setForeground(display.getSystemColor(2));
        int numAfter = historyList.size() - this.idxHistory - 1;
        this.setButtonNextText(numAfter);
        this.btnNext.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                if (MessageSlideShell.this.idxHistory + 1 < historyList.size()) {
                    MessageSlideShell.this.showPopup(display, (PopupParams)historyList.get(MessageSlideShell.this.idxHistory + 1), false);
                }
                MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
            }
        });
        Point bestSize = this.cShell.computeSize(this.shellWidth, -1);
        if (bestSize.y < 150) {
            bestSize.y = 150;
        } else if (bestSize.y > 330) {
            bestSize.y = 330;
            this.sDetails = this.sDetails == null ? popupParams.text : popupParams.text + "\n===============\n" + this.sDetails;
        }
        Rectangle bounds = null;
        try {
            UIFunctionsSWT uiFunctions2 = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions2 != null) {
                Shell mainShell2 = uiFunctions2.getMainShell();
                if (mainShell2 != null) {
                    bounds = mainShell2.getMonitor().getClientArea();
                }
            } else {
                Shell shell = display.getActiveShell();
                if (shell != null) {
                    bounds = shell.getMonitor().getClientArea();
                }
            }
            if (bounds == null) {
                bounds = this.shell.getMonitor().getClientArea();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bounds == null) {
            bounds = display.getClientArea();
        }
        if (bDisableSliding) {
            endBounds = new Rectangle((bounds.x + bounds.width) / 2 - bestSize.x / 2, (bounds.y + bounds.height) / 2 - bestSize.y / 2, bestSize.x, bestSize.y);
        } else {
            int boundsX2 = bounds.x + bounds.width;
            int boundsY2 = bounds.y + bounds.height;
            endBounds = this.shell.computeTrim(boundsX2 - bestSize.x, boundsY2 - bestSize.y, bestSize.x, bestSize.y);
            int diff = endBounds.x + endBounds.width - boundsX2;
            if (diff >= 0) {
                endBounds.x -= diff + 0;
            }
            if ((diff = endBounds.y + endBounds.height - boundsY2) >= 0) {
                endBounds.y -= diff + 0;
            }
        }
        FormData data = new FormData(bestSize.x, bestSize.y);
        this.cShell.setLayoutData((Object)data);
        btnDetails.setVisible(this.sDetails != null);
        if (this.sDetails == null) {
            gridData = new GridData();
            gridData.widthHint = 0;
            btnDetails.setLayoutData((Object)gridData);
        }
        this.shell.layout();
        this.btnNext.setFocus();
        this.shell.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent e) {
                Utils.disposeSWTObjects(MessageSlideShell.this.disposeList);
                if (currentPopupIndex == MessageSlideShell.this.idxHistory) {
                    try {
                        monitor.enter();
                        currentPopupIndex = -1;
                        Object var3_2 = null;
                        monitor.exit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        monitor.exit();
                        throw throwable;
                    }
                }
            }
        });
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event event2) {
                if (event2.detail == 2) {
                    MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
                    event2.doit = false;
                }
            }
        });
        if (mouseAdapter != null) {
            this.addMouseTrackListener((Composite)this.shell, (MouseTrackListener)mouseAdapter);
        }
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].skinAfterComponents((Composite)this.shell, this, popupParams.relatedTo);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        int timeoutSecs = popupParams.timeoutSecs < 0 ? COConfigurationManager.getIntParameter("Message Popup Autoclose in Seconds") : popupParams.timeoutSecs;
        this.runPopup(endBounds, this.idxHistory, bSlide, timeoutSecs);
    }

    private void createLinkLabel(Composite shell, final PopupParams popupParams) {
        final Canvas canvas = new Canvas(shell, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Rectangle area = new Rectangle(0, 0, MessageSlideShell.this.shellWidth, 5000);
                GC gc = new GC((Drawable)this);
                GCStringPrinter sp = new GCStringPrinter(gc, popupParams.text, area, true, false, 192);
                sp.calculateMetrics();
                gc.dispose();
                Point size = sp.getCalculatedSize();
                return size;
            }
        };
        Listener l = new Listener(){
            GCStringPrinter sp;

            public void handleEvent(Event e) {
                GCStringPrinter.URLInfo hitUrl;
                if (e.type == 9) {
                    Rectangle area = canvas.getClientArea();
                    this.sp = new GCStringPrinter(e.gc, popupParams.text, area, true, false, 192);
                    this.sp.setUrlColor(ColorCache.getColor(e.gc.getDevice(), "#0000ff"));
                    if (MessageSlideShell.this.colorURL != null) {
                        this.sp.setUrlColor(MessageSlideShell.this.colorURL);
                    }
                    if (MessageSlideShell.this.colorFG != null) {
                        e.gc.setForeground(MessageSlideShell.this.colorFG);
                    }
                    this.sp.printString();
                } else if (e.type == 5) {
                    if (this.sp != null) {
                        GCStringPrinter.URLInfo hitUrl2 = this.sp.getHitUrl(e.x, e.y);
                        if (hitUrl2 != null) {
                            canvas.setCursor(canvas.getDisplay().getSystemCursor(21));
                            canvas.setToolTipText(hitUrl2.url);
                        } else {
                            canvas.setCursor(canvas.getDisplay().getSystemCursor(0));
                            canvas.setToolTipText(null);
                        }
                    }
                } else if (e.type == 4 && this.sp != null && (hitUrl = this.sp.getHitUrl(e.x, e.y)) != null && !hitUrl.url.startsWith(":")) {
                    Utils.launch(hitUrl.url);
                }
            }
        };
        canvas.addListener(9, l);
        canvas.addListener(5, l);
        canvas.addListener(4, l);
        ClipboardCopy.addCopyToClipMenu((Control)canvas, new ClipboardCopy.copyToClipProvider(){

            public String getText() {
                return popupParams.title + "\n\n" + popupParams.text;
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        canvas.setLayoutData((Object)gridData);
    }

    private void setButtonNextText(int numAfter) {
        if (numAfter <= 0) {
            Messages.setLanguageText((Widget)this.btnNext, "popup.error.hide");
        } else {
            Messages.setLanguageText((Widget)this.btnNext, "popup.next", new String[]{"" + numAfter});
        }
        this.cShell.layout(true);
    }

    private void showPopup(final Display display, final PopupParams item, final boolean bSlide) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                new MessageSlideShell(display, item, bSlide);
            }
        });
    }

    private void addMouseTrackListener(Composite parent, MouseTrackListener listener) {
        if (parent == null || listener == null || parent.isDisposed()) {
            return;
        }
        parent.addMouseTrackListener(listener);
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (control instanceof Composite) {
                this.addMouseTrackListener((Composite)control, listener);
                continue;
            }
            control.addMouseTrackListener(listener);
        }
    }

    private void removeMouseTrackListener(Composite parent, MouseTrackListener listener) {
        if (parent == null || listener == null || parent.isDisposed()) {
            return;
        }
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            control.removeMouseTrackListener(listener);
            if (!(control instanceof Composite)) continue;
            this.removeMouseTrackListener((Composite)control, listener);
        }
    }

    private void runPopup(final Rectangle endBounds, final int idx, final boolean bSlide, final int timeoutSecs) {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        final Display display = this.shell.getDisplay();
        AEThread thread = new AEThread("Slidey", true){
            private static final int PAUSE = 500;

            public void runSupport() {
                if (MessageSlideShell.this.shell == null || MessageSlideShell.this.shell.isDisposed()) {
                    return;
                }
                if (bSlide) {
                    new ShellSlider(MessageSlideShell.this.shell, 128, endBounds).run();
                } else {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            MessageSlideShell.this.shell.setBounds(endBounds);
                            MessageSlideShell.this.shell.open();
                        }
                    });
                }
                int delayLeft = timeoutSecs * 1000;
                final boolean autohide = delayLeft != 0;
                long lastDelaySecs = 0L;
                int lastNumPopups = -1;
                while (!(autohide && !MessageSlideShell.this.bDelayPaused && delayLeft <= 0 || MessageSlideShell.this.shell.isDisposed())) {
                    int delayPausedOfs = MessageSlideShell.this.bDelayPaused ? 1 : 0;
                    final long delaySecs = Math.round((double)delayLeft / 1000.0) + (long)delayPausedOfs;
                    final int numPopups = historyList.size();
                    if (lastDelaySecs != delaySecs || lastNumPopups != numPopups) {
                        lastDelaySecs = delaySecs;
                        lastNumPopups = numPopups;
                        MessageSlideShell.this.shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                            public void runSupport() {
                                int numPopupsAfterUs;
                                boolean bHasMany;
                                String sText = "";
                                if (MessageSlideShell.this.lblCloseIn == null || MessageSlideShell.this.lblCloseIn.isDisposed()) {
                                    return;
                                }
                                MessageSlideShell.this.lblCloseIn.setRedraw(false);
                                if (!MessageSlideShell.this.bDelayPaused && autohide) {
                                    sText = sText + MessageText.getString("popup.closing.in", new String[]{String.valueOf(delaySecs)});
                                }
                                boolean bl = bHasMany = (numPopupsAfterUs = numPopups - idx - 1) > 0;
                                if (bHasMany) {
                                    sText = sText + "\n";
                                    sText = sText + MessageText.getString("popup.more.waiting", new String[]{String.valueOf(numPopupsAfterUs)});
                                }
                                MessageSlideShell.this.lblCloseIn.setText(sText);
                                if (MessageSlideShell.this.btnHideAll.getVisible() != bHasMany) {
                                    MessageSlideShell.this.cShell.setRedraw(false);
                                    MessageSlideShell.this.btnHideAll.setVisible(bHasMany);
                                    MessageSlideShell.this.lblCloseIn.getParent().layout(true);
                                    MessageSlideShell.this.cShell.setRedraw(true);
                                }
                                MessageSlideShell.this.setButtonNextText(numPopupsAfterUs);
                                MessageSlideShell.this.lblCloseIn.setRedraw(true);
                            }
                        });
                    }
                    if (!MessageSlideShell.this.bDelayPaused) {
                        delayLeft -= 500;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        delayLeft = 0;
                    }
                }
                if (this.isInterrupted()) {
                    MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
                    return;
                }
                if (MessageSlideShell.this.shell != null && !MessageSlideShell.this.shell.isDisposed()) {
                    if (idx + 1 < historyList.size()) {
                        MessageSlideShell.this.showPopup(display, (PopupParams)historyList.get(idx + 1), true);
                    }
                    if (bSlide) {
                        new ShellSlider(MessageSlideShell.this.shell, 131072).run();
                    }
                    MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
                }
            }
        };
        thread.start();
    }

    private void disposeShell(final Shell shell) {
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                shell.dispose();
            }
        });
    }

    public static void waitUntilClosed() {
        if (currentPopupIndex < 0) {
            return;
        }
        Display display = Display.getCurrent();
        while (currentPopupIndex >= 0) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void main(String[] args) {
        final Display display = Display.getDefault();
        Shell shell = new Shell(display, 2144);
        shell.setLayout((Layout)new FillLayout());
        Button btn = new Button((Composite)shell, 8);
        btn.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MessageSlideShell.test(display);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void test(Display display) {
        String title = "This is the title that never ends, never ends!";
        String text = "This is a very long message with lots of information and stuff you really should read.  Are you still reading? Good, because reading <a href=\"http://moo.com\">stimulates</a> the mind and grows hair on your chest.\n\n  Unless you are a girl, then it makes you want to read more.  It's an endless cycle of reading that will never end.  Cursed is the long text that is in this test and may it fillevery last line of the shell until there is no more.";
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        new MessageSlideShell(display, 2, "Simple. . . . . . . . . . . . . . . . . . .", "Simple", (String)null, -1);
        new MessageSlideShell(display, 2, title + "1", text, "Details: " + text, -1);
        new MessageSlideShell(display, 2, "ShortTitle2", "ShortText", "Details", -1);
        MessageSlideShell.waitUntilClosed();
        new MessageSlideShell(display, 2, "ShortTitle3", "ShortText", (String)null, -1);
        for (int x = 0; x < 10; ++x) {
            text = text + "\n\n\n\n\n\n\n\nWow";
        }
        new MessageSlideShell(display, 2, title + "4", text, "Details", -1);
        new MessageSlideShell(display, 1, title + "5", text, (String)null, -1);
        MessageSlideShell.waitUntilClosed();
    }

    public Color getUrlColor() {
        return this.colorURL;
    }

    public void setUrlColor(Color urlColor) {
        this.colorURL = urlColor;
    }

    public Color getColorFG() {
        return this.colorFG;
    }

    public void setColorFG(Color colorFG) {
        this.colorFG = colorFG;
    }

    public static class PopupParams {
        public int iconID;
        public String title;
        public String text;
        public String details;
        public long addedOn;
        public Object[] relatedTo;
        public int timeoutSecs;

        public PopupParams(int iconID, String title, String text, String details, int timeoutSecs) {
            this.iconID = iconID;
            this.title = title;
            this.text = text;
            this.details = details;
            this.timeoutSecs = timeoutSecs;
            this.addedOn = System.currentTimeMillis();
        }

        public PopupParams(int iconID, String title, String text, String details, Object[] relatedTo, int timeoutSecs) {
            this(iconID, title, text, details, timeoutSecs);
            this.relatedTo = relatedTo;
        }
    }
}

