/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionBackupRestore;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionConnection;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionConnectionAdvanced;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionConnectionDNS;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionConnectionEncryption;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionConnectionProxy;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFile;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFileMove;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFilePerformance;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFileTorrents;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFileTorrentsDecoding;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionIPFilter;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterface;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceAlerts;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceColor;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceDisplay;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceLanguage;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceLegacy;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfacePassword;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceStart;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceTables;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionLogging;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionMode;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionPlugins;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionSecurity;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionSharing;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionStartShutdown;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionStats;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTracker;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTrackerClient;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTrackerServer;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTransfer;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTransferAutoSpeed;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTransferAutoSpeedBeta;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTransferAutoSpeedSelect;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTransferLAN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigView
implements UISWTViewEventListener {
    public static final String VIEW_ID = "ConfigView";
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final String sSectionPrefix = "ConfigView.section.";
    Map<TreeItem, ConfigSection> sections = new HashMap<TreeItem, ConfigSection>();
    List<ConfigSection> sectionsCreated = new ArrayList<ConfigSection>(1);
    Composite cConfig;
    Composite cConfigSection;
    StackLayout layoutConfigSection;
    Label lHeader;
    Label usermodeHint;
    Font headerFont;
    Font filterFoundFont;
    Tree tree;
    ArrayList<ConfigSection> pluginSections;
    private Timer filterDelayTimer;
    private String filterText = "";
    private Label lblX;
    private Listener scResizeListener;
    private Image imgSmallX;
    private Image imgSmallXGray;
    private String startSection;
    private UISWTView swtView;
    private static Comparator<Object> insert_point_comparator = new Comparator<Object>(){

        private String asString(Object o) {
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof TreeItem) {
                return ((TreeItem)o).getText();
            }
            throw new ClassCastException("object is not String or TreeItem: " + o.getClass().getName());
        }

        @Override
        public int compare(Object o1, Object o2) {
            int result = String.CASE_INSENSITIVE_ORDER.compare(this.asString(o1), this.asString(o2));
            return result;
        }
    };

    private void initialize(final Composite composite) {
        this.cConfig = new Composite(composite, 0);
        GridLayout configLayout = new GridLayout();
        configLayout.marginHeight = 0;
        configLayout.marginWidth = 0;
        this.cConfig.setLayout((Layout)configLayout);
        GridData gridData = new GridData(1808);
        this.cConfig.setLayoutData((Object)gridData);
        final Label label = new Label(this.cConfig, 0x1000000);
        Messages.setLanguageText((Widget)label, "view.waiting.core");
        gridData = new GridData(1808);
        label.setLayoutData((Object)gridData);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        ConfigView.this._initialize(composite);
                        label.dispose();
                        composite.layout(true, true);
                    }
                });
            }
        });
    }

    private void _initialize(Composite composite) {
        try {
            Display d = composite.getDisplay();
            SashForm form = new SashForm(this.cConfig, 256);
            GridData gridData = new GridData(1808);
            form.setLayoutData((Object)gridData);
            Composite cLeftSide = new Composite((Composite)form, 2048);
            gridData = new GridData(1808);
            cLeftSide.setLayoutData((Object)gridData);
            FormLayout layout = new FormLayout();
            cLeftSide.setLayout((Layout)layout);
            Composite cFilterArea = new Composite(cLeftSide, 0);
            cFilterArea.setLayout((Layout)new FormLayout());
            final Text txtFilter = new Text(cFilterArea, 2048);
            final String sFilterText = MessageText.getString("ConfigView.filter");
            txtFilter.setText(sFilterText);
            txtFilter.selectAll();
            txtFilter.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ConfigView.this.filterTree(txtFilter.getText());
                }
            });
            txtFilter.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (txtFilter.getText().equals(sFilterText)) {
                        txtFilter.selectAll();
                    }
                }
            });
            txtFilter.setFocus();
            ImageLoader imageLoader = ImageLoader.getInstance();
            this.imgSmallXGray = imageLoader.getImage("smallx-gray");
            this.imgSmallX = imageLoader.getImage("smallx");
            this.lblX = new Label(cFilterArea, 64);
            Messages.setLanguageTooltip((Widget)this.lblX, "MyTorrentsView.clearFilter.tooltip");
            this.lblX.setImage(this.imgSmallXGray);
            this.lblX.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    txtFilter.setText("");
                }
            });
            this.lblX.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    imageLoader.releaseImage("smallx-gray");
                    imageLoader.releaseImage("smallx");
                }
            });
            Label lblSearch = new Label(cFilterArea, 0);
            imageLoader.setLabelImage(lblSearch, "search");
            this.tree = new Tree(cLeftSide, 0);
            FontData[] fontData = this.tree.getFont().getFontData();
            fontData[0].setStyle(1);
            this.filterFoundFont = new Font((Device)d, fontData);
            FormData formData = new FormData();
            formData.bottom = new FormAttachment(100, -5);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            cFilterArea.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment(0, 5);
            formData.left = new FormAttachment(0, 5);
            lblSearch.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment(0, 5);
            formData.left = new FormAttachment((Control)lblSearch, 5);
            formData.right = new FormAttachment((Control)this.lblX, -3);
            txtFilter.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment(0, 5);
            formData.right = new FormAttachment(100, -5);
            this.lblX.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment((Control)cFilterArea, -1);
            this.tree.setLayoutData((Object)formData);
            Composite cRightSide = new Composite((Composite)form, 0);
            GridLayout configLayout = new GridLayout();
            configLayout.marginHeight = 3;
            configLayout.marginWidth = 0;
            cRightSide.setLayout((Layout)configLayout);
            Composite cHeader = new Composite(cRightSide, 2048);
            configLayout = new GridLayout();
            configLayout.marginHeight = 3;
            configLayout.marginWidth = 0;
            configLayout.numColumns = 2;
            configLayout.marginRight = 5;
            cHeader.setLayout((Layout)configLayout);
            gridData = new GridData(772);
            cHeader.setLayoutData((Object)gridData);
            cHeader.setBackground(d.getSystemColor(26));
            cHeader.setForeground(d.getSystemColor(27));
            this.lHeader = new Label(cHeader, 0);
            this.lHeader.setBackground(d.getSystemColor(26));
            this.lHeader.setForeground(d.getSystemColor(27));
            fontData = this.lHeader.getFont().getFontData();
            fontData[0].setStyle(1);
            int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
            fontData[0].setHeight(fontHeight);
            this.headerFont = new Font((Device)d, fontData);
            this.lHeader.setFont(this.headerFont);
            gridData = new GridData(36);
            this.lHeader.setLayoutData((Object)gridData);
            this.usermodeHint = new Label(cHeader, 0);
            this.usermodeHint.setBackground(d.getSystemColor(26));
            this.usermodeHint.setForeground(d.getSystemColor(27));
            gridData = new GridData(644);
            this.usermodeHint.setLayoutData((Object)gridData);
            Menu headerMenu = new Menu((Decorations)cHeader.getShell(), 8);
            MenuItem menuShortCut = new MenuItem(headerMenu, 8);
            Messages.setLanguageText((Widget)menuShortCut, "label.set.shortcut");
            menuShortCut.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String id;
                    final TreeItem tree_item = (TreeItem)ConfigView.this.lHeader.getData("TreeItem");
                    if (tree_item != null && (id = (String)tree_item.getData("ID")) != null) {
                        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("config.dialog.shortcut.title", "config.dialog.shortcut.text");
                        entryWindow.setPreenteredText(COConfigurationManager.getStringParameter("config.section.shortcut.key." + id, ""), false);
                        entryWindow.setTextLimit(1);
                        entryWindow.prompt(new UIInputReceiverListener(){

                            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                                if (!entryWindow.hasSubmittedInput()) {
                                    return;
                                }
                                String sReturn = entryWindow.getSubmittedInput();
                                if (sReturn != null) {
                                    if ((sReturn = sReturn.trim()).length() > 1) {
                                        sReturn = sReturn.substring(0, 1);
                                    }
                                    COConfigurationManager.setParameter("config.section.shortcut.key." + id, sReturn);
                                    ConfigView.this.updateHeader(tree_item);
                                }
                            }
                        });
                    }
                }
            });
            cHeader.setMenu(headerMenu);
            this.lHeader.setMenu(headerMenu);
            this.usermodeHint.setMenu(headerMenu);
            this.cConfigSection = new Composite(cRightSide, 0);
            this.layoutConfigSection = new StackLayout();
            this.cConfigSection.setLayout((Layout)this.layoutConfigSection);
            gridData = new GridData(1808);
            gridData.horizontalIndent = 2;
            this.cConfigSection.setLayoutData((Object)gridData);
            form.setWeights(new int[]{20, 80});
            this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Tree tree = (Tree)e.getSource();
                    if (tree.getSelection().length > 0) {
                        ConfigView.this.showSection(tree.getSelection()[0], false);
                    }
                }
            });
            this.tree.addListener(14, new Listener(){

                public void handleEvent(Event e) {
                    TreeItem item = (TreeItem)e.item;
                    if (item != null) {
                        item.setExpanded(!item.getExpanded());
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error initializing ConfigView", e));
        }
        this.scResizeListener = new Listener(){

            public void handleEvent(Event event2) {
                ConfigView.this.setupSC((ScrolledComposite)event2.widget);
            }
        };
        this.pluginSections = ConfigSectionRepository.getInstance().getList();
        ConfigSection[] internalSections = new ConfigSection[]{new ConfigSectionMode(), new ConfigSectionStartShutdown(), new ConfigSectionBackupRestore(), new ConfigSectionConnection(), new ConfigSectionConnectionProxy(), new ConfigSectionConnectionAdvanced(), new ConfigSectionConnectionEncryption(), new ConfigSectionConnectionDNS(), new ConfigSectionTransfer(), new ConfigSectionTransferAutoSpeedSelect(), new ConfigSectionTransferAutoSpeed(), new ConfigSectionTransferAutoSpeedBeta(), new ConfigSectionTransferLAN(), new ConfigSectionFile(), new ConfigSectionFileMove(), new ConfigSectionFileTorrents(), new ConfigSectionFileTorrentsDecoding(), new ConfigSectionFilePerformance(), new ConfigSectionInterface(), new ConfigSectionInterfaceLanguage(), new ConfigSectionInterfaceStart(), new ConfigSectionInterfaceDisplay(), new ConfigSectionInterfaceTables(), new ConfigSectionInterfaceColor(), new ConfigSectionInterfaceAlerts(), new ConfigSectionInterfacePassword(), new ConfigSectionInterfaceLegacy(), new ConfigSectionIPFilter(), new ConfigSectionPlugins(this), new ConfigSectionStats(), new ConfigSectionTracker(), new ConfigSectionTrackerClient(), new ConfigSectionTrackerServer(), new ConfigSectionSecurity(), new ConfigSectionSharing(), new ConfigSectionLogging()};
        this.pluginSections.addAll(0, Arrays.asList(internalSections));
        for (int i = 0; i < this.pluginSections.size(); ++i) {
            String name;
            boolean plugin_section = i >= internalSections.length;
            ConfigSection section = this.pluginSections.get(i);
            if (!(section instanceof UISWTConfigSection)) continue;
            try {
                name = section.configSectionGetName();
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "A ConfigSection plugin caused an error while trying to call its configSectionGetName function", e));
                name = "Bad Plugin";
            }
            String section_key = name;
            if (plugin_section) {
                if (!MessageText.keyExists(section_key)) {
                    section_key = sSectionPrefix + name;
                }
            } else {
                section_key = sSectionPrefix + name;
            }
            String section_name = MessageText.getString(section_key);
            try {
                int position;
                TreeItem treeItemFound;
                String location = section.configSectionGetParentSection();
                TreeItem treeItem = location.length() == 0 || location.equalsIgnoreCase("root") ? new TreeItem(this.tree, 0) : ((treeItemFound = this.findTreeItem(this.tree, location)) != null ? (location.equalsIgnoreCase("plugins") ? ((position = ConfigView.findInsertPointFor(section_name, treeItemFound)) == -1 ? new TreeItem(treeItemFound, 0) : new TreeItem(treeItemFound, 0, position)) : new TreeItem(treeItemFound, 0)) : new TreeItem(this.tree, 0));
                ScrolledComposite sc = new ScrolledComposite(this.cConfigSection, 768);
                sc.setExpandHorizontal(true);
                sc.setExpandVertical(true);
                sc.setLayoutData((Object)new GridData(1808));
                sc.getVerticalBar().setIncrement(16);
                sc.addListener(11, this.scResizeListener);
                if (i == 0) {
                    Composite c = ((UISWTConfigSection)section).configSectionCreate((Composite)sc);
                    this.sectionsCreated.add(section);
                    sc.setContent((Control)c);
                }
                Messages.setLanguageText((Widget)treeItem, section_key);
                treeItem.setData("Panel", (Object)sc);
                treeItem.setData("ID", (Object)name);
                treeItem.setData("ConfigSectionSWT", (Object)section);
                this.sections.put(treeItem, section);
                if (!(section instanceof ConfigSectionPlugins)) continue;
                ((ConfigSectionPlugins)section).initPluginSubSections();
                continue;
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "ConfigSection plugin '" + name + "' caused an error", e));
            }
        }
        final Display d = composite.getDisplay();
        final Listener shortcut_listener = new Listener(){

            public void handleEvent(Event e) {
                if ((e.stateMask & (SWT.MOD1 | 0x40000)) != 0 || e.keyCode == 0x400000) {
                    char key = e.character;
                    if (key <= '\u001a' && key > '\u0000') {
                        key = (char)(key + 96);
                    }
                    if ((e.stateMask & 0x20000) != 0) {
                        key = Character.toUpperCase(key);
                    }
                    if (!Character.isISOControl(key)) {
                        for (TreeItem ti : ConfigView.this.sections.keySet()) {
                            String shortcut;
                            String id = (String)ti.getData("ID");
                            if (id == null || !(shortcut = COConfigurationManager.getStringParameter("config.section.shortcut.key." + id, "")).equals(String.valueOf(key))) continue;
                            ConfigView.this.selectSection(id, true);
                            e.doit = false;
                            break;
                        }
                    }
                }
            }
        };
        d.addFilter(1, shortcut_listener);
        this.cConfigSection.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                d.removeFilter(1, shortcut_listener);
            }
        });
        if (composite instanceof Shell) {
            this.initApplyCloseButton();
        } else {
            this.initSaveButton();
        }
        if (this.startSection != null && this.selectSection(this.startSection, false)) {
            return;
        }
        TreeItem[] items = new TreeItem[]{this.tree.getItems()[0]};
        this.tree.setSelection(items);
        this.showSection(items[0], false);
    }

    private void setupSC(ScrolledComposite sc) {
        Composite c = (Composite)sc.getContent();
        if (c != null) {
            Point size1 = c.computeSize(sc.getClientArea().width, -1);
            Point size = c.computeSize(-1, size1.y);
            sc.setMinSize(size);
        }
        sc.getVerticalBar().setPageIncrement(sc.getSize().y);
    }

    protected void filterTree(String text) {
        this.filterText = text;
        if (this.filterDelayTimer != null) {
            this.filterDelayTimer.destroy();
        }
        if (this.lblX != null && !this.lblX.isDisposed()) {
            Image img = this.filterText.length() > 0 ? this.imgSmallX : this.imgSmallXGray;
            this.lblX.setImage(img);
        }
        this.filterDelayTimer = new Timer("Filter");
        this.filterDelayTimer.addEvent(SystemTime.getCurrentTime() + 300L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                ConfigView.this.filterDelayTimer.destroy();
                ConfigView.this.filterDelayTimer = null;
                Utils.execSWTThread(new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        TreeItem[] selection2;
                        block11: {
                            if (ConfigView.this.filterDelayTimer != null) {
                                return;
                            }
                            if (ConfigView.this.tree.isDisposed()) {
                                return;
                            }
                            Shell shell = ConfigView.this.tree.getShell();
                            if (shell != null) {
                                shell.setCursor(shell.getDisplay().getSystemCursor(1));
                            }
                            try {
                                ArrayList<TreeItem> foundItems = new ArrayList<TreeItem>();
                                TreeItem[] items = ConfigView.this.tree.getItems();
                                try {
                                    ConfigView.this.tree.setRedraw(false);
                                    for (int i = 0; i < items.length; ++i) {
                                        items[i].setExpanded(false);
                                    }
                                    ConfigView.this.filterTree(items, ConfigView.this.filterText, foundItems);
                                    Object var6_5 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var6_6 = null;
                                    ConfigView.this.tree.setRedraw(true);
                                    throw throwable;
                                }
                                ConfigView.this.tree.setRedraw(true);
                                Object var8_8 = null;
                                if (shell == null) break block11;
                            }
                            catch (Throwable throwable) {
                                TreeItem[] selection2;
                                Object var8_9 = null;
                                if (shell != null) {
                                    shell.setCursor(null);
                                }
                                if ((selection2 = ConfigView.this.tree.getSelection()) != null && selection2.length > 0) {
                                    ConfigView.this.showSection(selection2[0], false);
                                }
                                throw throwable;
                            }
                            shell.setCursor(null);
                        }
                        if ((selection2 = ConfigView.this.tree.getSelection()) != null && selection2.length > 0) {
                            ConfigView.this.showSection(selection2[0], false);
                        }
                    }
                });
            }
        });
    }

    protected void filterTree(TreeItem[] items, String text, ArrayList<TreeItem> foundItems) {
        text = text.toLowerCase();
        for (int i = 0; i < items.length; ++i) {
            this.ensureSectionBuilt(items[i], false);
            ScrolledComposite composite = (ScrolledComposite)items[i].getData("Panel");
            if (text.length() > 0 && (items[i].getText().toLowerCase().indexOf(text) >= 0 || this.compositeHasText((Composite)composite, text))) {
                foundItems.add(items[i]);
                this.ensureExpandedTo(items[i]);
                items[i].setFont(this.filterFoundFont);
            } else {
                items[i].setFont(null);
            }
            this.filterTree(items[i].getItems(), text, foundItems);
        }
    }

    private void ensureExpandedTo(TreeItem item) {
        TreeItem itemParent = item.getParentItem();
        if (itemParent != null) {
            itemParent.setExpanded(true);
            this.ensureExpandedTo(itemParent);
        }
    }

    private boolean compositeHasText(Composite composite, String text) {
        Control[] children = composite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            String[] items;
            Control child = children[i];
            if (child instanceof Label) {
                if (((Label)child).getText().toLowerCase().indexOf(text) >= 0) {
                    return true;
                }
            } else if (child instanceof Group) {
                if (((Group)child).getText().toLowerCase().indexOf(text) >= 0) {
                    return true;
                }
            } else if (child instanceof Button) {
                if (((Button)child).getText().toLowerCase().indexOf(text) >= 0) {
                    return true;
                }
            } else if (child instanceof org.eclipse.swt.widgets.List) {
                for (String item : items = ((org.eclipse.swt.widgets.List)child).getItems()) {
                    if (item.toLowerCase().indexOf(text) < 0) continue;
                    return true;
                }
            } else if (child instanceof Combo) {
                for (String item : items = ((Combo)child).getItems()) {
                    if (item.toLowerCase().indexOf(text) < 0) continue;
                    return true;
                }
            }
            if (!(child instanceof Composite) || !this.compositeHasText((Composite)child, text)) continue;
            return true;
        }
        return false;
    }

    private void showSection(TreeItem section, boolean focus) {
        ScrolledComposite item = (ScrolledComposite)section.getData("Panel");
        if (item != null) {
            this.ensureSectionBuilt(section, true);
            this.layoutConfigSection.topControl = item;
            this.setupSC(item);
            if (this.filterText != null && this.filterText.length() > 0) {
                this.hilightText((Composite)item, this.filterText);
                item.layout(true, true);
            }
            this.cConfigSection.layout();
            this.updateHeader(section);
            if (focus) {
                this.layoutConfigSection.topControl.traverse(16);
            }
        }
    }

    private void hilightText(Composite c, String text) {
        Control[] children;
        block0: for (Control child : children = c.getChildren()) {
            String[] items;
            if (child instanceof Composite) {
                this.hilightText((Composite)child, text);
            }
            if (child instanceof Label) {
                if (((Label)child).getText().toLowerCase().indexOf(text) < 0) continue;
                this.hilightControl(child);
                continue;
            }
            if (child instanceof Group) {
                if (((Group)child).getText().toLowerCase().indexOf(text) < 0) continue;
                this.hilightControl(child);
                continue;
            }
            if (child instanceof Button) {
                if (((Button)child).getText().toLowerCase().indexOf(text) < 0) continue;
                this.hilightControl(child);
                continue;
            }
            if (child instanceof org.eclipse.swt.widgets.List) {
                for (String item : items = ((org.eclipse.swt.widgets.List)child).getItems()) {
                    if (item.toLowerCase().indexOf(text) < 0) continue;
                    this.hilightControl(child);
                    continue block0;
                }
                continue;
            }
            if (!(child instanceof Combo)) continue;
            for (String item : items = ((Combo)child).getItems()) {
                if (item.toLowerCase().indexOf(text) < 0) continue;
                this.hilightControl(child);
                continue block0;
            }
        }
    }

    private void hilightControl(Control child) {
        child.setFont(this.headerFont);
        child.setBackground(child.getDisplay().getSystemColor(29));
        child.setForeground(child.getDisplay().getSystemColor(28));
    }

    private void ensureSectionBuilt(TreeItem treeSection, boolean recreateIfAlreadyThere) {
        ConfigSection configSection;
        ScrolledComposite item = (ScrolledComposite)treeSection.getData("Panel");
        if (item != null && (configSection = (ConfigSection)treeSection.getData("ConfigSectionSWT")) != null) {
            Control previous = item.getContent();
            if (previous instanceof Composite) {
                if (!recreateIfAlreadyThere) {
                    return;
                }
                configSection.configSectionDelete();
                this.sectionsCreated.remove(configSection);
                Utils.disposeComposite((Composite)previous, true);
            }
            Composite c = ((UISWTConfigSection)configSection).configSectionCreate((Composite)item);
            this.sectionsCreated.add(configSection);
            item.setContent((Control)c);
        }
    }

    private void updateHeader(TreeItem section) {
        if (section == null) {
            return;
        }
        this.lHeader.setData("TreeItem", (Object)section);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        int maxUsermode = 0;
        try {
            ConfigSection sect = this.sections.get(section);
            if (sect instanceof UISWTConfigSection) {
                maxUsermode = ((UISWTConfigSection)sect).maxUserMode();
            }
        }
        catch (Error e) {
            // empty catch block
        }
        String id = (String)section.getData("ID");
        String shortcut = COConfigurationManager.getStringParameter("config.section.shortcut.key." + id, null);
        String sc_text = shortcut != null && shortcut.length() > 0 ? "      (Ctrl+" + shortcut.charAt(0) + ")" : "";
        if (userMode < maxUsermode) {
            Messages.setLanguageText((Widget)this.usermodeHint, "ConfigView.higher.mode.available");
        } else {
            this.usermodeHint.setText("");
        }
        String sHeader = section.getText();
        for (section = section.getParentItem(); section != null; section = section.getParentItem()) {
            sHeader = section.getText() + " : " + sHeader;
        }
        this.lHeader.setText(" " + sHeader.replaceAll("&", "&&") + sc_text);
        this.lHeader.getParent().layout(true, true);
    }

    public Composite createConfigSection(TreeItem treeItemParent, String sNameID, int position, boolean bPrefix) {
        ScrolledComposite sc = new ScrolledComposite(this.cConfigSection, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setLayoutData((Object)new GridData(1808));
        sc.getVerticalBar().setIncrement(16);
        sc.addListener(11, this.scResizeListener);
        Composite cConfigSection = new Composite((Composite)sc, 0);
        String section_key = (bPrefix ? sSectionPrefix : "") + sNameID;
        if (position == -2) {
            position = ConfigView.findInsertPointFor(MessageText.getString(section_key), treeItemParent == null ? this.tree : treeItemParent);
        }
        TreeItem treeItem = treeItemParent == null ? (position >= 0 ? new TreeItem(this.tree, 0, position) : new TreeItem(this.tree, 0)) : (position >= 0 ? new TreeItem(treeItemParent, 0, position) : new TreeItem(treeItemParent, 0));
        Messages.setLanguageText((Widget)treeItem, section_key);
        treeItem.setData("Panel", (Object)sc);
        treeItem.setData("ID", (Object)sNameID);
        sc.setContent((Control)cConfigSection);
        return cConfigSection;
    }

    private static int findInsertPointFor(String name, Object structure) {
        TreeItem[] children = null;
        children = structure instanceof Tree ? ((Tree)structure).getItems() : ((TreeItem)structure).getItems();
        if (children.length == 0) {
            return -1;
        }
        int result = Arrays.binarySearch(children, name, insert_point_comparator);
        if (result > 0) {
            return result;
        }
        if ((result = -(result + 1)) == children.length) {
            result = -1;
        }
        return result;
    }

    public TreeItem findTreeItem(String ID) {
        return this.findTreeItem((Tree)null, ID);
    }

    private TreeItem findTreeItem(Tree tree, String ID) {
        if (tree == null) {
            tree = this.tree;
        }
        if (tree == null) {
            return null;
        }
        TreeItem[] items = tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            String itemID = (String)items[i].getData("ID");
            if (itemID != null && itemID.equalsIgnoreCase(ID)) {
                return items[i];
            }
            TreeItem itemFound = this.findTreeItem(items[i], ID);
            if (itemFound == null) continue;
            return itemFound;
        }
        return null;
    }

    private TreeItem findTreeItem(TreeItem item, String ID) {
        TreeItem[] subItems = item.getItems();
        for (int i = 0; i < subItems.length; ++i) {
            String itemID = (String)subItems[i].getData("ID");
            if (itemID != null && itemID.equalsIgnoreCase(ID)) {
                return subItems[i];
            }
            TreeItem itemFound = this.findTreeItem(subItems[i], ID);
            if (itemFound == null) continue;
            return itemFound;
        }
        return null;
    }

    private void initSaveButton() {
        final Button save = new Button(this.cConfig, 8);
        Messages.setLanguageText((Widget)save, "ConfigView.button.save");
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 80;
        save.setLayoutData((Object)gridData);
        save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                save.setFocus();
                ConfigView.this.save();
            }
        });
    }

    private void initApplyCloseButton() {
        Composite cButtons = new Composite(this.cConfig, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 2;
        cButtons.setLayout((Layout)gridLayout);
        cButtons.setLayoutData((Object)new GridData(128));
        final Button apply = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)apply, "Button.apply");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        apply.setLayoutData((Object)gridData);
        apply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                apply.setFocus();
                ConfigView.this.save();
            }
        });
        Button close = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)close, "Button.close");
        gridData = new GridData(32);
        gridData.widthHint = 80;
        close.setLayoutData((Object)gridData);
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                apply.setFocus();
                ConfigView.this.save();
                apply.getShell().dispose();
            }
        });
    }

    private Composite getComposite() {
        return this.cConfig;
    }

    private void updateLanguage() {
        this.updateHeader(this.tree.getSelection()[0]);
        if (this.swtView != null) {
            this.swtView.setTitle(this.getFullTitle());
        }
    }

    private void delete() {
        for (ConfigSection section : this.sectionsCreated) {
            try {
                section.configSectionDelete();
            }
            catch (Exception e) {
                Debug.out("Error while deleting config section", e);
            }
        }
        this.sectionsCreated.clear();
        if (this.pluginSections != null) {
            this.pluginSections.clear();
        }
        if (this.tree != null && !this.tree.isDisposed()) {
            TreeItem[] items = this.tree.getItems();
            for (int i = 0; i < items.length; ++i) {
                Composite c = (Composite)items[i].getData("Panel");
                Utils.disposeComposite(c);
                items[i].setData("Panel", null);
                items[i].setData("ConfigSectionSWT", null);
            }
        }
        Utils.disposeComposite(this.cConfig);
        Utils.disposeSWTObjects(new Object[]{this.headerFont, this.filterFoundFont});
        this.headerFont = null;
        this.filterFoundFont = null;
    }

    private String getFullTitle() {
        return MessageText.getString(MessageText.resolveLocalizationKey("ConfigView.title.full"));
    }

    public boolean selectSection(String id, boolean focus) {
        TreeItem ti = this.findTreeItem(id);
        if (ti == null) {
            return false;
        }
        this.tree.setSelection(new TreeItem[]{ti});
        this.showSection(ti, focus);
        return true;
    }

    public void selectSection(Class<?> config_section_class) {
        TreeItem[] items = this.tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            TreeItem item = items[i];
            ConfigSection section = (ConfigSection)item.getData("ConfigSectionSWT");
            if (section == null || section.getClass() != config_section_class) continue;
            this.tree.setSelection(new TreeItem[]{item});
            this.showSection(item, true);
            break;
        }
    }

    public void save() {
        COConfigurationManager.setParameter("updated", 1);
        COConfigurationManager.save();
        if (null != this.pluginSections) {
            for (int i = 0; i < this.pluginSections.size(); ++i) {
                this.pluginSections.get(i).configSectionSave();
            }
        }
    }

    private void dataSourceChanged(Object newDataSource) {
        if (newDataSource instanceof String) {
            String id;
            this.startSection = id = (String)newDataSource;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    ConfigView.this.selectSection(ConfigView.this.startSection, false);
                }
            });
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.updateLanguage();
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                break;
            }
        }
        return true;
    }
}

