/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreFactory;
import java.util.HashMap;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class PrivacyView
implements UISWTViewCoreEventListener {
    public static final String MSGID_PREFIX = "PrivacyView";
    private UISWTView swtView;
    private Composite cMainComposite;
    private ScrolledComposite sc;
    private Composite parent;
    private Composite lookup_comp;
    private Button button;
    private DownloadManager current_dm;

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.parent = (Composite)event2.getData();
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.cMainComposite);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                this.dataSourceChanged(ds);
                break;
            }
            case 3: {
                this.initialize();
                if (this.current_dm != null) break;
                this.dataSourceChanged(this.swtView.getDataSource());
                break;
            }
            case 4: {
                this.delete();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void delete() {
        Utils.disposeComposite((Composite)this.sc);
        this.dataSourceChanged(null);
    }

    private void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataSourceChanged(Object ds) {
        PrivacyView privacyView = this;
        synchronized (privacyView) {
            DownloadManager old_dm = this.current_dm;
            if (ds != this.current_dm) {
                Object[] objs;
                if (ds == null) {
                    this.current_dm = null;
                } else if (ds instanceof DownloadManager) {
                    this.current_dm = (DownloadManager)ds;
                } else if (ds instanceof Object[] && (objs = (Object[])ds).length == 1 && objs[0] instanceof DownloadManager) {
                    this.current_dm = (DownloadManager)objs[0];
                }
            }
            if (old_dm == this.current_dm) {
                return;
            }
            final DownloadManager dm = this.current_dm;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    PrivacyView.this.swt_updateFields(dm);
                }
            });
        }
    }

    private void initialize() {
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            if (this.parent == null || this.parent.isDisposed()) {
                return;
            }
            this.sc = new ScrolledComposite(this.parent, 512);
            this.sc.setExpandHorizontal(true);
            this.sc.setExpandVertical(true);
            this.sc.getVerticalBar().setIncrement(16);
            Layout parentLayout = this.parent.getLayout();
            if (parentLayout instanceof GridLayout) {
                GridData gd = new GridData(4, 4, true, true);
                this.sc.setLayoutData((Object)gd);
            } else if (parentLayout instanceof FormLayout) {
                this.sc.setLayoutData((Object)Utils.getFilledFormData());
            }
            this.cMainComposite = new Composite((Composite)this.sc, 0);
            this.sc.setContent((Control)this.cMainComposite);
        } else {
            Utils.disposeComposite(this.cMainComposite, false);
        }
        this.cMainComposite.setLayout((Layout)new GridLayout(1, false));
        this.lookup_comp = new Composite(this.cMainComposite, 0);
        GridData gd = new GridData();
        gd.widthHint = 300;
        gd.heightHint = 200;
        this.lookup_comp.setLayoutData((Object)gd);
        this.lookup_comp.setBackground(Colors.white);
        this.button = new Button(this.cMainComposite, 8);
        this.button.setText("Lookup");
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                Utils.disposeComposite(PrivacyView.this.lookup_comp, false);
                PluginInterface i2p_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azneti2phelper", true);
                if (i2p_pi != null) {
                    IPCInterface ipc = i2p_pi.getIPC();
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("server_id", "Scraper");
                    options.put("server_id_transient", true);
                    options.put("ui_composite", PrivacyView.this.lookup_comp);
                    IPCInterface callback = new IPCInterface(){

                        public Object invoke(String methodName, Object[] params) throws IPCException {
                            if (methodName.equals("statusUpdate")) {
                                // empty if block
                            }
                            return null;
                        }

                        public boolean canInvoke(String methodName, Object[] params) {
                            return true;
                        }
                    };
                    byte[] hash = (byte[])PrivacyView.this.button.getData("hash");
                    try {
                        ipc.invoke("lookupTorrent", new Object[]{"", hash, options, callback});
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.button.setEnabled(false);
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = PrivacyView.this.sc.getClientArea();
                Point size = PrivacyView.this.cMainComposite.computeSize(r.width, -1);
                PrivacyView.this.sc.setMinSize(size);
            }
        });
        this.swt_updateFields(this.current_dm);
        Rectangle r = this.sc.getClientArea();
        Point size = this.cMainComposite.computeSize(r.width, -1);
        this.sc.setMinSize(size);
    }

    private String getFullTitle() {
        return MessageText.getString("label.privacy");
    }

    private void swt_updateFields(DownloadManager dm) {
        TOTorrent torrent;
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            return;
        }
        byte[] hash = null;
        if (dm != null && (torrent = dm.getTorrent()) != null) {
            try {
                hash = torrent.getHash();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.button.setData("hash", hash);
        this.button.setEnabled(hash != null);
        Utils.disposeComposite(this.lookup_comp, false);
    }
}

