/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.generic.GenericBooleanParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericFloatParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericIntParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class TorrentOptionsView
implements DownloadManagerStateAttributeListener,
UISWTViewCoreEventListener {
    private static final String TEXT_PREFIX = "TorrentOptionsView.param.";
    private static final String MAX_UPLOAD = "max.upload";
    private static final String MAX_DOWNLOAD = "max.download";
    public static final String MSGID_PREFIX = "TorrentOptionsView";
    private boolean multi_view;
    private DownloadManager[] managers;
    private GenericParameterAdapter ds_param_adapter = new downloadStateParameterAdapter();
    private GenericParameterAdapter adhoc_param_adapter = new adhocParameterAdapter();
    private Map<String, Object> adhoc_parameters = new HashMap<String, Object>();
    private Map<String, Object> ds_parameters = new HashMap<String, Object>();
    private Composite panel;
    private Font headerFont;
    private BufferedLabel agg_size;
    private BufferedLabel agg_remaining;
    private BufferedLabel agg_uploaded;
    private BufferedLabel agg_downloaded;
    private BufferedLabel agg_share_ratio;
    private BufferedLabel agg_upload_speed;
    private BufferedLabel agg_download_speed;
    private Composite parent;
    private UISWTView swtView;

    public TorrentOptionsView() {
    }

    public TorrentOptionsView(DownloadManager[] managers2) {
        this.dataSourceChanged(managers2);
    }

    private void initialize(Composite composite) {
        GridLayout layout;
        this.parent = composite;
        if (this.panel != null && !this.panel.isDisposed()) {
            Utils.disposeComposite(this.panel, false);
        } else {
            this.panel = new Composite(composite, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 1;
            this.panel.setLayout((Layout)layout);
            Layout parentLayout = this.parent.getLayout();
            if (parentLayout instanceof FormLayout) {
                this.panel.setLayoutData((Object)Utils.getFilledFormData());
            } else {
                this.panel.setLayoutData((Object)new GridData(1808));
            }
        }
        if (this.managers == null) {
            return;
        }
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite cHeader = new Composite(this.panel, 2048);
        GridLayout configLayout = new GridLayout();
        configLayout.marginHeight = 3;
        configLayout.marginWidth = 0;
        cHeader.setLayout((Layout)configLayout);
        GridData gridData = new GridData(772);
        cHeader.setLayoutData((Object)gridData);
        Display d = this.panel.getDisplay();
        cHeader.setBackground(d.getSystemColor(26));
        cHeader.setForeground(d.getSystemColor(27));
        Label lHeader = new Label(cHeader, 0);
        lHeader.setBackground(d.getSystemColor(26));
        lHeader.setForeground(d.getSystemColor(27));
        FontData[] fontData = lHeader.getFont().getFontData();
        fontData[0].setStyle(1);
        int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
        fontData[0].setHeight(fontHeight);
        this.headerFont = new Font((Device)d, fontData);
        lHeader.setFont(this.headerFont);
        if (this.managers.length == 1) {
            lHeader.setText(" " + MessageText.getString("authenticator.torrent") + " : " + this.managers[0].getDisplayName().replaceAll("&", "&&"));
        } else {
            String str = "";
            for (int i = 0; i < Math.min(3, this.managers.length); ++i) {
                str = str + (i == 0 ? "" : ", ") + this.managers[i].getDisplayName().replaceAll("&", "&&");
            }
            if (this.managers.length > 3) {
                str = str + "...";
            }
            lHeader.setText(" " + this.managers.length + " " + MessageText.getString("ConfigView.section.torrents") + " : " + str);
        }
        gridData = new GridData(772);
        lHeader.setLayoutData((Object)gridData);
        Group gTorrentOptions = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gTorrentOptions, "ConfigView.section.transfer");
        gridData = new GridData(272);
        gTorrentOptions.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gTorrentOptions.setLayout((Layout)layout);
        String k_unit = DisplayFormatters.getRateUnitBase10(1).trim();
        Label label = new Label((Composite)gTorrentOptions, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(k_unit + " " + MessageText.getString("GeneralView.label.maxuploadspeed.tooltip"));
        GenericIntParameter max_upload = new GenericIntParameter(this.adhoc_param_adapter, (Composite)gTorrentOptions, MAX_UPLOAD);
        this.adhoc_parameters.put(MAX_UPLOAD, max_upload);
        gridData = new GridData();
        max_upload.setLayoutData(gridData);
        if (userMode > 0) {
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.max.uploads.when.busy");
            GenericIntParameter max_upload_when_busy = new GenericIntParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "max.upload.when.busy");
            this.ds_parameters.put("max.upload.when.busy", max_upload_when_busy);
            gridData = new GridData();
            max_upload_when_busy.setLayoutData(gridData);
        }
        label = new Label((Composite)gTorrentOptions, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(k_unit + " " + MessageText.getString("GeneralView.label.maxdownloadspeed.tooltip"));
        GenericIntParameter max_download = new GenericIntParameter(this.adhoc_param_adapter, (Composite)gTorrentOptions, MAX_DOWNLOAD);
        this.adhoc_parameters.put(MAX_DOWNLOAD, max_download);
        gridData = new GridData();
        max_download.setLayoutData(gridData);
        if (userMode > 0) {
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.max.uploads");
            GenericIntParameter max_uploads = new GenericIntParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "max.uploads");
            this.ds_parameters.put("max.uploads", max_uploads);
            max_uploads.setMinimumValue(2);
            gridData = new GridData();
            max_uploads.setLayoutData(gridData);
            Composite cMaxUploadsOptionsArea = new Composite((Composite)gTorrentOptions, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cMaxUploadsOptionsArea.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalIndent = 15;
            gridData.horizontalSpan = 2;
            cMaxUploadsOptionsArea.setLayoutData((Object)gridData);
            label = new Label(cMaxUploadsOptionsArea, 0);
            ImageLoader.getInstance().setLabelImage(label, "subitem");
            gridData = new GridData(2);
            label.setLayoutData((Object)gridData);
            gridData = new GridData();
            GenericBooleanParameter max_uploads_when_seeding_enabled = new GenericBooleanParameter(this.ds_param_adapter, cMaxUploadsOptionsArea, "max.uploads.when.seeding.enabled", false, "TorrentOptionsView.param.alternative.value.enable");
            this.ds_parameters.put("max.uploads.when.seeding.enabled", max_uploads_when_seeding_enabled);
            max_uploads_when_seeding_enabled.setLayoutData(gridData);
            GenericIntParameter max_uploads_when_seeding = new GenericIntParameter(this.ds_param_adapter, cMaxUploadsOptionsArea, "max.uploads.when.seeding");
            this.ds_parameters.put("max.uploads.when.seeding", max_uploads_when_seeding);
            gridData = new GridData();
            max_uploads_when_seeding.setMinimumValue(2);
            max_uploads_when_seeding.setLayoutData(gridData);
            max_uploads_when_seeding_enabled.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(max_uploads_when_seeding.getControl()));
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.max.peers");
            GenericIntParameter max_peers = new GenericIntParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "max.peers");
            this.ds_parameters.put("max.peers", max_peers);
            gridData = new GridData();
            max_peers.setLayoutData(gridData);
            Composite cMaxPeersOptionsArea = new Composite((Composite)gTorrentOptions, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cMaxPeersOptionsArea.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalIndent = 15;
            gridData.horizontalSpan = 2;
            cMaxPeersOptionsArea.setLayoutData((Object)gridData);
            label = new Label(cMaxPeersOptionsArea, 0);
            ImageLoader.getInstance().setLabelImage(label, "subitem");
            gridData = new GridData(2);
            label.setLayoutData((Object)gridData);
            gridData = new GridData();
            GenericBooleanParameter max_peers_when_seeding_enabled = new GenericBooleanParameter(this.ds_param_adapter, cMaxPeersOptionsArea, "max.peers.when.seeding.enabled", false, "TorrentOptionsView.param.alternative.value.enable");
            this.ds_parameters.put("max.peers.when.seeding.enabled", max_peers_when_seeding_enabled);
            max_peers_when_seeding_enabled.setLayoutData(gridData);
            GenericIntParameter max_peers_when_seeding = new GenericIntParameter(this.ds_param_adapter, cMaxPeersOptionsArea, "max.peers.when.seeding");
            this.ds_parameters.put("max.peers.when.seeding", max_peers_when_seeding);
            gridData = new GridData();
            max_peers_when_seeding.setLayoutData(gridData);
            max_peers_when_seeding_enabled.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(max_peers_when_seeding.getControl()));
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.max.seeds");
            GenericIntParameter max_seeds = new GenericIntParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "max.seeds");
            this.ds_parameters.put("max.seeds", max_seeds);
            gridData = new GridData();
            max_seeds.setLayoutData(gridData);
        }
        if (userMode > 0) {
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.upload.priority");
            gridData = new GridData();
            GenericIntParameter upload_priority_enabled = new GenericIntParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "up.pri", 0, 1);
            this.ds_parameters.put("up.pri", upload_priority_enabled);
            upload_priority_enabled.setLayoutData(gridData);
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TableColumn.header.min_sr");
            gridData = new GridData();
            gridData.widthHint = 50;
            GenericFloatParameter min_sr = new GenericFloatParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "sr.min", 0.0f, Float.MAX_VALUE, true, 3);
            this.ds_parameters.put("sr.min", min_sr);
            min_sr.setLayoutData(gridData);
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TableColumn.header.max_sr");
            gridData = new GridData();
            gridData.widthHint = 50;
            GenericFloatParameter max_sr = new GenericFloatParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "sr.max", 0.0f, Float.MAX_VALUE, true, 3);
            this.ds_parameters.put("sr.max", max_sr);
            max_sr.setLayoutData(gridData);
        }
        Label reset_label = new Label((Composite)gTorrentOptions, 0);
        Messages.setLanguageText((Widget)reset_label, "TorrentOptionsView.param.reset.to.default");
        Button reset_button = new Button((Composite)gTorrentOptions, 8);
        Messages.setLanguageText((Widget)reset_button, "TorrentOptionsView.param.reset.button");
        reset_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TorrentOptionsView.this.setDefaults();
            }
        });
        for (int i = 0; i < this.managers.length; ++i) {
            this.managers[i].getDownloadState().addListener(this, "parameters", 1);
        }
        Group gTorrentInfo = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gTorrentInfo, "label.aggregate.info");
        gridData = new GridData(272);
        gTorrentInfo.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gTorrentInfo.setLayout((Layout)layout);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(MessageText.getString("TableColumn.header.size") + ": ");
        this.agg_size = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_size.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(MessageText.getString("TableColumn.header.remaining") + ": ");
        this.agg_remaining = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_remaining.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(MessageText.getString("MyTrackerView.uploaded") + ": ");
        this.agg_uploaded = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_uploaded.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(MessageText.getString("MyTrackerView.downloaded") + ": ");
        this.agg_downloaded = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_downloaded.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(MessageText.getString("SpeedView.uploadSpeed.title") + ": ");
        this.agg_upload_speed = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_upload_speed.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(MessageText.getString("SpeedView.downloadSpeed.title") + ": ");
        this.agg_download_speed = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_download_speed.setLayoutData(gridData);
        label = new Label((Composite)gTorrentInfo, 0);
        label.setText(MessageText.getString("TableColumn.header.shareRatio") + ": ");
        this.agg_share_ratio = new BufferedLabel((Composite)gTorrentInfo, 0x20004000);
        gridData = new GridData(768);
        this.agg_share_ratio.setLayoutData(gridData);
        Label stats_reset_label = new Label((Composite)gTorrentInfo, 0);
        Messages.setLanguageText((Widget)stats_reset_label, "TorrentOptionsView.param.reset.stats");
        Button stats_reset_button = new Button((Composite)gTorrentInfo, 8);
        Messages.setLanguageText((Widget)stats_reset_button, "TorrentOptionsView.param.reset.button");
        stats_reset_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (DownloadManager dm : TorrentOptionsView.this.managers) {
                    dm.getStats().resetTotalBytesSentReceived(0L, 0L);
                }
            }
        });
        this.panel.layout(true, true);
    }

    private void refresh() {
        String share_ratio_str;
        if (this.agg_size == null) {
            return;
        }
        long total_size = 0L;
        long total_remaining = 0L;
        long total_good_downloaded = 0L;
        long total_downloaded = 0L;
        long total_uploaded = 0L;
        long total_data_up_speed = 0L;
        long total_prot_up_speed = 0L;
        long total_data_down_speed = 0L;
        long total_prot_down_speed = 0L;
        for (int i = 0; i < this.managers.length; ++i) {
            DownloadManager dm = this.managers[i];
            DownloadManagerStats stats2 = dm.getStats();
            total_size += stats2.getSizeExcludingDND();
            total_remaining += stats2.getRemainingExcludingDND();
            long good_received = stats2.getTotalGoodDataBytesReceived();
            long received = stats2.getTotalDataBytesReceived();
            long sent = stats2.getTotalDataBytesSent();
            total_good_downloaded += good_received;
            total_downloaded += received;
            total_uploaded += sent;
            total_data_up_speed += stats2.getDataSendRate();
            total_prot_up_speed += stats2.getProtocolSendRate();
            total_data_down_speed += stats2.getDataReceiveRate();
            total_prot_down_speed += stats2.getProtocolReceiveRate();
        }
        this.agg_size.setText(DisplayFormatters.formatByteCountToKiBEtc(total_size));
        this.agg_remaining.setText(DisplayFormatters.formatByteCountToKiBEtc(total_remaining));
        this.agg_uploaded.setText(DisplayFormatters.formatByteCountToKiBEtc(total_uploaded));
        this.agg_downloaded.setText(DisplayFormatters.formatByteCountToKiBEtc(total_downloaded));
        this.agg_upload_speed.setText(DisplayFormatters.formatDataProtByteCountToKiBEtc(total_data_up_speed, total_prot_up_speed));
        this.agg_download_speed.setText(DisplayFormatters.formatDataProtByteCountToKiBEtc(total_data_down_speed, total_prot_down_speed));
        long sr = total_good_downloaded == 0L ? (total_uploaded == 0L ? 1000L : -1L) : 1000L * total_uploaded / total_good_downloaded;
        if (sr == -1L) {
            share_ratio_str = "\u221e";
        } else {
            String partial = "" + sr % 1000L;
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            share_ratio_str = sr / 1000L + "." + partial;
        }
        this.agg_share_ratio.setText(share_ratio_str);
    }

    protected void setDefaults() {
        for (String key : this.ds_parameters.keySet()) {
            for (int i = 0; i < this.managers.length; ++i) {
                this.managers[i].getDownloadState().setParameterDefault(key);
            }
        }
        for (Object param : this.adhoc_parameters.values()) {
            if (param instanceof GenericIntParameter) {
                GenericIntParameter int_param = (GenericIntParameter)param;
                int_param.setValue(0, true);
                continue;
            }
            Debug.out("Unknown parameter type: " + param.getClass());
        }
    }

    public void attributeEventOccurred(DownloadManager dm, String attribute_name, int event_type) {
        final DownloadManagerState state = dm.getDownloadState();
        Utils.execSWTThread(new Runnable(){

            public void run() {
                for (Map.Entry entry : TorrentOptionsView.this.ds_parameters.entrySet()) {
                    String key = (String)entry.getKey();
                    Object param = entry.getValue();
                    if (param instanceof GenericIntParameter) {
                        GenericIntParameter int_param = (GenericIntParameter)param;
                        int value = state.getIntParameter(key);
                        int_param.setValue(value);
                        continue;
                    }
                    if (param instanceof GenericBooleanParameter) {
                        GenericBooleanParameter bool_param = (GenericBooleanParameter)param;
                        boolean value = state.getBooleanParameter(key);
                        bool_param.setSelected(value);
                        continue;
                    }
                    if (param instanceof GenericFloatParameter) {
                        GenericFloatParameter float_param = (GenericFloatParameter)param;
                        float value = (float)state.getIntParameter(key) / 1000.0f;
                        float_param.setValue(value);
                        continue;
                    }
                    Debug.out("Unknown parameter type: " + param.getClass());
                }
            }
        }, true);
    }

    private Composite getComposite() {
        return this.panel;
    }

    private String getFullTitle() {
        return MessageText.getString(this.multi_view ? "TorrentOptionsView.multi.title.full" : "TorrentOptionsView.title.full");
    }

    private void delete() {
        if (this.headerFont != null) {
            this.headerFont.dispose();
        }
        if (this.managers != null) {
            for (int i = 0; i < this.managers.length; ++i) {
                this.managers[i].getDownloadState().removeListener(this, "parameters", 1);
            }
        }
    }

    private void dataSourceChanged(Object newDataSource) {
        Object[] objs;
        DownloadManager[] old_managers = this.managers;
        if (old_managers != null) {
            for (int i = 0; i < old_managers.length; ++i) {
                old_managers[i].getDownloadState().removeListener(this, "parameters", 1);
            }
        }
        if (newDataSource instanceof DownloadManager) {
            this.multi_view = false;
            this.managers = new DownloadManager[]{(DownloadManager)newDataSource};
        } else if (newDataSource instanceof DownloadManager[]) {
            this.multi_view = true;
            this.managers = (DownloadManager[])newDataSource;
        } else if (newDataSource instanceof Object[] && (objs = (Object[])newDataSource).length > 0 && objs[0] instanceof DownloadManager) {
            this.managers = new DownloadManager[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                this.managers[i] = (DownloadManager)objs[i];
            }
            this.multi_view = true;
        }
        if (this.parent != null) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    TorrentOptionsView.this.initialize(TorrentOptionsView.this.parent);
                }
            });
        }
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    protected class adhocParameterAdapter
    extends GenericParameterAdapter {
        protected adhocParameterAdapter() {
        }

        public int getIntValue(String key) {
            return this.getIntValue(key, 0);
        }

        public int getIntValue(String key, int def) {
            if (key == TorrentOptionsView.MAX_UPLOAD) {
                int result = def;
                for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                    int val = TorrentOptionsView.this.managers[i].getStats().getUploadRateLimitBytesPerSecond() / 1024;
                    if (i == 0) {
                        result = val;
                        continue;
                    }
                    if (result == val) continue;
                    return def;
                }
                return result;
            }
            if (key == TorrentOptionsView.MAX_DOWNLOAD) {
                int result = def;
                for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                    int val = TorrentOptionsView.this.managers[i].getStats().getDownloadRateLimitBytesPerSecond() / 1024;
                    if (i == 0) {
                        result = val;
                        continue;
                    }
                    if (result == val) continue;
                    return def;
                }
                return result;
            }
            Debug.out("Unknown key '" + key + "'");
            return 0;
        }

        public void setIntValue(String key, int value) {
            if (key == TorrentOptionsView.MAX_UPLOAD) {
                for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                    DownloadManager manager = TorrentOptionsView.this.managers[i];
                    if (value == manager.getStats().getUploadRateLimitBytesPerSecond() / 1024) continue;
                    manager.getStats().setUploadRateLimitBytesPerSecond(value * 1024);
                }
            } else if (key == TorrentOptionsView.MAX_DOWNLOAD) {
                for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                    DownloadManager manager = TorrentOptionsView.this.managers[i];
                    if (value == manager.getStats().getDownloadRateLimitBytesPerSecond() / 1024) continue;
                    manager.getStats().setDownloadRateLimitBytesPerSecond(value * 1024);
                }
            } else {
                Debug.out("Unknown key '" + key + "'");
            }
        }
    }

    protected class downloadStateParameterAdapter
    extends GenericParameterAdapter {
        protected downloadStateParameterAdapter() {
        }

        public int getIntValue(String key) {
            return this.getIntValue(key, 0);
        }

        public int getIntValue(String key, int def) {
            int result = def;
            for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                int val = TorrentOptionsView.this.managers[i].getDownloadState().getIntParameter(key);
                if (i == 0) {
                    result = val;
                    continue;
                }
                if (result == val) continue;
                return def;
            }
            return result;
        }

        public void setIntValue(String key, int value) {
            for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                DownloadManager manager = TorrentOptionsView.this.managers[i];
                if (value == manager.getDownloadState().getIntParameter(key)) continue;
                manager.getDownloadState().setIntParameter(key, value);
            }
        }

        public boolean getBooleanValue(String key) {
            return this.getBooleanValue(key, false);
        }

        public boolean getBooleanValue(String key, boolean def) {
            boolean result = def;
            for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                boolean val = TorrentOptionsView.this.managers[i].getDownloadState().getBooleanParameter(key);
                if (i == 0) {
                    result = val;
                    continue;
                }
                if (result == val) continue;
                return def;
            }
            return result;
        }

        public void setBooleanValue(String key, boolean value) {
            for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                DownloadManager manager = TorrentOptionsView.this.managers[i];
                if (value == manager.getDownloadState().getBooleanParameter(key)) continue;
                manager.getDownloadState().setBooleanParameter(key, value);
            }
        }

        public float getFloatValue(String key) {
            int result = 0;
            for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                int val = TorrentOptionsView.this.managers[i].getDownloadState().getIntParameter(key);
                if (i == 0) {
                    result = val;
                    continue;
                }
                if (result == val) continue;
                return 0.0f;
            }
            return (float)result / 1000.0f;
        }

        public void setFloatValue(String key, float _value) {
            int value = (int)(_value * 1000.0f);
            for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                DownloadManager manager = TorrentOptionsView.this.managers[i];
                if (value == manager.getDownloadState().getIntParameter(key)) continue;
                manager.getDownloadState().setIntParameter(key, value);
            }
        }
    }
}

