/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionConnectionAdvanced
implements UISWTConfigSection {
    private static final String CFG_PREFIX = "ConfigView.section.connection.advanced.";
    private static final int REQUIRED_MODE = 2;

    public int maxUserMode() {
        return 2;
    }

    public String configSectionGetParentSection() {
        return "server";
    }

    public String configSectionGetName() {
        return "connection.advanced";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout advanced_layout = new GridLayout();
        cSection.setLayout((Layout)advanced_layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 2) {
            Label label = new Label(cSection, 64);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
            String param1 = 2 < modeKeys.length ? MessageText.getString(modeKeys[2]) : String.valueOf(2);
            String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
            label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
            return cSection;
        }
        new LinkLabel(cSection, gridData, "ConfigView.section.connection.advanced.info.link", MessageText.getString("ConfigView.section.connection.advanced.url"));
        Group gSocket = new Group(cSection, 0);
        Messages.setLanguageText((Widget)gSocket, "ConfigView.section.connection.advanced.socket.group");
        gridData = new GridData(784);
        gSocket.setLayoutData((Object)gridData);
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 3;
        gSocket.setLayout((Layout)glayout);
        Label lmaxout = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lmaxout, "ConfigView.section.connection.network.max.simultaneous.connect.attempts");
        gridData = new GridData();
        lmaxout.setLayoutData((Object)gridData);
        IntParameter max_connects = new IntParameter((Composite)gSocket, "network.max.simultaneous.connect.attempts", 1, 100);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        max_connects.setLayoutData(gridData);
        Label lmaxpout = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lmaxpout, "ConfigView.section.connection.network.max.outstanding.connect.attempts");
        gridData = new GridData();
        lmaxpout.setLayoutData((Object)gridData);
        IntParameter max_pending_connects = new IntParameter((Composite)gSocket, "network.tcp.max.connections.outstanding", 1, 65536);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        max_pending_connects.setLayoutData(gridData);
        Label lbind = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lbind, "ConfigView.label.bindip");
        gridData = new GridData();
        lbind.setLayoutData((Object)gridData);
        StringParameter bindip = new StringParameter((Composite)gSocket, "Bind IP", "", false);
        gridData = new GridData();
        gridData.widthHint = 100;
        gridData.horizontalSpan = 2;
        bindip.setLayoutData(gridData);
        Text lbind2 = new Text((Composite)gSocket, 10);
        lbind2.setTabs(8);
        Messages.setLanguageText((Widget)lbind2, "ConfigView.label.bindip.details", new String[]{"\t" + NetworkAdmin.getSingleton().getNetworkInterfacesAsString().replaceAll("\\\n", "\n\t")});
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        lbind2.setLayoutData((Object)gridData);
        BooleanParameter check_bind = new BooleanParameter((Composite)gSocket, "Check Bind IP On Start", "network.check.ipbinding");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        check_bind.setLayoutData(gridData);
        BooleanParameter force_bind = new BooleanParameter((Composite)gSocket, "Enforce Bind IP", "network.enforce.ipbinding");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        force_bind.setLayoutData(gridData);
        BooleanParameter bind_icon = new BooleanParameter((Composite)gSocket, "Show IP Bindings Icon", "network.ipbinding.icon.show");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        bind_icon.setLayoutData(gridData);
        Label lpbind = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lpbind, "ConfigView.section.connection.advanced.bind_port");
        IntParameter port_bind = new IntParameter((Composite)gSocket, "network.bind.local.port", 0, 65535);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        port_bind.setLayoutData(gridData);
        Label lmtu = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lmtu, "ConfigView.section.connection.advanced.mtu");
        IntParameter mtu_size = new IntParameter((Composite)gSocket, "network.tcp.mtu.size");
        mtu_size.setMaximumValue(524288);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        mtu_size.setLayoutData(gridData);
        Label lsend = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lsend, "ConfigView.section.connection.advanced.SO_SNDBUF");
        final IntParameter SO_SNDBUF = new IntParameter((Composite)gSocket, "network.tcp.socket.SO_SNDBUF");
        gridData = new GridData();
        SO_SNDBUF.setLayoutData(gridData);
        final Label lsendcurr = new Label((Composite)gSocket, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        lsendcurr.setLayoutData((Object)gridData);
        Label lreceiv = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lreceiv, "ConfigView.section.connection.advanced.SO_RCVBUF");
        final IntParameter SO_RCVBUF = new IntParameter((Composite)gSocket, "network.tcp.socket.SO_RCVBUF");
        gridData = new GridData();
        SO_RCVBUF.setLayoutData(gridData);
        final Label lreccurr = new Label((Composite)gSocket, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        lreccurr.setLayoutData((Object)gridData);
        final Runnable buff_updater = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                int rec_val;
                int snd_val;
                block14: {
                    SocketChannel sc;
                    block13: {
                        sc = null;
                        snd_val = 0;
                        rec_val = 0;
                        sc = SocketChannel.open();
                        Socket socket = sc.socket();
                        if (SO_SNDBUF.getValue() == 0) {
                            snd_val = socket.getSendBufferSize();
                        }
                        if (SO_RCVBUF.getValue() != 0) break block13;
                        rec_val = socket.getReceiveBufferSize();
                    }
                    Object var6_6 = null;
                    try {
                        sc.close();
                    }
                    catch (Throwable e2) {}
                    break block14;
                    {
                        catch (Throwable e) {
                            Object var6_7 = null;
                            try {
                                sc.close();
                            }
                            catch (Throwable e2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        try {
                            sc.close();
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                if (snd_val == 0) {
                    lsendcurr.setText("");
                } else {
                    Messages.setLanguageText((Widget)lsendcurr, "label.current.equals", new String[]{String.valueOf(snd_val)});
                }
                if (rec_val == 0) {
                    lreccurr.setText("");
                } else {
                    Messages.setLanguageText((Widget)lreccurr, "label.current.equals", new String[]{String.valueOf(rec_val)});
                }
            }
        };
        buff_updater.run();
        ParameterChangeAdapter buff_listener = new ParameterChangeAdapter(){

            public void parameterChanged(Parameter p, boolean caused_internally) {
                buff_updater.run();
            }
        };
        SO_RCVBUF.addChangeListener(buff_listener);
        SO_SNDBUF.addChangeListener(buff_listener);
        Label ltos = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)ltos, "ConfigView.section.connection.advanced.IPDiffServ");
        final StringParameter IPDiffServ = new StringParameter((Composite)gSocket, "network.tcp.socket.IPDiffServ");
        gridData = new GridData();
        gridData.widthHint = 100;
        gridData.horizontalSpan = 2;
        IPDiffServ.setLayoutData(gridData);
        IPDiffServ.addChangeListener(new ParameterChangeAdapter(){
            final Color obg;
            final Color ofg;
            {
                this.obg = IPDiffServ.getControl().getBackground();
                this.ofg = IPDiffServ.getControl().getForeground();
            }

            public void parameterChanged(Parameter p, boolean caused_internally) {
                String raw = IPDiffServ.getValue();
                int value = -1;
                try {
                    value = Integer.decode(raw);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (value < 0 || value > 255) {
                    ConfigurationManager.getInstance().removeParameter("network.tcp.socket.IPDiffServ");
                    if (raw != null && raw.length() > 0) {
                        IPDiffServ.getControl().setBackground(Colors.red);
                        IPDiffServ.getControl().setForeground(Colors.white);
                    } else {
                        IPDiffServ.getControl().setBackground(this.obg);
                        IPDiffServ.getControl().setForeground(this.ofg);
                    }
                    ConfigSectionConnectionAdvanced.this.enableTOSRegistrySetting(false);
                } else {
                    IPDiffServ.getControl().setBackground(this.obg);
                    IPDiffServ.getControl().setForeground(this.ofg);
                    ConfigSectionConnectionAdvanced.this.enableTOSRegistrySetting(true);
                }
            }
        });
        Label lreadsel = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lreadsel, "ConfigView.section.connection.advanced.read_select", new String[]{String.valueOf(COConfigurationManager.getDefault("network.tcp.read.select.time"))});
        IntParameter read_select = new IntParameter((Composite)gSocket, "network.tcp.read.select.time", 10, 250);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        read_select.setLayoutData(gridData);
        Label lreadselmin = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lreadselmin, "ConfigView.section.connection.advanced.read_select_min", new String[]{String.valueOf(COConfigurationManager.getDefault("network.tcp.read.select.min.time"))});
        IntParameter read_select_min = new IntParameter((Composite)gSocket, "network.tcp.read.select.min.time", 0, 100);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        read_select_min.setLayoutData(gridData);
        Label lwritesel = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lwritesel, "ConfigView.section.connection.advanced.write_select", new String[]{String.valueOf(COConfigurationManager.getDefault("network.tcp.write.select.time"))});
        IntParameter write_select = new IntParameter((Composite)gSocket, "network.tcp.write.select.time", 10, 250);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        write_select.setLayoutData(gridData);
        Label lwriteselmin = new Label((Composite)gSocket, 0);
        Messages.setLanguageText((Widget)lwriteselmin, "ConfigView.section.connection.advanced.write_select_min", new String[]{String.valueOf(COConfigurationManager.getDefault("network.tcp.write.select.min.time"))});
        IntParameter write_select_min = new IntParameter((Composite)gSocket, "network.tcp.write.select.min.time", 0, 100);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        write_select_min.setLayoutData(gridData);
        new BooleanParameter(cSection, "IPV6 Enable Support", "network.ipv6.enable.support");
        new BooleanParameter(cSection, "IPV6 Prefer Addresses", "network.ipv6.prefer.addresses");
        if (Constants.isWindowsVistaOrHigher && Constants.isJava7OrHigher) {
            new BooleanParameter(cSection, "IPV4 Prefer Stack", "network.ipv4.prefer.stack");
        }
        return cSection;
    }

    private void enableTOSRegistrySetting(boolean enable) {
        PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
        if (mgr.hasCapability(PlatformManagerCapabilities.SetTCPTOSEnabled)) {
            try {
                mgr.setTCPTOSEnabled(enable);
            }
            catch (PlatformManagerException pe) {
                Debug.printStackTrace(pe);
            }
        }
    }
}

