/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class ETAItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "eta";
    private ViewUtils.CustomDateFormat cdf;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ETAItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 60, sTableID);
        this.setRefreshInterval(-2);
        this.cdf = ViewUtils.addCustomDateFormat(this);
    }

    public void refresh(TableCell cell) {
        long value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long l = value = dm == null ? 0L : dm.getStats().getETA();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(ViewUtils.formatETA(value, MyTorrentsView.eta_absolute, this.cdf.getDateFormat()));
    }

    public void postConfigLoad() {
        super.postConfigLoad();
        this.cdf.update();
    }
}

