/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.util.RegExUtil;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginInterface;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchResult;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedContentSearcher
implements DistributedDatabaseTransferHandler {
    private static final boolean SEARCH_CVS_ONLY = Constants.isCurrentVersionLT("4.7.0.4");
    private static final boolean TRACE_SEARCH = false;
    private static final int MAX_REMOTE_SEARCH_RESULTS = 30;
    private static final int MAX_REMOTE_SEARCH_CONTACTS = 50;
    private static final int MAX_REMOTE_SEARCH_MILLIS = 25000;
    private static final int REDUCED_REMOTE_SEARCH_MILLIS = 10000;
    private static final int HARVEST_MAX_BLOOMS = 50;
    private static final int HARVEST_MAX_FAILS_HISTORY = 128;
    private static final int HARVEST_BLOOM_UPDATE_MILLIS = 900000;
    private static final int HARVEST_BLOOM_DISCARD_MILLIS = 3600000;
    private static final int HARVEST_BLOOM_OP_RESET_MILLIS = 300000;
    private static final int HARVEST_BLOOM_OP_RESET_TICKS = 10;
    private static final int HARVEST_BLOOM_SE_RESET_MILLIS = 60000;
    private static final int HARVEST_BLOOM_SE_RESET_TICKS = 2;
    private static final int KEY_BLOOM_LOAD_FACTOR = 8;
    private static final int KEY_BLOOM_MIN_BITS = 1000;
    private static final int KEY_BLOOM_MAX_BITS = 50000;
    private static final int KEY_BLOOM_MAX_ENTRIES = 6250;
    private volatile BloomFilter key_bloom_with_local;
    private volatile BloomFilter key_bloom_without_local;
    private volatile long last_key_bloom_update = -1L;
    private Set<String> ignore_words = new HashSet<String>();
    private ByteArrayHashMap<ForeignBloom> harvested_blooms;
    private ByteArrayHashMap<String> harvested_fails;
    private volatile BloomFilter harvest_op_requester_bloom;
    private volatile BloomFilter harvest_se_requester_bloom;
    private final AsyncDispatcher harvest_dispatcher;
    private final RelatedContentManager manager;
    private final DistributedDatabaseTransferType transfer_type;
    private final DHTPluginInterface dht_plugin;
    private DistributedDatabase ddb;

    protected RelatedContentSearcher(RelatedContentManager _manager, DistributedDatabaseTransferType _transfer_type, DHTPluginInterface _dht_plugin) {
        String[] lame_entries;
        String ignore = "a, in, of, at, the, and, or, if, to, an, for, with";
        for (String entry : lame_entries = ignore.toLowerCase(Locale.US).split(",")) {
            if ((entry = entry.trim()).length() <= 0) continue;
            this.ignore_words.add(entry);
        }
        this.harvested_blooms = new ByteArrayHashMap();
        this.harvested_fails = new ByteArrayHashMap();
        this.harvest_op_requester_bloom = BloomFilterFactory.createAddOnly(2048);
        this.harvest_se_requester_bloom = BloomFilterFactory.createAddRemove4Bit(512);
        this.harvest_dispatcher = new AsyncDispatcher();
        this.manager = _manager;
        this.transfer_type = _transfer_type;
        this.dht_plugin = _dht_plugin;
    }

    protected DHTPluginInterface getDHTPlugin() {
        return this.dht_plugin;
    }

    protected void timerTick(boolean enabled, int tick_count) {
        if (tick_count == 1) {
            try {
                List<DistributedDatabase> ddbs = DDBaseImpl.getDDBs(new String[]{this.dht_plugin.getNetwork()});
                if (ddbs.size() > 0) {
                    this.ddb = ddbs.get(0);
                    this.ddb.addTransferHandler(this.transfer_type, this);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (enabled) {
            this.harvestBlooms();
            if (tick_count % 2 == 0) {
                this.harvest_se_requester_bloom = this.harvest_se_requester_bloom.getReplica();
            }
            if (tick_count % 10 == 0) {
                this.harvest_op_requester_bloom = this.harvest_op_requester_bloom.getReplica();
            }
        }
        this.checkKeyBloom();
        this.testKeyBloom();
    }

    protected SearchInstance searchRCM(Map<String, Object> search_parameters, SearchObserver _observer) throws SearchException {
        final MySearchObserver observer = new MySearchObserver(_observer);
        final String term = this.fixupTerm((String)search_parameters.get("s"));
        final SearchInstance si = new SearchInstance(){

            public void cancel() {
                Debug.out("Cancelled");
            }
        };
        if (term == null) {
            observer.complete();
        } else {
            new AEThread2("RCM:search", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public void run() {
                    hashes_sync_me = new HashSet<String>();
                    try {
                        block59: {
                            matches = RelatedContentSearcher.this.matchContent(term);
                            for (final RelatedContent c : matches) {
                                hash = c.getHash();
                                if (hash == null) continue;
                                hashes_sync_me.add(Base32.encode(hash));
                                result = new SearchResult(){

                                    public Object getProperty(int property_name) {
                                        if (property_name == 1) {
                                            return c.getTitle();
                                        }
                                        if (property_name == 3) {
                                            return c.getSize();
                                        }
                                        if (property_name == 21) {
                                            return hash;
                                        }
                                        if (property_name == 17) {
                                            return new Long(c.getRank() / 4);
                                        }
                                        if (property_name == 5) {
                                            return new Long(c.getSeeds());
                                        }
                                        if (property_name == 4) {
                                            return new Long(c.getLeechers());
                                        }
                                        if (property_name == 6) {
                                            if (c.getContentNetwork() != -1L) {
                                                return new Long(1L);
                                            }
                                            return new Long(0L);
                                        }
                                        if (property_name == 2) {
                                            long date = c.getPublishDate();
                                            if (date <= 0L) {
                                                return null;
                                            }
                                            return new Date(date);
                                        }
                                        if (property_name == 12 || property_name == 16) {
                                            byte[] hash2 = c.getHash();
                                            if (hash2 != null) {
                                                return UrlUtils.getMagnetURI(hash2, c.getTitle(), c.getNetworks());
                                            }
                                        } else {
                                            if (property_name == 50000) {
                                                return c.getContentNetwork();
                                            }
                                            if (property_name == 50001) {
                                                return c.getTrackerKeys();
                                            }
                                            if (property_name == 50002) {
                                                return c.getWebSeedKeys();
                                            }
                                            if (property_name == 50003) {
                                                return c.getTags();
                                            }
                                            if (property_name == 50004) {
                                                return c.getNetworks();
                                            }
                                        }
                                        return null;
                                    }
                                };
                                observer.resultReceived(si, result);
                            }
                            var8_7 = null;
                            try {
                                initial_hinted_contacts = RelatedContentSearcher.access$100(RelatedContentSearcher.this, term);
                                extra_hinted_contacts = new HashSet<E>();
                                Collections.shuffle(initial_hinted_contacts);
                                contacts_to_search = new LinkedList<DistributedDatabaseContact>();
                                contact_map = new HashMap<InetSocketAddress, DistributedDatabaseContact>();
                                for (DistributedDatabaseContact c : initial_hinted_contacts) {
                                    contact_map.put(c.getAddress(), c);
                                }
                                if (RelatedContentSearcher.access$200(RelatedContentSearcher.this) == null) ** GOTO lbl65
                                arr$ = dhts = RelatedContentSearcher.access$300(RelatedContentSearcher.this).getDHTInterfaces();
                                len$ = arr$.length;
                                i$ = 0;
lbl27:
                                // 2 sources

                                while (true) {
                                    block63: {
                                        block64: {
                                            if (i$ >= len$) break block63;
                                            dht = arr$[i$];
                                            if (dht.isIPV6()) ** GOTO lbl276
                                            network = dht.getNetwork();
                                            if (!RelatedContentSearcher.access$400() || network == 1) break block64;
                                            RelatedContentSearcher.access$500("Search: ignoring main DHT");
                                            ** GOTO lbl276
                                        }
                                        contacts = dht.getReachableContacts();
                                        Collections.shuffle(Arrays.asList(contacts));
                                        arr$ = contacts;
                                        len$ = arr$.length;
                                        ** GOTO lbl262
                                    }
                                    if (contact_map.size() < 50) {
                                        for (DHTPluginInterface.DHTInterface dht : dhts) {
                                            if (dht.isIPV6()) continue;
                                            network = dht.getNetwork();
                                            if (RelatedContentSearcher.access$400() && network != 1) {
                                                RelatedContentSearcher.access$500("Search: ignoring main DHT");
                                                continue;
                                            }
                                            for (DHTPluginContact dc : contacts = dht.getRecentContacts()) {
                                                address = dc.getAddress();
                                                if (contact_map.containsKey(address)) continue;
                                                try {
                                                    c = RelatedContentSearcher.access$600(RelatedContentSearcher.this, dc, network);
                                                    contact_map.put(address, c);
                                                    contacts_to_search.add(c);
                                                    if (contact_map.size() < 50) continue;
                                                    break;
                                                }
                                                catch (Throwable e) {
                                                    // empty catch block
                                                }
                                            }
                                            if (contact_map.size() >= 50) break;
                                        }
                                    }
lbl65:
                                    // 5 sources

                                    desired_pos = 0;
                                    for (DistributedDatabaseContact dc : initial_hinted_contacts) {
                                        if (desired_pos < contacts_to_search.size()) {
                                            contacts_to_search.add(desired_pos, dc);
                                            desired_pos += 2;
                                            continue;
                                        }
                                        contacts_to_search.addLast(dc);
                                    }
                                    start = SystemTime.getMonotonousTime();
                                    max = 25000L;
                                    sem = new AESemaphore("RCM:rems");
                                    sent = 0;
                                    done = new int[]{0};
                                    RelatedContentSearcher.access$500("Search starts: contacts=" + contacts_to_search.size() + ", hinted=" + initial_hinted_contacts.size());
                                    while (true) {
                                        if (MySearchObserver.access$700(observer) >= 200 || SystemTime.getMonotonousTime() - start >= max) {
                                            RelatedContentSearcher.access$500("Hard limit exceeded");
                                            v0 = null;
                                            break block59;
                                        }
                                        if (sent >= 50) {
                                            RelatedContentSearcher.access$500("Max contacts searched");
                                            break;
                                        }
                                        i$ = contacts_to_search;
                                        // MONITORENTER : i$
                                        if (contacts_to_search.isEmpty()) {
                                            RelatedContentSearcher.access$500("Contacts exhausted");
                                            // MONITOREXIT : i$
                                            break;
                                        }
                                        contact_to_search = (DistributedDatabaseContact)contacts_to_search.removeFirst();
                                        // MONITOREXIT : i$
                                        new AEThread2("RCM:rems", true, contact_to_search, hashes_sync_me, initial_hinted_contacts, extra_hinted_contacts, contacts_to_search, contact_map, done, sem){
                                            final /* synthetic */ DistributedDatabaseContact val$contact_to_search;
                                            final /* synthetic */ Set val$hashes_sync_me;
                                            final /* synthetic */ List val$initial_hinted_contacts;
                                            final /* synthetic */ Set val$extra_hinted_contacts;
                                            final /* synthetic */ LinkedList val$contacts_to_search;
                                            final /* synthetic */ Map val$contact_map;
                                            final /* synthetic */ int[] val$done;
                                            final /* synthetic */ AESemaphore val$sem;
                                            {
                                                this.val$contact_to_search = distributedDatabaseContact;
                                                this.val$hashes_sync_me = set;
                                                this.val$initial_hinted_contacts = list;
                                                this.val$extra_hinted_contacts = set2;
                                                this.val$contacts_to_search = linkedList;
                                                this.val$contact_map = map;
                                                this.val$done = nArray;
                                                this.val$sem = aESemaphore;
                                                super(x0, x1);
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public void run() {
                                                try {
                                                    RelatedContentSearcher.logSearch("Searching " + this.val$contact_to_search.getAddress());
                                                    List<DistributedDatabaseContact> extra_contacts = RelatedContentSearcher.this.sendRemoteSearch(si, this.val$hashes_sync_me, this.val$contact_to_search, term, observer);
                                                    if (extra_contacts == null) {
                                                        RelatedContentSearcher.logSearch("    " + this.val$contact_to_search.getAddress() + " failed");
                                                        RelatedContentSearcher.this.foreignBloomFailed(this.val$contact_to_search);
                                                    } else {
                                                        String type = this.val$initial_hinted_contacts.contains(this.val$contact_to_search) ? "i" : (this.val$extra_hinted_contacts.contains(this.val$contact_to_search) ? "e" : "n");
                                                        RelatedContentSearcher.logSearch("    " + this.val$contact_to_search.getAddress() + " OK " + type + " - additional=" + extra_contacts.size());
                                                        LinkedList linkedList = this.val$contacts_to_search;
                                                        synchronized (linkedList) {
                                                            int insert_point = 0;
                                                            if (type.equals("i")) {
                                                                for (int i = 0; i < this.val$contacts_to_search.size(); ++i) {
                                                                    if (!this.val$extra_hinted_contacts.contains(this.val$contacts_to_search.get(i))) continue;
                                                                    insert_point = i + 1;
                                                                }
                                                            }
                                                            for (DistributedDatabaseContact c : extra_contacts) {
                                                                InetSocketAddress address = c.getAddress();
                                                                if (this.val$contact_map.containsKey(address)) continue;
                                                                RelatedContentSearcher.logSearch("        additional target: " + address);
                                                                this.val$extra_hinted_contacts.add(c);
                                                                this.val$contact_map.put(address, c);
                                                                this.val$contacts_to_search.add(insert_point, c);
                                                            }
                                                        }
                                                    }
                                                    Object var10_10 = null;
                                                    int[] nArray = this.val$done;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var10_11 = null;
                                                    int[] nArray = this.val$done;
                                                    synchronized (this.val$done) {
                                                        this.val$done[0] = this.val$done[0] + 1;
                                                        // ** MonitorExit[var11_13] (shouldn't be in output)
                                                        this.val$sem.release();
                                                        throw throwable;
                                                    }
                                                }
                                                synchronized (this.val$done) {
                                                    this.val$done[0] = this.val$done[0] + 1;
                                                    // ** MonitorExit[var11_12] (shouldn't be in output)
                                                    this.val$sem.release();
                                                    return;
                                                }
                                            }
                                        }.start();
                                        ++sent;
                                        i$ = done;
                                        // MONITORENTER : done
                                        if (done[0] >= 25) {
                                            RelatedContentSearcher.access$500("Switching to reduced time limit (1)");
                                            start = SystemTime.getMonotonousTime();
                                            max = 10000L;
                                            // MONITOREXIT : i$
                                            break;
                                        }
                                        // MONITOREXIT : i$
                                        if (sent <= 10) continue;
                                        try {
                                            Thread.sleep(250L);
                                        }
                                        catch (Throwable e) {}
                                    }
                                    RelatedContentSearcher.access$500("Request dispatch complete: sent=" + sent + ", done=" + done[0]);
                                    for (i = 0; i < sent; ++i) {
                                        if (done[0] > sent * 9 / 10) {
                                            RelatedContentSearcher.access$500("9/10ths replied (" + done[0] + "/" + sent + "), done");
                                            break;
                                        }
                                        remaining = start + max - SystemTime.getMonotonousTime();
                                        if (remaining > 10000L && done[0] >= 25) {
                                            RelatedContentSearcher.access$500("Switching to reduced time limit (2)");
                                            start = SystemTime.getMonotonousTime();
                                            max = 10000L;
                                        }
                                        if (remaining > 0L) {
                                            sem.reserve(250L);
                                            continue;
                                        }
                                        RelatedContentSearcher.access$500("Time exhausted");
                                        break;
                                    }
                                    v0 = null;
                                    break;
                                }
                            }
                            catch (Throwable var28_64) {
                                v0 = null;
                            }
                        }
                        var29_66 = v0;
                        RelatedContentSearcher.access$500("Search complete");
                        observer.complete();
                        return;
                    }
                    catch (Throwable var7_68) {
                        block60: {
                            block61: {
                                block62: {
                                    var8_8 = null;
                                    ** try [egrp 1[TRYBLOCK] [11 : 120->1168)] { 
lbl141:
                                    // 1 sources

                                    initial_hinted_contacts = RelatedContentSearcher.access$100(RelatedContentSearcher.this, term);
                                    extra_hinted_contacts = new HashSet<E>();
                                    Collections.shuffle(initial_hinted_contacts);
                                    contacts_to_search = new LinkedList<DistributedDatabaseContact>();
                                    contact_map = new HashMap<InetSocketAddress, DistributedDatabaseContact>();
                                    for (DistributedDatabaseContact c : initial_hinted_contacts) {
                                        contact_map.put(c.getAddress(), c);
                                    }
                                    if (RelatedContentSearcher.access$200(RelatedContentSearcher.this) == null) ** GOTO lbl190
                                    arr$ = dhts = RelatedContentSearcher.access$300(RelatedContentSearcher.this).getDHTInterfaces();
                                    len$ = arr$.length;
                                    i$ = 0;
lbl154:
                                    // 2 sources

                                    while (true) {
                                        if (i$ < len$) {
                                            dht = arr$[i$];
                                            if (dht.isIPV6()) break block60;
                                            network = dht.getNetwork();
                                            if (RelatedContentSearcher.access$400() && network != 1) {
                                                RelatedContentSearcher.access$500("Search: ignoring main DHT");
                                                break block60;
                                            }
                                            contacts = dht.getReachableContacts();
                                            Collections.shuffle(Arrays.asList(contacts));
                                            arr$ = contacts;
                                            len$ = arr$.length;
                                            break block61;
                                        }
                                        if (contact_map.size() < 50) {
                                            for (DHTPluginInterface.DHTInterface dht : dhts) {
                                                if (dht.isIPV6()) continue;
                                                network = dht.getNetwork();
                                                if (RelatedContentSearcher.access$400() && network != 1) {
                                                    RelatedContentSearcher.access$500("Search: ignoring main DHT");
                                                    continue;
                                                }
                                                for (DHTPluginContact dc : contacts = dht.getRecentContacts()) {
                                                    address = dc.getAddress();
                                                    if (contact_map.containsKey(address)) continue;
                                                    ** try [egrp 3[TRYBLOCK] [3 : 558->609)] { 
lbl178:
                                                    // 1 sources

                                                    c = RelatedContentSearcher.access$600(RelatedContentSearcher.this, dc, network);
                                                    contact_map.put(address, c);
                                                    contacts_to_search.add(c);
                                                    if (contact_map.size() < 50) continue;
                                                    break;
lbl185:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (contact_map.size() >= 50) break;
                                            }
                                        }
lbl190:
                                        // 5 sources

                                        desired_pos = 0;
                                        for (DistributedDatabaseContact dc : initial_hinted_contacts) {
                                            if (desired_pos < contacts_to_search.size()) {
                                                contacts_to_search.add(desired_pos, dc);
                                                desired_pos += 2;
                                                continue;
                                            }
                                            contacts_to_search.addLast(dc);
                                        }
                                        start = SystemTime.getMonotonousTime();
                                        max = 25000L;
                                        sem = new AESemaphore("RCM:rems");
                                        sent = 0;
                                        done = new int[]{0};
                                        RelatedContentSearcher.access$500("Search starts: contacts=" + contacts_to_search.size() + ", hinted=" + initial_hinted_contacts.size());
                                        while (true) {
                                            if (MySearchObserver.access$700(observer) >= 200 || SystemTime.getMonotonousTime() - start >= max) {
                                                RelatedContentSearcher.access$500("Hard limit exceeded");
                                                v1 = null;
                                                break block62;
                                            }
                                            if (sent >= 50) {
                                                RelatedContentSearcher.access$500("Max contacts searched");
                                                break;
                                            }
                                            i$ = contacts_to_search;
                                            // MONITORENTER : i$
                                            if (contacts_to_search.isEmpty()) {
                                                RelatedContentSearcher.access$500("Contacts exhausted");
                                                // MONITOREXIT : i$
                                                break;
                                            }
                                            contact_to_search = (DistributedDatabaseContact)contacts_to_search.removeFirst();
                                            // MONITOREXIT : i$
                                            new /* invalid duplicate definition of identical inner class */.start();
                                            ++sent;
                                            i$ = done;
                                            // MONITORENTER : done
                                            if (done[0] >= 25) {
                                                RelatedContentSearcher.access$500("Switching to reduced time limit (1)");
                                                start = SystemTime.getMonotonousTime();
                                                max = 10000L;
                                                // MONITOREXIT : i$
                                                break;
                                            }
                                            // MONITOREXIT : i$
                                            if (sent <= 10) continue;
                                            try {}
                                            catch (Throwable e) {}
                                            Thread.sleep(250L);
                                        }
                                        RelatedContentSearcher.access$500("Request dispatch complete: sent=" + sent + ", done=" + done[0]);
                                        for (i = 0; i < sent; ++i) {
                                            if (done[0] > sent * 9 / 10) {
                                                RelatedContentSearcher.access$500("9/10ths replied (" + done[0] + "/" + sent + "), done");
                                                break;
                                            }
                                            remaining = start + max - SystemTime.getMonotonousTime();
                                            if (remaining > 10000L && done[0] >= 25) {
                                                RelatedContentSearcher.access$500("Switching to reduced time limit (2)");
                                                start = SystemTime.getMonotonousTime();
                                                max = 10000L;
                                            }
                                            if (remaining > 0L) {
                                                sem.reserve(250L);
                                                continue;
                                            }
                                            RelatedContentSearcher.access$500("Time exhausted");
                                            break;
                                        }
                                        v1 = null;
                                        break block62;
                                        break;
                                    }
lbl255:
                                    // 1 sources

                                    catch (Throwable var28_65) {
                                        v1 = null;
                                    }
                                }
                                var29_67 = v1;
                                RelatedContentSearcher.access$500("Search complete");
                                observer.complete();
                                throw var7_68;
lbl262:
                                // 4 sources

                                for (i$ = 0; i$ < len$; ++i$) {
                                    dc = arr$[i$];
                                    address = dc.getAddress();
                                    if (contact_map.containsKey(address)) continue;
                                    try {
                                        c = RelatedContentSearcher.access$600(RelatedContentSearcher.this, dc, network);
                                        contact_map.put(address, c);
                                        contacts_to_search.add(c);
                                        continue;
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                }
lbl276:
                                // 3 sources

                                ++i$;
                                ** continue;
                            }
                            for (i$ = 0; i$ < len$; ++i$) {
                                dc = arr$[i$];
                                address = dc.getAddress();
                                if (contact_map.containsKey(address)) continue;
                                ** try [egrp 2[TRYBLOCK] [2 : 372->408)] { 
lbl284:
                                // 1 sources

                                c = RelatedContentSearcher.access$600(RelatedContentSearcher.this, dc, network);
                                contact_map.put(address, c);
                                contacts_to_search.add(c);
                                continue;
lbl290:
                                // 1 sources

                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                        }
                        ++i$;
                        ** continue;
                    }
                }
            }.start();
        }
        return si;
    }

    private String fixupTerm(String term) {
        if (term == null) {
            return null;
        }
        if (term.contains("|")) {
            while (term.contains(" |")) {
                term = term.replaceAll(" \\|", "|");
            }
            while (term.contains("| ")) {
                term = term.replaceAll("\\| ", "|");
            }
        }
        return term;
    }

    private String escapeTag(String tag) {
        if (tag.contains(" ")) {
            tag = tag.replaceAll(" ", "+");
        }
        return tag;
    }

    private String unescapeTag(String tag) {
        if (tag.contains("+")) {
            tag = tag.replaceAll("\\+", " ");
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RelatedContent> matchContent(String term) {
        Iterator<RelatedContentManager.DownloadInfo> it2;
        String[] bits = Constants.PAT_SPLIT_SPACE.split(term.toLowerCase());
        int[] bit_types = new int[bits.length];
        Pattern[] bit_patterns = new Pattern[bits.length];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = bits[i].trim();
            String bit = bits[i];
            if (bit.length() <= 0) continue;
            char c = bit.charAt(0);
            if (c == '+') {
                bit_types[i] = 1;
                bit = bits[i] = bit.substring(1);
            } else if (c == '-') {
                bit_types[i] = 2;
                bit = bits[i] = bit.substring(1);
            }
            if (bit.startsWith("(") && bit.endsWith(")")) {
                bit = bit.substring(1, bit.length() - 1);
                try {
                    if (RegExUtil.mightBeEvil(bit)) continue;
                    bit_patterns[i] = Pattern.compile(bit, 2);
                }
                catch (Throwable e) {}
                continue;
            }
            if (!bit.contains("|") || bit.contains("tag:")) continue;
            try {
                if (RegExUtil.mightBeEvil(bit)) continue;
                bit_patterns[i] = Pattern.compile(bit, 2);
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        HashMap<String, RelatedContentManager.DownloadInfo> result = new HashMap<String, RelatedContentManager.DownloadInfo>();
        Iterator<RelatedContentManager.DownloadInfo> it1 = this.getDHTInfos().iterator();
        Object e = this.manager.rcm_lock;
        synchronized (e) {
            it2 = new ArrayList<RelatedContentManager.DownloadInfo>(RelatedContentManager.transient_info_cache.values()).iterator();
        }
        Iterator<RelatedContentManager.DownloadInfo> it3 = this.manager.getRelatedContentAsList().iterator();
        Iterator[] arr$ = new Iterator[]{it1, it2, it3};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Iterator _it;
            Iterator it = _it = arr$[i$];
            while (it.hasNext()) {
                RelatedContentManager.DownloadInfo c = (RelatedContentManager.DownloadInfo)it.next();
                String title = c.getTitle();
                String lc_title = c.getTitle().toLowerCase();
                boolean match = true;
                boolean at_least_one = false;
                if (title.equalsIgnoreCase(term) && term.trim().length() > 0) {
                    at_least_one = true;
                } else {
                    for (int i = 0; i < bits.length; ++i) {
                        boolean hit;
                        String bit = bits[i];
                        if (bit.length() <= 0) continue;
                        if (bit_patterns[i] == null) {
                            String[] sub_bits = bit.split("\\|");
                            hit = false;
                            for (String sub_bit : sub_bits) {
                                if (sub_bit.startsWith("tag:")) {
                                    String[] tags = c.getTags();
                                    hit = false;
                                    if (tags != null && tags.length > 0) {
                                        String target_tag = sub_bit.substring(4).toLowerCase(Locale.US);
                                        target_tag = this.unescapeTag(target_tag);
                                        target_tag = this.manager.truncateTag(target_tag);
                                        for (String t : tags) {
                                            if (!t.startsWith(target_tag)) continue;
                                            hit = true;
                                            break;
                                        }
                                    }
                                } else {
                                    hit = lc_title.contains(sub_bit);
                                }
                                if (!hit) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            hit = bit_patterns[i].matcher(lc_title).find();
                        }
                        int type = bit_types[i];
                        if (hit) {
                            if (type == 2) {
                                match = false;
                                break;
                            }
                            at_least_one = true;
                            continue;
                        }
                        if (type == 2) {
                            at_least_one = true;
                            continue;
                        }
                        match = false;
                        break;
                    }
                }
                if (!match || !at_least_one) continue;
                byte[] hash = c.getHash();
                String key = hash != null ? Base32.encode(hash) : this.manager.getPrivateInfoKey(c);
                result.put(key, c);
            }
        }
        return new ArrayList<RelatedContent>(result.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DistributedDatabaseContact> sendRemoteSearch(SearchInstance si, Set<String> hashes_sync_me, DistributedDatabaseContact contact, String term, SearchObserver observer) {
        try {
            HashMap<String, String> request2 = new HashMap<String, String>();
            request2.put("t", term);
            DistributedDatabaseKey key = this.ddb.createKey(BEncoder.encode(request2));
            DistributedDatabaseValue value = contact.read(new DistributedDatabaseProgressListener(){

                public void reportSize(long size) {
                }

                public void reportActivity(String str) {
                }

                public void reportCompleteness(int percent) {
                }
            }, this.transfer_type, key, contact.getAddress().isUnresolved() ? 20000L : 10000L);
            if (value == null) {
                return null;
            }
            Map<String, Object> reply = BDecoder.decode((byte[])value.getValue(byte[].class));
            List list = (List)reply.get("l");
            if (list != null) {
                for (final Map map : list) {
                    final String title = ImportExportUtils.importString(map, "n");
                    final byte[] hash = (byte[])map.get("h");
                    if (hash == null) continue;
                    String hash_str = Base32.encode(hash);
                    Set<String> set = hashes_sync_me;
                    synchronized (set) {
                        if (hashes_sync_me.contains(hash_str)) {
                            continue;
                        }
                        hashes_sync_me.add(hash_str);
                    }
                    SearchResult result = new SearchResult(){

                        public Object getProperty(int property_name) {
                            try {
                                if (property_name == 1) {
                                    return title;
                                }
                                if (property_name == 3) {
                                    return ImportExportUtils.importLong(map, "s");
                                }
                                if (property_name == 21) {
                                    return hash;
                                }
                                if (property_name == 17) {
                                    return ImportExportUtils.importLong(map, "r") / 4L;
                                }
                                if (property_name == 6) {
                                    long cnet = ImportExportUtils.importLong(map, "c", -1L);
                                    if (cnet == -1L) {
                                        return 0L;
                                    }
                                    return 1L;
                                }
                                if (property_name == 5) {
                                    return ImportExportUtils.importLong(map, "z");
                                }
                                if (property_name == 4) {
                                    return ImportExportUtils.importLong(map, "l");
                                }
                                if (property_name == 2) {
                                    long date = ImportExportUtils.importLong(map, "p", 0L) * 60L * 60L * 1000L;
                                    if (date <= 0L) {
                                        return null;
                                    }
                                    return new Date(date);
                                }
                                if (property_name == 12 || property_name == 16) {
                                    byte[] hash2 = (byte[])map.get("h");
                                    if (hash2 != null) {
                                        return UrlUtils.getMagnetURI(hash2, title, RelatedContentManager.convertNetworks((byte)ImportExportUtils.importLong(map, "o", 1L)));
                                    }
                                } else {
                                    if (property_name == 50000) {
                                        long cnet = ImportExportUtils.importLong(map, "c", -1L);
                                        return cnet;
                                    }
                                    if (property_name == 50001) {
                                        return map.get("k");
                                    }
                                    if (property_name == 50002) {
                                        return map.get("w");
                                    }
                                    if (property_name == 50003) {
                                        return RelatedContentSearcher.this.manager.decodeTags((byte[])map.get("g"));
                                    }
                                    if (property_name == 50004) {
                                        return RelatedContentManager.convertNetworks((byte)ImportExportUtils.importLong(map, "o", 1L));
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return null;
                        }
                    };
                    observer.resultReceived(si, result);
                }
            }
            list = (List)reply.get("c");
            ArrayList<DistributedDatabaseContact> contacts = new ArrayList<DistributedDatabaseContact>();
            if (list != null) {
                for (Map m : list) {
                    try {
                        Map map = (Map)m.get("m");
                        if (map != null) {
                            DistributedDatabaseContact ddb_contact = this.ddb.importContact(map);
                            contacts.add(ddb_contact);
                            continue;
                        }
                        String host = ImportExportUtils.importString(m, "a");
                        int port = ImportExportUtils.importInt(m, "p");
                        DistributedDatabaseContact ddb_contact = this.ddb.importContact(new InetSocketAddress(InetAddress.getByName(host), port), DHTTransportUDP.PROTOCOL_VERSION_MIN, contact.getDHT());
                        contacts.add(ddb_contact);
                    }
                    catch (Throwable e) {}
                }
            }
            return contacts;
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected BloomFilter sendRemoteFetch(DistributedDatabaseContact contact) {
        try {
            Map<String, Object> reply;
            Map m;
            HashMap<String, String> request2 = new HashMap<String, String>();
            request2.put("x", "f");
            DistributedDatabaseKey key = this.ddb.createKey(BEncoder.encode(request2));
            DistributedDatabaseValue value = contact.read(new DistributedDatabaseProgressListener(){

                public void reportSize(long size) {
                }

                public void reportActivity(String str) {
                }

                public void reportCompleteness(int percent) {
                }
            }, this.transfer_type, key, contact.getAddress().isUnresolved() ? 15000L : 5000L);
            if (value != null && (m = (Map)(reply = BDecoder.decode((byte[])value.getValue(byte[].class))).get("f")) != null) {
                return BloomFilterFactory.deserialiseFromMap(m);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected BloomFilter sendRemoteUpdate(ForeignBloom f_bloom) {
        try {
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("x", "u");
            request2.put("s", new Long(f_bloom.getFilter().getEntryCount()));
            DistributedDatabaseKey key = this.ddb.createKey(BEncoder.encode(request2));
            DistributedDatabaseContact contact = f_bloom.getContact();
            DistributedDatabaseValue value = contact.read(new DistributedDatabaseProgressListener(){

                public void reportSize(long size) {
                }

                public void reportActivity(String str) {
                }

                public void reportCompleteness(int percent) {
                }
            }, this.transfer_type, key, contact.getAddress().isUnresolved() ? 15000L : 5000L);
            if (value != null) {
                Map<String, Object> reply = BDecoder.decode((byte[])value.getValue(byte[].class));
                Map m = (Map)reply.get("f");
                if (m != null) {
                    RelatedContentSearcher.logSearch("Bloom for " + f_bloom.getContact().getAddress() + " updated");
                    return BloomFilterFactory.deserialiseFromMap(m);
                }
                if (reply.containsKey("s")) {
                    RelatedContentSearcher.logSearch("Bloom for " + f_bloom.getContact().getAddress() + " same size");
                } else {
                    RelatedContentSearcher.logSearch("Bloom for " + f_bloom.getContact().getAddress() + " update not supported yet");
                }
                return f_bloom.getFilter();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RelatedContentSearcher.logSearch("Bloom for " + f_bloom.getContact().getAddress() + " update failed");
        return null;
    }

    protected Map<String, Object> receiveRemoteRequest(DistributedDatabaseContact originator, Map<String, Object> request2) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String req_type;
            boolean originator_is_neighbour = false;
            DHTPluginInterface.DHTInterface[] dhts = this.dht_plugin.getDHTInterfaces();
            byte[] originator_id = originator.getID();
            byte[] originator_bytes = AddressUtils.getAddressBytes(originator.getAddress());
            for (DHTPluginInterface.DHTInterface d : dhts) {
                List<DHTPluginContact> contacts = d.getClosestContacts(d.getID(), true);
                for (DHTPluginContact dHTPluginContact : contacts) {
                    if (!Arrays.equals(dHTPluginContact.getID(), originator_id)) continue;
                    originator_is_neighbour = true;
                    break;
                }
                if (originator_is_neighbour) break;
            }
            if ((req_type = ImportExportUtils.importString(request2, "x")) != null) {
                boolean dup = this.harvest_op_requester_bloom.contains(originator_bytes);
                RelatedContentSearcher.logSearch("Received remote request: " + BDecoder.decodeStrings(request2) + " from " + originator.getAddress() + "/" + originator.getDHT() + ", dup=" + dup + ", bs=" + this.harvest_op_requester_bloom.getEntryCount());
                if (!dup) {
                    BloomFilter filter2;
                    this.harvest_op_requester_bloom.add(originator_bytes);
                    if (req_type.equals("f")) {
                        BloomFilter filter3 = this.getKeyBloom(!originator_is_neighbour);
                        if (filter3 != null) {
                            response.put("f", filter3.serialiseToMap());
                        }
                    } else if (req_type.equals("u") && (filter2 = this.getKeyBloom(!originator_is_neighbour)) != null) {
                        int existing_size = ImportExportUtils.importInt(request2, "s", 0);
                        if (existing_size != filter2.getEntryCount()) {
                            response.put("f", filter2.serialiseToMap());
                        } else {
                            response.put("s", new Long(existing_size));
                        }
                    }
                }
            } else {
                int hits = this.harvest_se_requester_bloom.count(originator_bytes);
                String term = ImportExportUtils.importString(request2, "t");
                term = this.fixupTerm(term);
                RelatedContentSearcher.logSearch("Received remote search: '" + term + "' from " + originator.getAddress() + ", hits=" + hits + ", bs=" + this.harvest_se_requester_bloom.getEntryCount());
                if (hits < 10) {
                    this.harvest_se_requester_bloom.add(originator_bytes);
                    if (term != null) {
                        List<RelatedContent> matches = this.matchContent(term);
                        if (matches.size() > 30) {
                            Collections.sort(matches, new Comparator<RelatedContent>(){

                                @Override
                                public int compare(RelatedContent o1, RelatedContent o2) {
                                    return o2.getRank() - o1.getRank();
                                }
                            });
                        }
                        ArrayList l_list = new ArrayList();
                        for (int i = 0; i < Math.min(matches.size(), 30); ++i) {
                            byte nets;
                            String[] tags;
                            byte[] ws_keys;
                            byte[] tracker_keys;
                            RelatedContent relatedContent = matches.get(i);
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            l_list.add(map);
                            ImportExportUtils.exportString(map, "n", relatedContent.getTitle());
                            ImportExportUtils.exportLong(map, "s", relatedContent.getSize());
                            ImportExportUtils.exportLong(map, "r", relatedContent.getRank());
                            ImportExportUtils.exportLong(map, "d", relatedContent.getLastSeenSecs());
                            ImportExportUtils.exportLong(map, "p", relatedContent.getPublishDate() / 3600000L);
                            ImportExportUtils.exportLong(map, "l", relatedContent.getLeechers());
                            ImportExportUtils.exportLong(map, "z", relatedContent.getSeeds());
                            ImportExportUtils.exportLong(map, "c", relatedContent.getContentNetwork());
                            byte[] hash = relatedContent.getHash();
                            if (hash != null) {
                                map.put("h", hash);
                            }
                            if ((tracker_keys = relatedContent.getTrackerKeys()) != null) {
                                map.put("k", tracker_keys);
                            }
                            if ((ws_keys = relatedContent.getWebSeedKeys()) != null) {
                                map.put("w", ws_keys);
                            }
                            if ((tags = relatedContent.getTags()) != null) {
                                map.put("g", this.manager.encodeTags(tags));
                            }
                            if ((nets = relatedContent.getNetworksInternal()) == 0 || nets == 1) continue;
                            map.put("o", new Long(nets & 0xFF));
                        }
                        response.put("l", l_list);
                        List<DistributedDatabaseContact> bloom_hits = this.searchForeignBlooms(term);
                        if (bloom_hits.size() > 0) {
                            ArrayList arrayList = new ArrayList();
                            for (DistributedDatabaseContact c : bloom_hits) {
                                HashMap<String, Object> m = new HashMap<String, Object>();
                                arrayList.add(m);
                                InetSocketAddress address = c.getAddress();
                                if (address.isUnresolved()) {
                                    m.put("m", c.exportToMap());
                                    continue;
                                }
                                m.put("a", address.getAddress().getHostAddress());
                                m.put("p", new Long(address.getPort()));
                            }
                            response.put("c", arrayList);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return response;
    }

    @Override
    public DistributedDatabaseValue read(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey ddb_key) throws DistributedDatabaseException {
        Object o_key = ddb_key.getKey();
        try {
            byte[] key = (byte[])o_key;
            Map<String, Object> request2 = BDecoder.decode(key);
            Map<String, Object> result = this.receiveRemoteRequest(contact, request2);
            return this.ddb.createValue(BEncoder.encode(result));
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    public DistributedDatabaseValue write(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key, DistributedDatabaseValue value) throws DistributedDatabaseException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkKeyBloom() {
        if (this.last_key_bloom_update == -1L || SystemTime.getMonotonousTime() - this.last_key_bloom_update > 600000L) {
            Object object = this.manager.rcm_lock;
            synchronized (object) {
                this.updateKeyBloom(this.manager.loadRelatedContent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BloomFilter getKeyBloom(boolean include_dht_local) {
        if (this.key_bloom_with_local == null) {
            Object object = this.manager.rcm_lock;
            synchronized (object) {
                this.updateKeyBloom(this.manager.loadRelatedContent());
            }
        }
        if (include_dht_local) {
            return this.key_bloom_with_local;
        }
        return this.key_bloom_without_local;
    }

    private List<String> getDHTWords(RelatedContentManager.DownloadInfo info) {
        String title = info.getTitle();
        title = title.toLowerCase(Locale.US);
        char[] chars = title.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetterOrDigit(chars[i])) continue;
            chars[i] = 32;
        }
        String[] words = new String(chars).split(" ");
        ArrayList<String> result = new ArrayList<String>(words.length);
        for (String word : words) {
            if (word.length() <= 0 || this.ignore_words.contains(word)) continue;
            result.add(word);
        }
        String[] tags = info.getTags();
        if (tags != null) {
            for (String tag : tags) {
                tag = this.escapeTag(tag);
                for (int i = 1; i <= tag.length(); ++i) {
                    result.add("tag:" + tag.substring(0, i));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateKeyBloom(RelatedContentManager.ContentCache cc) {
        Object object = this.manager.rcm_lock;
        synchronized (object) {
            HashSet<String> dht_only_words = new HashSet<String>();
            HashSet<String> non_dht_words = new HashSet<String>();
            List<RelatedContentManager.DownloadInfo> dht_infos = this.getDHTInfos();
            Iterator<RelatedContentManager.DownloadInfo> it_dht = dht_infos.iterator();
            Iterator<RelatedContentManager.DownloadInfo> it_transient = RelatedContentManager.transient_info_cache.values().iterator();
            Iterator<RelatedContentManager.DownloadInfo> it_rc = cc.related_content.values().iterator();
            Iterator[] arr$ = new Iterator[]{it_transient, it_rc, it_dht};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Iterator _it;
                Iterator it = _it = arr$[i$];
                while (it.hasNext()) {
                    RelatedContentManager.DownloadInfo di = (RelatedContentManager.DownloadInfo)it.next();
                    List<String> words = this.getDHTWords(di);
                    for (String word : words) {
                        if (it == it_dht) {
                            if (non_dht_words.contains(word)) continue;
                            dht_only_words.add(word);
                            continue;
                        }
                        non_dht_words.add(word);
                    }
                }
            }
            int all_desired_bits = (dht_only_words.size() + non_dht_words.size()) * 8;
            all_desired_bits = Math.max(all_desired_bits, 1000);
            all_desired_bits = Math.min(all_desired_bits, 50000);
            BloomFilter all_bloom = BloomFilterFactory.createAddOnly(all_desired_bits);
            int non_dht_desired_bits = non_dht_words.size() * 8;
            non_dht_desired_bits = Math.max(non_dht_desired_bits, 1000);
            non_dht_desired_bits = Math.min(non_dht_desired_bits, 50000);
            BloomFilter non_dht_bloom = BloomFilterFactory.createAddOnly(non_dht_desired_bits);
            ArrayList non_dht_words_rand = new ArrayList(non_dht_words);
            Collections.shuffle(non_dht_words_rand);
            for (String word : non_dht_words_rand) {
                try {
                    byte[] bytes = word.getBytes("UTF8");
                    all_bloom.add(bytes);
                    if (all_bloom.getEntryCount() >= 6250) break;
                    if (non_dht_bloom.getEntryCount() >= 6250) continue;
                    non_dht_bloom.add(bytes);
                }
                catch (Throwable e) {}
            }
            ArrayList dht_only_words_rand = new ArrayList(dht_only_words);
            Collections.shuffle(dht_only_words_rand);
            for (String word : dht_only_words_rand) {
                try {
                    byte[] bytes = word.getBytes("UTF8");
                    all_bloom.add(bytes);
                    if (all_bloom.getEntryCount() < 6250) continue;
                    break;
                }
                catch (Throwable e) {
                }
            }
            RelatedContentSearcher.logSearch("blooms=" + all_bloom.getSize() + "/" + all_bloom.getEntryCount() + ", " + non_dht_bloom.getSize() + "/" + non_dht_bloom.getEntryCount() + ": rcm=" + cc.related_content.size() + ", trans=" + RelatedContentManager.transient_info_cache.size() + ", dht=" + dht_infos.size());
            this.key_bloom_with_local = all_bloom;
            this.key_bloom_without_local = non_dht_bloom;
            this.last_key_bloom_update = SystemTime.getMonotonousTime();
        }
    }

    private List<RelatedContentManager.DownloadInfo> getDHTInfos() {
        List<DHTPluginValue> vals = this.dht_plugin.getValues();
        HashSet<String> unique_keys = new HashSet<String>();
        ArrayList<RelatedContentManager.DownloadInfo> dht_infos = new ArrayList<RelatedContentManager.DownloadInfo>();
        for (DHTPluginValue val : vals) {
            byte[] bytes;
            String test;
            if (val.isLocal() || !(test = new String(bytes = val.getValue())).startsWith("d1:d") || !test.endsWith("ee") || !test.contains("1:h20:")) continue;
            try {
                Map<String, Object> map = BDecoder.decode(bytes);
                RelatedContentManager.DownloadInfo info = this.manager.decodeInfo(map, null, 1, false, unique_keys);
                if (info == null) continue;
                dht_infos.add(info);
            }
            catch (Throwable e) {}
        }
        return dht_infos;
    }

    private void testKeyBloom() {
    }

    private void harvestBlooms() {
        this.harvest_dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                block39: {
                    if (RelatedContentSearcher.this.harvest_dispatcher.getQueueSize() > 0) {
                        return;
                    }
                    ForeignBloom oldest = null;
                    ByteArrayHashMap byteArrayHashMap = RelatedContentSearcher.this.harvested_blooms;
                    synchronized (byteArrayHashMap) {
                        for (ForeignBloom bloom : RelatedContentSearcher.this.harvested_blooms.values()) {
                            if (oldest != null && bloom.getLastUpdateTime() >= oldest.getLastUpdateTime()) continue;
                            oldest = bloom;
                        }
                    }
                    long now = SystemTime.getMonotonousTime();
                    if (oldest != null && now - oldest.getLastUpdateTime() > 900000L) {
                        DistributedDatabaseContact ddb_contact = oldest.getContact();
                        if (now - oldest.getCreateTime() > 3600000L && RelatedContentSearcher.this.harvested_blooms.size() >= 25) {
                            RelatedContentSearcher.logSearch("Harvest: discarding " + ddb_contact.getAddress());
                            ByteArrayHashMap byteArrayHashMap2 = RelatedContentSearcher.this.harvested_blooms;
                            synchronized (byteArrayHashMap2) {
                                RelatedContentSearcher.this.harvested_blooms.remove(ddb_contact.getID());
                            }
                        } else {
                            BloomFilter updated_filter = RelatedContentSearcher.this.sendRemoteUpdate(oldest);
                            if (updated_filter == null) {
                                ByteArrayHashMap byteArrayHashMap3 = RelatedContentSearcher.this.harvested_blooms;
                                synchronized (byteArrayHashMap3) {
                                    RelatedContentSearcher.this.harvested_blooms.remove(ddb_contact.getID());
                                    RelatedContentSearcher.this.harvested_fails.put(ddb_contact.getID(), "");
                                }
                            } else {
                                oldest.updateFilter(updated_filter);
                            }
                        }
                    }
                    if (RelatedContentSearcher.this.harvested_blooms.size() < 50) {
                        try {
                            DHTPluginInterface.DHTInterface[] dhts;
                            int fail_count = 0;
                            for (DHTPluginInterface.DHTInterface dht : dhts = RelatedContentSearcher.this.dht_plugin.getDHTInterfaces()) {
                                if (dht.isIPV6()) continue;
                                int network = dht.getNetwork();
                                if (SEARCH_CVS_ONLY && network != 1) {
                                    RelatedContentSearcher.logSearch("Harvest: ignoring main DHT");
                                    continue;
                                }
                                DHTPluginContact[] contacts = dht.getReachableContacts();
                                byte[] dht_id = dht.getID();
                                for (DHTPluginContact contact : contacts) {
                                    ByteArrayHashMap byteArrayHashMap4;
                                    byte[] contact_id = contact.getID();
                                    if (Arrays.equals(dht_id, contact_id)) continue;
                                    DistributedDatabaseContact ddb_contact = RelatedContentSearcher.this.importContact(contact, network);
                                    ByteArrayHashMap byteArrayHashMap5 = RelatedContentSearcher.this.harvested_blooms;
                                    synchronized (byteArrayHashMap5) {
                                        if (RelatedContentSearcher.this.harvested_fails.containsKey(contact_id)) {
                                            continue;
                                        }
                                        if (RelatedContentSearcher.this.harvested_blooms.containsKey(contact_id)) {
                                            continue;
                                        }
                                    }
                                    BloomFilter filter2 = RelatedContentSearcher.this.sendRemoteFetch(ddb_contact);
                                    RelatedContentSearcher.logSearch("harvest: " + contact.getString() + " -> " + (filter2 == null ? "null" : filter2.getString()));
                                    if (filter2 != null) {
                                        byteArrayHashMap4 = RelatedContentSearcher.this.harvested_blooms;
                                        synchronized (byteArrayHashMap4) {
                                            RelatedContentSearcher.this.harvested_blooms.put(contact_id, new ForeignBloom(ddb_contact, filter2));
                                            break block39;
                                        }
                                    }
                                    byteArrayHashMap4 = RelatedContentSearcher.this.harvested_blooms;
                                    synchronized (byteArrayHashMap4) {
                                        RelatedContentSearcher.this.harvested_fails.put(contact_id, "");
                                    }
                                    if (++fail_count <= 5) {
                                        continue;
                                    }
                                    break block39;
                                }
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                ByteArrayHashMap byteArrayHashMap = RelatedContentSearcher.this.harvested_blooms;
                synchronized (byteArrayHashMap) {
                    if (RelatedContentSearcher.this.harvested_fails.size() > 128) {
                        RelatedContentSearcher.this.harvested_fails.clear();
                    }
                }
            }
        });
    }

    private DistributedDatabaseContact importContact(DHTPluginContact contact, int network) throws DistributedDatabaseException {
        InetSocketAddress address = contact.getAddress();
        if (address.isUnresolved()) {
            return this.ddb.importContact(contact.exportToMap());
        }
        return this.ddb.importContact(address, DHTTransportUDP.PROTOCOL_VERSION_MIN, network == 1 ? 2 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void foreignBloomFailed(DistributedDatabaseContact contact) {
        byte[] contact_id = contact.getID();
        ByteArrayHashMap<ForeignBloom> byteArrayHashMap = this.harvested_blooms;
        synchronized (byteArrayHashMap) {
            if (this.harvested_blooms.remove(contact_id) != null) {
                this.harvested_fails.put(contact_id, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DistributedDatabaseContact> searchForeignBlooms(String term) {
        ArrayList<DistributedDatabaseContact> result = new ArrayList<DistributedDatabaseContact>();
        try {
            String[] bits = Constants.PAT_SPLIT_SPACE.split(term.toLowerCase());
            int[] bit_types = new int[bits.length];
            byte[][] bit_bytes = new byte[bit_types.length][];
            byte[][][] extras = new byte[bit_types.length][][];
            for (int i = 0; i < bits.length; ++i) {
                String bit = bits[i].trim();
                if (bit.length() <= 0) continue;
                char c = bit.charAt(0);
                if (c == '+') {
                    bit_types[i] = 1;
                    bit = bit.substring(1);
                } else if (c == '-') {
                    bit_types[i] = 2;
                    bit = bit.substring(1);
                }
                if (bit.startsWith("(") && bit.endsWith(")")) {
                    bit_types[i] = 3;
                } else if (bit.contains("|")) {
                    String[] parts = bit.split("\\|");
                    ArrayList<String> p = new ArrayList<String>();
                    for (String part : parts) {
                        if ((part = part.trim()).length() <= 0) continue;
                        p.add(part);
                    }
                    if (p.size() == 0) {
                        bit_types[i] = 3;
                    } else {
                        bit_types[i] = 4;
                        extras[i] = new byte[p.size()][];
                        for (int j = 0; j < p.size(); ++j) {
                            extras[i][j] = ((String)p.get(j)).getBytes("UTF8");
                        }
                    }
                }
                bit_bytes[i] = bit.getBytes("UTF8");
            }
            ByteArrayHashMap<ForeignBloom> byteArrayHashMap = this.harvested_blooms;
            synchronized (byteArrayHashMap) {
                for (ForeignBloom fb : this.harvested_blooms.values()) {
                    BloomFilter filter2 = fb.getFilter();
                    boolean failed = false;
                    int matches = 0;
                    for (int i = 0; i < bit_bytes.length; ++i) {
                        int type;
                        byte[] bit = bit_bytes[i];
                        if (bit == null || bit.length == 0 || (type = bit_types[i]) == 3) continue;
                        if (type == 0 || type == 1) {
                            if (filter2.contains(bit)) {
                                ++matches;
                                continue;
                            }
                            failed = true;
                            break;
                        }
                        if (type == 2) {
                            if (!filter2.contains(bit)) {
                                ++matches;
                                continue;
                            }
                            failed = true;
                            break;
                        }
                        if (type != 4) continue;
                        byte[][] parts = extras[i];
                        int old_matches = matches;
                        for (byte[] p : parts) {
                            if (!filter2.contains(p)) continue;
                            ++matches;
                            break;
                        }
                        if (matches != old_matches) continue;
                        failed = true;
                        break;
                    }
                    if (matches <= 0 || failed) continue;
                    result.add(fb.getContact());
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Debug.out(e);
        }
        return result;
    }

    private static void logSearch(String str) {
    }

    static /* synthetic */ List access$100(RelatedContentSearcher x0, String x1) {
        return x0.searchForeignBlooms(x1);
    }

    static /* synthetic */ DistributedDatabase access$200(RelatedContentSearcher x0) {
        return x0.ddb;
    }

    private static class ForeignBloom {
        private DistributedDatabaseContact contact;
        private BloomFilter filter;
        private long created;
        private long last_update;

        private ForeignBloom(DistributedDatabaseContact _contact, BloomFilter _filter) {
            this.contact = _contact;
            this.filter = _filter;
            this.last_update = this.created = SystemTime.getMonotonousTime();
        }

        public DistributedDatabaseContact getContact() {
            return this.contact;
        }

        public BloomFilter getFilter() {
            return this.filter;
        }

        public long getCreateTime() {
            return this.created;
        }

        public long getLastUpdateTime() {
            return this.last_update;
        }

        public void updateFilter(BloomFilter f) {
            this.filter = f;
            this.last_update = SystemTime.getMonotonousTime();
        }
    }

    private static class MySearchObserver
    implements SearchObserver {
        private SearchObserver observer;
        private AtomicInteger num_results = new AtomicInteger();

        private MySearchObserver(SearchObserver _observer) {
            this.observer = _observer;
        }

        public void resultReceived(SearchInstance search, SearchResult result) {
            this.observer.resultReceived(search, result);
            RelatedContentSearcher.logSearch("results=" + this.num_results.incrementAndGet());
        }

        private int getResultCount() {
            return this.num_results.get();
        }

        public void complete() {
            this.observer.complete();
        }

        public void cancelled() {
            this.observer.cancelled();
        }

        public Object getProperty(int property) {
            return this.observer.getProperty(property);
        }

        static /* synthetic */ int access$700(MySearchObserver x0) {
            return x0.getResultCount();
        }
    }
}

