/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.impl.DateParser;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.lang.Entities;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;

public class WebResult
extends Result {
    String searchQuery;
    String rootPageURL;
    String basePageURL;
    DateParser dateParser;
    String contentType = "";
    String name;
    String category = "";
    String drmKey = null;
    Date publishedDate;
    long size = -1L;
    int nbPeers = -1;
    int nbSeeds = -1;
    int nbSuperSeeds = -1;
    int comments = -1;
    int votes = -1;
    int votesDown = -1;
    float rank = -1.0f;
    boolean privateTorrent;
    String cdpLink;
    String torrentLink;
    String downloadButtonLink;
    String playLink;
    String uid;
    String hash;

    public WebResult(Engine engine, String rootPageURL, String basePageURL, DateParser dateParser, String searchQuery) {
        super(engine);
        this.rootPageURL = rootPageURL;
        this.basePageURL = basePageURL;
        this.dateParser = dateParser;
        this.searchQuery = searchQuery;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public void setNameFromHTML(String name) {
        if (name != null) {
            name = WebResult.removeHTMLTags(name);
            this.name = Entities.HTML40.unescape(name);
        }
    }

    public void setCommentsFromHTML(String comments) {
        if (comments != null) {
            comments = WebResult.removeHTMLTags(comments);
            comments = Entities.HTML40.unescape(comments);
            comments = comments.replaceAll(",", "");
            comments = comments.replaceAll(" ", "");
            try {
                this.comments = Integer.parseInt(comments);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setCategoryFromHTML(String category) {
        if (category != null) {
            category = WebResult.removeHTMLTags(category);
            this.category = Entities.HTML40.unescape(category).trim();
        }
    }

    public void setUID(String _uid) {
        this.uid = _uid;
    }

    public String getUID() {
        return this.uid;
    }

    public void setNbPeersFromHTML(String nbPeers) {
        if (nbPeers != null) {
            nbPeers = WebResult.removeHTMLTags(nbPeers);
            String nbPeersS = Entities.HTML40.unescape(nbPeers);
            nbPeersS = nbPeersS.replaceAll(",", "");
            nbPeersS = nbPeersS.replaceAll(" ", "");
            try {
                this.nbPeers = Integer.parseInt(nbPeersS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setNbSeedsFromHTML(String nbSeeds) {
        if (nbSeeds != null) {
            nbSeeds = WebResult.removeHTMLTags(nbSeeds);
            String nbSeedsS = Entities.HTML40.unescape(nbSeeds);
            nbSeedsS = nbSeedsS.replaceAll(",", "");
            nbSeedsS = nbSeedsS.replaceAll(" ", "");
            try {
                this.nbSeeds = Integer.parseInt(nbSeedsS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setNbSuperSeedsFromHTML(String nbSuperSeeds) {
        if (nbSuperSeeds != null) {
            nbSuperSeeds = WebResult.removeHTMLTags(nbSuperSeeds);
            String nbSuperSeedsS = Entities.HTML40.unescape(nbSuperSeeds);
            nbSuperSeedsS = nbSuperSeedsS.replaceAll(",", "");
            nbSuperSeedsS = nbSuperSeedsS.replaceAll(" ", "");
            try {
                this.nbSuperSeeds = Integer.parseInt(nbSuperSeedsS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setRankFromHTML(String rank_str, float divisor) {
        if (rank_str == null) {
            return;
        }
        try {
            float f = Float.parseFloat(rank_str.trim());
            this.rank = f / divisor;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setRankFromHTML(String rank_str) {
        if (rank_str != null) {
            try {
                float f = Float.parseFloat(rank_str.trim());
                if (rank_str.indexOf(".") == -1) {
                    if (f >= 0.0f && f <= 100.0f) {
                        this.rank = f / 100.0f;
                    }
                } else if (f >= 0.0f && f <= 1.0f) {
                    this.rank = f;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public float getRank() {
        if (this.rank != -1.0f) {
            return this.applyRankBias(this.rank);
        }
        return super.getRank();
    }

    public void setPublishedDate(Date date) {
        this.publishedDate = date;
    }

    public void setPublishedDateFromHTML(String publishedDate) {
        if (publishedDate != null) {
            publishedDate = WebResult.removeHTMLTags(publishedDate);
            String publishedDateS = Entities.HTML40.unescape(publishedDate).replace('\u00a0', ' ');
            this.publishedDate = this.dateParser.parseDate(publishedDateS);
        }
    }

    public void setSizeFromHTML(String size) {
        if (size != null) {
            size = WebResult.removeHTMLTags(size);
            String sizeS = Entities.HTML40.unescape(size).replace('\u00a0', ' ');
            sizeS = sizeS.replaceAll("<[^>]+>", " ");
            sizeS = sizeS.replaceFirst("(\\d)([a-zA-Z])", "$1 $2");
            try {
                StringTokenizer st = new StringTokenizer(sizeS, " ");
                double base = Double.parseDouble(st.nextToken());
                String unit = "b";
                try {
                    unit = st.nextToken().toLowerCase();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                long multiplier = 1L;
                long KB_UNIT = 1024L;
                long KIB_UNIT = 1024L;
                if ("mb".equals(unit)) {
                    multiplier = KB_UNIT * KB_UNIT;
                } else if ("mib".equals(unit)) {
                    multiplier = KIB_UNIT * KIB_UNIT;
                } else if ("m".equals(unit)) {
                    multiplier = KIB_UNIT * KIB_UNIT;
                } else if ("gb".equals(unit)) {
                    multiplier = KB_UNIT * KB_UNIT * KB_UNIT;
                } else if ("gib".equals(unit)) {
                    multiplier = KIB_UNIT * KIB_UNIT * KIB_UNIT;
                } else if ("g".equals(unit)) {
                    multiplier = KIB_UNIT * KIB_UNIT * KIB_UNIT;
                } else if ("kb".equals(unit)) {
                    multiplier = KB_UNIT;
                } else if ("kib".equals(unit)) {
                    multiplier = KIB_UNIT;
                } else if ("k".equals(unit)) {
                    multiplier = KIB_UNIT;
                }
                this.size = (long)(base * (double)multiplier);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setVotesFromHTML(String votes_str) {
        if (votes_str != null) {
            votes_str = WebResult.removeHTMLTags(votes_str);
            votes_str = Entities.HTML40.unescape(votes_str);
            votes_str = votes_str.replaceAll(",", "");
            votes_str = votes_str.replaceAll(" ", "");
            try {
                this.votes = Integer.parseInt(votes_str);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setVotesDownFromHTML(String votes_str) {
        if (votes_str != null) {
            votes_str = WebResult.removeHTMLTags(votes_str);
            votes_str = Entities.HTML40.unescape(votes_str);
            votes_str = votes_str.replaceAll(",", "");
            votes_str = votes_str.replaceAll(" ", "");
            try {
                this.votesDown = Integer.parseInt(votes_str);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setPrivateFromHTML(String privateTorrent) {
        if (privateTorrent != null && !"".equals(privateTorrent)) {
            this.privateTorrent = true;
        }
    }

    public int getVotes() {
        return this.votes;
    }

    public int getVotesDown() {
        return this.votesDown;
    }

    public void setCDPLink(String cdpLink) {
        this.cdpLink = UrlUtils.unescapeXML(cdpLink);
    }

    public void setDownloadButtonLink(String downloadButtonLink) {
        this.downloadButtonLink = UrlUtils.unescapeXML(downloadButtonLink);
    }

    public void setTorrentLink(String torrentLink) {
        this.torrentLink = UrlUtils.unescapeXML(torrentLink);
    }

    public void setPlayLink(String playLink) {
        this.playLink = playLink;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getPlayLink() {
        return this.reConstructLink(this.playLink);
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDrmKey(String drmKey) {
        this.drmKey = drmKey;
    }

    public void setHash(String _hash) {
        try {
            this.hash = _hash.trim();
            if (this.hash.length() != 32) {
                this.hash = this.hash.length() == 40 ? Base32.encode(ByteFormatter.decodeString(this.hash)) : null;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.hash = null;
        }
        if (this.hash != null && this.downloadButtonLink == null) {
            this.setDownloadButtonLink(UrlUtils.normaliseMagnetURI(this.hash));
        }
        if (this.hash != null && this.torrentLink == null) {
            this.setTorrentLink(UrlUtils.normaliseMagnetURI(this.hash));
        }
    }

    public String getHash() {
        return this.hash;
    }

    public String getCDPLink() {
        return this.reConstructLink(this.cdpLink);
    }

    public String getCategory() {
        return this.category;
    }

    public String getDownloadLink() {
        return this.reConstructLink(this.torrentLink);
    }

    public String getDownloadButtonLink() {
        if (this.downloadButtonLink != null) {
            return this.reConstructLink(this.downloadButtonLink);
        }
        return this.getDownloadLink();
    }

    private String reConstructLink(String link) {
        if (link != null) {
            String lc_link = link.toLowerCase();
            if (lc_link.startsWith("http://") || lc_link.startsWith("https://") || lc_link.startsWith("tor:http://") || lc_link.startsWith("tor:https://") || lc_link.startsWith("azplug:") || lc_link.startsWith("magnet:") || lc_link.startsWith("bc:") || lc_link.startsWith("bctp:") || lc_link.startsWith("dht:")) {
                return link;
            }
            if (link.startsWith("/")) {
                return (this.rootPageURL == null ? "" : this.rootPageURL) + link;
            }
            return (this.basePageURL == null ? "" : this.basePageURL) + link;
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    public int getNbPeers() {
        return this.nbPeers;
    }

    public int getNbSeeds() {
        return this.nbSeeds;
    }

    public int getNbSuperSeeds() {
        return this.nbSuperSeeds;
    }

    public Date getPublishedDate() {
        return this.publishedDate;
    }

    public long getSize() {
        return this.size;
    }

    public int getComments() {
        return this.comments;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public boolean isPrivate() {
        return this.privateTorrent;
    }

    public String getDRMKey() {
        return this.drmKey;
    }

    public float getAccuracy() {
        return -1.0f;
    }
}

