/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportStartpoint;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProxyLoginHandler;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportStartpointTCP;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;

public class TCPTransportImpl
extends TransportImpl
implements Transport {
    private static final LogIDs LOGID = LogIDs.NET;
    private final ProtocolEndpointTCP protocol_endpoint;
    private TCPConnectionManager.ConnectListener connect_request_key = null;
    private String description = "<disconnected>";
    private final boolean is_inbound_connection;
    private int transport_mode = 0;
    public volatile boolean has_been_closed = false;
    private boolean connect_with_crypto;
    private byte[][] shared_secrets;
    private int fallback_count;
    private final boolean fallback_allowed;
    private boolean is_socks;
    private volatile AEProxyFactory.PluginProxy plugin_proxy;

    public TCPTransportImpl(ProtocolEndpointTCP endpoint, boolean use_crypto, boolean allow_fallback, byte[][] _shared_secrets) {
        this.protocol_endpoint = endpoint;
        this.is_inbound_connection = false;
        this.connect_with_crypto = use_crypto;
        this.shared_secrets = _shared_secrets;
        this.fallback_allowed = allow_fallback;
    }

    public TCPTransportImpl(ProtocolEndpointTCP endpoint, TransportHelperFilter filter2) {
        this.protocol_endpoint = endpoint;
        this.setFilter(filter2);
        this.is_inbound_connection = true;
        this.connect_with_crypto = false;
        this.fallback_allowed = false;
        InetSocketAddress address = endpoint.getAddress();
        this.description = (this.is_inbound_connection ? "R" : "L") + ": " + AddressUtils.getHostNameNoResolve(address) + ": " + address.getPort();
    }

    public SocketChannel getSocketChannel() {
        TransportHelperFilter filter2 = this.getFilter();
        if (filter2 == null) {
            return null;
        }
        TCPTransportHelper helper = (TCPTransportHelper)filter2.getHelper();
        if (helper == null) {
            return null;
        }
        return helper.getSocketChannel();
    }

    public TransportEndpointTCP getTransportEndpoint() {
        return new TransportEndpointTCP(this.protocol_endpoint, this.getSocketChannel());
    }

    public TransportStartpoint getTransportStartpoint() {
        return new TransportStartpointTCP(this.getTransportEndpoint());
    }

    public int getMssSize() {
        return TCPNetworkManager.getTcpMssSize();
    }

    public boolean isTCP() {
        return true;
    }

    public boolean isSOCKS() {
        return this.is_socks;
    }

    public String getProtocol() {
        if (this.is_socks) {
            return "TCP (SOCKS)";
        }
        return "TCP";
    }

    public String getDescription() {
        return this.description;
    }

    public void connectOutbound(final ByteBuffer initial_data, final Transport.ConnectListener listener, final int priority) {
        TCPConnectionManager.ConnectListener connect_listener;
        AEProxyFactory.PluginProxy pp;
        if (!TCPNetworkManager.TCP_OUTGOING_ENABLED) {
            listener.connectFailure(new Throwable("Outbound TCP connections disabled"));
            return;
        }
        if (this.has_been_closed) {
            listener.connectFailure(new Throwable("Connection already closed"));
            return;
        }
        if (this.getFilter() != null) {
            Debug.out("socket_channel != null");
            listener.connectSuccess(this, initial_data);
            return;
        }
        final InetSocketAddress address = this.protocol_endpoint.getAddress();
        if (!address.equals(ProxyLoginHandler.DEFAULT_SOCKS_SERVER_ADDRESS)) {
            String host;
            if (address.isUnresolved() && AENetworkClassifier.categoriseAddress(host = address.getHostName()) != "Public") {
                HashMap<String, Object> opts = new HashMap<String, Object>();
                Object peer_nets = listener.getConnectionProperty("peer_networks");
                if (peer_nets != null) {
                    opts.put("peer_networks", peer_nets);
                }
                pp = this.plugin_proxy;
                this.plugin_proxy = null;
                if (pp != null) {
                    pp.setOK(true);
                }
                this.plugin_proxy = AEProxyFactory.getPluginProxy("outbound connection", host, address.getPort(), opts);
            }
            if (this.plugin_proxy == null) {
                this.is_socks = COConfigurationManager.getBooleanParameter("Proxy.Data.Enable");
            }
        }
        final TCPTransportImpl transport_instance = this;
        this.connect_request_key = connect_listener = new TCPConnectionManager.ConnectListener(){

            public int connectAttemptStarted(int default_connect_timeout) {
                return listener.connectAttemptStarted(default_connect_timeout);
            }

            public void connectSuccess(final SocketChannel channel2) {
                if (channel2 == null) {
                    String msg = "connectSuccess:: given channel == null";
                    Debug.out(msg);
                    TCPTransportImpl.this.setConnectResult(false);
                    listener.connectFailure(new Exception(msg));
                    return;
                }
                if (TCPTransportImpl.this.has_been_closed) {
                    TCPNetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(channel2);
                    TCPTransportImpl.this.setConnectResult(false);
                    listener.connectFailure(new Throwable("Connection has been closed"));
                    return;
                }
                TCPTransportImpl.this.connect_request_key = null;
                TCPTransportImpl.this.description = (TCPTransportImpl.this.is_inbound_connection ? "R" : "L") + ": " + channel2.socket().getInetAddress().getHostAddress() + ": " + channel2.socket().getPort();
                AEProxyFactory.PluginProxy pp = TCPTransportImpl.this.plugin_proxy;
                if (TCPTransportImpl.this.is_socks) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Socket connection established to proxy server [" + TCPTransportImpl.this.description + "], login initiated..."));
                    }
                    TCPTransportImpl.this.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(channel2));
                    new ProxyLoginHandler(transport_instance, address, new ProxyLoginHandler.ProxyListener(){

                        public void connectSuccess() {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "Proxy [" + TCPTransportImpl.this.description + "] login successful."));
                            }
                            TCPTransportImpl.this.handleCrypto(address, channel2, initial_data, priority, listener);
                        }

                        public void connectFailure(Throwable failure_msg) {
                            TCPTransportImpl.this.close("Proxy login failed");
                            listener.connectFailure(failure_msg);
                        }
                    });
                } else if (pp != null) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Socket connection established via plugin proxy [" + TCPTransportImpl.this.description + "], login initiated..."));
                    }
                    TCPTransportImpl.this.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(channel2));
                    String pp_host = pp.getHost();
                    InetSocketAddress ia_address = AENetworkClassifier.categoriseAddress(pp_host) == "Public" ? new InetSocketAddress(pp.getHost(), pp.getPort()) : InetSocketAddress.createUnresolved(pp_host, pp.getPort());
                    new ProxyLoginHandler(transport_instance, ia_address, new ProxyLoginHandler.ProxyListener(){

                        public void connectSuccess() {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "Proxy [" + TCPTransportImpl.this.description + "] login successful."));
                            }
                            TCPTransportImpl.this.setConnectResult(true);
                            TCPTransportImpl.this.handleCrypto(address, channel2, initial_data, priority, listener);
                        }

                        public void connectFailure(Throwable failure_msg) {
                            TCPTransportImpl.this.setConnectResult(false);
                            TCPTransportImpl.this.close("Proxy login failed");
                            listener.connectFailure(failure_msg);
                        }
                    }, "V4a", "", "");
                } else {
                    TCPTransportImpl.this.handleCrypto(address, channel2, initial_data, priority, listener);
                }
            }

            public void connectFailure(Throwable failure_msg) {
                TCPTransportImpl.this.connect_request_key = null;
                TCPTransportImpl.this.setConnectResult(false);
                listener.connectFailure(failure_msg);
            }
        };
        pp = this.plugin_proxy;
        InetSocketAddress to_connect = this.is_socks ? ProxyLoginHandler.getProxyAddress(address) : (pp != null ? (InetSocketAddress)pp.getProxy().address() : address);
        TCPNetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(to_connect, connect_listener, priority);
    }

    protected void handleCrypto(InetSocketAddress address, final SocketChannel channel2, final ByteBuffer initial_data, final int priority, final Transport.ConnectListener listener) {
        if (this.connect_with_crypto) {
            final TCPTransportHelper helper = new TCPTransportHelper(channel2);
            TransportCryptoManager.getSingleton().manageCrypto(helper, this.shared_secrets, false, initial_data, new TransportCryptoManager.HandshakeListener(){

                public void handshakeSuccess(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                    TransportHelperFilter filter2 = decoder.getFilter();
                    TCPTransportImpl.this.setFilter(filter2);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Outgoing TCP stream to " + channel2.socket().getRemoteSocketAddress() + " established, type = " + filter2.getName(false)));
                    }
                    TCPTransportImpl.this.connectedOutbound(remaining_initial_data, listener);
                }

                public void handshakeFailure(Throwable failure_msg) {
                    if (TCPTransportImpl.this.fallback_allowed && NetworkManager.OUTGOING_HANDSHAKE_FALLBACK_ALLOWED && !TCPTransportImpl.this.has_been_closed) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, TCPTransportImpl.this.description + " | crypto handshake failure [" + failure_msg.getMessage() + "], attempting non-crypto fallback."));
                        }
                        TCPTransportImpl.this.connect_with_crypto = false;
                        TCPTransportImpl.this.fallback_count++;
                        TCPTransportImpl.this.close(helper, "Handshake failure and retry");
                        TCPTransportImpl.this.has_been_closed = false;
                        if (initial_data != null) {
                            initial_data.position(0);
                        }
                        TCPTransportImpl.this.connectOutbound(initial_data, listener, priority);
                    } else {
                        TCPTransportImpl.this.close(helper, "Handshake failure");
                        listener.connectFailure(failure_msg);
                    }
                }

                public void gotSecret(byte[] session_secret) {
                }

                public int getMaximumPlainHeaderLength() {
                    throw new RuntimeException();
                }

                public int matchPlainHeader(ByteBuffer buffer) {
                    throw new RuntimeException();
                }
            });
        } else {
            this.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(channel2));
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Outgoing TCP stream to " + channel2.socket().getRemoteSocketAddress() + " established, type = " + this.getFilter().getName(false) + ", fallback = " + (this.fallback_count == 0 ? "no" : "yes")));
            }
            this.connectedOutbound(initial_data, listener);
        }
    }

    private void setTransportBuffersSize(int size_in_bytes) {
        if (this.getFilter() == null) {
            Debug.out("socket_channel == null");
            return;
        }
        try {
            SocketChannel channel2 = this.getSocketChannel();
            channel2.socket().setSendBufferSize(size_in_bytes);
            channel2.socket().setReceiveBufferSize(size_in_bytes);
            int snd_real = channel2.socket().getSendBufferSize();
            int rcv_real = channel2.socket().getReceiveBufferSize();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Setting new transport [" + this.description + "] buffer sizes: SND=" + size_in_bytes + " [" + snd_real + "] , RCV=" + size_in_bytes + " [" + rcv_real + "]"));
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
    }

    public void setTransportMode(int mode) {
        if (mode == this.transport_mode) {
            return;
        }
        switch (mode) {
            case 0: {
                this.setTransportBuffersSize(8192);
                break;
            }
            case 1: {
                this.setTransportBuffersSize(65536);
                break;
            }
            case 2: {
                this.setTransportBuffersSize(524288);
                break;
            }
            default: {
                Debug.out("invalid transport mode given: " + mode);
            }
        }
        this.transport_mode = mode;
    }

    protected void connectedOutbound(ByteBuffer remaining_initial_data, Transport.ConnectListener listener) {
        if (this.has_been_closed) {
            TransportHelperFilter filter2 = this.getFilter();
            if (filter2 != null) {
                filter2.getHelper().close("Connection closed");
                this.setFilter(null);
            }
            listener.connectFailure(new Throwable("Connection closed"));
        } else {
            this.connectedOutbound();
            listener.connectSuccess(this, remaining_initial_data);
        }
    }

    public int getTransportMode() {
        return this.transport_mode;
    }

    protected void close(TransportHelper helper, String reason) {
        helper.close(reason);
        this.close(reason);
    }

    private void setConnectResult(boolean ok) {
        AEProxyFactory.PluginProxy pp = this.plugin_proxy;
        if (pp != null) {
            this.plugin_proxy = null;
            pp.setOK(ok);
        }
    }

    public void close(String reason) {
        this.has_been_closed = true;
        this.setConnectResult(false);
        if (this.connect_request_key != null) {
            TCPNetworkManager.getSingleton().getConnectDisconnectManager().cancelRequest(this.connect_request_key);
        }
        this.readyForRead(false);
        this.readyForWrite(false);
        TransportHelperFilter filter2 = this.getFilter();
        if (filter2 != null) {
            filter2.getHelper().close(reason);
            this.setFilter(null);
        }
        this.setReadyForRead();
    }
}

