/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.gudy.azureus2.core3.peer.PEPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedingUnchoker
implements Unchoker {
    private ArrayList<PEPeer> chokes = new ArrayList();
    private ArrayList<PEPeer> unchokes = new ArrayList();

    protected SeedingUnchoker() {
    }

    @Override
    public boolean isSeedingUnchoker() {
        return true;
    }

    @Override
    public ArrayList<PEPeer> getImmediateUnchokes(int max_to_unchoke, ArrayList<PEPeer> all_peers) {
        int peer_count = all_peers.size();
        if (max_to_unchoke > peer_count) {
            max_to_unchoke = peer_count;
        }
        int num_unchoked = 0;
        for (int i = 0; i < all_peers.size(); ++i) {
            PEPeer peer = all_peers.get(i);
            if (peer.isChokedByMe()) continue;
            ++num_unchoked;
        }
        int needed = max_to_unchoke - num_unchoked;
        if (needed > 0) {
            ArrayList<PEPeer> to_unchoke = UnchokerUtil.getNextOptimisticPeers(all_peers, false, false, needed);
            if (to_unchoke == null) {
                return new ArrayList<PEPeer>(0);
            }
            for (int i = 0; i < to_unchoke.size(); ++i) {
                to_unchoke.get(i).setOptimisticUnchoke(true);
            }
            return to_unchoke;
        }
        return new ArrayList<PEPeer>(0);
    }

    @Override
    public void calculateUnchokes(int max_to_unchoke, ArrayList<PEPeer> all_peers, boolean force_refresh, boolean check_priority_connections, boolean do_high_latency_peers) {
        int max_optimistic = (max_to_unchoke - 1) / 5 + 1;
        for (int i = 0; i < all_peers.size(); ++i) {
            PEPeer peer = all_peers.get(i);
            if (peer.isChokedByMe()) continue;
            if (UnchokerUtil.isUnchokable(peer, false)) {
                this.unchokes.add(peer);
                continue;
            }
            this.chokes.add(peer);
        }
        while (this.unchokes.size() > max_to_unchoke) {
            this.chokes.add(this.unchokes.remove(this.unchokes.size() - 1));
        }
        if (force_refresh) {
            ArrayList peers_ordered_by_rate = new ArrayList();
            ArrayList peers_ordered_by_uploaded = new ArrayList();
            long[] rates = new long[this.unchokes.size()];
            long[] uploaded = new long[rates.length];
            for (int i = 0; i < this.unchokes.size(); ++i) {
                PEPeer peer = this.unchokes.get(i);
                long rate = peer.getStats().getDataSendRate();
                if (rate <= 256L) continue;
                UnchokerUtil.updateLargestValueFirstSort(rate, rates, peer, peers_ordered_by_rate, 0);
                UnchokerUtil.updateLargestValueFirstSort(peer.getStats().getTotalDataBytesSent(), uploaded, peer, peers_ordered_by_uploaded, 0);
            }
            Collections.reverse(peers_ordered_by_rate);
            ArrayList peers_ordered_by_rank = new ArrayList();
            long[] ranks = new long[peers_ordered_by_rate.size()];
            Arrays.fill(ranks, Long.MIN_VALUE);
            for (int i = 0; i < this.unchokes.size(); ++i) {
                PEPeer peer = this.unchokes.get(i);
                long rate_factor = peers_ordered_by_rate.indexOf(peer);
                long uploaded_factor = peers_ordered_by_uploaded.indexOf(peer);
                if (rate_factor == -1L) continue;
                long rank_factor = rate_factor + uploaded_factor;
                UnchokerUtil.updateLargestValueFirstSort(rank_factor, ranks, peer, peers_ordered_by_rank, 0);
            }
            while (peers_ordered_by_rank.size() > max_to_unchoke - max_optimistic) {
                peers_ordered_by_rank.remove(peers_ordered_by_rank.size() - 1);
            }
            ArrayList<PEPeer> to_unchoke = new ArrayList<PEPeer>();
            Iterator<PEPeer> it = this.unchokes.iterator();
            while (it.hasNext()) {
                PEPeer optimistic_peer;
                PEPeer peer = it.next();
                peer.setOptimisticUnchoke(false);
                if (peers_ordered_by_rank.contains(peer) || (optimistic_peer = UnchokerUtil.getNextOptimisticPeer(all_peers, false, false)) == null) continue;
                this.chokes.add(peer);
                it.remove();
                to_unchoke.add(optimistic_peer);
                optimistic_peer.setOptimisticUnchoke(true);
            }
            for (int i = 0; i < to_unchoke.size(); ++i) {
                this.unchokes.add((PEPeer)to_unchoke.get(i));
            }
        }
        if (check_priority_connections) {
            this.setBuddyUnchokes(max_to_unchoke - max_optimistic, all_peers);
        }
        if (do_high_latency_peers) {
            UnchokerUtil.doHighLatencyPeers(this.chokes, this.unchokes, false);
        }
    }

    private void setBuddyUnchokes(int max_buddies, ArrayList<PEPeer> all_peers) {
        int max;
        if (this.unchokes.isEmpty()) {
            return;
        }
        ArrayList<PEPeer> buddies = new ArrayList<PEPeer>();
        for (int i = 0; i < all_peers.size(); ++i) {
            PEPeer peer = all_peers.get(i);
            if (!peer.isPriorityConnection() || !UnchokerUtil.isUnchokable(peer, true)) continue;
            buddies.add(peer);
        }
        Collections.shuffle(buddies);
        int n = max = max_buddies > this.unchokes.size() ? this.unchokes.size() : max_buddies;
        for (int num_unchoked = 0; num_unchoked < max && !buddies.isEmpty(); ++num_unchoked) {
            PEPeer peer = this.unchokes.remove(0);
            if (buddies.remove(peer)) {
                this.unchokes.add(peer);
                continue;
            }
            PEPeer buddy = (PEPeer)buddies.remove(buddies.size() - 1);
            this.chokes.remove(buddy);
            this.unchokes.add(buddy);
        }
    }

    @Override
    public ArrayList<PEPeer> getChokes() {
        ArrayList<PEPeer> to_choke = this.chokes;
        this.chokes = new ArrayList();
        return to_choke;
    }

    @Override
    public ArrayList<PEPeer> getUnchokes() {
        ArrayList<PEPeer> to_unchoke = this.unchokes;
        this.unchokes = new ArrayList();
        return to_unchoke;
    }
}

