/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.clientid;

import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.clientid.ClientIDGenerator;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class ClientIDPlugin {
    private static boolean send_os;

    public static void initialize() {
        String param = "Tracker Client Send OS and Java Version";
        COConfigurationManager.addAndFireParameterListener("Tracker Client Send OS and Java Version", new ParameterListener(){

            public void parameterChanged(String param) {
                send_os = COConfigurationManager.getBooleanParameter(param);
            }
        });
        ClientIDManagerImpl.getSingleton().setGenerator(new ClientIDGenerator(){

            public byte[] generatePeerID(Torrent torrent, boolean for_tracker) {
                return PeerUtils.createPeerID();
            }

            public void generateHTTPProperties(Properties properties) {
                ClientIDPlugin.doHTTPProperties(properties);
            }

            public String[] filterHTTP(String[] lines_in) {
                return lines_in;
            }
        }, false);
    }

    protected static void doHTTPProperties(Properties properties) {
        Boolean raw = (Boolean)properties.get("Raw-Request");
        if (raw != null && raw.booleanValue()) {
            return;
        }
        String version = "5.6.1.3_B03";
        int pos = version.indexOf(95);
        if (pos != -1) {
            version = version.substring(0, pos);
        }
        String agent = "Azureus " + version;
        if (send_os) {
            agent = agent + ";" + Constants.OSName;
            agent = agent + ";Java " + Constants.JAVA_VERSION;
        }
        properties.put("User-Agent", agent);
    }
}

