/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.netstatus.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNATDevice;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProgressListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusPlugin;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterBT;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetStatusPluginTester {
    public static final int TEST_NAT_PROXIES = 2;
    public static final int TEST_OUTBOUND = 4;
    public static final int TEST_INBOUND = 8;
    public static final int TEST_BT_CONNECT = 16;
    public static final int TEST_IPV6 = 32;
    public static final int TEST_VUZE_SERVICES = 64;
    public static final int TEST_PROXY_CONNECT = 128;
    private static final int ROUTE_TIMEOUT = 120000;
    private NetStatusPlugin plugin;
    private int test_types;
    private loggerProvider logger;
    private volatile boolean test_cancelled;

    public NetStatusPluginTester(NetStatusPlugin _plugin, int _test_types, loggerProvider _logger) {
        this.plugin = _plugin;
        this.test_types = _test_types;
        this.logger = _logger;
    }

    protected boolean doTest(int type) {
        if (this.test_cancelled) {
            return false;
        }
        return (this.test_types & type) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(AzureusCore core) {
        NetworkAdmin admin;
        block69: {
            InetAddress public_address;
            NetworkAdminProtocol protocol;
            int i;
            admin = NetworkAdmin.getSingleton();
            boolean checked_public = false;
            HashSet<InetAddress> public_addresses = new HashSet<InetAddress>();
            InetAddress def_pa = admin.getDefaultPublicAddress();
            if (def_pa != null) {
                this.log("Default public address is " + def_pa.getHostAddress());
                this.addPublicAddress(public_addresses, def_pa);
                checked_public = true;
            }
            if (this.doTest(2)) {
                checked_public = true;
                NetworkAdminNATDevice[] nat_devices = admin.getNATDevices(core);
                this.log(nat_devices.length + " NAT device" + (nat_devices.length == 1 ? "" : "s") + " found");
                for (int i2 = 0; i2 < nat_devices.length; ++i2) {
                    NetworkAdminNATDevice device = nat_devices[i2];
                    InetAddress ext_address = device.getExternalAddress();
                    this.addPublicAddress(public_addresses, ext_address);
                    this.log("    " + device.getString());
                }
                NetworkAdminSocksProxy[] socks_proxies = admin.getSocksProxies();
                if (socks_proxies.length == 0) {
                    this.log("No SOCKS proxy found");
                } else if (socks_proxies.length == 1) {
                    this.log("One SOCKS proxy found");
                } else {
                    this.log(socks_proxies.length + " SOCKS proxies found");
                }
                for (int i3 = 0; i3 < socks_proxies.length; ++i3) {
                    NetworkAdminSocksProxy proxy = socks_proxies[i3];
                    this.log("    " + proxy.getString());
                }
                NetworkAdminHTTPProxy http_proxy = admin.getHTTPProxy();
                if (http_proxy == null) {
                    this.log("No HTTP proxy found");
                } else {
                    this.log("HTTP proxy found");
                    this.log("    " + http_proxy.getString());
                }
            }
            InetAddress[] bind_addresses = admin.getAllBindAddresses(false);
            int num_binds = 0;
            for (i = 0; i < bind_addresses.length; ++i) {
                if (bind_addresses[i] == null) continue;
                ++num_binds;
            }
            if (num_binds == 0) {
                this.log("No explicit bind address set");
            } else {
                this.log(num_binds + " bind addresses");
                for (i = 0; i < bind_addresses.length; ++i) {
                    if (bind_addresses[i] == null) continue;
                    this.log("    " + bind_addresses[i].getHostAddress());
                }
            }
            if (this.doTest(4)) {
                checked_public = true;
                NetworkAdminProtocol[] outbound_protocols = admin.getOutboundProtocols(core);
                if (outbound_protocols.length == 0) {
                    this.log("No outbound protocols");
                } else {
                    for (int i4 = 0; i4 < outbound_protocols.length; ++i4) {
                        if (this.test_cancelled) {
                            return;
                        }
                        protocol = outbound_protocols[i4];
                        this.log("Testing " + protocol.getName());
                        try {
                            public_address = protocol.test(null, new NetworkAdminProgressListener(){

                                public void reportProgress(String task2) {
                                    NetStatusPluginTester.this.log("    " + task2);
                                }
                            });
                            this.logSuccess("    Test successful");
                            this.addPublicAddress(public_addresses, public_address);
                            continue;
                        }
                        catch (Throwable e) {
                            this.logError("    Test failed", e);
                        }
                    }
                }
            }
            if (this.doTest(8)) {
                checked_public = true;
                NetworkAdminProtocol[] inbound_protocols = admin.getInboundProtocols(core);
                if (inbound_protocols.length == 0) {
                    this.log("No inbound protocols");
                } else {
                    for (int i5 = 0; i5 < inbound_protocols.length; ++i5) {
                        if (this.test_cancelled) {
                            return;
                        }
                        protocol = inbound_protocols[i5];
                        this.log("Testing " + protocol.getName());
                        try {
                            public_address = protocol.test(null, new NetworkAdminProgressListener(){

                                public void reportProgress(String task2) {
                                    NetStatusPluginTester.this.log("    " + task2);
                                }
                            });
                            this.logSuccess("    Test successful");
                            this.addPublicAddress(public_addresses, public_address);
                            continue;
                        }
                        catch (Throwable e) {
                            this.logError("    Test failed", e);
                            this.logInfo("    Check your port forwarding for " + protocol.getTypeString() + " " + protocol.getPort());
                        }
                    }
                }
            }
            if (checked_public) {
                if (public_addresses.size() == 0) {
                    this.log("No public addresses found");
                } else {
                    Iterator it = public_addresses.iterator();
                    this.log(public_addresses.size() + " public/external addresses found");
                    while (it.hasNext()) {
                        InetAddress pub_address = (InetAddress)it.next();
                        this.log("    " + pub_address.getHostAddress());
                        try {
                            NetworkAdminASN asn = admin.lookupASN(pub_address);
                            this.log("    AS details: " + asn.getString());
                        }
                        catch (Throwable e) {
                            this.logError("    failed to lookup AS", e);
                        }
                    }
                }
            }
            if (this.doTest(64)) {
                String[][] services;
                this.log("Vuze Services test");
                for (String[] service : services = new String[][]{{"Vuze Website", "https://www.vuze.com/"}, {"Client Website", "https://client.vuze.com/"}, {"Version Server", "http://version.vuze.com/?dee"}, {"Pairing Server", "https://pair.vuze.com/pairing/web/view?"}, {"License Server", "https://license.vuze.com/licence"}, {"Plugins Website", "https://plugins.vuze.com/"}}) {
                    if (this.test_cancelled) {
                        return;
                    }
                    try {
                        URL url = new URL(service[1]);
                        this.log("    " + service[0] + " - " + url.getHost());
                        boolean is_https = url.getProtocol().equals("https");
                        if (is_https) {
                            X509Certificate x509_cert;
                            String[] host_bits = url.getHost().split("\\.");
                            String host_match = "." + host_bits[host_bits.length - 2] + "." + host_bits[host_bits.length - 1];
                            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                            con.setHostnameVerifier(new HostnameVerifier(){

                                public boolean verify(String host, SSLSession session) {
                                    return true;
                                }
                            });
                            con.setInstanceFollowRedirects(false);
                            con.setConnectTimeout(30000);
                            con.setReadTimeout(30000);
                            con.getResponseCode();
                            con.getInputStream();
                            Certificate[] certs = con.getServerCertificates();
                            if (certs == null || certs.length == 0) {
                                this.logError("        No certificates returned");
                                continue;
                            }
                            Certificate cert = certs[0];
                            if (cert instanceof X509Certificate) {
                                x509_cert = (X509Certificate)cert;
                            } else {
                                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                x509_cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
                            }
                            this.log("        Certificate: " + x509_cert.getSubjectDN());
                            Collection<List<?>> alt_names = x509_cert.getSubjectAlternativeNames();
                            boolean match = false;
                            for (List<?> alt_name : alt_names) {
                                String dns_name;
                                int type = ((Number)alt_name.get(0)).intValue();
                                if (type != 2 || !(dns_name = (String)alt_name.get(1)).endsWith(host_match)) continue;
                                match = true;
                                break;
                            }
                            if (!match) {
                                this.logError("        Failed: Host '" + host_match + "' not found in certificate");
                                continue;
                            }
                            this.logSuccess("        Connection result: " + con.getResponseCode() + "/" + con.getResponseMessage());
                            continue;
                        }
                        HttpURLConnection con = (HttpURLConnection)url.openConnection();
                        con.setInstanceFollowRedirects(false);
                        con.setConnectTimeout(30000);
                        con.setReadTimeout(30000);
                        if (con.getResponseCode() != 200) {
                            throw new Exception("Connection failed: " + con.getResponseCode() + "/" + con.getResponseMessage());
                        }
                        Map<String, Object> resp = BDecoder.decode(new BufferedInputStream(con.getInputStream(), 16384));
                        if (resp != null && resp.containsKey("version")) {
                            this.logSuccess("        Connection result: " + con.getResponseCode() + "/" + con.getResponseMessage());
                            continue;
                        }
                        this.logError("        Unexpected reply from server: " + resp);
                    }
                    catch (Throwable e) {
                        this.logError("        Failed: " + Debug.getNestedExceptionMessage(e));
                    }
                }
            }
            if (this.doTest(128)) {
                this.log("Indirect Connect test");
                try {
                    URL target = new URL("https://www.vuze.com");
                    AEProxyFactory.PluginProxy proxy = AEProxyFactory.getPluginProxy("Network Status test", target);
                    if (proxy == null) {
                        String url_str = "http://azureus.sourceforge.net/plugin_detailssf.php?plugin=aznettor&os=";
                        url_str = Constants.isWindows ? url_str + "Windows" : url_str + "Mac%20OSX";
                        URL url = new URL(url_str);
                        this.logError("    No plugin proxy available");
                        this.logInfo("    For the plugin installer see " + url.toExternalForm());
                        break block69;
                    }
                    this.log("    Connecting to " + target.toExternalForm());
                    HttpURLConnection con = (HttpURLConnection)proxy.getURL().openConnection(proxy.getProxy());
                    if (con instanceof HttpsURLConnection) {
                        ((HttpsURLConnection)con).setHostnameVerifier(new HostnameVerifier(){

                            public boolean verify(String host, SSLSession session) {
                                return true;
                            }
                        });
                    }
                    con.setRequestProperty("HOST", proxy.getURLHostRewrite());
                    con.setInstanceFollowRedirects(false);
                    con.setConnectTimeout(60000);
                    con.setReadTimeout(30000);
                    try {
                        int resp = con.getResponseCode();
                        if (con instanceof HttpsURLConnection) {
                            Certificate[] certs = ((HttpsURLConnection)con).getServerCertificates();
                            if (certs == null || certs.length == 0) {
                                this.logError("    No certificates returned");
                            } else {
                                X509Certificate x509_cert;
                                Certificate cert = certs[0];
                                if (cert instanceof X509Certificate) {
                                    x509_cert = (X509Certificate)cert;
                                } else {
                                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                    x509_cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
                                }
                                this.log("    Certificate: " + x509_cert.getSubjectDN());
                            }
                        }
                        if (resp == 200) {
                            this.logSuccess("    Connection result: " + con.getResponseCode() + "/" + con.getResponseMessage());
                        } else {
                            this.log("    Connection result: " + con.getResponseCode() + "/" + con.getResponseMessage());
                        }
                        Object var28_57 = null;
                        proxy.setOK(true);
                    }
                    catch (Throwable throwable) {
                        Object var28_58 = null;
                        proxy.setOK(true);
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    this.logError("    Failed: " + Debug.getNestedExceptionMessage(e));
                    this.logError("    Check the logs for the 'Tor Helper Plugin' (Tools->Plugins->Log Views)");
                }
            }
        }
        if (this.doTest(16)) {
            this.log("Distributed protocol test");
            NetStatusProtocolTesterBT bt_test = this.plugin.getProtocolTester().runTest(new NetStatusProtocolTesterListener(){
                private List sessions = new ArrayList();

                public void complete(NetStatusProtocolTesterBT tester) {
                    this.log("Results", false);
                    if (tester.getOutboundConnects() < 4) {
                        this.log("    insufficient outbound connects for analysis", false);
                        return;
                    }
                    int outgoing_seed_ok = 0;
                    int outgoing_leecher_ok = 0;
                    int outgoing_seed_bad = 0;
                    int outgoing_leecher_bad = 0;
                    int incoming_connect_ok = 0;
                    for (int i = 0; i < this.sessions.size(); ++i) {
                        NetStatusProtocolTesterBT.Session session = (NetStatusProtocolTesterBT.Session)this.sessions.get(i);
                        if (session.isOK()) {
                            if (session.isInitiator()) {
                                if (session.isSeed()) {
                                    ++outgoing_seed_ok;
                                } else {
                                    ++outgoing_leecher_ok;
                                }
                            } else {
                                ++incoming_connect_ok;
                            }
                        } else if (session.isConnected()) {
                            if (session.isInitiator()) {
                                if (session.isSeed()) {
                                    ++outgoing_seed_bad;
                                } else {
                                    ++outgoing_leecher_bad;
                                }
                            } else {
                                ++incoming_connect_ok;
                            }
                        }
                        this.log("  " + (session.isInitiator() ? "Outbound" : "Inbound") + "," + (session.isSeed() ? "Seed" : "Leecher") + "," + session.getProtocolString(), false);
                    }
                    boolean good = true;
                    if (incoming_connect_ok == 0) {
                        this.logError("  No incoming connections received, likely NAT problems");
                        good = false;
                    }
                    if (outgoing_leecher_ok > 0 && outgoing_seed_ok == 0 && outgoing_seed_bad > 0) {
                        this.logError("  Outgoing seed connects appear to be failing while non-seeds succeed");
                        good = false;
                    }
                    if (good) {
                        NetStatusPluginTester.this.logSuccess("    Test successful");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void sessionAdded(NetStatusProtocolTesterBT.Session session) {
                    List list = this.sessions;
                    synchronized (list) {
                        this.sessions.add(session);
                    }
                }

                public void log(String str, boolean detailed) {
                    NetStatusPluginTester.this.log("  " + str, detailed);
                }

                public void logError(String str) {
                    NetStatusPluginTester.this.logError("  " + str);
                }

                public void logError(String str, Throwable e) {
                    NetStatusPluginTester.this.logError("  " + str, e);
                }
            });
            while (!bt_test.waitForCompletion(5000L)) {
                if (this.isCancelled()) {
                    bt_test.destroy();
                    break;
                }
                this.log("    Status: " + bt_test.getStatus());
            }
        }
        if (this.doTest(32)) {
            this.log("IPv6 test");
            InetAddress ipv6_address = admin.getDefaultPublicAddressV6();
            if (ipv6_address == null) {
                this.log("    No default public IPv6 address found");
            } else {
                this.log("    Default public IPv6 address: " + ipv6_address.getHostAddress());
                this.log("    Testing connectivity...");
                String res = VersionCheckClient.getSingleton().getExternalIpAddress(false, true, true);
                if (res != null && res.length() > 0) {
                    this.logSuccess("        Connect succeeded, reported IPv6 address: " + res);
                } else {
                    this.logError("        Connect failed");
                }
            }
        }
    }

    protected void addPublicAddress(Set<InetAddress> addresses, InetAddress address) {
        if (address == null) {
            return;
        }
        if (address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress()) {
            return;
        }
        addresses.add(address);
    }

    public void cancel() {
        this.test_cancelled = true;
    }

    public boolean isCancelled() {
        return this.test_cancelled;
    }

    protected void log(String str) {
        this.log(str, false);
    }

    protected void log(String str, boolean detailed) {
        this.logger.log(str, detailed);
    }

    protected void logSuccess(String str) {
        this.logger.logSuccess(str);
    }

    protected void logInfo(String str) {
        this.logger.logInfo(str);
    }

    protected void log(String str, Throwable e) {
        this.logger.log(str + ": " + e.getLocalizedMessage(), false);
    }

    protected void logError(String str) {
        this.logger.logFailure(str);
    }

    protected void logError(String str, Throwable e) {
        this.logger.logFailure(str + ": " + e.getLocalizedMessage());
    }

    public static interface loggerProvider {
        public void log(String var1, boolean var2);

        public void logSuccess(String var1);

        public void logInfo(String var1);

        public void logFailure(String var1);
    }
}

