/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.opentorrent;

import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenFileOptions;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class TableColumnOTOF_Priority
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static final String COLUMN_ID = "priority";

    public TableColumnOTOF_Priority(TableColumn column) {
        column.initialize(1, -2, 50);
        column.addListeners(this);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell) {
        String text;
        int priority;
        Object ds = cell.getDataSource();
        if (!(ds instanceof TorrentOpenFileOptions)) {
            return;
        }
        TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)ds;
        if (tfi.isToDownload()) {
            priority = tfi.getPriority();
            if (priority > 0) {
                text = MessageText.getString("FileItem.high");
                if (priority > 1) {
                    text = text + " (" + priority + ")";
                }
            } else if (priority < 0) {
                text = MessageText.getString("FileItem.low");
                if (priority < -1) {
                    text = text + " (" + priority + ")";
                }
            } else {
                text = MessageText.getString("FileItem.normal");
            }
        } else {
            priority = Integer.MIN_VALUE;
            text = "";
        }
        if (cell.setSortValue(priority)) {
            cell.setText(text);
        }
    }
}

