/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.opentorrent;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenFileOptions;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class TableColumnOTOF_Size
implements TableCellRefreshListener,
TableColumnExtraInfoListener,
TableCellSWTPaintListener {
    public static final String COLUMN_ID = "size";

    public TableColumnOTOF_Size(TableColumn column) {
        column.initialize(2, -2, 80);
        column.addListeners(this);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).addCellOtherListener("SWTPaint", this);
        }
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        if (!(ds instanceof TorrentOpenFileOptions)) {
            return;
        }
        TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)ds;
        cell.setSortValue(tfi.lSize);
        cell.setText(DisplayFormatters.formatByteCountToKiBEtc(tfi.lSize));
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        Object ds = cell.getDataSource();
        if (!(ds instanceof TorrentOpenFileOptions)) {
            return;
        }
        TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)ds;
        float pct = (float)tfi.lSize / (float)tfi.parent.getTorrent().getSize();
        Rectangle bounds = cell.getBounds();
        bounds.width = (int)((float)bounds.width * pct);
        if (bounds.width > 2) {
            ++bounds.x;
            ++bounds.y;
            bounds.height -= 2;
            bounds.width -= 2;
            gc.setBackground(gc.getForeground());
            int alpha = gc.getAlpha();
            gc.setAlpha(10);
            gc.fillRectangle(bounds);
            gc.setAlpha(alpha);
        }
    }
}

