/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import com.aelitis.net.udp.uc.PRUDPPacketReplyDecoder;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import com.aelitis.net.udp.uc.PRUDPPacketRequestDecoder;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;

public class PRUDPTrackerCodecs {
    private static boolean registered = false;

    public static void registerCodecs() {
        if (registered) {
            return;
        }
        registered = true;
        PRUDPPacketReplyDecoder reply_decoder = new PRUDPPacketReplyDecoder(){

            public PRUDPPacketReply decode(PRUDPPacketHandler handler, InetSocketAddress originator, DataInputStream is, int action, int transaction_id) throws IOException {
                switch (action) {
                    case 0: {
                        return new PRUDPPacketReplyConnect(is, transaction_id);
                    }
                    case 1: {
                        if (PRUDPPacketTracker.VERSION == 1) {
                            return new PRUDPPacketReplyAnnounce(is, transaction_id);
                        }
                        return new PRUDPPacketReplyAnnounce2(is, transaction_id);
                    }
                    case 2: {
                        if (PRUDPPacketTracker.VERSION == 1) {
                            return new PRUDPPacketReplyScrape(is, transaction_id);
                        }
                        return new PRUDPPacketReplyScrape2(is, transaction_id);
                    }
                    case 3: {
                        return new PRUDPPacketReplyError(is, transaction_id);
                    }
                }
                throw new IOException("Unrecognised action '" + action + "'");
            }
        };
        HashMap<Integer, 1> reply_decoders = new HashMap<Integer, 1>();
        reply_decoders.put(new Integer(0), reply_decoder);
        reply_decoders.put(new Integer(1), reply_decoder);
        reply_decoders.put(new Integer(2), reply_decoder);
        reply_decoders.put(new Integer(3), reply_decoder);
        PRUDPPacketReply.registerDecoders(reply_decoders);
        PRUDPPacketRequestDecoder request_decoder = new PRUDPPacketRequestDecoder(){

            public PRUDPPacketRequest decode(PRUDPPacketHandler handler, DataInputStream is, long connection_id, int action, int transaction_id) throws IOException {
                switch (action) {
                    case 0: {
                        return new PRUDPPacketRequestConnect(is, connection_id, transaction_id);
                    }
                    case 1: {
                        if (PRUDPPacketTracker.VERSION == 1) {
                            return new PRUDPPacketRequestAnnounce(is, connection_id, transaction_id);
                        }
                        return new PRUDPPacketRequestAnnounce2(is, connection_id, transaction_id);
                    }
                    case 2: {
                        return new PRUDPPacketRequestScrape(is, connection_id, transaction_id);
                    }
                }
                throw new IOException("unsupported request type");
            }
        };
        HashMap<Integer, 2> request_decoders = new HashMap<Integer, 2>();
        request_decoders.put(new Integer(0), request_decoder);
        request_decoders.put(new Integer(1), request_decoder);
        request_decoders.put(new Integer(2), request_decoder);
        PRUDPPacketRequest.registerDecoders(request_decoders);
    }
}

