/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionHelper;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportBase;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignDelegate;

public class PeerForeignNetworkConnection
extends NetworkConnectionHelper {
    private final PeerForeignDelegate delegate;
    private final Peer peer;
    private OutgoingMessageQueue outgoing_message_queue = new omq();
    private IncomingMessageQueue incoming_message_queue = new imq();
    private TransportBase transport_base = new tp();

    protected PeerForeignNetworkConnection(PeerForeignDelegate _delegate, Peer _peer) {
        this.delegate = _delegate;
        this.peer = _peer;
    }

    public ConnectionEndpoint getEndpoint() {
        return new ConnectionEndpoint(new InetSocketAddress(this.peer.getIp(), this.peer.getPort()));
    }

    public void notifyOfException(Throwable error) {
        Debug.printStackTrace(error);
    }

    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.outgoing_message_queue;
    }

    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.incoming_message_queue;
    }

    public TransportBase getTransportBase() {
        return this.transport_base;
    }

    public int getMssSize() {
        return NetworkManager.getMinMssSize();
    }

    public boolean isIncoming() {
        return false;
    }

    public boolean isLANLocal() {
        return false;
    }

    public String getString() {
        String peer_str = this.peer.getClass().getName();
        int pos = peer_str.lastIndexOf(46);
        if (pos != -1) {
            peer_str = peer_str.substring(pos + 1);
        }
        peer_str = peer_str + " " + this.peer.getIp() + ":" + this.peer.getPort();
        return "peer=" + peer_str + ",in=" + this.incoming_message_queue.getPercentDoneOfCurrentMessage() + ",out=" + this.outgoing_message_queue.getTotalSize();
    }

    protected class imq
    implements IncomingMessageQueue {
        protected imq() {
        }

        public void setDecoder(MessageStreamDecoder new_stream_decoder) {
        }

        public MessageStreamDecoder getDecoder() {
            throw new RuntimeException("Not imp");
        }

        public int getPercentDoneOfCurrentMessage() {
            return 0;
        }

        public int receiveFromTransport(int max_bytes) throws IOException {
            return PeerForeignNetworkConnection.this.peer.readBytes(PeerForeignNetworkConnection.this.delegate.isDownloadDisabled() ? 0 : max_bytes);
        }

        public void notifyOfExternallyReceivedMessage(Message message) {
        }

        public void resumeQueueProcessing() {
        }

        public void registerQueueListener(IncomingMessageQueue.MessageQueueListener listener) {
        }

        public void cancelQueueListener(IncomingMessageQueue.MessageQueueListener listener) {
        }

        public void destroy() {
        }
    }

    protected class omq
    implements OutgoingMessageQueue {
        protected omq() {
        }

        public void setTransport(Transport _transport) {
        }

        public int getMssSize() {
            return PeerForeignNetworkConnection.this.getMssSize();
        }

        public void setEncoder(MessageStreamEncoder stream_encoder) {
        }

        public MessageStreamEncoder getEncoder() {
            throw new RuntimeException("Not imp");
        }

        public int getPercentDoneOfCurrentMessage() {
            return 0;
        }

        public void destroy() {
        }

        public void flush() {
        }

        public boolean isDestroyed() {
            return false;
        }

        public int getTotalSize() {
            return 0;
        }

        public int getDataQueuedBytes() {
            return 0;
        }

        public int getProtocolQueuedBytes() {
            return 0;
        }

        public boolean getPriorityBoost() {
            return false;
        }

        public void setPriorityBoost(boolean boost) {
        }

        public boolean isBlocked() {
            return false;
        }

        public boolean hasUrgentMessage() {
            return false;
        }

        public void addMessage(Message message, boolean manual_listener_notify) {
            throw new RuntimeException("Not imp");
        }

        public void removeMessagesOfType(Message[] message_types, boolean manual_listener_notify) {
            throw new RuntimeException("Not imp");
        }

        public boolean removeMessage(Message message, boolean manual_listener_notify) {
            throw new RuntimeException("Not imp");
        }

        public int deliverToTransport(int max_bytes, boolean manual_listener_notify) throws IOException {
            throw new RuntimeException("Not imp");
        }

        public void doListenerNotifications() {
        }

        public void setTrace(boolean on) {
        }

        public String getQueueTrace() {
            return "";
        }

        public void registerQueueListener(OutgoingMessageQueue.MessageQueueListener listener) {
        }

        public void cancelQueueListener(OutgoingMessageQueue.MessageQueueListener listener) {
        }

        public void notifyOfExternallySentMessage(Message message) {
        }
    }

    protected class tp
    implements TransportBase {
        private long last_ready_for_read = SystemTime.getSteppedMonotonousTime();

        protected tp() {
        }

        public boolean isReadyForWrite(EventWaiter waiter) {
            return false;
        }

        public long isReadyForRead(EventWaiter waiter) {
            long now = SystemTime.getSteppedMonotonousTime();
            if (PeerForeignNetworkConnection.this.peer.isTransferAvailable()) {
                this.last_ready_for_read = now;
                return 0L;
            }
            long diff = now - this.last_ready_for_read + 1L;
            return diff;
        }

        public boolean isTCP() {
            return false;
        }

        public String getDescription() {
            return "Peer transport delegate";
        }
    }
}

