/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerDecisionListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckerImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateImpl;

public class UpdateCheckInstanceImpl
implements UpdateCheckInstance {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static UpdateCheckInstanceImpl active_checker;
    private List<UpdateCheckInstanceListener> listeners = new ArrayList<UpdateCheckInstanceListener>();
    private List<UpdateImpl> updates = new ArrayList<UpdateImpl>();
    private List<UpdateManagerDecisionListener> decision_listeners = new ArrayList<UpdateManagerDecisionListener>();
    private AESemaphore sem = new AESemaphore("UpdateCheckInstance");
    private UpdateManager manager;
    private int check_type;
    private String name;
    private UpdatableComponentImpl[] components;
    private UpdateCheckerImpl[] checkers;
    private boolean completed;
    private boolean cancelled;
    private boolean automatic = true;
    private boolean low_noise = false;
    protected AEMonitor this_mon = new AEMonitor("UpdateCheckInstance");
    private Map<Integer, Object> properties = new HashMap<Integer, Object>();

    protected UpdateCheckInstanceImpl(UpdateManager _manager, int _check_type, String _name, UpdatableComponentImpl[] _components) {
        this.properties.put(1, 1);
        this.manager = _manager;
        this.check_type = _check_type;
        this.name = _name;
        this.components = _components;
        this.checkers = new UpdateCheckerImpl[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            UpdatableComponentImpl comp2 = this.components[i];
            this.checkers[i] = new UpdateCheckerImpl(this, comp2, this.sem);
        }
    }

    public int getType() {
        return this.check_type;
    }

    public String getName() {
        return this.name;
    }

    public void addUpdatableComponent(UpdatableComponent component, boolean mandatory) {
        UpdatableComponentImpl comp2 = new UpdatableComponentImpl(component, mandatory);
        UpdatableComponentImpl[] new_comps = new UpdatableComponentImpl[this.components.length + 1];
        System.arraycopy(this.components, 0, new_comps, 0, this.components.length);
        new_comps[this.components.length] = comp2;
        this.components = new_comps;
        UpdateCheckerImpl checker = new UpdateCheckerImpl(this, comp2, this.sem);
        UpdateCheckerImpl[] new_checkers = new UpdateCheckerImpl[this.checkers.length + 1];
        System.arraycopy(this.checkers, 0, new_checkers, 0, this.checkers.length);
        new_checkers[this.checkers.length] = checker;
        this.checkers = new_checkers;
    }

    public void setAutomatic(boolean a) {
        this.automatic = a;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setLowNoise(boolean a) {
        this.low_noise = a;
    }

    public boolean isLowNoise() {
        return this.low_noise;
    }

    public Object getProperty(int property_name) {
        return this.properties.get(property_name);
    }

    public void setProperty(int property_name, Object value) {
        this.properties.put(property_name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class<UpdateCheckInstanceImpl> clazz = UpdateCheckInstanceImpl.class;
        synchronized (UpdateCheckInstanceImpl.class) {
            boolean run_now;
            if (active_checker == null) {
                active_checker = this;
                run_now = true;
                new AEThread2("UCI:clearer"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            if (!UpdateCheckInstanceImpl.this.isCompleteOrCancelled()) continue;
                            boolean done = true;
                            if (UpdateCheckInstanceImpl.this.completed) {
                                Update[] updates;
                                for (Update update : updates = UpdateCheckInstanceImpl.this.getUpdates()) {
                                    if (update.isCancelled() || update.isComplete()) continue;
                                    done = false;
                                    break;
                                }
                            }
                            if (done) break;
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Class<UpdateCheckInstanceImpl> clazz = UpdateCheckInstanceImpl.class;
                        synchronized (UpdateCheckInstanceImpl.class) {
                            active_checker = null;
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            return;
                        }
                    }
                }.start();
            } else {
                run_now = false;
                new AEThread2("UCI:waiter"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    public void run() {
                        boolean retry;
                        do {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            retry = false;
                            Class<UpdateCheckInstanceImpl> clazz = UpdateCheckInstanceImpl.class;
                            // MONITORENTER : org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl.class
                            if (active_checker == null) {
                                retry = true;
                            }
                            // MONITOREXIT : clazz
                        } while (!retry);
                        UpdateCheckInstanceImpl.this.start();
                    }
                }.start();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (run_now) {
                this.startSupport();
            }
            return;
        }
    }

    private void startSupport() {
        for (int i = 0; i < this.components.length; ++i) {
            final UpdateCheckerImpl checker = this.checkers[i];
            new AEThread2("UpdatableComponent Checker:" + i, true){

                public void run() {
                    try {
                        checker.getComponent().checkForUpdate(checker);
                    }
                    catch (Throwable e) {
                        checker.reportProgress("Update check failed: " + Debug.getNestedExceptionMessage(e));
                        e.printStackTrace();
                        checker.failed();
                    }
                }
            }.start();
        }
        new AEThread2("UpdatableComponent Completion Waiter", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int i;
                for (i = 0; i < UpdateCheckInstanceImpl.this.components.length; ++i) {
                    UpdateCheckInstanceImpl.this.sem.reserve();
                }
                try {
                    boolean mandatory_failed = false;
                    for (int i2 = 0; i2 < UpdateCheckInstanceImpl.this.checkers.length; ++i2) {
                        if (!UpdateCheckInstanceImpl.this.components[i2].isMandatory() || !UpdateCheckInstanceImpl.this.checkers[i2].getFailed()) continue;
                        mandatory_failed = true;
                        break;
                    }
                    ArrayList<UpdateImpl> target_updates = new ArrayList<UpdateImpl>();
                    if (mandatory_failed) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 3, "Dropping all updates as a mandatory update check failed"));
                        }
                    } else {
                        UpdateImpl update;
                        int i3;
                        boolean mandatory_only = false;
                        for (i3 = 0; i3 < UpdateCheckInstanceImpl.this.updates.size(); ++i3) {
                            update = (UpdateImpl)UpdateCheckInstanceImpl.this.updates.get(i3);
                            if (!update.isMandatory()) continue;
                            mandatory_only = true;
                            break;
                        }
                        for (i3 = 0; i3 < UpdateCheckInstanceImpl.this.updates.size(); ++i3) {
                            update = (UpdateImpl)UpdateCheckInstanceImpl.this.updates.get(i3);
                            if (update.isMandatory() || !mandatory_only) {
                                target_updates.add(update);
                                continue;
                            }
                            if (!Logger.isEnabled()) continue;
                            Logger.log(new LogEvent(LOGID, 3, "Dropping update '" + update.getName() + "' as non-mandatory and " + "mandatory updates found"));
                        }
                    }
                    Collections.sort(target_updates, new Comparator<UpdateImpl>(){

                        @Override
                        public int compare(UpdateImpl o1, UpdateImpl o2) {
                            int i1 = this.getIndex(o1);
                            int i2 = this.getIndex(o2);
                            return i1 - i2;
                        }

                        private int getIndex(UpdateImpl update) {
                            UpdatableComponentImpl component = update.getComponent();
                            for (int i = 0; i < UpdateCheckInstanceImpl.this.components.length; ++i) {
                                if (UpdateCheckInstanceImpl.this.components[i] != component) continue;
                                return i;
                            }
                            Debug.out("Missing component!");
                            return 0;
                        }
                    });
                    UpdateCheckInstanceImpl.this.updates = target_updates;
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        UpdateCheckInstanceImpl.this.this_mon.enter();
                        if (UpdateCheckInstanceImpl.this.cancelled) {
                            Object var9_13 = null;
                            UpdateCheckInstanceImpl.this.this_mon.exit();
                            return;
                        }
                        UpdateCheckInstanceImpl.this.completed = true;
                    }
                    catch (Throwable throwable2) {
                        Object var9_15 = null;
                        UpdateCheckInstanceImpl.this.this_mon.exit();
                        throw throwable2;
                    }
                    Object var9_14 = null;
                    UpdateCheckInstanceImpl.this.this_mon.exit();
                    throw throwable;
                }
                try {
                    UpdateCheckInstanceImpl.this.this_mon.enter();
                    if (UpdateCheckInstanceImpl.this.cancelled) {
                        Object var9_10 = null;
                        UpdateCheckInstanceImpl.this.this_mon.exit();
                        return;
                    }
                    UpdateCheckInstanceImpl.this.completed = true;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    UpdateCheckInstanceImpl.this.this_mon.exit();
                    throw throwable;
                }
                Object var9_11 = null;
                UpdateCheckInstanceImpl.this.this_mon.exit();
                for (i = 0; i < UpdateCheckInstanceImpl.this.listeners.size(); ++i) {
                    try {
                        ((UpdateCheckInstanceListener)UpdateCheckInstanceImpl.this.listeners.get(i)).complete(UpdateCheckInstanceImpl.this);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateImpl addUpdate(UpdatableComponentImpl comp2, String update_name, String[] desc, String old_version, String new_version, ResourceDownloader[] downloaders, int restart_required) {
        try {
            this.this_mon.enter();
            UpdateImpl update = new UpdateImpl(this, comp2, update_name, desc, old_version, new_version, downloaders, comp2.isMandatory(), restart_required);
            this.updates.add(update);
            if (this.cancelled) {
                update.cancel();
            }
            UpdateImpl updateImpl = update;
            Object var11_10 = null;
            this.this_mon.exit();
            return updateImpl;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Update[] getUpdates() {
        try {
            this.this_mon.enter();
            Update[] res = new Update[this.updates.size()];
            this.updates.toArray(res);
            Update[] updateArray = res;
            Object var4_3 = null;
            this.this_mon.exit();
            return updateArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UpdateChecker[] getCheckers() {
        return this.checkers;
    }

    public UpdateInstaller createInstaller() throws UpdateException {
        return this.manager.createInstaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleteOrCancelled() {
        try {
            this.this_mon.enter();
            boolean bl = this.completed || this.cancelled;
            Object var3_2 = null;
            this.this_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        int i;
        boolean just_do_updates = false;
        try {
            this.this_mon.enter();
            if (this.completed) {
                just_do_updates = true;
            }
            this.cancelled = true;
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (i = 0; i < this.updates.size(); ++i) {
            this.updates.get(i).cancel();
        }
        if (!just_do_updates) {
            for (i = 0; i < this.checkers.length; ++i) {
                if (this.checkers[i] == null) continue;
                this.checkers[i].cancel();
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                try {
                    this.listeners.get(i).cancelled(this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public UpdateManager getManager() {
        return this.manager;
    }

    protected Object getDecision(Update update, int decision_type, String decision_name, String decision_description, Object decision_data) {
        for (int i = 0; i < this.decision_listeners.size(); ++i) {
            Object res = this.decision_listeners.get(i).decide(update, decision_type, decision_name, decision_description, decision_data);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void addDecisionListener(UpdateManagerDecisionListener l) {
        this.decision_listeners.add(l);
    }

    public void removeDecisionListener(UpdateManagerDecisionListener l) {
        this.decision_listeners.remove(l);
    }

    public void addListener(UpdateCheckInstanceListener l) {
        this.listeners.add(l);
        if (this.completed) {
            l.complete(this);
        } else if (this.cancelled) {
            l.cancelled(this);
        }
    }

    public void removeListener(UpdateCheckInstanceListener l) {
        this.listeners.remove(l);
    }
}

