/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderTorrentImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    public static final int MAX_FOLLOWS = 1;
    protected ResourceDownloaderBaseImpl delegate;
    protected boolean persistent;
    protected File download_dir;
    protected long size = -2L;
    protected TOTorrent[] torrent_holder = new TOTorrent[1];
    protected DownloadManager download_manager;
    protected Download download;
    protected boolean cancelled;
    protected boolean completed;
    protected ResourceDownloader current_downloader;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDTorrent");

    public ResourceDownloaderTorrentImpl(ResourceDownloaderBaseImpl _parent, ResourceDownloader _delegate, boolean _persistent, File _download_dir) {
        super(_parent);
        this.persistent = _persistent;
        this.download_dir = _download_dir;
        this.delegate = (ResourceDownloaderBaseImpl)_delegate;
        this.delegate.setParent(this);
        this.download_manager = PluginInitializer.getDefaultInterface().getDownloadManager();
    }

    public String getName() {
        return this.delegate.getName() + ": torrent";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                this.size = this.getSizeSupport();
                Object var2_1 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                this.setSize(this.size);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                this.setSize(this.size);
                throw throwable;
            }
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            this.delegate.setSize(this.size);
        }
    }

    public void setProperty(String name, Object value) throws ResourceDownloaderException {
        this.setPropertySupport(name, value);
        this.delegate.setProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            block10: {
                if (this.torrent_holder[0] != null) break block10;
                ResourceDownloaderBaseImpl x = this.delegate.getClone(this);
                this.addReportListener(x);
                InputStream is = x.download();
                try {
                    this.torrent_holder[0] = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException e) {}
                if (!this.torrent_holder[0].isSimpleTorrent()) {
                    throw new ResourceDownloaderException(this, "Only simple torrents supported");
                }
            }
            try {
                String file_str = new String(this.torrent_holder[0].getName());
                int pos = file_str.lastIndexOf(".");
                String file_type = pos != -1 ? file_str.substring(pos + 1) : null;
                this.setProperty("ContentType", HTTPUtils.guessContentTypeFromFileType(file_type));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            return this.torrent_holder[0].getSize();
        }
        catch (TOTorrentException e) {
            throw new ResourceDownloaderException(this, "Torrent deserialisation failed", e);
        }
    }

    protected void setSizeAndTorrent(long _size, TOTorrent[] _torrent_holder) {
        this.size = _size;
        this.torrent_holder = _torrent_holder;
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderTorrentImpl c = new ResourceDownloaderTorrentImpl(parent, this.delegate.getClone(this), this.persistent, this.download_dir);
        c.setSizeAndTorrent(this.size, this.torrent_holder);
        c.setProperties(this);
        return c;
    }

    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else if (this.torrent_holder[0] == null) {
                this.current_downloader = this.delegate.getClone(this);
                this.informActivity(this.getLogIndent() + "Downloading: " + this.getName());
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            } else {
                this.downloadTorrent();
            }
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void downloadTorrent() {
        try {
            String name = new String(this.torrent_holder[0].getName(), "UTF8");
            this.informActivity(this.getLogIndent() + "Downloading: " + name);
            final File torrent_file = AETemporaryFileHandler.createSemiTempFile();
            if (this.download_dir != null && !this.download_dir.exists()) {
                FileUtil.mkdirs(this.download_dir);
            }
            final File data_dir = this.download_dir == null ? torrent_file.getParentFile() : this.download_dir;
            final TOTorrent torrent = this.torrent_holder[0];
            TorrentUtils.setFlag(torrent, 1, true);
            torrent.serialiseToBEncodedFile(torrent_file);
            try {
                int existing_state;
                Download existing = this.download_manager.getDownload(torrent.getHash());
                if (existing != null && ((existing_state = existing.getState()) == 8 || existing_state == 7)) {
                    this.informActivity(this.getLogIndent() + "Deleting existing stopped/error state download for " + name);
                    existing.remove(true, true);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.download = this.persistent ? this.download_manager.addDownload(new TorrentImpl(torrent), torrent_file, data_dir) : this.download_manager.addNonPersistentDownload(new TorrentImpl(torrent), torrent_file, data_dir);
            this.download.moveTo(1);
            this.download.setForceStart(true);
            this.download.setFlag(4L, true);
            this.download_manager.addListener(new DownloadManagerListener(){

                public void downloadAdded(Download download) {
                }

                public void downloadRemoved(Download _download) {
                    if (ResourceDownloaderTorrentImpl.this.download == _download) {
                        ResourceDownloaderTorrentImpl.this.downloadRemoved(torrent_file, data_dir);
                    }
                }
            });
            this.download.addListener(new DownloadListener(){

                public void stateChanged(final Download download, int old_state, int new_state) {
                    if (new_state == 5) {
                        download.removeListener(this);
                        PluginInitializer.getDefaultInterface().getUtilities().createThread("resource complete event dispatcher", new Runnable(){

                            public void run() {
                                ResourceDownloaderTorrentImpl.this.downloadSucceeded(download, torrent_file, data_dir);
                            }
                        });
                    }
                }

                public void positionChanged(Download download, int oldPosition, int newPosition) {
                }
            });
            AEThread t = new AEThread("RDTorrent percentage checker"){

                public void runSupport() {
                    int last_percentage = 0;
                    while (ResourceDownloaderTorrentImpl.this.result == null) {
                        int this_percentage = ResourceDownloaderTorrentImpl.this.download.getStats().getDownloadCompleted(false) / 10;
                        long total = torrent.getSize();
                        if (this_percentage != last_percentage) {
                            ResourceDownloaderTorrentImpl.this.reportPercentComplete(ResourceDownloaderTorrentImpl.this, this_percentage);
                            last_percentage = this_percentage;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            };
            t.setDaemon(true);
            t.start();
            if (this.download.getState() == 5) {
                this.downloadSucceeded(this.download, torrent_file, data_dir);
            }
        }
        catch (Throwable e) {
            this.failed(this, new ResourceDownloaderException(this, "Torrent download failed", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadSucceeded(Download download, File torrent_file, File data_dir) {
        ResourceDownloaderTorrentImpl resourceDownloaderTorrentImpl = this;
        synchronized (resourceDownloaderTorrentImpl) {
            if (this.completed) {
                return;
            }
            this.completed = true;
        }
        this.reportActivity("Torrent download complete");
        File target_file = new File(data_dir, new String(this.torrent_holder[0].getFiles()[0].getPathComponents()[0]));
        if (!target_file.exists()) {
            File actual_target_file = new File(download.getSavePath());
            try {
                if (this.download_dir != null && actual_target_file.exists()) {
                    FileUtil.copyFile(actual_target_file, target_file);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            target_file = actual_target_file;
        }
        try {
            if (!target_file.exists()) {
                throw new Exception("File '" + target_file.toString() + "' not found");
            }
            FileInputStream data = new FileInputStream(target_file);
            this.informComplete(data);
            this.result = data;
            this.done_sem.release();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.failed(this, new ResourceDownloaderException(this, "Failed to read downloaded torrent data: " + e.getMessage(), e));
        }
    }

    protected void downloadRemoved(File torrent_file, File data_dir) {
        this.reportActivity("Torrent removed");
        if (!(this.result instanceof InputStream)) {
            this.failed(this, new ResourceDownloaderException(this, "Download did not complete"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderCancelledException(this);
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean completed(ResourceDownloader downloader, InputStream data) {
        block10: {
            block9: {
                this.torrent_holder[0] = TOTorrentFactory.deserialiseFromBEncodedInputStream(data);
                if (this.torrent_holder[0].isSimpleTorrent()) {
                    this.downloadTorrent();
                    break block9;
                }
                this.failed(this, new ResourceDownloaderException(this, "Only simple torrents supported"));
            }
            Object var5_3 = null;
            try {
                data.close();
            }
            catch (IOException e2) {}
            break block10;
            {
                catch (TOTorrentException e) {
                    this.failed(downloader, new ResourceDownloaderException(this, "Torrent deserialisation failed", e));
                    Object var5_4 = null;
                    try {
                        data.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    data.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.result = e;
        this.done_sem.release();
        this.informFailed(e);
    }

    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
        if (downloader == this) {
            this.informPercentDone(percentage);
        }
    }
}

