/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.proxy.AEProxySelector;
import com.aelitis.azureus.core.proxy.AEProxySelectorFactory;
import com.aelitis.azureus.plugins.I2PHelpers;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerController;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class PrivacyView
implements UISWTViewCoreEventListener,
DownloadManagerStateAttributeListener {
    public static final String MSGID_PREFIX = "PrivacyView";
    private UISWTView swtView;
    private Composite cMainComposite;
    private ScrolledComposite sc;
    private Composite parent;
    private Composite i2p_lookup_comp;
    private Button i2p_lookup_button;
    private Button[] network_buttons;
    private Button[] source_buttons;
    private Button ipfilter_enabled;
    private BufferedLabel peer_info;
    private Label torrent_info;
    private Label tracker_info;
    private Label webseed_info;
    private BufferedLabel vpn_info;
    private BufferedLabel socks_state;
    private BufferedLabel socks_current;
    private BufferedLabel socks_fails;
    private Label socks_more;
    private DownloadManager current_dm;
    private Set<String> enabled_networks = new HashSet<String>();
    private Set<String> enabled_sources = new HashSet<String>();

    private String getFullTitle() {
        return MessageText.getString("label.privacy");
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.parent = (Composite)event2.getData();
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.cMainComposite);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                this.dataSourceChanged(ds);
                break;
            }
            case 3: {
                this.initialize();
                if (this.current_dm != null) break;
                this.dataSourceChanged(this.swtView.getDataSource());
                break;
            }
            case 4: {
                this.delete();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void delete() {
        Utils.disposeComposite((Composite)this.sc);
        this.dataSourceChanged(null);
    }

    private void refresh() {
        this.updatePeersEtc(this.current_dm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataSourceChanged(Object ds) {
        PrivacyView privacyView = this;
        synchronized (privacyView) {
            final DownloadManager old_dm = this.current_dm;
            if (ds != this.current_dm) {
                Object[] objs;
                this.current_dm = ds == null ? null : (ds instanceof DownloadManager ? (DownloadManager)ds : (ds instanceof Object[] ? ((objs = (Object[])ds).length == 1 && objs[0] instanceof DownloadManager ? (DownloadManager)objs[0] : null) : null));
            }
            if (old_dm == this.current_dm) {
                return;
            }
            final DownloadManager new_dm = this.current_dm;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    PrivacyView.this.swt_updateFields(old_dm, new_dm);
                }
            });
        }
    }

    private void initialize() {
        GridData gd;
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            if (this.parent == null || this.parent.isDisposed()) {
                return;
            }
            this.sc = new ScrolledComposite(this.parent, 512);
            this.sc.setExpandHorizontal(true);
            this.sc.setExpandVertical(true);
            this.sc.getVerticalBar().setIncrement(16);
            Layout parentLayout = this.parent.getLayout();
            if (parentLayout instanceof GridLayout) {
                gd = new GridData(4, 4, true, true);
                this.sc.setLayoutData((Object)gd);
            } else if (parentLayout instanceof FormLayout) {
                this.sc.setLayoutData((Object)Utils.getFilledFormData());
            }
            this.cMainComposite = new Composite((Composite)this.sc, 0);
            this.sc.setContent((Control)this.cMainComposite);
        } else {
            Utils.disposeComposite(this.cMainComposite, false);
        }
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.cMainComposite.setLayout((Layout)layout);
        Composite i2p_install_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData(768);
        i2p_install_comp.setLayoutData((Object)gd);
        i2p_install_comp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(i2p_install_comp, 0);
        label.setText("I2P Network Availability");
        final Button i2p_install = new Button(i2p_install_comp, 8);
        boolean i2p_installed = I2PHelpers.isI2PInstalled();
        i2p_install.setText(i2p_installed ? "I2P is available" : "Install I2P");
        i2p_install.setEnabled(!i2p_installed);
        i2p_install.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                final boolean[] result = new boolean[]{false};
                I2PHelpers.installI2PHelper(null, result, new Runnable(){

                    public void run() {
                        Utils.execSWTThread(new Runnable(){

                            public void run() {
                                boolean i2p_installed = result[0];
                                i2p_install.setText(i2p_installed ? "I2P is available" : "Install I2P");
                                i2p_install.setEnabled(!i2p_installed);
                            }
                        });
                    }
                });
            }
        });
        this.i2p_lookup_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData();
        gd.widthHint = 300;
        gd.heightHint = 200;
        this.i2p_lookup_comp.setLayoutData((Object)gd);
        this.i2p_lookup_comp.setBackground(Colors.white);
        this.i2p_lookup_button = new Button(this.cMainComposite, 8);
        this.i2p_lookup_button.setText("Lookup I2P Peers");
        this.i2p_lookup_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                Utils.disposeComposite(PrivacyView.this.i2p_lookup_comp, false);
                PluginInterface i2p_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azneti2phelper", true);
                if (i2p_pi != null) {
                    IPCInterface ipc = i2p_pi.getIPC();
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("server_id", "Scraper");
                    options.put("server_id_transient", true);
                    options.put("ui_composite", PrivacyView.this.i2p_lookup_comp);
                    IPCInterface callback = new IPCInterface(){

                        public Object invoke(String methodName, Object[] params) throws IPCException {
                            if (!methodName.equals("statusUpdate") && methodName.equals("peerFound")) {
                                String host = (String)params[0];
                                int peer_type = (Integer)params[1];
                                System.out.println(peer_type + "/" + host);
                            }
                            return null;
                        }

                        public boolean canInvoke(String methodName, Object[] params) {
                            return true;
                        }
                    };
                    byte[] hash = (byte[])PrivacyView.this.i2p_lookup_button.getData("hash");
                    try {
                        ipc.invoke("lookupTorrent", new Object[]{"", hash, options, callback});
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.i2p_lookup_button.setEnabled(false);
        Composite network_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData(768);
        network_comp.setLayoutData((Object)gd);
        this.network_buttons = new Button[AENetworkClassifier.AT_NETWORKS.length];
        network_comp.setLayout((Layout)new GridLayout(this.network_buttons.length + 1, false));
        label = new Label(network_comp, 0);
        label.setText("Networks:");
        for (int i = 0; i < this.network_buttons.length; ++i) {
            final String nn = AENetworkClassifier.AT_NETWORKS[i];
            String msg_text = "ConfigView.section.connection.networks." + nn;
            Button button = new Button(network_comp, 32);
            Messages.setLanguageText((Widget)button, msg_text);
            this.network_buttons[i] = button;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ((Button)e.widget).getSelection();
                    if (PrivacyView.this.current_dm != null) {
                        PrivacyView.this.current_dm.getDownloadState().setNetworkEnabled(nn, selected);
                    }
                }
            });
            GridData gridData = new GridData();
            button.setLayoutData((Object)gridData);
        }
        Composite sources_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData(768);
        sources_comp.setLayoutData((Object)gd);
        this.source_buttons = new Button[PEPeerSource.PS_SOURCES.length];
        sources_comp.setLayout((Layout)new GridLayout(this.source_buttons.length + 1, false));
        label = new Label(sources_comp, 0);
        label.setText("Peer Sources:");
        for (int i = 0; i < this.source_buttons.length; ++i) {
            final String src = PEPeerSource.PS_SOURCES[i];
            String msg_text = "ConfigView.section.connection.peersource." + src;
            Button button = new Button(sources_comp, 32);
            Messages.setLanguageText((Widget)button, msg_text);
            this.source_buttons[i] = button;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ((Button)e.widget).getSelection();
                    if (PrivacyView.this.current_dm != null) {
                        PrivacyView.this.current_dm.getDownloadState().setPeerSourceEnabled(src, selected);
                    }
                }
            });
            GridData gridData = new GridData();
            button.setLayoutData((Object)gridData);
        }
        Composite ipfilter_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData(768);
        ipfilter_comp.setLayoutData((Object)gd);
        ipfilter_comp.setLayout((Layout)new GridLayout(2, false));
        label = new Label(ipfilter_comp, 0);
        label.setText("IP Filter:");
        this.ipfilter_enabled = new Button(ipfilter_comp, 32);
        this.ipfilter_enabled.setText("Enabled");
        gd = new GridData(768);
        this.ipfilter_enabled.setLayoutData((Object)gd);
        Composite torrent_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData(768);
        torrent_comp.setLayoutData((Object)gd);
        torrent_comp.setLayout((Layout)new GridLayout(2, false));
        label = new Label(torrent_comp, 0);
        label.setText("Torrent:");
        this.torrent_info = new Label(torrent_comp, 0);
        gd = new GridData(768);
        this.torrent_info.setLayoutData((Object)gd);
        Composite tracker_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData(768);
        tracker_comp.setLayoutData((Object)gd);
        tracker_comp.setLayout((Layout)new GridLayout(2, false));
        label = new Label(tracker_comp, 0);
        label.setText("Trackers:");
        this.tracker_info = new Label(tracker_comp, 0);
        gd = new GridData(768);
        this.tracker_info.setLayoutData((Object)gd);
        Composite webseed_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData(768);
        webseed_comp.setLayoutData((Object)gd);
        webseed_comp.setLayout((Layout)new GridLayout(2, false));
        label = new Label(webseed_comp, 0);
        label.setText("Web Seeds:");
        this.webseed_info = new Label(webseed_comp, 0);
        gd = new GridData(768);
        this.webseed_info.setLayoutData((Object)gd);
        Composite vpn_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData(768);
        vpn_comp.setLayoutData((Object)gd);
        vpn_comp.setLayout((Layout)new GridLayout(2, false));
        label = new Label(vpn_comp, 0);
        label.setText("VPN Status:");
        this.vpn_info = new BufferedLabel(vpn_comp, 0x20000000);
        gd = new GridData(768);
        this.vpn_info.setLayoutData(gd);
        Composite socks_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData(768);
        socks_comp.setLayoutData((Object)gd);
        socks_comp.setLayout((Layout)new GridLayout(10, false));
        label = new Label(socks_comp, 0);
        label.setText("SOCKS Status:");
        label = new Label(socks_comp, 0);
        label.setText(MessageText.getString("label.proxy") + ":");
        this.socks_state = new BufferedLabel(socks_comp, 0x20000000);
        gd = new GridData();
        gd.widthHint = 120;
        this.socks_state.setLayoutData(gd);
        label = new Label(socks_comp, 0);
        label.setText(MessageText.getString("PeersView.state") + ":");
        this.socks_current = new BufferedLabel(socks_comp, 0x20000000);
        gd = new GridData();
        gd.widthHint = 120;
        this.socks_current.setLayoutData(gd);
        label = new Label(socks_comp, 0);
        label.setText(MessageText.getString("label.fails") + ":");
        this.socks_fails = new BufferedLabel(socks_comp, 0x20000000);
        gd = new GridData();
        gd.widthHint = 120;
        this.socks_fails.setLayoutData(gd);
        label = new Label(socks_comp, 0);
        gd = new GridData(768);
        gd.horizontalAlignment = 32;
        this.socks_more = new Label(socks_comp, 0);
        this.socks_more.setText(MessageText.getString("label.more") + "...");
        this.socks_more.setLayoutData((Object)gd);
        this.socks_more.setCursor(this.socks_more.getDisplay().getSystemCursor(21));
        this.socks_more.setForeground(Colors.blue);
        this.socks_more.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                PrivacyView.this.showSOCKSInfo();
            }

            public void mouseUp(MouseEvent arg0) {
                PrivacyView.this.showSOCKSInfo();
            }
        });
        Composite peer_comp = new Composite(this.cMainComposite, 0);
        gd = new GridData(768);
        peer_comp.setLayoutData((Object)gd);
        peer_comp.setLayout((Layout)new GridLayout(2, false));
        label = new Label(peer_comp, 0);
        label.setText("Peer Status:");
        this.peer_info = new BufferedLabel(peer_comp, 0x20000000);
        gd = new GridData(768);
        this.peer_info.setLayoutData(gd);
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = PrivacyView.this.sc.getClientArea();
                Point size = PrivacyView.this.cMainComposite.computeSize(r.width, -1);
                PrivacyView.this.sc.setMinSize(size);
            }
        });
        this.swt_updateFields(null, this.current_dm);
        this.updatePeersEtc(this.current_dm);
        this.updateVPNSocks();
        Rectangle r = this.sc.getClientArea();
        Point size = this.cMainComposite.computeSize(r.width, -1);
        this.sc.setMinSize(size);
    }

    private void swt_updateFields(DownloadManager old_dm, DownloadManager new_dm) {
        DownloadManagerState state;
        TOTorrent torrent;
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            return;
        }
        byte[] hash = null;
        if (new_dm != null && (torrent = new_dm.getTorrent()) != null) {
            try {
                hash = torrent.getHash();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.i2p_lookup_button.setData("hash", hash);
        this.i2p_lookup_button.setEnabled(hash != null);
        Utils.disposeComposite(this.i2p_lookup_comp, false);
        if (old_dm != null) {
            state = old_dm.getDownloadState();
            state.removeListener(this, "networks", 1);
            state.removeListener(this, "peersources", 1);
            state.removeListener(this, "flags", 1);
        }
        if (new_dm != null) {
            state = new_dm.getDownloadState();
            state.addListener(this, "networks", 1);
            state.addListener(this, "peersources", 1);
            state.addListener(this, "flags", 1);
            this.setupNetworksAndSources(new_dm);
            this.setupTorrentTracker(new_dm);
        } else {
            this.setupNetworksAndSources(null);
            this.setupTorrentTracker(null);
        }
    }

    private void setupNetworksAndSources(final DownloadManager dm) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int i;
                PrivacyView.this.enabled_networks.clear();
                PrivacyView.this.enabled_sources.clear();
                if (PrivacyView.this.network_buttons == null || PrivacyView.this.network_buttons[0].isDisposed()) {
                    return;
                }
                DownloadManagerState state = null;
                String[] networks = null;
                String[] sources = null;
                if (dm != null) {
                    state = dm.getDownloadState();
                    networks = state.getNetworks();
                    sources = state.getPeerSources();
                }
                if (networks != null) {
                    PrivacyView.this.enabled_networks.addAll(Arrays.asList(networks));
                }
                for (i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                    String net = AENetworkClassifier.AT_NETWORKS[i];
                    PrivacyView.this.network_buttons[i].setEnabled(networks != null);
                    PrivacyView.this.network_buttons[i].setSelection(PrivacyView.this.enabled_networks.contains(net));
                }
                if (sources != null) {
                    PrivacyView.this.enabled_sources.addAll(Arrays.asList(sources));
                }
                for (i = 0; i < PEPeerSource.PS_SOURCES.length; ++i) {
                    String source = PEPeerSource.PS_SOURCES[i];
                    PrivacyView.this.source_buttons[i].setEnabled(sources != null && state.isPeerSourcePermitted(source));
                    PrivacyView.this.source_buttons[i].setSelection(PrivacyView.this.enabled_sources.contains(source));
                }
                if (state != null) {
                    PrivacyView.this.ipfilter_enabled.setEnabled(true);
                    PrivacyView.this.ipfilter_enabled.setSelection(!state.getFlag(256L));
                } else {
                    PrivacyView.this.ipfilter_enabled.setEnabled(false);
                }
                PrivacyView.this.setupTorrentTracker(dm);
            }
        });
    }

    private void setupTorrentTracker(final DownloadManager dm) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                ExternalSeedReader[] seeds;
                TOTorrentAnnounceURLSet[] sets;
                TOTorrent torrent;
                if (PrivacyView.this.torrent_info == null || PrivacyView.this.torrent_info.isDisposed()) {
                    return;
                }
                TOTorrent tOTorrent = torrent = dm == null ? null : dm.getTorrent();
                if (torrent == null) {
                    PrivacyView.this.torrent_info.setText("");
                    PrivacyView.this.tracker_info.setText("");
                    PrivacyView.this.webseed_info.setText("");
                    return;
                }
                boolean private_torrent = torrent.getPrivate();
                PrivacyView.this.torrent_info.setText("Private=" + private_torrent);
                boolean decentralised = false;
                HashSet<String> tracker_nets = new HashSet<String>();
                URL announce_url = torrent.getAnnounceURL();
                if (announce_url != null) {
                    if (TorrentUtils.isDecentralised(announce_url)) {
                        decentralised = true;
                    } else {
                        String net = AENetworkClassifier.categoriseAddress(announce_url.getHost());
                        tracker_nets.add(net);
                    }
                }
                TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
                for (TOTorrentAnnounceURLSet set : sets = group.getAnnounceURLSets()) {
                    URL[] urls;
                    for (URL u : urls = set.getAnnounceURLs()) {
                        if (TorrentUtils.isDecentralised(u)) {
                            decentralised = true;
                            continue;
                        }
                        String net = AENetworkClassifier.categoriseAddress(u.getHost());
                        tracker_nets.add(net);
                    }
                }
                boolean tracker_source_enabled = PrivacyView.this.enabled_sources.contains("Tracker");
                boolean dht_source_enabled = PrivacyView.this.enabled_sources.contains("DHT");
                String tracker_str = "";
                tracker_str = "Decentralised";
                String net_string = "";
                if (dht_source_enabled && !private_torrent) {
                    for (String net : new String[]{"Public", "I2P"}) {
                        if (!PrivacyView.this.enabled_networks.contains(net)) continue;
                        net_string = net_string + (net_string.length() == 0 ? "" : ", ") + net;
                    }
                }
                tracker_str = net_string.length() == 0 ? tracker_str + " (disabled)" : tracker_str + " [" + net_string + "]";
                for (String net : tracker_nets) {
                    if (!tracker_source_enabled || !PrivacyView.this.enabled_networks.contains(net)) {
                        net = net + " (disabled)";
                    }
                    tracker_str = tracker_str + (tracker_str.length() == 0 ? "" : ", ") + net;
                }
                PrivacyView.this.tracker_info.setText(tracker_str);
                HashSet<String> webseed_nets = new HashSet<String>();
                ExternalSeedPlugin esp = DownloadManagerController.getExternalSeedPlugin();
                if (esp != null && (seeds = esp.getManualWebSeeds(PluginCoreUtils.wrap(torrent))) != null) {
                    for (ExternalSeedReader seed : seeds) {
                        URL u = seed.getURL();
                        String net = AENetworkClassifier.categoriseAddress(u.getHost());
                        webseed_nets.add(net);
                    }
                }
                String webseeds_str = "";
                if (webseed_nets.isEmpty()) {
                    webseeds_str = "None";
                } else {
                    for (String net : webseed_nets) {
                        if (!PrivacyView.this.enabled_networks.contains(net)) {
                            net = net + " (disabled)";
                        }
                        webseeds_str = webseeds_str + (webseeds_str.length() == 0 ? "" : ", ") + net;
                    }
                }
                PrivacyView.this.webseed_info.setText(webseeds_str);
            }
        });
    }

    private void updatePeersEtc(final DownloadManager dm) {
        final PEPeerManager pm = dm != null ? dm.getPeerManager() : null;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (PrivacyView.this.peer_info == null || PrivacyView.this.peer_info.isDisposed()) {
                    return;
                }
                if (pm == null) {
                    PrivacyView.this.peer_info.setText(dm == null ? "" : "Download is not running");
                } else {
                    AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
                    Proxy proxy = proxy_selector.getActiveProxy();
                    boolean socks_bad_incoming = false;
                    List<PEPeer> peers = pm.getPeers();
                    String[] all_nets = AENetworkClassifier.AT_NETWORKS;
                    int[] counts = new int[all_nets.length];
                    for (PEPeer peer : peers) {
                        String net = PeerUtils.getNetwork(peer);
                        for (int i = 0; i < all_nets.length; ++i) {
                            if (all_nets[i] != net) continue;
                            int n = i;
                            counts[n] = counts[n] + 1;
                            break;
                        }
                        if (proxy == null || !peer.isIncoming() || peer.isLANLocal()) continue;
                        try {
                            if (InetAddress.getByAddress(HostNameToIPResolver.hostAddressToBytes(peer.getIp())).isLoopbackAddress()) {
                                continue;
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        socks_bad_incoming = true;
                        break;
                    }
                    String str = "";
                    for (int i = 0; i < all_nets.length; ++i) {
                        int num = counts[i];
                        if (num <= 0) continue;
                        str = str + (str.length() == 0 ? "" : ", ") + all_nets[i] + "=" + num;
                    }
                    if (str.length() == 0) {
                        str = "No peers connected";
                    }
                    if (socks_bad_incoming) {
                        str = str + " (non-local incoming connection detected)";
                    }
                    PrivacyView.this.peer_info.setText(str);
                }
                PrivacyView.this.updateVPNSocks();
            }
        });
    }

    private void updateVPNSocks() {
        AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
        Proxy proxy = proxy_selector.getActiveProxy();
        this.socks_more.setEnabled(proxy != null);
        if (Constants.isOSX) {
            this.socks_more.setForeground(proxy == null ? Colors.light_grey : Colors.blue);
        }
        this.socks_state.setText(proxy == null ? MessageText.getString("label.inactive") : ((InetSocketAddress)proxy.address()).getHostName());
        if (proxy == null) {
            this.socks_current.setText("");
            this.socks_fails.setText("");
        } else {
            long last_con = proxy_selector.getLastConnectionTime();
            long last_fail = proxy_selector.getLastFailTime();
            int total_cons = proxy_selector.getConnectionCount();
            int total_fails = proxy_selector.getFailCount();
            long now = SystemTime.getMonotonousTime();
            long con_ago = now - last_con;
            long fail_ago = now - last_fail;
            String state_str = last_fail < 0L ? "PeerManager.status.ok" : (fail_ago > 60000L ? (con_ago < fail_ago ? "PeerManager.status.ok" : "SpeedView.stats.unknown") : "ManagerItem.error");
            this.socks_current.setText(MessageText.getString(state_str) + ", con=" + total_cons);
            long fail_ago_secs = fail_ago / 1000L;
            if (fail_ago_secs == 0L) {
                fail_ago_secs = 1L;
            }
            this.socks_fails.setText(last_fail < 0L ? "" : DisplayFormatters.formatETA(fail_ago_secs, false) + " " + MessageText.getString("label.ago") + ", tot=" + total_fails);
        }
        this.vpn_info.setText(NetworkAdmin.getSingleton().getBindStatus());
    }

    public void attributeEventOccurred(DownloadManager download, String attribute, int event_type) {
        this.setupNetworksAndSources(download);
    }

    private void showSOCKSInfo() {
        AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
        String info = proxy_selector.getInfo();
        TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("proxy.info.title"), null, info, false);
    }
}

