/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.util.List;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class CategoryUIUtils {
    public static void setupCategoryMenu(final Menu menu, final Category category) {
        menu.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX) {
                    return;
                }
                e.widget.getDisplay().asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (bShown || menu.isDisposed()) {
                            return;
                        }
                        MenuItem[] items = menu.getItems();
                        for (int i = 0; i < items.length; ++i) {
                            items[i].dispose();
                        }
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                this.bShown = true;
                CategoryUIUtils.createMenuItems(menu, category);
            }
        });
    }

    public static void createMenuItems(Menu menu, final Category category) {
        AZ3Functions.provider.TranscodeTarget[] tts;
        AZ3Functions.provider provider2;
        BuddyPlugin buddy_plugin;
        if (category.getType() == 0) {
            MenuItem itemDelete = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemDelete, "MyTorrentsView.menu.category.delete");
            itemDelete.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    List<DownloadManager> managers = category.getDownloadManagers(gm.getDownloadManagers());
                    DownloadManager[] dms = managers.toArray(new DownloadManager[managers.size()]);
                    for (int i = 0; i < dms.length; ++i) {
                        dms[i].getDownloadState().setCategory(null);
                    }
                    CategoryManager.removeCategory(category);
                }
            });
        }
        if (category.getType() != 1) {
            long maxDownload = (long)COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * 1024L;
            long maxUpload = (long)COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0) * 1024L;
            int down_speed = category.getDownloadSpeed();
            int up_speed = category.getUploadSpeed();
            ViewUtils.addSpeedMenu(menu.getShell(), menu, true, true, true, true, false, down_speed == 0, down_speed, down_speed, maxDownload, false, up_speed == 0, up_speed, up_speed, maxUpload, 1, null, new ViewUtils.SpeedAdapter(){

                public void setDownSpeed(int val) {
                    category.setDownloadSpeed(val);
                }

                public void setUpSpeed(int val) {
                    category.setUploadSpeed(val);
                }
            });
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        List<DownloadManager> managers = category.getDownloadManagers(gm.getDownloadManagers());
        final DownloadManager[] dms = managers.toArray(new DownloadManager[managers.size()]);
        boolean start = false;
        boolean stop = false;
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = dms[i];
            stop = stop || ManagerUtils.isStopable(dm);
            start = start || ManagerUtils.isStartable(dm);
        }
        MenuItem itemQueue = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemQueue, "MyTorrentsView.menu.queue");
        Utils.setMenuItemImage(itemQueue, "start");
        itemQueue.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                List<DownloadManager> managers = category.getDownloadManagers(gm.getDownloadManagers());
                Object[] dms = managers.toArray();
                TorrentUtil.queueDataSources(dms, true);
            }
        });
        itemQueue.setEnabled(start);
        MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        Utils.setMenuItemImage(itemStop, "stop");
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                List<DownloadManager> managers = category.getDownloadManagers(gm.getDownloadManagers());
                Object[] dms = managers.toArray();
                TorrentUtil.stopDataSources(dms);
            }
        });
        itemStop.setEnabled(stop);
        if (category.canBePublic()) {
            new MenuItem(menu, 2);
            final MenuItem itemPublic = new MenuItem(menu, 32);
            itemPublic.setSelection(category.isPublic());
            Messages.setLanguageText((Widget)itemPublic, "cat.share");
            itemPublic.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    category.setPublic(itemPublic.getSelection());
                }
            });
        }
        PluginInterface bpi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByClass(BuddyPlugin.class);
        int cat_type = category.getType();
        if (bpi != null && cat_type != 2 && (buddy_plugin = (BuddyPlugin)bpi.getPlugin()).isClassicEnabled()) {
            Menu share_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem share_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)share_item, "azbuddy.ui.menu.cat.share");
            share_item.setMenu(share_menu);
            List<BuddyPluginBuddy> buddies = buddy_plugin.getBuddies();
            if (buddies.size() == 0) {
                MenuItem item = new MenuItem(share_menu, 32);
                item.setText(MessageText.getString("general.add.friends"));
                item.setEnabled(false);
            } else {
                final String cname = cat_type == 1 ? "All" : category.getName();
                final boolean is_public = buddy_plugin.isPublicTagOrCategory(cname);
                MenuItem itemPubCat = new MenuItem(share_menu, 32);
                Messages.setLanguageText((Widget)itemPubCat, "general.all.friends");
                itemPubCat.setSelection(is_public);
                itemPubCat.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        if (is_public) {
                            buddy_plugin.removePublicTagOrCategory(cname);
                        } else {
                            buddy_plugin.addPublicTagOrCategory(cname);
                        }
                    }
                });
                new MenuItem(share_menu, 2);
                for (final BuddyPluginBuddy buddy : buddies) {
                    if (buddy.getNickName() == null) continue;
                    final boolean auth = buddy.isLocalRSSTagOrCategoryAuthorised(cname);
                    MenuItem itemShare = new MenuItem(share_menu, 32);
                    itemShare.setText(buddy.getName());
                    itemShare.setSelection(auth || is_public);
                    if (is_public) {
                        itemShare.setEnabled(false);
                    }
                    itemShare.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            if (auth) {
                                buddy.removeLocalAuthorisedRSSTagOrCategory(cname);
                            } else {
                                buddy.addLocalAuthorisedRSSTagOrCategory(cname);
                            }
                        }
                    });
                }
            }
        }
        if ((provider2 = AZ3Functions.getProvider()) != null && category.getType() != 1 && (tts = provider2.getTranscodeTargets()).length > 0) {
            Menu t_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem t_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)t_item, "cat.autoxcode");
            t_item.setMenu(t_menu);
            String existing = category.getStringAttribute("at_att");
            for (AZ3Functions.provider.TranscodeTarget tt : tts) {
                AZ3Functions.provider.TranscodeProfile[] profiles = tt.getProfiles();
                if (profiles.length <= 0) continue;
                Menu tt_menu = new Menu((Decorations)t_menu.getShell(), 4);
                MenuItem tt_item = new MenuItem(t_menu, 64);
                tt_item.setText(tt.getName());
                tt_item.setMenu(tt_menu);
                for (final AZ3Functions.provider.TranscodeProfile tp2 : profiles) {
                    boolean selected;
                    final MenuItem p_item = new MenuItem(tt_menu, 32);
                    p_item.setText(tp2.getName());
                    boolean bl = selected = existing != null && existing.equals(tp2.getUID());
                    if (selected) {
                        Utils.setMenuItemImage(tt_item, "blacktick");
                    }
                    p_item.setSelection(selected);
                    p_item.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            category.setStringAttribute("at_att", p_item.getSelection() ? tp2.getUID() : null);
                        }
                    });
                }
            }
        }
        final MenuItem rssOption = new MenuItem(menu, 32);
        rssOption.setSelection(category.getBooleanAttribute("at_rss_gen"));
        Messages.setLanguageText((Widget)rssOption, "cat.rss.gen");
        rssOption.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                boolean set = rssOption.getSelection();
                category.setBooleanAttribute("at_rss_gen", set);
            }
        });
        if (cat_type != 2 && cat_type != 1) {
            final MenuItem upPriority = new MenuItem(menu, 32);
            upPriority.setSelection(category.getIntAttribute("at_up_pri") > 0);
            Messages.setLanguageText((Widget)upPriority, "cat.upload.priority");
            upPriority.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    boolean set = upPriority.getSelection();
                    category.setIntAttribute("at_up_pri", set ? 1 : 0);
                }
            });
        }
        MenuItem itemOptions = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOptions, "cat.options");
        itemOptions.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.getMDI().showEntryByID("TorrentOptionsView", dms);
                }
            }
        });
        if (dms.length == 0) {
            itemOptions.setEnabled(false);
        }
    }
}

