/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.QTFastStartRAF;
import java.io.File;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRandomReadRequest;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerFileInfoFile
implements DiskManagerFileInfo {
    private byte[] hash;
    private File file;

    public DiskManagerFileInfoFile(File _file) {
        this.file = _file;
        try {
            this.hash = new SHA1Simple().calculateHash(this.file.getAbsolutePath().getBytes("UTF-8"));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public void setPriority(boolean b) {
    }

    public int getNumericPriorty() {
        return 0;
    }

    public int getNumericPriority() {
        return 0;
    }

    public void setNumericPriority(int priority) {
        throw new RuntimeException("Not supported");
    }

    public void setSkipped(boolean b) {
        throw new RuntimeException("Not supported");
    }

    public void setDeleted(boolean b) {
    }

    public void setLink(File link_destination) {
        throw new RuntimeException("Not supported");
    }

    public File getLink() {
        return null;
    }

    public int getAccessMode() {
        return 1;
    }

    public long getDownloaded() {
        return this.getLength();
    }

    public long getLength() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }

    public File getFile(boolean follow_link) {
        return this.file;
    }

    public int getIndex() {
        return 0;
    }

    public int getFirstPieceNumber() {
        return 0;
    }

    public long getPieceSize() {
        return 32768L;
    }

    public int getNumPieces() {
        long piece_size = this.getPieceSize();
        return (int)((this.getLength() + piece_size - 1L) / piece_size);
    }

    public boolean isPriority() {
        return false;
    }

    public boolean isSkipped() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public byte[] getDownloadHash() {
        return this.hash;
    }

    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    public DiskManagerChannel createChannel() throws DownloadException {
        return new channel();
    }

    public DiskManagerRandomReadRequest createRandomReadRequest(long file_offset, long length, boolean reverse_order, DiskManagerListener listener) throws DownloadException {
        throw new DownloadException("Not supported");
    }

    protected class channel
    implements DiskManagerChannel {
        private volatile boolean channel_destroyed;
        private volatile long channel_position;

        protected channel() {
        }

        public DiskManagerRequest createRequest() {
            return new request();
        }

        public DiskManagerFileInfo getFile() {
            return DiskManagerFileInfoFile.this;
        }

        public long getPosition() {
            return this.channel_position;
        }

        public boolean isDestroyed() {
            return this.channel_destroyed;
        }

        public void destroy() {
            this.channel_destroyed = true;
        }

        protected class request
        implements DiskManagerRequest {
            private long offset;
            private long length;
            private long position;
            private int max_read_chunk = 131072;
            private volatile boolean cancelled;
            private String user_agent;
            private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

            protected request() {
            }

            public void setType(int type) {
                if (type != 1) {
                    throw new RuntimeException("Not supported");
                }
            }

            public void setOffset(long _offset) {
                this.offset = _offset;
            }

            public void setLength(long _length) {
                if (_length < 0L) {
                    throw new RuntimeException("Illegal argument");
                }
                this.length = _length;
            }

            public void setMaximumReadChunkSize(int size) {
                this.max_read_chunk = size;
            }

            public void setUserAgent(String agent) {
                this.user_agent = agent;
            }

            public long getAvailableBytes() {
                return this.getRemaining();
            }

            public long getRemaining() {
                return this.offset + this.length - this.position;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                QTFastStartRAF raf = null;
                String name = DiskManagerFileInfoFile.this.file.getName();
                int dot_pos = name.lastIndexOf(46);
                String ext = dot_pos < 0 ? "" : name.substring(dot_pos + 1);
                raf = new QTFastStartRAF(DiskManagerFileInfoFile.this.file, this.user_agent != null && QTFastStartRAF.isSupportedExtension(ext));
                raf.seek(this.offset);
                byte[] buffer = new byte[this.max_read_chunk];
                long rem = this.length;
                long pos = this.offset;
                while (rem > 0L) {
                    if (this.cancelled) {
                        throw new Exception("Cancelled");
                    }
                    if (channel.this.channel_destroyed) {
                        throw new Exception("Destroyed");
                    }
                    int chunk = (int)Math.min(rem, (long)this.max_read_chunk);
                    int len = raf.read(buffer, 0, chunk);
                    this.sendEvent(new event(new PooledByteBufferImpl(buffer, 0, len), pos, len));
                    rem -= (long)len;
                    pos += (long)len;
                }
                Object var13_11 = null;
                if (raf == null) return;
                try {
                    raf.close();
                    return;
                }
                catch (Throwable e2) {
                    Debug.out(e2);
                }
                return;
                {
                    catch (Throwable e) {
                        this.sendEvent(new event(e));
                        Object var13_12 = null;
                        if (raf == null) return;
                        try {
                            raf.close();
                            return;
                        }
                        catch (Throwable e2) {
                            Debug.out(e2);
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    if (raf == null) throw throwable;
                    try {
                        raf.close();
                        throw throwable;
                    }
                    catch (Throwable e2) {
                        Debug.out(e2);
                    }
                    throw throwable;
                }
            }

            public void cancel() {
                this.cancelled = true;
            }

            protected void sendEvent(event ev) {
                for (DiskManagerListener l : this.listeners) {
                    l.eventOccurred(ev);
                }
            }

            public void addListener(DiskManagerListener listener) {
                this.listeners.add(listener);
            }

            public void removeListener(DiskManagerListener listener) {
                this.listeners.remove(listener);
            }

            protected class event
            implements DiskManagerEvent {
                private int event_type;
                private Throwable error;
                private PooledByteBuffer buffer;
                private long event_offset;
                private int event_length;

                protected event(Throwable _error) {
                    this.event_type = 2;
                    this.error = _error;
                }

                protected event(PooledByteBuffer _buffer, long _offset, int _length) {
                    this.event_type = 1;
                    this.buffer = _buffer;
                    this.event_offset = _offset;
                    this.event_length = _length;
                    channel.this.channel_position = _offset + (long)_length - 1L;
                }

                public int getType() {
                    return this.event_type;
                }

                public DiskManagerRequest getRequest() {
                    return request.this;
                }

                public long getOffset() {
                    return this.event_offset;
                }

                public int getLength() {
                    return this.event_length;
                }

                public PooledByteBuffer getBuffer() {
                    return this.buffer;
                }

                public Throwable getFailure() {
                    return this.error;
                }
            }
        }
    }
}

