/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucket;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucketMT;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucketST;
import com.aelitis.azureus.core.networkmanager.impl.EntityHandler;
import com.aelitis.azureus.core.networkmanager.impl.NetworkManagerUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferProcessor {
    private static final boolean RATE_LIMIT_LAN_TOO = false;
    public static final int TYPE_UPLOAD = 0;
    public static final int TYPE_DOWNLOAD = 1;
    private final LimitedRateGroup max_rate;
    private final RateHandler main_rate_handler;
    private final ByteBucket main_bucket;
    private final EntityHandler main_controller;
    private final HashMap<LimitedRateGroup, GroupData> group_buckets = new HashMap();
    private final HashMap<NetworkConnectionBase, ConnectionData> connections = new HashMap();
    private final AEMonitor connections_mon;
    private final boolean multi_threaded;

    public TransferProcessor(int processor_type, LimitedRateGroup max_rate_limit, boolean multi_threaded) {
        this.max_rate = max_rate_limit;
        this.multi_threaded = multi_threaded;
        this.connections_mon = new AEMonitor("TransferProcessor:" + processor_type);
        this.main_bucket = this.createBucket(this.max_rate.getRateLimitBytesPerSecond());
        this.main_rate_handler = new RateHandler(){

            public int getCurrentNumBytesAllowed() {
                if (TransferProcessor.this.main_bucket.getRate() != TransferProcessor.this.max_rate.getRateLimitBytesPerSecond()) {
                    TransferProcessor.this.main_bucket.setRate(TransferProcessor.this.max_rate.getRateLimitBytesPerSecond());
                }
                return TransferProcessor.this.main_bucket.getAvailableByteCount();
            }

            public void bytesProcessed(int num_bytes_written) {
                TransferProcessor.this.main_bucket.setBytesUsed(num_bytes_written);
                TransferProcessor.this.max_rate.updateBytesUsed(num_bytes_written);
            }
        };
        this.main_controller = new EntityHandler(processor_type, this.main_rate_handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPeerConnection(NetworkConnectionBase connection, boolean upload) {
        ConnectionData conn_data = new ConnectionData();
        try {
            this.connections_mon.enter();
            LimitedRateGroup[] groups = connection.getRateLimiters(upload);
            GroupData[] group_datas = new GroupData[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                LimitedRateGroup group = groups[i];
                GroupData group_data = this.group_buckets.get(group);
                if (group_data == null) {
                    int limit = NetworkManagerUtilities.getGroupRateLimit(group);
                    group_data = new GroupData(this.createBucket(limit));
                    this.group_buckets.put(group, group_data);
                }
                group_data.group_size++;
                group_datas[i] = group_data;
            }
            ConnectionData.access$502(conn_data, groups);
            ConnectionData.access$602(conn_data, group_datas);
            conn_data.state = 0;
            this.connections.put(connection, conn_data);
            Object var11_10 = null;
            this.connections_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.connections_mon.exit();
            throw throwable;
        }
        this.main_controller.registerPeerConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetworkConnectionBase> getConnections() {
        try {
            this.connections_mon.enter();
            ArrayList<NetworkConnectionBase> arrayList = new ArrayList<NetworkConnectionBase>(this.connections.keySet());
            Object var3_2 = null;
            this.connections_mon.exit();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.connections_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(NetworkConnectionBase connection) {
        try {
            this.connections_mon.enter();
            boolean bl = this.connections.containsKey(connection);
            Object var4_3 = null;
            this.connections_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.connections_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterPeerConnection(NetworkConnectionBase connection) {
        try {
            this.connections_mon.enter();
            ConnectionData conn_data = this.connections.remove(connection);
            if (conn_data != null) {
                GroupData[] group_datas = conn_data.group_datas;
                for (int i = 0; i < group_datas.length; ++i) {
                    GroupData group_data = group_datas[i];
                    if (group_data.group_size == 1) {
                        this.group_buckets.remove(conn_data.groups[i]);
                        continue;
                    }
                    group_data.group_size--;
                }
            }
            Object var7_6 = null;
            this.connections_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.connections_mon.exit();
            throw throwable;
        }
        this.main_controller.cancelPeerConnection(connection);
    }

    public void setRateLimiterFreezeState(boolean frozen) {
        this.main_bucket.setFrozen(frozen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRateLimiter(NetworkConnectionBase connection, LimitedRateGroup group) {
        try {
            this.connections_mon.enter();
            ConnectionData conn_data = this.connections.get(connection);
            if (conn_data != null) {
                LimitedRateGroup[] groups = conn_data.groups;
                for (int i = 0; i < groups.length; ++i) {
                    if (groups[i] != group) continue;
                    Object var11_7 = null;
                    this.connections_mon.exit();
                    return;
                }
                GroupData group_data = this.group_buckets.get(group);
                if (group_data == null) {
                    int limit = NetworkManagerUtilities.getGroupRateLimit(group);
                    group_data = new GroupData(this.createBucket(limit));
                    this.group_buckets.put(group, group_data);
                }
                group_data.group_size++;
                GroupData[] group_datas = conn_data.group_datas;
                int len = groups.length;
                LimitedRateGroup[] new_groups = new LimitedRateGroup[len + 1];
                System.arraycopy(groups, 0, new_groups, 0, len);
                new_groups[len] = group;
                ConnectionData.access$502(conn_data, new_groups);
                GroupData[] new_group_datas = new GroupData[len + 1];
                System.arraycopy(group_datas, 0, new_group_datas, 0, len);
                new_group_datas[len] = group_data;
                ConnectionData.access$602(conn_data, new_group_datas);
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.connections_mon.exit();
            throw throwable;
        }
        Object var11_8 = null;
        this.connections_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeRateLimiter(NetworkConnectionBase connection, LimitedRateGroup group) {
        block7: {
            block8: {
                try {
                    this.connections_mon.enter();
                    ConnectionData conn_data = this.connections.get(connection);
                    if (conn_data == null) break block7;
                    LimitedRateGroup[] groups = conn_data.groups;
                    GroupData[] group_datas = conn_data.group_datas;
                    int len = groups.length;
                    if (len == 0) {
                        Object var13_7 = null;
                        this.connections_mon.exit();
                        return;
                    }
                    LimitedRateGroup[] new_groups = new LimitedRateGroup[len - 1];
                    GroupData[] new_group_datas = new GroupData[len - 1];
                    int pos = 0;
                    for (int i = 0; i < groups.length; ++i) {
                        if (groups[i] == group) {
                            GroupData group_data = conn_data.group_datas[i];
                            if (group_data.group_size == 1) {
                                this.group_buckets.remove(conn_data.groups[i]);
                                continue;
                            }
                            group_data.group_size--;
                            continue;
                        }
                        if (pos == new_groups.length) {
                            break block8;
                        }
                        new_groups[pos] = groups[i];
                        new_group_datas[pos] = group_datas[i];
                        ++pos;
                    }
                    ConnectionData.access$502(conn_data, new_groups);
                    ConnectionData.access$602(conn_data, new_group_datas);
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    this.connections_mon.exit();
                    throw throwable;
                }
            }
            Object var13_8 = null;
            this.connections_mon.exit();
            return;
        }
        Object var13_9 = null;
        this.connections_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradePeerConnection(final NetworkConnectionBase connection, int partition_id) {
        ConnectionData connection_data = null;
        try {
            this.connections_mon.enter();
            connection_data = this.connections.get(connection);
            Object var5_4 = null;
            this.connections_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.connections_mon.exit();
            throw throwable;
        }
        if (connection_data != null && connection_data.state == 0) {
            final ConnectionData conn_data = connection_data;
            this.main_controller.upgradePeerConnection(connection, new RateHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int getCurrentNumBytesAllowed() {
                    int allowed;
                    block10: {
                        if (TransferProcessor.this.main_bucket.getRate() != TransferProcessor.this.max_rate.getRateLimitBytesPerSecond()) {
                            TransferProcessor.this.main_bucket.setRate(TransferProcessor.this.max_rate.getRateLimitBytesPerSecond());
                        }
                        allowed = TransferProcessor.this.main_bucket.getAvailableByteCount();
                        if ((allowed -= connection.getMssSize()) < 0) {
                            allowed = 0;
                        }
                        if (!connection.isLANLocal() || !NetworkManager.isLANRateEnabled()) {
                            GroupData[] group_datas;
                            LimitedRateGroup[] groups = conn_data.groups;
                            if (groups.length != (group_datas = conn_data.group_datas).length) {
                                try {
                                    TransferProcessor.this.connections_mon.enter();
                                    groups = conn_data.groups;
                                    group_datas = conn_data.group_datas;
                                    Object var5_4 = null;
                                    TransferProcessor.this.connections_mon.exit();
                                }
                                catch (Throwable throwable) {
                                    Object var5_5 = null;
                                    TransferProcessor.this.connections_mon.exit();
                                    throw throwable;
                                }
                            }
                            try {
                                for (int i = 0; i < group_datas.length; ++i) {
                                    int group_allowed;
                                    int group_rate = NetworkManagerUtilities.getGroupRateLimit(groups[i]);
                                    ByteBucket group_bucket = group_datas[i].bucket;
                                    if (group_bucket.getRate() != group_rate) {
                                        group_bucket.setRate(group_rate);
                                    }
                                    if ((group_allowed = group_bucket.getAvailableByteCount()) >= allowed) continue;
                                    allowed = group_allowed;
                                }
                            }
                            catch (Throwable e) {
                                if (e instanceof IndexOutOfBoundsException) break block10;
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                    return allowed;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void bytesProcessed(int num_bytes_written) {
                    if (!connection.isLANLocal() || !NetworkManager.isLANRateEnabled()) {
                        GroupData[] group_datas;
                        LimitedRateGroup[] groups = conn_data.groups;
                        if (groups.length != (group_datas = conn_data.group_datas).length) {
                            try {
                                TransferProcessor.this.connections_mon.enter();
                                groups = conn_data.groups;
                                group_datas = conn_data.group_datas;
                                Object var5_4 = null;
                                TransferProcessor.this.connections_mon.exit();
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                TransferProcessor.this.connections_mon.exit();
                                throw throwable;
                            }
                        }
                        for (int i = 0; i < group_datas.length; ++i) {
                            group_datas[i].bucket.setBytesUsed(num_bytes_written);
                            groups[i].updateBytesUsed(num_bytes_written);
                        }
                    }
                    TransferProcessor.this.main_bucket.setBytesUsed(num_bytes_written);
                }
            }, partition_id);
            conn_data.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downgradePeerConnection(NetworkConnectionBase connection) {
        ConnectionData conn_data = null;
        try {
            this.connections_mon.enter();
            conn_data = this.connections.get(connection);
            Object var4_3 = null;
            this.connections_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.connections_mon.exit();
            throw throwable;
        }
        if (conn_data != null && conn_data.state == 1) {
            this.main_controller.downgradePeerConnection(connection);
            conn_data.state = 0;
        }
    }

    public RateHandler getRateHandler() {
        return this.main_rate_handler;
    }

    public RateHandler getRateHandler(NetworkConnectionBase connection) {
        return this.main_controller.getRateHandler(connection);
    }

    private ByteBucket createBucket(int bytes_per_sec) {
        if (this.multi_threaded) {
            return new ByteBucketMT(bytes_per_sec);
        }
        return new ByteBucketST(bytes_per_sec);
    }

    private static class ConnectionData {
        private static final int STATE_NORMAL = 0;
        private static final int STATE_UPGRADED = 1;
        private int state;
        private LimitedRateGroup[] groups;
        private GroupData[] group_datas;

        private ConnectionData() {
        }

        static /* synthetic */ LimitedRateGroup[] access$502(ConnectionData x0, LimitedRateGroup[] x1) {
            x0.groups = x1;
            return x1;
        }

        static /* synthetic */ GroupData[] access$602(ConnectionData x0, GroupData[] x1) {
            x0.group_datas = x1;
            return x1;
        }
    }

    private static class GroupData {
        private final ByteBucket bucket;
        private int group_size = 0;

        private GroupData(ByteBucket bucket) {
            this.bucket = bucket;
        }
    }
}

