/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.socks.impl;

import com.aelitis.azureus.core.proxy.AEProxyConnection;
import com.aelitis.azureus.core.proxy.AEProxyConnectionListener;
import com.aelitis.azureus.core.proxy.AEProxyException;
import com.aelitis.azureus.core.proxy.AEProxyState;
import com.aelitis.azureus.core.proxy.socks.AESocksProxy;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnectionFactory;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyAddressImpl;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyImpl;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyState;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;

public class AESocksProxyConnectionImpl
implements AESocksProxyConnection,
AEProxyConnectionListener {
    private static final LogIDs LOGID = LogIDs.NET;
    public static final boolean TRACE = false;
    private final AESocksProxyImpl proxy;
    private final AEProxyConnection connection;
    private boolean disable_dns_lookups;
    private String username;
    private String password;
    private SocketChannel source_channel;
    private int socks_version;
    private AESocksProxyPlugableConnection plugable_connection;

    protected AESocksProxyConnectionImpl(AESocksProxyImpl _proxy, AESocksProxyPlugableConnectionFactory _connection_factory, AEProxyConnection _connection) throws IOException {
        this.proxy = _proxy;
        this.connection = _connection;
        this.connection.addListener(this);
        this.source_channel = this.connection.getSourceChannel();
        try {
            this.plugable_connection = _connection_factory.create(this);
        }
        catch (AEProxyException e) {
            throw new IOException(e.getMessage());
        }
    }

    public AESocksProxy getProxy() {
        return this.proxy;
    }

    public void setDelegate(AESocksProxyPlugableConnection target) {
        this.plugable_connection = target;
    }

    protected String getName() {
        String name = this.connection.getName() + ", ver = " + this.socks_version;
        name = name + this.plugable_connection.getName();
        return name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    protected AEProxyState getInitialState() {
        return new proxyStateVersion();
    }

    public void connectionClosed(AEProxyConnection con) {
        try {
            if (this.plugable_connection != null) {
                this.plugable_connection.close();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public boolean isClosed() {
        return this.connection.isClosed();
    }

    public AEProxyConnection getConnection() {
        return this.connection;
    }

    public void disableDNSLookups() {
        this.disable_dns_lookups = true;
    }

    public void enableDNSLookups() {
        this.disable_dns_lookups = false;
    }

    public boolean areDNSLookupsEnabled() {
        return !this.disable_dns_lookups;
    }

    public void close() throws IOException {
        new ProxyStateClose();
    }

    public void connected() throws IOException {
        if (this.socks_version == 4) {
            new proxyStateV4Reply();
        } else {
            new proxyStateV5Reply();
        }
    }

    private class ProxyStateClose
    extends AESocksProxyState {
        private ProxyStateClose() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.close();
            AESocksProxyConnectionImpl.this.connection.setReadState(null);
            AESocksProxyConnectionImpl.this.connection.setWriteState(null);
            AESocksProxyConnectionImpl.this.connection.setConnectState(null);
        }
    }

    private class ProxyStateWriter
    extends AESocksProxyState {
        private ProxyStateWriter() {
            super(AESocksProxyConnectionImpl.this);
        }

        protected boolean writeSupport(SocketChannel sc) throws IOException {
            int len = sc.write(this.buffer);
            if (this.buffer.hasRemaining()) {
                AESocksProxyConnectionImpl.this.connection.requestWriteSelect(sc);
            }
            return len > 0;
        }
    }

    private class proxyStateV4Reply
    extends AESocksProxyState {
        protected proxyStateV4Reply() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            byte[] addr = AESocksProxyConnectionImpl.this.plugable_connection.getLocalAddress().getAddress();
            int port = AESocksProxyConnectionImpl.this.plugable_connection.getLocalPort();
            this.buffer = ByteBuffer.wrap(new byte[]{0, 90, (byte)(port >> 8 & 0xFF), (byte)(port & 0xFF), addr[0], addr[1], addr[2], addr[3]});
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }

        protected boolean writeSupport(SocketChannel sc) throws IOException {
            int len = sc.write(this.buffer);
            if (this.buffer.hasRemaining()) {
                AESocksProxyConnectionImpl.this.connection.requestWriteSelect(sc);
            } else {
                AESocksProxyConnectionImpl.this.plugable_connection.relayData();
            }
            return len > 0;
        }
    }

    private class proxyStateV4Request
    extends AESocksProxyState {
        boolean got_header;
        protected int port;
        protected byte[] address;

        protected proxyStateV4Request() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(7);
        }

        protected boolean readSupport(SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            if (this.got_header) {
                if (this.buffer.get() == 0) {
                    if (this.address[0] == 0 && this.address[1] == 0 && this.address[2] == 0 && this.address[3] != 0) {
                        new proxyStateV4aRequest(this.port);
                    } else {
                        AESocksProxyConnectionImpl.this.socks_version = 4;
                        AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl("", InetAddress.getByAddress(this.address), this.port));
                    }
                } else {
                    this.buffer.flip();
                }
            } else {
                this.got_header = true;
                byte command = this.buffer.get();
                if (command != 1) {
                    throw new IOException("SocksV4: only CONNECT supported");
                }
                this.port = ((this.buffer.get() & 0xFF) << 8) + (this.buffer.get() & 0xFF);
                this.address = new byte[4];
                for (int i = 0; i < this.address.length; ++i) {
                    this.address[i] = this.buffer.get();
                }
                this.buffer = ByteBuffer.allocate(1);
            }
            return true;
        }
    }

    private class proxyStateV4aRequest
    extends AESocksProxyState {
        protected String dns_address;
        protected int port;

        protected proxyStateV4aRequest(int _port) {
            super(AESocksProxyConnectionImpl.this);
            this.port = _port;
            this.dns_address = "";
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        protected boolean readSupport(final SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            byte data = this.buffer.get();
            if (data == 0) {
                if (AESocksProxyConnectionImpl.this.disable_dns_lookups) {
                    AESocksProxyConnectionImpl.this.socks_version = 4;
                    AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl(this.dns_address, null, this.port));
                } else {
                    final String f_dns_address = this.dns_address;
                    AESocksProxyConnectionImpl.this.connection.cancelReadSelect(sc);
                    HostNameToIPResolver.addResolverRequest(this.dns_address, new HostNameToIPResolverListener(){

                        public void hostNameResolutionComplete(InetAddress address) {
                            try {
                                AESocksProxyConnectionImpl.this.socks_version = 4;
                                AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl(f_dns_address, address, proxyStateV4aRequest.this.port));
                                AESocksProxyConnectionImpl.this.connection.requestReadSelect(sc);
                            }
                            catch (IOException e) {
                                AESocksProxyConnectionImpl.this.connection.failed(e);
                            }
                        }
                    });
                }
            } else {
                this.dns_address = this.dns_address + (char)data;
                if (this.dns_address.length() > 4096) {
                    throw new IOException("DNS name too long");
                }
                this.buffer.flip();
            }
            return true;
        }
    }

    private class proxyStateV5MethodNumber
    extends AESocksProxyState {
        protected proxyStateV5MethodNumber() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        protected boolean readSupport(SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            byte num_methods = this.buffer.get();
            new proxyStateV5Methods(num_methods);
            return true;
        }
    }

    private class proxyStateV5Methods
    extends AESocksProxyState {
        protected proxyStateV5Methods(int methods) {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(methods);
        }

        protected boolean readSupport(SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            byte[] methods = new byte[this.buffer.remaining()];
            this.buffer.get(methods);
            boolean found_no_auth = false;
            boolean found_user_pass = false;
            for (int i = 0; i < methods.length; ++i) {
                int method = methods[i] & 0xFF;
                if (method == 0) {
                    found_no_auth = true;
                    continue;
                }
                if (method != 2) continue;
                found_user_pass = true;
            }
            if (found_no_auth) {
                new proxyStateV5MethodsReply(0);
                return true;
            }
            if (found_user_pass) {
                new proxyStateV5MethodsReply(2);
                return true;
            }
            throw new IOException("V5: No supported methods requested");
        }
    }

    private class proxyStateV5MethodsReply
    extends ProxyStateWriter {
        protected proxyStateV5MethodsReply(int selected_method) throws IOException {
            if (selected_method == 0) {
                new proxyStateV5Request();
            } else {
                new proxyStateV5Username();
            }
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            this.buffer = ByteBuffer.wrap(new byte[]{5, (byte)selected_method});
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }
    }

    private class proxyStateV5Password
    extends AESocksProxyState {
        private final String username;
        boolean got_length;

        protected proxyStateV5Password(String _username) {
            super(AESocksProxyConnectionImpl.this);
            this.got_length = false;
            this.username = _username;
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        protected boolean readSupport(SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            if (!this.got_length) {
                int length = this.buffer.get() & 0xFF;
                this.buffer = ByteBuffer.allocate(length);
                this.got_length = true;
            } else {
                String password = "";
                while (this.buffer.hasRemaining()) {
                    password = password + (char)this.buffer.get();
                }
                AESocksProxyConnectionImpl.this.username = this.username;
                AESocksProxyConnectionImpl.this.password = password;
                new proxyStateV5UsernamePasswordReply();
            }
            return true;
        }
    }

    private class proxyStateV5Reply
    extends AESocksProxyState {
        protected proxyStateV5Reply() throws IOException {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            byte[] addr = AESocksProxyConnectionImpl.this.plugable_connection.getLocalAddress().getAddress();
            int port = AESocksProxyConnectionImpl.this.plugable_connection.getLocalPort();
            this.buffer = ByteBuffer.wrap(new byte[]{5, 0, 0, 1, addr[0], addr[1], addr[2], addr[3], (byte)(port >> 8 & 0xFF), (byte)(port & 0xFF)});
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }

        protected boolean writeSupport(SocketChannel sc) throws IOException {
            int len = sc.write(this.buffer);
            if (this.buffer.hasRemaining()) {
                AESocksProxyConnectionImpl.this.connection.requestWriteSelect(sc);
            } else {
                AESocksProxyConnectionImpl.this.plugable_connection.relayData();
            }
            return len > 0;
        }
    }

    private class proxyStateV5Request
    extends AESocksProxyState {
        protected proxyStateV5Request() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean readSupport(SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            this.buffer.get();
            byte command = this.buffer.get();
            this.buffer.get();
            byte address_type = this.buffer.get();
            if (command == 1) {
                if (address_type == 1) {
                    new proxyStateV5RequestIP();
                    return true;
                } else if (address_type == 3) {
                    new proxyStateV5RequestDNS();
                    return true;
                } else {
                    if (address_type != 4) throw new IOException("V5: Unsupported address type: " + address_type);
                    new proxyStateV5RequestIPV6();
                }
                return true;
            } else {
                if (command != 3) throw new IOException("V5: Only connect supported: command=" + command);
                new proxyStateV5UDPAssociateReply();
            }
            return true;
        }
    }

    private class proxyStateV5RequestDNS
    extends AESocksProxyState {
        boolean got_length;

        protected proxyStateV5RequestDNS() {
            super(AESocksProxyConnectionImpl.this);
            this.got_length = false;
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        protected boolean readSupport(final SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            if (!this.got_length) {
                int length = this.buffer.get() & 0xFF;
                this.buffer = ByteBuffer.allocate(length);
                this.got_length = true;
            } else {
                StringBuilder dns_address_b = new StringBuilder(256);
                while (this.buffer.hasRemaining()) {
                    dns_address_b.append((char)this.buffer.get());
                }
                String dns_address = dns_address_b.toString();
                if (AESocksProxyConnectionImpl.this.disable_dns_lookups) {
                    new proxyStateV5RequestPort(dns_address, null);
                } else {
                    final String f_dns_address = dns_address;
                    AESocksProxyConnectionImpl.this.connection.cancelReadSelect(sc);
                    HostNameToIPResolver.addResolverRequest(dns_address, new HostNameToIPResolverListener(){

                        public void hostNameResolutionComplete(InetAddress address) {
                            new proxyStateV5RequestPort(f_dns_address, address);
                            AESocksProxyConnectionImpl.this.connection.requestReadSelect(sc);
                        }
                    });
                }
            }
            return true;
        }
    }

    private class proxyStateV5RequestIP
    extends AESocksProxyState {
        protected proxyStateV5RequestIP() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(4);
        }

        protected boolean readSupport(SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            byte[] bytes = new byte[4];
            this.buffer.get(bytes);
            InetAddress inet_address = InetAddress.getByAddress(bytes);
            new proxyStateV5RequestPort("", inet_address);
            return true;
        }
    }

    private class proxyStateV5RequestIPV6
    extends AESocksProxyState {
        protected proxyStateV5RequestIPV6() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(16);
        }

        protected boolean readSupport(SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            byte[] bytes = new byte[16];
            this.buffer.get(bytes);
            InetAddress inet_address = InetAddress.getByAddress(bytes);
            new proxyStateV5RequestPort("", inet_address);
            return true;
        }
    }

    private class proxyStateV5RequestPort
    extends AESocksProxyState {
        protected String unresolved_address;
        protected InetAddress address;

        protected proxyStateV5RequestPort(String _unresolved_address, InetAddress _address) {
            super(AESocksProxyConnectionImpl.this);
            this.unresolved_address = _unresolved_address;
            this.address = _address;
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(2);
        }

        protected boolean readSupport(SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            int port = ((this.buffer.get() & 0xFF) << 8) + (this.buffer.get() & 0xFF);
            AESocksProxyConnectionImpl.this.socks_version = 5;
            AESocksProxyConnectionImpl.this.plugable_connection.connect(new AESocksProxyAddressImpl(this.unresolved_address, this.address, port));
            return true;
        }
    }

    private class proxyStateV5UDPAssociateReply
    extends ProxyStateWriter {
        protected proxyStateV5UDPAssociateReply() throws IOException {
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            byte[] addr = new byte[4];
            int port = 0;
            int reply_state = 69;
            this.buffer = ByteBuffer.wrap(new byte[]{5, (byte)reply_state, 0, 1, addr[0], addr[1], addr[2], addr[3], (byte)(port >> 8 & 0xFF), (byte)(port & 0xFF)});
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }
    }

    private class proxyStateV5Username
    extends AESocksProxyState {
        boolean got_length;

        protected proxyStateV5Username() {
            super(AESocksProxyConnectionImpl.this);
            this.got_length = false;
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(2);
        }

        protected boolean readSupport(SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            if (!this.got_length) {
                this.buffer.get();
                int length = this.buffer.get() & 0xFF;
                this.buffer = ByteBuffer.allocate(length);
                this.got_length = true;
            } else {
                String user_name = "";
                while (this.buffer.hasRemaining()) {
                    user_name = user_name + (char)this.buffer.get();
                }
                new proxyStateV5Password(user_name);
            }
            return true;
        }
    }

    private class proxyStateV5UsernamePasswordReply
    extends ProxyStateWriter {
        protected proxyStateV5UsernamePasswordReply() throws IOException {
            new proxyStateV5Request();
            AESocksProxyConnectionImpl.this.connection.setWriteState(this);
            this.buffer = ByteBuffer.wrap(new byte[]{1, 0});
            this.write(AESocksProxyConnectionImpl.this.source_channel);
        }
    }

    private class proxyStateVersion
    extends AESocksProxyState {
        protected proxyStateVersion() {
            super(AESocksProxyConnectionImpl.this);
            AESocksProxyConnectionImpl.this.connection.setReadState(this);
            this.buffer = ByteBuffer.allocate(1);
        }

        protected boolean readSupport(SocketChannel sc) throws IOException {
            int len = sc.read(this.buffer);
            if (len == 0) {
                return false;
            }
            if (len == -1) {
                throw new IOException("Connection closed");
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            this.buffer.flip();
            byte version = this.buffer.get();
            if (version == 5) {
                new proxyStateV5MethodNumber();
            } else if (version == 4) {
                new proxyStateV4Request();
            } else {
                throw new IOException("Unsupported version " + version);
            }
            return true;
        }
    }
}

