/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkFileMap {
    private Map<wrapper, Entry> name_map = new HashMap<wrapper, Entry>();
    private Map<Integer, Entry> index_map = new HashMap<Integer, Entry>();

    public File get(int index, File from_file) {
        Entry entry;
        if (index >= 0) {
            entry = this.index_map.get(index);
            if (entry != null) {
                return entry.getToFile();
            }
        } else {
            Debug.out("unexpected index");
        }
        entry = this.name_map.get(new wrapper(from_file));
        if (entry == null) {
            return null;
        }
        int e_index = entry.getIndex();
        if (e_index >= 0 && e_index != index) {
            return null;
        }
        return entry.getToFile();
    }

    public Entry getEntry(int index, File from_file) {
        Entry entry;
        if (index >= 0) {
            entry = this.index_map.get(index);
            if (entry != null) {
                return entry;
            }
        } else {
            Debug.out("unexpected index");
        }
        entry = this.name_map.get(new wrapper(from_file));
        if (entry == null) {
            return null;
        }
        int e_index = entry.getIndex();
        if (e_index >= 0 && e_index != index) {
            return null;
        }
        return entry;
    }

    public void put(int index, File from_file, File to_file) {
        Entry entry = new Entry(index, from_file, to_file);
        if (index >= 0) {
            this.index_map.put(index, entry);
            if (this.name_map.size() > 0) {
                this.name_map.remove(new wrapper(from_file));
            }
        } else {
            wrapper wrap = new wrapper(from_file);
            Entry existing = this.name_map.get(wrap);
            if (existing == null || !existing.getFromFile().equals(from_file) || !existing.getToFile().equals(to_file)) {
                Debug.out("unexpected index");
            }
            this.name_map.put(wrap, entry);
        }
    }

    public void putMigration(File from_file, File to_file) {
        Entry entry = new Entry(-1, from_file, to_file);
        this.name_map.put(new wrapper(from_file), entry);
    }

    public void remove(int index, File key) {
        if (index >= 0) {
            this.index_map.remove(index);
        }
        if (this.name_map.size() > 0) {
            this.name_map.remove(new wrapper(key));
        }
    }

    public Iterator<Entry> entryIterator() {
        if (this.index_map.size() > 0) {
            if (this.name_map.size() == 0) {
                return this.index_map.values().iterator();
            }
            HashSet<Entry> entries = new HashSet<Entry>(this.index_map.values());
            entries.addAll(this.name_map.values());
            return entries.iterator();
        }
        return this.name_map.values().iterator();
    }

    public String getString() {
        String str = "";
        if (this.index_map.size() > 0) {
            String i_str = "";
            for (Entry e : this.index_map.values()) {
                i_str = i_str + (i_str.length() == 0 ? "" : ", ") + e.getString();
            }
            str = str + "i_map={ " + i_str + " }";
        }
        if (this.name_map.size() > 0) {
            String n_str = "";
            for (Entry e : this.name_map.values()) {
                n_str = n_str + (n_str.length() == 0 ? "" : ", ") + e.getString();
            }
            str = str + "n_map={ " + n_str + " }";
        }
        return str;
    }

    public static class Entry {
        private int index;
        private File from_file;
        private File to_file;

        private Entry(int _index, File _from_file, File _to_file) {
            this.index = _index;
            this.from_file = _from_file;
            this.to_file = _to_file;
        }

        public int getIndex() {
            return this.index;
        }

        public File getFromFile() {
            return this.from_file;
        }

        public File getToFile() {
            return this.to_file;
        }

        public String getString() {
            return this.index + ": " + this.from_file + " -> " + this.to_file;
        }
    }

    private static class wrapper {
        private String file_str;

        protected wrapper(File file) {
            this.file_str = file.toString();
        }

        public boolean equals(Object other) {
            if (other instanceof wrapper) {
                return this.file_str.equals(((wrapper)other).file_str);
            }
            return false;
        }

        public int hashCode() {
            return this.file_str.hashCode();
        }
    }
}

