/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.swt;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.plugins.net.buddy.swt.BuddyPluginView;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyPluginViewBetaChat
implements BuddyPluginBeta.ChatListener {
    private static final boolean TEST_LOOPBACK_CHAT = System.getProperty("az.chat.loopback.enable", "0").equals("1");
    private static final boolean DEBUG_ENABLED = BuddyPluginBeta.DEBUG_ENABLED;
    private static final int MAX_MSG_LENGTH = 400;
    private static final Set<BuddyPluginViewBetaChat> active_windows = new HashSet<BuddyPluginViewBetaChat>();
    private static boolean auto_ftux_popout_done = false;
    private final BuddyPluginView view;
    private final BuddyPlugin plugin;
    private final BuddyPluginBeta beta;
    private final BuddyPluginBeta.ChatInstance chat;
    private final LocaleUtilities lu;
    private Shell shell;
    private StyledText log;
    private StyleRange[] log_styles = new StyleRange[0];
    private BufferedLabel table_header;
    private Table buddy_table;
    private BufferedLabel status;
    private Button shared_nick_button;
    private Text nickname;
    private Text input_area;
    private DropTarget[] drop_targets;
    private LinkedHashMap<BuddyPluginBeta.ChatMessage, Integer> messages = new LinkedHashMap();
    private List<BuddyPluginBeta.ChatParticipant> participants = new ArrayList<BuddyPluginBeta.ChatParticipant>();
    private Map<BuddyPluginBeta.ChatParticipant, BuddyPluginBeta.ChatMessage> participant_last_message_map = new HashMap<BuddyPluginBeta.ChatParticipant, BuddyPluginBeta.ChatMessage>();
    private boolean table_resort_required;
    private Font italic_font;
    private Font bold_font;
    private Font big_font;
    private Font small_font;
    private Color ftux_dark_bg;
    private Color ftux_dark_fg;
    private Color ftux_light_bg;
    private boolean ftux_ok;
    private boolean build_complete;
    private String previous_says = null;
    private int previous_says_mt = -1;
    private long last_seen_message = -1L;
    private long last_seen_message_pending = -1L;
    private final SimpleDateFormat time_format1 = new SimpleDateFormat("HH:mm");
    private final SimpleDateFormat time_format2a = new SimpleDateFormat("EE h");
    private final SimpleDateFormat time_format2b = new SimpleDateFormat("a");
    private final SimpleDateFormat time_format3 = new SimpleDateFormat("dd/MM");

    protected static BuddyPluginViewBetaChat createChatWindow(BuddyPluginView view, BuddyPlugin plugin, BuddyPluginBeta.ChatInstance chat) {
        for (BuddyPluginViewBetaChat win : active_windows) {
            if (win.getChat() != chat) continue;
            Shell existing = win.getShell();
            if (existing.isVisible()) {
                existing.setActive();
            }
            return win;
        }
        return new BuddyPluginViewBetaChat(view, plugin, chat);
    }

    private BuddyPluginViewBetaChat(BuddyPluginView _view, BuddyPlugin _plugin, BuddyPluginBeta.ChatInstance _chat) {
        this.view = _view;
        this.plugin = _plugin;
        this.chat = _chat;
        this.beta = this.plugin.getBeta();
        this.lu = this.plugin.getPluginInterface().getUtilities().getLocaleUtilities();
        this.shell = this.beta.getStandAloneWindows() ? ShellFactory.createShell((Shell)null, 3312) : ShellFactory.createMainShell(3312);
        this.shell.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                BuddyPluginViewBetaChat.this.activate();
            }
        });
        this.shell.setText(this.lu.getLocalisedMessageText("label.chat") + ": " + this.chat.getName());
        Utils.setShellIcon(this.shell);
        this.build((Composite)this.shell);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    BuddyPluginViewBetaChat.this.close();
                }
            }
        });
        this.shell.addControlListener(new ControlListener(){
            private volatile Rectangle last_position;
            private FrequencyLimitedDispatcher disp = new FrequencyLimitedDispatcher(new AERunnable(){

                public void runSupport() {
                    Rectangle pos = last_position;
                    String str = pos.x + "," + pos.y + "," + pos.width + "," + pos.height;
                    COConfigurationManager.setParameter("azbuddy.dchat.ui.last.win.pos", str);
                }
            }, 1000);

            public void controlResized(ControlEvent e) {
                this.handleChange();
            }

            public void controlMoved(ControlEvent e) {
                this.handleChange();
            }

            private void handleChange() {
                this.last_position = BuddyPluginViewBetaChat.this.shell.getBounds();
                this.disp.dispatch();
            }
        });
        int DEFAULT_WIDTH = 500;
        int DEFAULT_HEIGHT = 500;
        int MIN_WIDTH = 300;
        int MIN_HEIGHT = 150;
        String str_pos = COConfigurationManager.getStringParameter("azbuddy.dchat.ui.last.win.pos", "");
        Rectangle last_bounds = null;
        try {
            String[] bits;
            if (str_pos != null && str_pos.length() > 0 && (bits = str_pos.split(",")).length == 4) {
                int[] i_bits = new int[4];
                for (int i = 0; i < bits.length; ++i) {
                    i_bits[i] = Integer.parseInt(bits[i]);
                }
                last_bounds = new Rectangle(i_bits[0], i_bits[1], Math.max(MIN_WIDTH, i_bits[2]), Math.max(MIN_HEIGHT, i_bits[3]));
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (active_windows.size() > 0) {
            int max_x = 0;
            int max_y = 0;
            for (BuddyPluginViewBetaChat window : active_windows) {
                if (window.shell.isDisposed()) continue;
                Rectangle rect = window.shell.getBounds();
                max_x = Math.max(max_x, rect.x);
                max_y = Math.max(max_y, rect.y);
            }
            Rectangle rect = new Rectangle(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
            rect.x = max_x + 16;
            rect.y = max_y + 16;
            if (last_bounds != null) {
                rect.width = last_bounds.width;
                rect.height = last_bounds.height;
            }
            this.shell.setBounds(rect);
            Utils.verifyShellRect(this.shell, true);
        } else if (last_bounds != null) {
            this.shell.setBounds(last_bounds);
            Utils.verifyShellRect(this.shell, true);
        } else {
            this.shell.setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
            Utils.centreWindow(this.shell);
        }
        active_windows.add(this);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                active_windows.remove(BuddyPluginViewBetaChat.this);
            }
        });
        this.shell.open();
        this.shell.forceActive();
    }

    protected BuddyPluginViewBetaChat(BuddyPluginView _view, BuddyPlugin _plugin, BuddyPluginBeta.ChatInstance _chat, Composite _parent) {
        this.view = _view;
        this.plugin = _plugin;
        this.chat = _chat;
        this.beta = this.plugin.getBeta();
        this.lu = this.plugin.getPluginInterface().getUtilities().getLocaleUtilities();
        this.build(_parent);
    }

    private Shell getShell() {
        return this.shell;
    }

    private BuddyPluginBeta.ChatInstance getChat() {
        return this.chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(Composite parent) {
        int rhs_width;
        String[] info_lines;
        this.view.registerUI(this.chat);
        boolean public_chat = !this.chat.isPrivateChat();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        GridData grid_data = new GridData(1808);
        parent.setLayoutData((Object)grid_data);
        Composite sash_area = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sash_area.setLayout((Layout)layout);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 2;
        sash_area.setLayoutData((Object)grid_data);
        SashForm sash = new SashForm(sash_area, 256);
        grid_data = new GridData(1808);
        sash.setLayoutData((Object)grid_data);
        Composite lhs = new Composite((Composite)sash, 0);
        lhs.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                Color[] colours;
                Font[] fonts;
                for (Font f : fonts = new Font[]{BuddyPluginViewBetaChat.this.italic_font, BuddyPluginViewBetaChat.this.bold_font, BuddyPluginViewBetaChat.this.big_font, BuddyPluginViewBetaChat.this.small_font}) {
                    if (f == null) continue;
                    f.dispose();
                }
                for (Color color : colours = new Color[]{BuddyPluginViewBetaChat.this.ftux_dark_bg, BuddyPluginViewBetaChat.this.ftux_dark_fg, BuddyPluginViewBetaChat.this.ftux_light_bg}) {
                    if (color == null) continue;
                    color.dispose();
                }
                if (BuddyPluginViewBetaChat.this.drop_targets != null) {
                    for (Color color : BuddyPluginViewBetaChat.this.drop_targets) {
                        color.dispose();
                    }
                }
                BuddyPluginViewBetaChat.this.closed();
            }
        });
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        layout.marginLeft = 4;
        lhs.setLayout((Layout)layout);
        grid_data = new GridData(1808);
        grid_data.widthHint = 300;
        lhs.setLayoutData((Object)grid_data);
        final Label menu_drop = new Label(lhs, 0);
        FontData fontData = menu_drop.getFont().getFontData()[0];
        Display display = menu_drop.getDisplay();
        this.italic_font = new Font((Device)display, new FontData(fontData.getName(), fontData.getHeight(), 2));
        this.bold_font = new Font((Device)display, new FontData(fontData.getName(), fontData.getHeight(), 1));
        this.big_font = new Font((Device)display, new FontData(fontData.getName(), (int)((double)fontData.getHeight() * 1.5), 1));
        this.small_font = new Font((Device)display, new FontData(fontData.getName(), (int)((double)fontData.getHeight() * 0.5), 1));
        this.ftux_dark_bg = new Color((Device)display, 183, 200, 212);
        this.ftux_dark_fg = new Color((Device)display, 0, 81, 134);
        this.ftux_light_bg = new Color((Device)display, 236, 242, 246);
        this.status = new BufferedLabel(lhs, 0x20004000);
        grid_data = new GridData(768);
        this.status.setLayoutData(grid_data);
        this.status.setText(MessageText.getString("PeersView.state.pending"));
        Image image = ImageLoader.getInstance().getImage("menu_down");
        menu_drop.setImage(image);
        grid_data = new GridData();
        grid_data.widthHint = image.getBounds().width;
        grid_data.heightHint = image.getBounds().height;
        menu_drop.setLayoutData((Object)grid_data);
        menu_drop.setCursor(menu_drop.getDisplay().getSystemCursor(21));
        Control status_control = this.status.getControl();
        final Menu status_menu = new Menu(status_control);
        this.status.getControl().setMenu(status_menu);
        menu_drop.setMenu(status_menu);
        menu_drop.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event2) {
                try {
                    Point p = status_menu.getDisplay().map((Control)menu_drop, null, event2.x, event2.y);
                    status_menu.setLocation(p);
                    status_menu.setVisible(true);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
        if (public_chat) {
            Menu status_clip_menu = new Menu((Decorations)lhs.getShell(), 4);
            MenuItem status_clip_item = new MenuItem(status_menu, 64);
            status_clip_item.setMenu(status_clip_menu);
            status_clip_item.setText(MessageText.getString("label.copy.to.clipboard"));
            MenuItem status_mi = new MenuItem(status_clip_menu, 8);
            status_mi.setText(MessageText.getString("azbuddy.dchat.copy.channel.key"));
            status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard(BuddyPluginViewBetaChat.this.chat.getKey());
                }
            });
            status_mi = new MenuItem(status_clip_menu, 8);
            status_mi.setText(MessageText.getString("azbuddy.dchat.copy.channel.url"));
            status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard(BuddyPluginViewBetaChat.this.chat.getURL());
                }
            });
            status_mi = new MenuItem(status_clip_menu, 8);
            status_mi.setText(MessageText.getString("azbuddy.dchat.copy.rss.url"));
            status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard("azplug:?id=azbuddy&arg=" + UrlUtils.encode(BuddyPluginViewBetaChat.this.chat.getURL() + "&format=rss"));
                }
            });
            status_mi = new MenuItem(status_clip_menu, 8);
            status_mi.setText(MessageText.getString("azbuddy.dchat.copy.channel.pk"));
            status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard(Base32.encode(BuddyPluginViewBetaChat.this.chat.getPublicKey()));
                }
            });
            status_mi = new MenuItem(status_clip_menu, 8);
            status_mi.setText(MessageText.getString("azbuddy.dchat.copy.channel.export"));
            status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard(BuddyPluginViewBetaChat.this.chat.export());
                }
            });
            if (!this.chat.isManaged()) {
                Menu status_channel_menu = new Menu((Decorations)lhs.getShell(), 4);
                MenuItem status_channel_item = new MenuItem(status_menu, 64);
                status_channel_item.setMenu(status_channel_menu);
                status_channel_item.setText(MessageText.getString("azbuddy.dchat.rchans"));
                status_mi = new MenuItem(status_channel_menu, 8);
                status_mi.setText(MessageText.getString("azbuddy.dchat.rchans.managed"));
                status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event2) {
                        try {
                            BuddyPluginBeta.ChatInstance inst = BuddyPluginViewBetaChat.this.chat.getManagedChannel();
                            BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, inst);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                status_mi = new MenuItem(status_channel_menu, 8);
                status_mi.setText(MessageText.getString("azbuddy.dchat.rchans.ro"));
                status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event2) {
                        try {
                            BuddyPluginBeta.ChatInstance inst = BuddyPluginViewBetaChat.this.chat.getReadOnlyChannel();
                            BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, inst);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                status_mi = new MenuItem(status_channel_menu, 8);
                status_mi.setText(MessageText.getString("azbuddy.dchat.rchans.rand"));
                status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event2) {
                        try {
                            byte[] rand = new byte[20];
                            RandomUtils.nextSecureBytes(rand);
                            BuddyPluginBeta.ChatInstance inst = BuddyPluginViewBetaChat.this.beta.getChat(BuddyPluginViewBetaChat.this.chat.getNetwork(), BuddyPluginViewBetaChat.this.chat.getKey() + " {" + Base32.encode(rand) + "}");
                            BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, inst);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                if (this.beta.isI2PAvailable()) {
                    status_mi = new MenuItem(status_channel_menu, 8);
                    status_mi.setText(MessageText.getString(this.chat.getNetwork() == "I2P" ? "azbuddy.dchat.rchans.pub" : "azbuddy.dchat.rchans.anon"));
                    status_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event2) {
                            try {
                                BuddyPluginBeta.ChatInstance inst = BuddyPluginViewBetaChat.this.beta.getChat(BuddyPluginViewBetaChat.this.chat.getNetwork() == "I2P" ? "Public" : "I2P", BuddyPluginViewBetaChat.this.chat.getKey());
                                BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, inst);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                }
            }
            final MenuItem fave_mi = new MenuItem(status_menu, 32);
            fave_mi.setText(MessageText.getString("label.fave"));
            fave_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.chat.setFavourite(fave_mi.getSelection());
                }
            });
            Menu advanced_menu = new Menu((Decorations)status_menu.getShell(), 4);
            MenuItem advanced_menu_item = new MenuItem(status_menu, 64);
            advanced_menu_item.setMenu(advanced_menu);
            advanced_menu_item.setText(MessageText.getString("MyTorrentsView.menu.advancedmenu"));
            final MenuItem persist_mi = new MenuItem(advanced_menu, 32);
            persist_mi.setText(MessageText.getString("azbuddy.dchat.save.messages"));
            persist_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.chat.setSaveMessages(persist_mi.getSelection());
                }
            });
            final MenuItem log_mi = new MenuItem(advanced_menu, 32);
            log_mi.setText(MessageText.getString("azbuddy.dchat.log.messages"));
            log_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.chat.setLogMessages(log_mi.getSelection());
                }
            });
            final MenuItem automute_mi = new MenuItem(advanced_menu, 32);
            automute_mi.setText(MessageText.getString("azbuddy.dchat.auto.mute"));
            automute_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.chat.setAutoMute(automute_mi.getSelection());
                }
            });
            status_menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    fave_mi.setSelection(BuddyPluginViewBetaChat.this.chat.isFavourite());
                    persist_mi.setSelection(BuddyPluginViewBetaChat.this.chat.getSaveMessages());
                    log_mi.setSelection(BuddyPluginViewBetaChat.this.chat.getLogMessages());
                    automute_mi.setSelection(BuddyPluginViewBetaChat.this.chat.getAutoMute());
                }
            });
        } else {
            final Menu status_priv_menu = new Menu((Decorations)lhs.getShell(), 4);
            MenuItem status_priv_item = new MenuItem(status_menu, 64);
            status_priv_item.setMenu(status_priv_menu);
            status_priv_item.setText(MessageText.getString("label.private.chat"));
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginViewBetaChat.this.beta.setPrivateChatState((Integer)((MenuItem)e.widget).getData());
                }
            };
            MenuItem status_mi = new MenuItem(status_priv_menu, 16);
            status_mi.setText(MessageText.getString("devices.contextmenu.od.enabled"));
            status_mi.setData((Object)3);
            status_mi.addSelectionListener((SelectionListener)listener);
            status_mi = new MenuItem(status_priv_menu, 16);
            status_mi.setText(MessageText.getString("label.pinned.only"));
            status_mi.setData((Object)2);
            status_mi.addSelectionListener((SelectionListener)listener);
            status_mi = new MenuItem(status_priv_menu, 16);
            status_mi.setText(MessageText.getString("pairing.status.disabled"));
            status_mi.setData((Object)1);
            status_mi.addSelectionListener((SelectionListener)listener);
            status_priv_menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    int pc_state = BuddyPluginViewBetaChat.this.beta.getPrivateChatState();
                    for (MenuItem mi : status_priv_menu.getItems()) {
                        mi.setSelection(pc_state == (Integer)mi.getData());
                    }
                }
            });
            final MenuItem fave_mi = new MenuItem(status_menu, 32);
            fave_mi.setText(MessageText.getString("label.keep.alive"));
            status_menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    fave_mi.setSelection(BuddyPluginViewBetaChat.this.chat.getUserData("AC:KeepAlive") != null);
                }
            });
            fave_mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuddyPluginBeta.ChatInstance clone = (BuddyPluginBeta.ChatInstance)BuddyPluginViewBetaChat.this.chat.getUserData("AC:KeepAlive");
                    if (clone != null) {
                        clone.destroy();
                        clone = null;
                    } else {
                        try {
                            clone = BuddyPluginViewBetaChat.this.chat.getClone();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    BuddyPluginViewBetaChat.this.chat.setUserData("AC:KeepAlive", clone);
                }
            });
        }
        final Composite ftux_stack = new Composite(lhs, 0);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 2;
        ftux_stack.setLayoutData((Object)grid_data);
        final StackLayout stack_layout = new StackLayout();
        ftux_stack.setLayout((Layout)stack_layout);
        final Composite log_holder = new Composite(ftux_stack, 2048);
        final Composite ftux_holder = new Composite(ftux_stack, 2048);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        ftux_holder.setLayout((Layout)layout);
        ftux_holder.setBackground(this.ftux_light_bg);
        Composite ftux_top_area = new Composite(ftux_holder, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        ftux_top_area.setLayout((Layout)layout);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        grid_data.heightHint = 30;
        ftux_top_area.setLayoutData((Object)grid_data);
        ftux_top_area.setBackground(this.ftux_dark_bg);
        Label ftux_top = new Label(ftux_top_area, 64);
        grid_data = new GridData(16384, 0x1000000, true, true);
        grid_data.horizontalIndent = 8;
        ftux_top.setLayoutData((Object)grid_data);
        ftux_top.setAlignment(16384);
        ftux_top.setBackground(this.ftux_dark_bg);
        ftux_top.setForeground(this.ftux_dark_fg);
        ftux_top.setFont(this.big_font);
        ftux_top.setText(MessageText.getString("azbuddy.dchat.ftux.welcome"));
        Label ftux_hack = new Label(ftux_holder, 0);
        grid_data = new GridData();
        grid_data.heightHint = 40;
        grid_data.widthHint = 0;
        ftux_hack.setLayoutData((Object)grid_data);
        StyledText ftux_middle = new StyledText(ftux_holder, 524872);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 1;
        grid_data.verticalIndent = 4;
        grid_data.horizontalIndent = 16;
        ftux_middle.setLayoutData((Object)grid_data);
        ftux_middle.setBackground(this.ftux_light_bg);
        String info1_text = "Vuze chat allows you to communicate with other Vuze users directly by sending and receiving messages.\nIt is a decentralized chat system - there are no central servers involved, all messages are passed directly between Vuze users.\nConsequently Vuze has absolutely no control over message content. In particular no mechanism exists (nor is possible) for Vuze to moderate or otherwise control either messages or the users that send messages.";
        String info2_text = "I UNDERSTAND AND AGREE that Vuze has no responsibility whatsoever with my enabling this function and using chat.";
        for (String line : info_lines = info1_text.split("\n")) {
            ftux_middle.append(line);
            if (line == info_lines[info_lines.length - 1]) continue;
            ftux_middle.append("\n");
            int pos = ftux_middle.getText().length();
            ftux_middle.append("\u200b");
            StyleRange styleRange = new StyleRange();
            styleRange.start = pos;
            styleRange.length = 1;
            styleRange.font = this.big_font;
            ftux_middle.setStyleRange(styleRange);
        }
        Composite ftux_check_area = new Composite(ftux_holder, 0);
        layout = new GridLayout();
        layout.marginLeft = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        ftux_check_area.setLayout((Layout)layout);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        ftux_check_area.setLayoutData((Object)grid_data);
        ftux_check_area.setBackground(this.ftux_light_bg);
        final Button ftux_check = new Button(ftux_check_area, 32);
        grid_data = new GridData();
        grid_data.horizontalIndent = 16;
        ftux_check.setLayoutData((Object)grid_data);
        ftux_check.setBackground(this.ftux_light_bg);
        Label ftux_check_test = new Label(ftux_check_area, 64);
        grid_data = new GridData(768);
        ftux_check_test.setLayoutData((Object)grid_data);
        ftux_check_test.setBackground(this.ftux_light_bg);
        ftux_check_test.setText(info2_text);
        final StyledText ftux_bottom = new StyledText(ftux_holder, 524360);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        grid_data.horizontalIndent = 16;
        ftux_bottom.setLayoutData((Object)grid_data);
        ftux_bottom.setBackground(this.ftux_light_bg);
        ftux_bottom.setFont(this.bold_font);
        ftux_bottom.setText(MessageText.getString("azbuddy.dchat.ftux.footer") + " ");
        int start = ftux_bottom.getText().length();
        String url = MessageText.getString("faq.legal.url");
        String url_text = MessageText.getString("label.more.dot");
        ftux_bottom.append(url_text);
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = url_text.length();
        styleRange.foreground = Colors.blue;
        styleRange.underline = true;
        styleRange.data = url;
        ftux_bottom.setStyleRange(styleRange);
        ftux_bottom.addListener(4, new Listener(){

            public void handleEvent(Event event2) {
                int offset = ftux_bottom.getOffsetAtLocation(new Point(event2.x, event2.y));
                StyleRange style = ftux_bottom.getStyleRangeAtOffset(offset);
                if (style != null) {
                    String url = (String)style.data;
                    try {
                        Utils.launch(new URL(url));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
        Label ftux_line = new Label(ftux_holder, 258);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        grid_data.verticalIndent = 4;
        ftux_line.setLayoutData((Object)grid_data);
        Composite ftux_button_area = new Composite(ftux_holder, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        ftux_button_area.setLayout((Layout)layout);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        ftux_button_area.setLayoutData((Object)grid_data);
        ftux_button_area.setBackground(Colors.white);
        Label filler = new Label(ftux_button_area, 0);
        grid_data = new GridData(768);
        filler.setLayoutData((Object)grid_data);
        filler.setBackground(Colors.white);
        final Button ftux_accept = new Button(ftux_button_area, 8);
        grid_data = new GridData();
        grid_data.horizontalAlignment = 131072;
        grid_data.widthHint = 60;
        ftux_accept.setLayoutData((Object)grid_data);
        ftux_accept.setText(MessageText.getString("label.accept"));
        ftux_accept.setEnabled(false);
        ftux_accept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuddyPluginViewBetaChat.this.beta.setFTUXAccepted(true);
            }
        });
        ftux_check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ftux_accept.setEnabled(ftux_check.getSelection());
            }
        });
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 4;
        log_holder.setLayout((Layout)layout);
        this.log = new StyledText(log_holder, 524872);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 1;
        this.log.setLayoutData((Object)grid_data);
        this.log.setEditable(false);
        log_holder.setBackground(this.log.getBackground());
        final Menu log_menu = new Menu((Control)this.log);
        this.log.setMenu(log_menu);
        this.log.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                String text;
                e.doit = false;
                boolean handled = false;
                for (MenuItem mi : log_menu.getItems()) {
                    mi.dispose();
                }
                try {
                    Point mapped = BuddyPluginViewBetaChat.this.log.getDisplay().map(null, (Control)BuddyPluginViewBetaChat.this.log, new Point(e.x, e.y));
                    int offset = BuddyPluginViewBetaChat.this.log.getOffsetAtLocation(mapped);
                    StyleRange sr = BuddyPluginViewBetaChat.this.log.getStyleRangeAtOffset(offset);
                    if (sr != null) {
                        Object data = sr.data;
                        if (data instanceof BuddyPluginBeta.ChatParticipant) {
                            BuddyPluginBeta.ChatParticipant cp = (BuddyPluginBeta.ChatParticipant)data;
                            ArrayList<BuddyPluginBeta.ChatParticipant> cps = new ArrayList<BuddyPluginBeta.ChatParticipant>();
                            cps.add(cp);
                            BuddyPluginViewBetaChat.this.buildParticipantMenu(log_menu, cps);
                            handled = true;
                        } else if (data instanceof String) {
                            String url_str = (String)sr.data;
                            String str = url_str;
                            if (str.length() > 50) {
                                str = str.substring(0, 50) + "...";
                            }
                            if (BuddyPluginViewBetaChat.this.chat.isAnonymous() && url_str.toLowerCase(Locale.US).startsWith("magnet:")) {
                                String[] magnet_uri = new String[]{url_str};
                                Set<String> networks = UrlUtils.extractNetworks(magnet_uri);
                                String i2p_only_uri = magnet_uri[0] + "&net=" + UrlUtils.encode("I2P");
                                String i2p_only_str = i2p_only_uri;
                                if (i2p_only_str.length() > 50) {
                                    i2p_only_str = i2p_only_str.substring(0, 50) + "...";
                                }
                                i2p_only_str = BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.open.i2p.magnet") + ": " + i2p_only_str;
                                final MenuItem mi_open_i2p_vuze = new MenuItem(log_menu, 8);
                                mi_open_i2p_vuze.setText(i2p_only_str);
                                mi_open_i2p_vuze.setData((Object)i2p_only_uri);
                                mi_open_i2p_vuze.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        String url_str = (String)mi_open_i2p_vuze.getData();
                                        if (url_str != null) {
                                            TorrentOpener.openTorrent(url_str);
                                        }
                                    }
                                });
                                if (networks.size() != 1 || networks.iterator().next() != "I2P") {
                                    str = BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.open.magnet") + ": " + str;
                                    final MenuItem mi_open_vuze = new MenuItem(log_menu, 8);
                                    mi_open_vuze.setText(str);
                                    mi_open_vuze.setData((Object)url_str);
                                    mi_open_vuze.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                        public void widgetSelected(SelectionEvent e) {
                                            String url_str = (String)mi_open_vuze.getData();
                                            if (url_str != null) {
                                                TorrentOpener.openTorrent(url_str);
                                            }
                                        }
                                    });
                                }
                            } else {
                                str = BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.open.in.vuze") + ": " + str;
                                final MenuItem mi_open_vuze = new MenuItem(log_menu, 8);
                                mi_open_vuze.setText(str);
                                mi_open_vuze.setData((Object)url_str);
                                mi_open_vuze.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        String url_str = (String)mi_open_vuze.getData();
                                        if (url_str != null) {
                                            String lc_url_str = url_str.toLowerCase(Locale.US);
                                            if (lc_url_str.startsWith("chat:")) {
                                                try {
                                                    BuddyPluginViewBetaChat.this.beta.handleURI(url_str, true);
                                                }
                                                catch (Throwable f) {
                                                    Debug.out(f);
                                                }
                                            } else {
                                                TorrentOpener.openTorrent(url_str);
                                            }
                                        }
                                    }
                                });
                            }
                            final MenuItem mi_open_ext = new MenuItem(log_menu, 8);
                            mi_open_ext.setText(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.open.in.browser"));
                            mi_open_ext.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    String url_str = (String)mi_open_ext.getData();
                                    Utils.launch(url_str);
                                }
                            });
                            new MenuItem(log_menu, 2);
                            if (BuddyPluginViewBetaChat.this.chat.isAnonymous() && url_str.toLowerCase(Locale.US).startsWith("magnet:")) {
                                String[] magnet_uri = new String[]{url_str};
                                Set<String> networks = UrlUtils.extractNetworks(magnet_uri);
                                String i2p_only_uri = magnet_uri[0] + "&net=" + UrlUtils.encode("I2P");
                                final MenuItem mi_copy_i2p_clip = new MenuItem(log_menu, 8);
                                mi_copy_i2p_clip.setText(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.copy.i2p.magnet"));
                                mi_copy_i2p_clip.setData((Object)i2p_only_uri);
                                mi_copy_i2p_clip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        String url_str = (String)mi_copy_i2p_clip.getData();
                                        if (url_str != null) {
                                            ClipboardCopy.copyToClipBoard(url_str);
                                        }
                                    }
                                });
                                if (networks.size() != 1 || networks.iterator().next() != "I2P") {
                                    final MenuItem mi_copy_clip = new MenuItem(log_menu, 8);
                                    mi_copy_clip.setText(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("azbuddy.dchat.copy.magnet"));
                                    mi_copy_clip.setData((Object)url_str);
                                    mi_copy_clip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                        public void widgetSelected(SelectionEvent e) {
                                            String url_str = (String)mi_copy_clip.getData();
                                            if (url_str != null) {
                                                ClipboardCopy.copyToClipBoard(url_str);
                                            }
                                        }
                                    });
                                }
                            } else {
                                final MenuItem mi_copy_clip = new MenuItem(log_menu, 8);
                                mi_copy_clip.setText(BuddyPluginViewBetaChat.this.lu.getLocalisedMessageText("label.copy.to.clipboard"));
                                mi_copy_clip.setData((Object)url_str);
                                mi_copy_clip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        String url_str = (String)mi_copy_clip.getData();
                                        if (url_str != null) {
                                            ClipboardCopy.copyToClipBoard(url_str);
                                        }
                                    }
                                });
                            }
                            if (url_str.toLowerCase().startsWith("http")) {
                                mi_open_ext.setData((Object)url_str);
                                mi_open_ext.setEnabled(true);
                            } else {
                                mi_open_ext.setEnabled(false);
                            }
                            handled = true;
                        }
                    }
                }
                catch (Throwable f) {
                    // empty catch block
                }
                if (!handled && (text = BuddyPluginViewBetaChat.this.log.getSelectionText()) != null && text.length() > 0) {
                    MenuItem item = new MenuItem(log_menu, 0);
                    item.setText(MessageText.getString("label.copy.to.clipboard"));
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ClipboardCopy.copyToClipBoard(text);
                        }
                    });
                    handled = true;
                }
                if (handled) {
                    e.doit = true;
                }
            }
        });
        this.log.addListener(8, new Listener(){

            public void handleEvent(Event e) {
                try {
                    int offset = BuddyPluginViewBetaChat.this.log.getOffsetAtLocation(new Point(e.x, e.y));
                    for (int i = 0; i < BuddyPluginViewBetaChat.this.log_styles.length; ++i) {
                        StyleRange sr = BuddyPluginViewBetaChat.this.log_styles[i];
                        Object data = sr.data;
                        if (data == null || offset < sr.start || offset >= sr.start + sr.length) continue;
                        boolean anon_chat = BuddyPluginViewBetaChat.this.chat.isAnonymous();
                        if (data instanceof String) {
                            final String url_str = (String)data;
                            String lc_url_str = url_str.toLowerCase(Locale.US);
                            if (lc_url_str.startsWith("chat:")) {
                                if (anon_chat && !lc_url_str.startsWith("chat:anon:")) {
                                    return;
                                }
                                try {
                                    BuddyPluginViewBetaChat.this.beta.handleURI(url_str, true);
                                }
                                catch (Throwable f) {
                                    Debug.out(f);
                                }
                            } else {
                                if (anon_chat) {
                                    try {
                                        String host = new URL(lc_url_str).getHost();
                                        if (AENetworkClassifier.categoriseAddress(host) == "Public") {
                                            return;
                                        }
                                    }
                                    catch (Throwable f) {
                                        return;
                                    }
                                }
                                if (lc_url_str.contains(".torrent") || UrlUtils.parseTextForMagnets(url_str) != null) {
                                    TorrentOpener.openTorrent(url_str);
                                } else if (url_str.toLowerCase(Locale.US).startsWith("http")) {
                                    Utils.execSWTThreadLater(100, new Runnable(){

                                        public void run() {
                                            Utils.launch(url_str);
                                        }
                                    });
                                } else {
                                    TorrentOpener.openTorrent(url_str);
                                }
                            }
                            BuddyPluginViewBetaChat.this.log.setSelection(offset);
                            e.doit = false;
                            continue;
                        }
                        if (!(data instanceof BuddyPluginBeta.ChatParticipant)) continue;
                        BuddyPluginBeta.ChatParticipant participant = (BuddyPluginBeta.ChatParticipant)data;
                        String name = participant.getName(true);
                        String existing = BuddyPluginViewBetaChat.this.input_area.getText();
                        if (existing.length() > 0 && !existing.endsWith(" ")) {
                            name = " " + name;
                        }
                        BuddyPluginViewBetaChat.this.input_area.append(name);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.log.addMouseTrackListener(new MouseTrackListener(){
            private StyleRange old_range;
            private StyleRange temp_range;
            private int temp_index;

            public void mouseHover(MouseEvent e) {
                boolean active = false;
                try {
                    int offset = BuddyPluginViewBetaChat.this.log.getOffsetAtLocation(new Point(e.x, e.y));
                    for (int i = 0; i < BuddyPluginViewBetaChat.this.log_styles.length; ++i) {
                        StyleRange sr = BuddyPluginViewBetaChat.this.log_styles[i];
                        Object data = sr.data;
                        if (data == null || offset < sr.start || offset >= sr.start + sr.length) continue;
                        if (this.old_range != null && this.temp_index < BuddyPluginViewBetaChat.this.log_styles.length && BuddyPluginViewBetaChat.this.log_styles[this.temp_index] == this.temp_range) {
                            ((BuddyPluginViewBetaChat)BuddyPluginViewBetaChat.this).log_styles[this.temp_index] = this.old_range;
                            this.old_range = null;
                        }
                        sr = BuddyPluginViewBetaChat.this.log_styles[i];
                        BuddyPluginViewBetaChat.this.log.setToolTipText(MessageText.getString("label.right.click.for.options"));
                        StyleRange derp = new StyleRange((TextStyle)sr);
                        derp.start = sr.start;
                        derp.length = sr.length;
                        derp.borderStyle = 2;
                        this.old_range = sr;
                        this.temp_range = derp;
                        this.temp_index = i;
                        ((BuddyPluginViewBetaChat)BuddyPluginViewBetaChat.this).log_styles[i] = derp;
                        BuddyPluginViewBetaChat.this.log.setStyleRanges(BuddyPluginViewBetaChat.this.log_styles);
                        active = true;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!active) {
                    BuddyPluginViewBetaChat.this.log.setToolTipText("");
                    if (this.old_range != null && this.temp_index < BuddyPluginViewBetaChat.this.log_styles.length && BuddyPluginViewBetaChat.this.log_styles[this.temp_index] == this.temp_range) {
                        ((BuddyPluginViewBetaChat)BuddyPluginViewBetaChat.this).log_styles[this.temp_index] = this.old_range;
                        this.old_range = null;
                        BuddyPluginViewBetaChat.this.log.setStyleRanges(BuddyPluginViewBetaChat.this.log_styles);
                    }
                }
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
            }
        });
        this.log.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event2) {
                int key = event2.character;
                if (key <= 26 && key > 0) {
                    key += 96;
                }
                if (key == 97 && event2.stateMask == SWT.MOD1) {
                    event2.doit = false;
                    BuddyPluginViewBetaChat.this.log.selectAll();
                }
            }
        });
        Composite rhs = new Composite((Composite)sash, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        layout.marginRight = 4;
        rhs.setLayout((Layout)layout);
        grid_data = new GridData(1040);
        grid_data.widthHint = rhs_width = Constants.isWindows ? 150 : 160;
        rhs.setLayoutData((Object)grid_data);
        Composite top_right = new Composite(rhs, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        top_right.setLayout((Layout)layout);
        grid_data = new GridData(768);
        top_right.setLayoutData((Object)grid_data);
        boolean can_popout = this.shell == null && public_chat;
        Label label = new Label(top_right, 0);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = can_popout ? 1 : 2;
        label.setLayoutData((Object)grid_data);
        LinkLabel link = new LinkLabel(top_right, "label.help", this.lu.getLocalisedMessageText("azbuddy.dchat.link.url"));
        if (can_popout) {
            Label pop_out = new Label(top_right, 0);
            image = ImageLoader.getInstance().getImage("popout_window");
            pop_out.setImage(image);
            grid_data = new GridData();
            grid_data.widthHint = image.getBounds().width;
            grid_data.heightHint = image.getBounds().height;
            pop_out.setLayoutData((Object)grid_data);
            pop_out.setCursor(label.getDisplay().getSystemCursor(21));
            pop_out.setToolTipText(MessageText.getString("label.pop.out"));
            pop_out.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent arg0) {
                    try {
                        BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, BuddyPluginViewBetaChat.this.chat.getClone());
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            });
        }
        Composite nick_area = new Composite(top_right, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        if (!Constants.isWindows) {
            layout.horizontalSpacing = 2;
            layout.verticalSpacing = 2;
        }
        nick_area.setLayout((Layout)layout);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 3;
        nick_area.setLayoutData((Object)grid_data);
        label = new Label(nick_area, 0);
        label.setText(this.lu.getLocalisedMessageText("azbuddy.dchat.nick"));
        grid_data = new GridData();
        label.setLayoutData((Object)grid_data);
        this.nickname = new Text(nick_area, 2048);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 1;
        this.nickname.setLayoutData((Object)grid_data);
        this.nickname.setText(this.chat.getNickname());
        this.nickname.setMessage(this.chat.getDefaultNickname());
        label = new Label(nick_area, 0);
        label.setText(this.lu.getLocalisedMessageText("label.shared"));
        label.setToolTipText(this.lu.getLocalisedMessageText("azbuddy.dchat.shared.tooltip"));
        this.shared_nick_button = new Button(nick_area, 32);
        this.shared_nick_button.setSelection(this.chat.isSharedNickname());
        this.shared_nick_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean shared = BuddyPluginViewBetaChat.this.shared_nick_button.getSelection();
                BuddyPluginViewBetaChat.this.chat.setSharedNickname(shared);
            }
        });
        this.nickname.addListener(16, new Listener(){

            public void handleEvent(Event event2) {
                String nick = BuddyPluginViewBetaChat.this.nickname.getText().trim();
                if (BuddyPluginViewBetaChat.this.chat.isSharedNickname()) {
                    if (BuddyPluginViewBetaChat.this.chat.getNetwork() == "Public") {
                        BuddyPluginViewBetaChat.this.beta.setSharedPublicNickname(nick);
                    } else {
                        BuddyPluginViewBetaChat.this.beta.setSharedAnonNickname(nick);
                    }
                } else {
                    BuddyPluginViewBetaChat.this.chat.setInstanceNickname(nick);
                }
            }
        });
        this.table_header = new BufferedLabel(top_right, 0x20000000);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 3;
        if (!Constants.isWindows) {
            grid_data.horizontalIndent = 2;
        }
        this.table_header.setLayoutData(grid_data);
        this.table_header.setText(MessageText.getString("PeersView.state.pending"));
        this.buddy_table = new Table(rhs, 268503042);
        String[] headers = new String[]{"azbuddy.ui.table.name"};
        int[] sizes = new int[]{rhs_width - 10};
        int[] aligns = new int[]{16384};
        for (int i = 0; i < headers.length; ++i) {
            TableColumn tc = new TableColumn(this.buddy_table, aligns[i]);
            tc.setWidth(sizes[i]);
            Messages.setLanguageText((Widget)tc, headers[i]);
        }
        this.buddy_table.setHeaderVisible(true);
        grid_data = new GridData(1808);
        this.buddy_table.setLayoutData((Object)grid_data);
        this.buddy_table.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                TableItem item = (TableItem)event2.item;
                BuddyPluginViewBetaChat.this.setItemData(item);
            }
        });
        final Menu menu = new Menu((Control)this.buddy_table);
        this.buddy_table.setMenu(menu);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                TableItem[] selection = BuddyPluginViewBetaChat.this.buddy_table.getSelection();
                ArrayList<BuddyPluginBeta.ChatParticipant> participants = new ArrayList<BuddyPluginBeta.ChatParticipant>(selection.length);
                for (int i = 0; i < selection.length; ++i) {
                    TableItem item = selection[i];
                    BuddyPluginBeta.ChatParticipant participant = (BuddyPluginBeta.ChatParticipant)item.getData();
                    if (participant == null) {
                        participant = BuddyPluginViewBetaChat.this.setItemData(item);
                    }
                    if (participant == null) continue;
                    participants.add(participant);
                }
                BuddyPluginViewBetaChat.this.buildParticipantMenu(menu, participants);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        this.buddy_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event2) {
                int key = event2.character;
                if (key <= 26 && key > 0) {
                    key += 96;
                }
                if (key == 97 && event2.stateMask == SWT.MOD1) {
                    event2.doit = false;
                    BuddyPluginViewBetaChat.this.buddy_table.selectAll();
                }
            }
        });
        this.buddy_table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] selection = BuddyPluginViewBetaChat.this.buddy_table.getSelection();
                if (selection.length != 1) {
                    return;
                }
                TableItem item = selection[0];
                BuddyPluginBeta.ChatParticipant participant = (BuddyPluginBeta.ChatParticipant)item.getData();
                String name = participant.getName(true);
                String existing = BuddyPluginViewBetaChat.this.input_area.getText();
                if (existing.length() > 0 && !existing.endsWith(" ")) {
                    name = " " + name;
                }
                BuddyPluginViewBetaChat.this.input_area.append(name);
            }
        });
        Utils.maintainSashPanelWidth(sash, rhs, new int[]{700, 300}, "azbuddy.dchat.ui.sash.pos");
        this.input_area = new Text(parent, 2626);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        grid_data.heightHint = 30;
        grid_data.horizontalIndent = 4;
        this.input_area.setLayoutData((Object)grid_data);
        this.input_area.setTextLimit(400);
        this.input_area.addKeyListener(new KeyListener(){
            private LinkedList<String> history = new LinkedList();
            private int history_pos = -1;
            private String buffered_message = "";

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    e.doit = false;
                    String message = BuddyPluginViewBetaChat.this.input_area.getText().trim();
                    if (message.length() > 0) {
                        BuddyPluginViewBetaChat.this.sendMessage(message);
                        this.history.addFirst(message);
                        if (this.history.size() > 32) {
                            this.history.removeLast();
                        }
                        this.history_pos = -1;
                        this.buffered_message = "";
                        BuddyPluginViewBetaChat.this.input_area.setText("");
                    }
                } else if (e.keyCode == 0x1000001) {
                    ++this.history_pos;
                    if (this.history_pos < this.history.size()) {
                        if (this.history_pos == 0) {
                            this.buffered_message = BuddyPluginViewBetaChat.this.input_area.getText().trim();
                        }
                        String msg = this.history.get(this.history_pos);
                        BuddyPluginViewBetaChat.this.input_area.setText(msg);
                        BuddyPluginViewBetaChat.this.input_area.setSelection(msg.length());
                    } else {
                        this.history_pos = this.history.size() - 1;
                    }
                    e.doit = false;
                } else if (e.keyCode == 0x1000002) {
                    --this.history_pos;
                    if (this.history_pos >= 0) {
                        String msg = this.history.get(this.history_pos);
                        BuddyPluginViewBetaChat.this.input_area.setText(msg);
                        BuddyPluginViewBetaChat.this.input_area.setSelection(msg.length());
                    } else if (this.history_pos == -1) {
                        BuddyPluginViewBetaChat.this.input_area.setText(this.buffered_message);
                        if (this.buffered_message.length() > 0) {
                            BuddyPluginViewBetaChat.this.input_area.setSelection(this.buffered_message.length());
                            this.buffered_message = "";
                        }
                    } else {
                        this.history_pos = -1;
                    }
                    e.doit = false;
                } else if (e.stateMask == SWT.MOD1) {
                    int key = e.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (key == 97) {
                        BuddyPluginViewBetaChat.this.input_area.selectAll();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.ftux_ok = this.beta.getFTUXAccepted();
        if (this.chat.isReadOnly()) {
            this.input_area.setText(MessageText.getString("azbuddy.dchat.ro"));
            this.input_area.setEnabled(false);
        } else if (!this.ftux_ok) {
            this.input_area.setEnabled(false);
        } else {
            this.input_area.setFocus();
        }
        final boolean[] ftux_init_done = new boolean[]{false};
        this.beta.addFTUXStateChangeListener(new BuddyPluginBeta.FTUXStateChangeListener(){

            public void stateChanged(final boolean _ftux_ok) {
                if (ftux_stack.isDisposed()) {
                    BuddyPluginViewBetaChat.this.beta.removeFTUXStateChangeListener(this);
                } else {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            BuddyPluginViewBetaChat.this.ftux_ok = _ftux_ok;
                            Composite composite = stack_layout.topControl = BuddyPluginViewBetaChat.this.ftux_ok ? log_holder : ftux_holder;
                            if (ftux_init_done[0]) {
                                ftux_stack.layout(true, true);
                            }
                            if (!BuddyPluginViewBetaChat.this.chat.isReadOnly()) {
                                BuddyPluginViewBetaChat.this.input_area.setEnabled(BuddyPluginViewBetaChat.this.ftux_ok);
                            }
                            BuddyPluginViewBetaChat.this.table_resort_required = true;
                            BuddyPluginViewBetaChat.this.updateTable(false);
                        }
                    });
                }
            }
        });
        if (!this.chat.isReadOnly()) {
            for (DropTarget drop_target : this.drop_targets = new DropTarget[]{new DropTarget((Control)this.log, 1), new DropTarget((Control)this.input_area, 1)}) {
                drop_target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                drop_target.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dropAccept(DropTargetEvent event2) {
                        event2.currentDataType = URLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
                    }

                    public void dragEnter(DropTargetEvent event2) {
                    }

                    public void dragOperationChanged(DropTargetEvent event2) {
                    }

                    public void dragOver(DropTargetEvent event2) {
                        if ((event2.operations & 4) > 0) {
                            event2.detail = 4;
                        } else if ((event2.operations & 1) > 0) {
                            event2.detail = 1;
                        } else if ((event2.operations & 0x10) > 0) {
                            event2.detail = 1;
                        }
                        event2.feedback = 25;
                    }

                    public void dragLeave(DropTargetEvent event2) {
                    }

                    public void drop(DropTargetEvent event2) {
                        BuddyPluginViewBetaChat.this.handleDrop(event2.data);
                    }
                });
            }
        }
        ftux_init_done[0] = true;
        Control[] focus_controls = new Control[]{this.log, this.input_area, this.buddy_table, this.nickname, this.shared_nick_button};
        Listener focus_listener = new Listener(){

            public void handleEvent(Event event2) {
                BuddyPluginViewBetaChat.this.activate();
            }
        };
        for (Control c : focus_controls) {
            c.addListener(15, focus_listener);
        }
        BuddyPluginBeta.ChatParticipant[] existing_participants = this.chat.getParticipants();
        List<BuddyPluginBeta.ChatParticipant> len$ = this.participants;
        synchronized (len$) {
            this.participants.addAll(Arrays.asList(existing_participants));
        }
        this.table_resort_required = true;
        this.updateTable(false);
        BuddyPluginBeta.ChatMessage[] history = this.chat.getHistory();
        this.logChatMessages(history);
        this.chat.addListener(this);
        this.build_complete = true;
        if (can_popout && !this.ftux_ok && !auto_ftux_popout_done) {
            auto_ftux_popout_done = true;
            try {
                BuddyPluginViewBetaChat.createChatWindow(this.view, this.plugin, this.chat.getClone());
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    private void buildParticipantMenu(Menu menu, final List<BuddyPluginBeta.ChatParticipant> participants) {
        boolean can_ignore = false;
        boolean can_listen = false;
        boolean can_pin = false;
        boolean can_unpin = false;
        boolean can_spam = false;
        boolean can_unspam = false;
        for (BuddyPluginBeta.ChatParticipant participant : participants) {
            if (DEBUG_ENABLED) {
                System.out.println(participant.getName() + "/" + participant.getAddress());
                List<BuddyPluginBeta.ChatMessage> messages = participant.getMessages();
                for (BuddyPluginBeta.ChatMessage msg : messages) {
                    System.out.println("    " + msg.getTimeStamp() + ", " + msg.getAddress() + " - " + msg.getMessage());
                }
            }
            if (participant.isIgnored()) {
                can_listen = true;
            } else {
                can_ignore = true;
            }
            if (participant.isPinned()) {
                can_unpin = true;
            } else if (!participant.isMe()) {
                can_pin = true;
            }
            if (participant.isSpammer()) {
                can_unspam = true;
                continue;
            }
            can_spam |= participant.canSpammer();
        }
        MenuItem ignore_item = new MenuItem(menu, 8);
        ignore_item.setText(this.lu.getLocalisedMessageText("label.mute"));
        ignore_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean changed = false;
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (participant.isIgnored()) continue;
                    participant.setIgnored(true);
                    BuddyPluginViewBetaChat.this.setProperties(participant);
                    changed = true;
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                }
            }
        });
        ignore_item.setEnabled(can_ignore);
        MenuItem listen_item = new MenuItem(menu, 8);
        listen_item.setText(this.lu.getLocalisedMessageText("label.listen"));
        listen_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean changed = false;
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (!participant.isIgnored()) continue;
                    participant.setIgnored(false);
                    BuddyPluginViewBetaChat.this.setProperties(participant);
                    changed = true;
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                }
            }
        });
        listen_item.setEnabled(can_listen);
        MenuItem spam_item = new MenuItem(menu, 8);
        spam_item.setText(this.lu.getLocalisedMessageText("label.spam"));
        spam_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean changed = false;
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (!participant.canSpammer()) continue;
                    participant.setSpammer(true);
                    BuddyPluginViewBetaChat.this.setProperties(participant);
                    changed = true;
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                }
            }
        });
        spam_item.setEnabled(can_spam);
        MenuItem unspam_item = new MenuItem(menu, 8);
        unspam_item.setText(this.lu.getLocalisedMessageText("label.not.spam"));
        unspam_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean changed = false;
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (!participant.isSpammer()) continue;
                    participant.setSpammer(false);
                    BuddyPluginViewBetaChat.this.setProperties(participant);
                    changed = true;
                }
                if (changed) {
                    BuddyPluginViewBetaChat.this.messagesChanged();
                }
            }
        });
        unspam_item.setEnabled(can_unspam);
        new MenuItem(menu, 2);
        MenuItem pin_item = new MenuItem(menu, 8);
        pin_item.setText(this.lu.getLocalisedMessageText("label.pin"));
        pin_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (participant.isPinned() || participant.isMe()) continue;
                    participant.setPinned(true);
                    BuddyPluginViewBetaChat.this.setProperties(participant);
                }
            }
        });
        pin_item.setEnabled(can_pin);
        MenuItem unpin_item = new MenuItem(menu, 8);
        unpin_item.setText(this.lu.getLocalisedMessageText("label.unpin"));
        unpin_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (!participant.isPinned()) continue;
                    participant.setPinned(false);
                    BuddyPluginViewBetaChat.this.setProperties(participant);
                }
            }
        });
        unpin_item.setEnabled(can_unpin);
        if (!this.chat.isPrivateChat()) {
            new MenuItem(menu, 2);
            MenuItem private_chat_item = new MenuItem(menu, 8);
            private_chat_item.setText(this.lu.getLocalisedMessageText("label.private.chat"));
            final byte[] chat_pk = this.chat.getPublicKey();
            private_chat_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (BuddyPluginBeta.ChatParticipant participant : participants) {
                        if (!TEST_LOOPBACK_CHAT && Arrays.equals(participant.getPublicKey(), chat_pk)) continue;
                        try {
                            BuddyPluginBeta.ChatInstance chat = participant.createPrivateChat();
                            BuddyPluginViewBetaChat.createChatWindow(BuddyPluginViewBetaChat.this.view, BuddyPluginViewBetaChat.this.plugin, chat);
                        }
                        catch (Throwable f) {
                            Debug.out(f);
                        }
                    }
                }
            });
            boolean pc_enable = false;
            if (chat_pk != null) {
                for (BuddyPluginBeta.ChatParticipant participant : participants) {
                    if (Arrays.equals(participant.getPublicKey(), chat_pk)) continue;
                    pc_enable = true;
                }
            }
            private_chat_item.setEnabled(pc_enable || TEST_LOOPBACK_CHAT);
        }
        if (participants.size() == 1) {
            new MenuItem(menu, 2);
            MenuItem mi_copy_clip = new MenuItem(menu, 8);
            mi_copy_clip.setText(this.lu.getLocalisedMessageText("label.copy.to.clipboard"));
            mi_copy_clip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard(((BuddyPluginBeta.ChatParticipant)participants.get(0)).getName(true));
                }
            });
        }
    }

    private BuddyPluginBeta.ChatParticipant setItemData(TableItem item) {
        int index = this.buddy_table.indexOf(item);
        if (index < 0 || index >= this.participants.size()) {
            return null;
        }
        BuddyPluginBeta.ChatParticipant participant = this.participants.get(index);
        item.setData((Object)participant);
        item.setText(0, participant.getName(this.ftux_ok));
        this.setProperties(item, participant);
        return participant;
    }

    private void setProperties(BuddyPluginBeta.ChatParticipant p) {
        for (TableItem ti : this.buddy_table.getItems()) {
            if (ti.getData() != p) continue;
            this.setProperties(ti, p);
        }
    }

    private void setProperties(TableItem item, BuddyPluginBeta.ChatParticipant p) {
        if (p.isIgnored() || p.isSpammer()) {
            item.setForeground(0, Colors.grey);
        } else if (p.isPinned()) {
            item.setForeground(0, Colors.fadedGreen);
        } else if (p.isMe()) {
            item.setForeground(0, Colors.fadedGreen);
            item.setFont(0, this.italic_font);
        } else if (p.isNickClash()) {
            item.setForeground(0, Colors.red);
        } else if (p.hasNickname()) {
            item.setForeground(0, Colors.blues[9]);
        } else {
            item.setForeground(0, Colors.black);
        }
    }

    protected void addDisposeListener(DisposeListener listener) {
        if (this.shell != null) {
            if (this.shell.isDisposed()) {
                listener.widgetDisposed(null);
            } else {
                this.shell.addDisposeListener(listener);
            }
        }
    }

    private void updateTableHeader() {
        int active = this.buddy_table.getItemCount();
        int online = this.chat.getEstimatedNodes();
        String msg = this.lu.getLocalisedMessageText("azbuddy.dchat.user.status", new String[]{online >= 100 ? "100+" : String.valueOf(online), String.valueOf(active)});
        this.table_header.setText(msg);
    }

    protected void updateTable(boolean async) {
        if (async) {
            if (!this.buddy_table.isDisposed()) {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        if (BuddyPluginViewBetaChat.this.buddy_table.isDisposed()) {
                            return;
                        }
                        BuddyPluginViewBetaChat.this.updateTable(false);
                        BuddyPluginViewBetaChat.this.updateTableHeader();
                    }
                });
            }
        } else {
            if (this.table_resort_required) {
                this.table_resort_required = false;
                this.sortParticipants();
            }
            this.buddy_table.setItemCount(this.participants.size());
            this.buddy_table.clearAll();
            this.buddy_table.redraw();
        }
    }

    private void handleDrop(Object payload) {
        String url;
        if (payload instanceof String[]) {
            String[] files;
            for (String file : files = (String[])payload) {
                File f = new File(file);
                if (!f.exists()) continue;
                this.dropFile(f);
            }
        } else if (payload instanceof String) {
            String stuff = (String)payload;
            if (stuff.startsWith("DownloadManager\n") || stuff.startsWith("DiskManagerFileInfo\n")) {
                String[] bits = Constants.PAT_SPLIT_SLASH_N.split(stuff);
                for (int i = 1; i < bits.length; ++i) {
                    String hash_str = bits[i];
                    int pos = hash_str.indexOf(59);
                    try {
                        if (pos == -1) {
                            byte[] hash = Base32.decode(bits[i]);
                            Download download = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(hash);
                            this.dropDownload(download);
                            continue;
                        }
                        String[] files = hash_str.split(";");
                        byte[] hash = Base32.decode(files[0].trim());
                        DiskManagerFileInfo[] dm_files = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(hash).getDiskManagerFileInfo();
                        for (int j = 1; j < files.length; ++j) {
                            DiskManagerFileInfo dm_file = dm_files[Integer.parseInt(files[j].trim())];
                            this.dropDownloadFile(dm_file);
                        }
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to get download for hash " + bits[1]);
                    }
                }
            } else if (stuff.startsWith("TranscodeFile\n")) {
                String[] bits = Constants.PAT_SPLIT_SLASH_N.split(stuff);
                for (int i = 1; i < bits.length; ++i) {
                    File f = new File(bits[i]);
                    if (!f.isFile()) continue;
                    this.dropFile(f);
                }
            } else {
                String lc_stuff = stuff.toLowerCase(Locale.US);
                if (lc_stuff.startsWith("http:") || lc_stuff.startsWith("https:") || lc_stuff.startsWith("magnet: ")) {
                    this.dropURL(stuff);
                }
            }
        } else if (payload instanceof URLTransfer.URLType && (url = ((URLTransfer.URLType)payload).linkURL) != null) {
            this.dropURL(url);
        }
    }

    private void dropURL(String str) {
        this.input_area.setText(this.input_area.getText() + str);
    }

    private void dropFile(final File file) {
        try {
            if (!file.exists() || !file.canRead()) {
                throw new Exception("File '" + file + "' does not exist or is not accessible");
            }
            new AEThread2("share async"){

                public void run() {
                    PluginInterface pi = BuddyPluginViewBetaChat.this.plugin.getPluginInterface();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    String[] networks = BuddyPluginViewBetaChat.this.chat.isAnonymous() ? AENetworkClassifier.AT_NON_PUBLIC : AENetworkClassifier.AT_NETWORKS;
                    String networks_str = "";
                    for (String net : networks) {
                        networks_str = networks_str + (networks_str.length() == 0 ? "" : ",") + net;
                    }
                    properties.put("personal", "true");
                    properties.put("networks", networks_str);
                    properties.put("user_data", "buddyplugin:share");
                    try {
                        Torrent torrent;
                        if (file.isFile()) {
                            ShareResourceFile srf = pi.getShareManager().addFile(file, properties);
                            torrent = srf.getItem().getTorrent();
                        } else {
                            ShareResourceDir srd = pi.getShareManager().addDir(file, properties);
                            torrent = srd.getItem().getTorrent();
                        }
                        final Download download = pi.getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(torrent.getHash());
                        if (download == null) {
                            throw new Exception("Download no longer exists");
                        }
                        Utils.execSWTThread(new Runnable(){

                            public void run() {
                                BuddyPluginViewBetaChat.this.dropDownload(download);
                            }
                        });
                    }
                    catch (Throwable e) {
                        BuddyPluginViewBetaChat.this.dropFailed(file.getName(), e);
                    }
                }
            }.start();
        }
        catch (Throwable e) {
            this.dropFailed(file.getName(), e);
        }
    }

    private void dropDownload(Download download) {
        String magnet = UrlUtils.getMagnetURI(download, 80);
        InetSocketAddress address = this.chat.getMyAddress();
        if (address != null) {
            String address_str = AddressUtils.getHostAddress(address) + ":" + address.getPort();
            String arg = "&xsource=" + UrlUtils.encode(address_str);
            if (magnet.length() + arg.length() < 400) {
                magnet = magnet + arg;
            }
        }
        if (magnet.length() < 390) {
            magnet = magnet + "[[$dn]]";
        }
        this.plugin.getBeta().tagDownload(download);
        download.setForceStart(true);
        this.input_area.setText(this.input_area.getText() + magnet);
    }

    private void dropDownloadFile(DiskManagerFileInfo file) {
        try {
            Download download = file.getDownload();
            if (download.getTorrent().isSimpleTorrent()) {
                this.dropDownload(download);
                return;
            }
            File target = file.getFile(true);
            if (!target.exists() || file.getDownloaded() != file.getLength() && (!download.isComplete() || file.isSkipped())) {
                throw new Exception("File is incomplete or missing");
            }
            this.dropFile(target);
        }
        catch (Throwable e) {
            this.dropFailed(file.getFile(true).getName(), e);
        }
    }

    private void dropFailed(String content, Throwable e) {
        UIManager ui_manager = this.plugin.getPluginInterface().getUIManager();
        String details = MessageText.getString("azbuddy.dchat.share.fail.msg", new String[]{content, Debug.getNestedExceptionMessage(e)});
        ui_manager.showMessageBox("azbuddy.dchat.share.fail.title", "!" + details + "!", 1L);
    }

    protected void close() {
        if (this.shell != null) {
            this.shell.dispose();
        }
    }

    protected void closed() {
        this.chat.removeListener(this);
        this.chat.destroy();
        this.view.unregisterUI(this.chat);
    }

    @Override
    public void stateChanged(final boolean avail) {
        if (this.buddy_table.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new Runnable(){

            public void run() {
                if (BuddyPluginViewBetaChat.this.buddy_table.isDisposed()) {
                    return;
                }
                BuddyPluginViewBetaChat.this.input_area.setEnabled(avail);
                BuddyPluginViewBetaChat.this.nickname.setMessage(BuddyPluginViewBetaChat.this.chat.getDefaultNickname());
            }
        });
    }

    @Override
    public void updated() {
        if (this.status.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new Runnable(){

            public void run() {
                if (BuddyPluginViewBetaChat.this.status.isDisposed()) {
                    return;
                }
                BuddyPluginViewBetaChat.this.status.setText(BuddyPluginViewBetaChat.this.chat.getStatus());
                boolean is_shared = BuddyPluginViewBetaChat.this.chat.isSharedNickname();
                if (is_shared != BuddyPluginViewBetaChat.this.shared_nick_button.getSelection()) {
                    BuddyPluginViewBetaChat.this.shared_nick_button.setSelection(is_shared);
                }
                if (!BuddyPluginViewBetaChat.this.nickname.isFocusControl()) {
                    String nick = BuddyPluginViewBetaChat.this.nickname.getText().trim();
                    if (!BuddyPluginViewBetaChat.this.chat.getNickname().equals(nick)) {
                        BuddyPluginViewBetaChat.this.nickname.setText(BuddyPluginViewBetaChat.this.chat.getNickname());
                    }
                }
                if (BuddyPluginViewBetaChat.this.table_resort_required) {
                    BuddyPluginViewBetaChat.this.updateTable(false);
                }
                BuddyPluginViewBetaChat.this.updateTableHeader();
            }
        });
    }

    private void sortParticipants() {
        Collections.sort(this.participants, new Comparator<BuddyPluginBeta.ChatParticipant>(){
            private Comparator<String> comp = new FormattersImpl().getAlphanumericComparator(true);

            @Override
            public int compare(BuddyPluginBeta.ChatParticipant p1, BuddyPluginBeta.ChatParticipant p2) {
                boolean b_p2;
                boolean b_p1 = p1.hasNickname();
                if (b_p1 == (b_p2 = p2.hasNickname())) {
                    return this.comp.compare(p1.getName(BuddyPluginViewBetaChat.this.ftux_ok), p2.getName(BuddyPluginViewBetaChat.this.ftux_ok));
                }
                if (b_p1) {
                    return -1;
                }
                return 1;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void participantAdded(BuddyPluginBeta.ChatParticipant participant) {
        List<BuddyPluginBeta.ChatParticipant> list = this.participants;
        synchronized (list) {
            this.participants.add(participant);
            this.table_resort_required = true;
        }
        this.updateTable(true);
    }

    @Override
    public void participantChanged(final BuddyPluginBeta.ChatParticipant participant) {
        if (!this.buddy_table.isDisposed()) {
            Utils.execSWTThread(new Runnable(){

                public void run() {
                    if (BuddyPluginViewBetaChat.this.buddy_table.isDisposed()) {
                        return;
                    }
                    TableItem[] items = BuddyPluginViewBetaChat.this.buddy_table.getItems();
                    String name = participant.getName(BuddyPluginViewBetaChat.this.ftux_ok);
                    for (TableItem item : items) {
                        if (item.getData() != participant) continue;
                        BuddyPluginViewBetaChat.this.setProperties(item, participant);
                        String old_name = item.getText(0);
                        if (old_name.equals(name)) continue;
                        item.setText(0, name);
                        BuddyPluginViewBetaChat.this.table_resort_required = true;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void participantRemoved(BuddyPluginBeta.ChatParticipant participant) {
        List<BuddyPluginBeta.ChatParticipant> list = this.participants;
        synchronized (list) {
            this.participants.remove(participant);
            this.participant_last_message_map.remove(participant);
        }
        this.updateTable(true);
    }

    protected void sendMessage(String text) {
        try {
            Pattern p = Pattern.compile("(?i)\\\\u([\\dabcdef]{4})");
            Matcher m = p.matcher(text);
            boolean result = m.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                while (result) {
                    String str = m.group(1);
                    int unicode = Integer.parseInt(str, 16);
                    m.appendReplacement(sb, String.valueOf((char)unicode));
                    result = m.find();
                }
                m.appendTail(sb);
                text = sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.chat.sendMessage(text, new HashMap<String, Object>());
    }

    private String expand(Map<String, String> params, String str, boolean url_decode) {
        int pos = 0;
        String result = "";
        while (true) {
            String param;
            String value;
            int new_pos;
            if ((new_pos = str.indexOf(36, pos)) == -1) break;
            result = result + str.substring(pos, new_pos);
            int end_pos = str.length();
            for (int i = new_pos + 1; i < end_pos; ++i) {
                char c = str.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                end_pos = i;
                break;
            }
            if ((value = params.get(param = str.substring(new_pos + 1, end_pos))) == null) {
                pos = new_pos + 1;
                result = result + "$";
                continue;
            }
            result = url_decode ? result + UrlUtils.decode(value) : result + value;
            pos = end_pos;
        }
        result = result + str.substring(pos);
        return result;
    }

    @Override
    public void messageReceived(final BuddyPluginBeta.ChatMessage message, boolean sort_outstanding) {
        if (sort_outstanding) {
            return;
        }
        if (!this.log.isDisposed()) {
            Utils.execSWTThread(new Runnable(){

                public void run() {
                    if (BuddyPluginViewBetaChat.this.log.isDisposed()) {
                        return;
                    }
                    BuddyPluginViewBetaChat.this.logChatMessage(message);
                }
            });
        }
    }

    @Override
    public void messagesChanged() {
        if (!this.log.isDisposed()) {
            Utils.execSWTThread(new Runnable(){

                public void run() {
                    if (BuddyPluginViewBetaChat.this.log.isDisposed()) {
                        return;
                    }
                    try {
                        BuddyPluginViewBetaChat.this.resetChatMessages();
                        BuddyPluginBeta.ChatMessage[] history = BuddyPluginViewBetaChat.this.chat.getHistory();
                        BuddyPluginViewBetaChat.this.logChatMessages(history);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetChatMessages() {
        this.log.setText("");
        this.messages.clear();
        this.previous_says = null;
        List<BuddyPluginBeta.ChatParticipant> list = this.participants;
        synchronized (list) {
            this.participant_last_message_map.clear();
        }
    }

    private void logChatMessage(BuddyPluginBeta.ChatMessage message) {
        this.logChatMessages(new BuddyPluginBeta.ChatMessage[]{message});
    }

    private String getChatTimestamp(long now, long time) {
        long age = now - time;
        Date date = new Date(time);
        if (age < 86400000L) {
            return this.time_format1.format(date);
        }
        if (age < 604800000L) {
            return this.time_format2a.format(date) + this.time_format2b.format(date).toLowerCase();
        }
        return this.time_format3.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private void logChatMessages(BuddyPluginBeta.ChatMessage[] all_messages) {
        long now = SystemTime.getCurrentTime();
        int existing_length = this.log.getText().length();
        StringBuffer appended = new StringBuffer(2048);
        ArrayList<StyleRange> new_ranges = new ArrayList<StyleRange>();
        BuddyPluginBeta.ChatMessage last_message_not_ours = null;
        boolean ignore_ratings = this.beta.getHideRatings();
        for (BuddyPluginBeta.ChatMessage message : all_messages) {
            int stamp_len;
            String says;
            BuddyPluginBeta.ChatMessage last_message;
            int origin;
            if (this.messages.containsKey(message)) continue;
            String original_msg = message.getMessage();
            if (message.isIgnored() || original_msg.length() <= 0 || ignore_ratings && (origin = message.getFlagOrigin()) == 1) continue;
            long time = message.getTimeStamp();
            BuddyPluginBeta.ChatParticipant participant = message.getParticipant();
            boolean is_me = participant.isMe();
            if (!is_me) {
                last_message_not_ours = message;
            }
            int overall_start = appended.length();
            String nick = message.getNickName();
            int message_type = message.getMessageType();
            Color colour = Colors.blues[9];
            if (message_type == 2) {
                colour = Colors.grey;
            } else if (message_type == 3) {
                colour = Colors.red;
            } else if (participant.isPinned() || is_me) {
                colour = Colors.fadedGreen;
            } else if (message.isNickClash()) {
                colour = Colors.red;
            }
            String stamp = this.getChatTimestamp(now, time);
            List<BuddyPluginBeta.ChatParticipant> list = this.participants;
            synchronized (list) {
                last_message = this.participant_last_message_map.get(participant);
                this.participant_last_message_map.put(participant, message);
            }
            int was_len = 0;
            if (message_type != 1) {
                says = "[" + stamp + "]";
                stamp_len = says.length();
            } else {
                String last_nick;
                says = "[" + stamp + "] " + (nick.length() > 20 ? nick.substring(0, 16) + "..." : nick);
                stamp_len = stamp.length() + 3;
                if (last_message != null && !participant.isMe() && !nick.equals(last_nick = last_message.getNickName())) {
                    String was = " (was " + (last_nick.length() > 20 ? last_nick.substring(0, 16) + "..." : last_nick) + ")";
                    says = says + was;
                    was_len = was.length();
                }
            }
            says = says + (message_type == 1 ? "\n" : " ");
            if (this.previous_says == null || this.previous_says_mt != message_type || !this.previous_says.equals(says)) {
                int rem;
                this.previous_says = says;
                this.previous_says_mt = message_type;
                int start = existing_length + appended.length();
                appended.append(says);
                StyleRange styleRange = new StyleRange();
                styleRange.start = start;
                styleRange.length = stamp_len;
                styleRange.foreground = Colors.grey;
                if (participant.isMe()) {
                    styleRange.font = this.italic_font;
                }
                new_ranges.add(styleRange);
                if (colour != Colors.black && (rem = says.length() - stamp_len) > 0) {
                    StyleRange styleRange2 = new StyleRange();
                    styleRange2.start = start + stamp_len;
                    styleRange2.length = rem - was_len;
                    styleRange2.foreground = colour;
                    styleRange2.data = participant;
                    if (participant.isMe()) {
                        styleRange2.font = this.italic_font;
                    }
                    new_ranges.add(styleRange2);
                }
            }
            int start = existing_length + appended.length();
            String msg = original_msg;
            try {
                ArrayList<Object> segments = new ArrayList<Object>();
                int pos = 0;
                while (true) {
                    int old_pos;
                    if ((pos = original_msg.indexOf(58, old_pos = pos)) == -1) {
                        String tail = original_msg.substring(old_pos);
                        if (tail.length() <= 0) break;
                        segments.add(tail);
                        break;
                    }
                    boolean was_url = false;
                    String protocol = "";
                    for (int i = pos - 1; i >= 0; --i) {
                        char c = original_msg.charAt(i);
                        if (!Character.isLetterOrDigit(c)) {
                            if (c != '\"') break;
                            protocol = c + protocol;
                            break;
                        }
                        protocol = c + protocol;
                    }
                    if (protocol.length() > 0) {
                        char term_char = ' ';
                        if (protocol.startsWith("\"")) {
                            term_char = '\"';
                        }
                        int url_start = pos - protocol.length();
                        int url_end = original_msg.length();
                        for (int i = pos + 1; i < url_end; ++i) {
                            char c = original_msg.charAt(i);
                            if (c != term_char && (term_char != ' ' || !Character.isWhitespace(c))) continue;
                            url_end = term_char == ' ' ? i : i + 1;
                            break;
                        }
                        if (url_end > pos + 1 && !Character.isDigit(protocol.charAt(0))) {
                            try {
                                String url_str = protocol + original_msg.substring(pos, url_end);
                                if (url_str.startsWith("\"") && url_str.endsWith("\"")) {
                                    url_str = url_str.substring(1, url_str.length() - 1);
                                }
                                URL url = new URL(url_str);
                                if (url_start > old_pos) {
                                    segments.add(original_msg.substring(old_pos, url_start));
                                }
                                segments.add(url);
                                was_url = true;
                                pos = url_end;
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                    }
                    if (was_url) continue;
                    segments.add(original_msg.substring(old_pos, ++pos));
                }
                if (segments.size() > 1) {
                    ArrayList<String> temp = new ArrayList<String>(segments.size());
                    String str = "";
                    for (Object obj : segments) {
                        if (obj instanceof String) {
                            str = str + obj;
                            continue;
                        }
                        if (str.length() > 0) {
                            temp.add(str);
                        }
                        str = "";
                        temp.add((String)obj);
                    }
                    if (str.length() > 0) {
                        temp.add(str);
                    }
                    segments = temp;
                }
                HashMap<String, String> params = new HashMap<String, String>();
                for (int i = 0; i < segments.size(); ++i) {
                    String str;
                    Object obj = segments.get(i);
                    if (obj instanceof URL) {
                        int hpos;
                        params.clear();
                        str = ((URL)obj).toExternalForm();
                        int qpos = str.indexOf(63);
                        if (qpos > 0) {
                            String[] bits;
                            hpos = str.lastIndexOf("[[");
                            for (String bit : bits = str.substring(qpos + 1, hpos == -1 ? str.length() : hpos).split("&")) {
                                String[] temp = bit.split("=", 2);
                                if (temp.length != 2) continue;
                                params.put(temp[0], temp[1]);
                            }
                            if (hpos <= 0 || !str.endsWith("]]")) continue;
                            str = str.substring(0, hpos) + "[[" + this.expand(params, str.substring(hpos + 2, str.length() - 2), false) + "]]";
                            try {
                                segments.set(i, new URL(str));
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                            continue;
                        }
                        hpos = str.lastIndexOf("[[");
                        if (hpos <= 0 || !str.endsWith("]]")) continue;
                        str = str.substring(0, hpos) + "[[" + str.substring(hpos + 2, str.length() - 2) + "]]";
                        try {
                            segments.set(i, new URL(str));
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        continue;
                    }
                    str = (String)obj;
                    if (params.size() <= 0) continue;
                    segments.set(i, this.expand(params, str, true));
                }
                StringBuffer sb = new StringBuffer(1024);
                for (Object obj : segments) {
                    if (obj instanceof URL) {
                        sb.append("\"" + ((URL)obj).toExternalForm() + "\"");
                        continue;
                    }
                    sb.append((String)obj);
                }
                msg = sb.toString();
                int next_style_start = start;
                pos = 0;
                while (pos < msg.length() && (pos = msg.indexOf(58, pos)) != -1) {
                    String protocol = "";
                    for (int i = pos - 1; i >= 0; --i) {
                        char c = msg.charAt(i);
                        if (!Character.isLetterOrDigit(c)) {
                            if (c != '\"') break;
                            protocol = c + protocol;
                            break;
                        }
                        protocol = c + protocol;
                    }
                    if (protocol.length() > 0) {
                        char term_char = ' ';
                        if (protocol.startsWith("\"")) {
                            term_char = '\"';
                        }
                        int url_start = pos - protocol.length();
                        int url_end = msg.length();
                        for (int i = pos + 1; i < url_end; ++i) {
                            char c = msg.charAt(i);
                            if (c != term_char && (term_char != ' ' || !Character.isWhitespace(c))) continue;
                            url_end = term_char == ' ' ? i : i + 1;
                            break;
                        }
                        if (url_end > pos + 1 && !Character.isDigit(protocol.charAt(0))) {
                            try {
                                StyleRange styleRange;
                                String url_str = protocol + msg.substring(pos, url_end);
                                if (url_str.startsWith("\"") && url_str.endsWith("\"")) {
                                    url_str = url_str.substring(1, url_str.length() - 1);
                                }
                                if (protocol.equalsIgnoreCase("chat")) {
                                    if (url_str.toLowerCase(Locale.US).startsWith("chat:anon") && !this.beta.isI2PAvailable()) {
                                        throw new Exception("Anonymous chat unavailable");
                                    }
                                } else {
                                    URL url = new URL(url_str);
                                }
                                String original_url_str = url_str;
                                String display_url = UrlUtils.decode(url_str);
                                int hack_pos = url_str.lastIndexOf("[[");
                                if (hack_pos > 0 && url_str.endsWith("]]")) {
                                    String substitution = url_str.substring(hack_pos + 2, url_str.length() - 2).trim();
                                    url_str = url_str.substring(0, hack_pos);
                                    display_url = UrlUtils.parseTextForURL(substitution, true) == null ? UrlUtils.decode(substitution) : UrlUtils.decode(url_str);
                                }
                                if (term_char != ' ' || !display_url.equals(original_url_str)) {
                                    int old_len = msg.length();
                                    msg = msg.substring(0, url_start) + display_url + msg.substring(url_end);
                                    url_end += msg.length() - old_len;
                                }
                                int this_style_start = start + url_start;
                                int this_style_length = display_url.length();
                                if (this_style_start > next_style_start && message_type == 2) {
                                    StyleRange styleRange3 = new StyleRange();
                                    styleRange3.start = next_style_start;
                                    styleRange3.length = this_style_start - next_style_start;
                                    styleRange3.foreground = Colors.grey;
                                    new_ranges.add(styleRange3);
                                    next_style_start = this_style_start + this_style_length;
                                }
                                boolean will_work = true;
                                try {
                                    String lc_url = url_str.toLowerCase(Locale.US);
                                    if (lc_url.startsWith("magnet") && (!lc_url.contains("btih:") || lc_url.contains("btih:&") || lc_url.endsWith("btih:")) && !lc_url.contains("&fl=")) {
                                        will_work = false;
                                    }
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                if (will_work) {
                                    styleRange = new StyleRange();
                                    styleRange.start = this_style_start;
                                    styleRange.length = this_style_length;
                                    styleRange.foreground = Colors.blue;
                                    styleRange.underline = true;
                                    styleRange.data = url_str;
                                    new_ranges.add(styleRange);
                                } else {
                                    styleRange = new StyleRange();
                                    styleRange.start = this_style_start;
                                    styleRange.length = this_style_length;
                                    styleRange.font = this.bold_font;
                                    new_ranges.add(styleRange);
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                        pos = url_end;
                        continue;
                    }
                    ++pos;
                }
                if (next_style_start < start + msg.length() && message_type == 2) {
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = next_style_start;
                    styleRange.length = start + msg.length() - next_style_start;
                    styleRange.foreground = Colors.grey;
                    new_ranges.add(styleRange);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            appended.append(msg);
            appended.append("\n");
            int actual_length = appended.length() - overall_start;
            this.messages.put(message, actual_length);
        }
        if (appended.length() > 0) {
            try {
                this.log.setVisible(false);
                this.log.append(appended.toString());
                if (new_ranges.size() > 0) {
                    StyleRange[] ranges;
                    List<StyleRange> existing_ranges = Arrays.asList(this.log.getStyleRanges());
                    ArrayList<StyleRange> all_ranges = new ArrayList<StyleRange>(existing_ranges.size() + new_ranges.size());
                    all_ranges.addAll(existing_ranges);
                    all_ranges.addAll(new_ranges);
                    for (StyleRange sr : ranges = all_ranges.toArray(new StyleRange[all_ranges.size()])) {
                        sr.borderStyle = 0;
                    }
                    this.log.setStyleRanges(ranges);
                    this.log_styles = ranges;
                }
                Iterator<Integer> it = null;
                int max_lines = this.beta.getMaxUILines();
                int max_chars = this.beta.getMaxUICharsKB() * 1024;
                while (this.messages.size() > max_lines || this.log.getText().length() > max_chars) {
                    if (it == null) {
                        it = this.messages.values().iterator();
                    }
                    if (!it.hasNext()) break;
                    int to_remove = it.next();
                    it.remove();
                    this.log.replaceTextRange(0, to_remove, "");
                    this.log_styles = this.log.getStyleRanges();
                }
                this.log.setSelection(this.log.getText().length());
                Object var44_91 = null;
            }
            catch (Throwable throwable) {
                Object var44_92 = null;
                this.log.setVisible(true);
                throw throwable;
            }
            this.log.setVisible(true);
            if (last_message_not_ours != null) {
                long last_message_not_ours_time = last_message_not_ours.getTimeStamp();
                if (this.build_complete) {
                    if (!this.log.isVisible() || this.shell != null && this.shell.getMinimized() || this.log.getDisplay().getFocusControl() == null) {
                        if (last_message_not_ours_time > this.last_seen_message) {
                            this.last_seen_message_pending = last_message_not_ours_time;
                            this.view.betaMessagePending(this.chat, (Control)this.log, last_message_not_ours);
                        }
                    } else {
                        this.last_seen_message = last_message_not_ours_time;
                    }
                } else if (last_message_not_ours_time > this.last_seen_message) {
                    this.last_seen_message = last_message_not_ours_time;
                }
            }
        }
    }

    public void activate() {
        if (this.last_seen_message_pending > this.last_seen_message) {
            this.last_seen_message = this.last_seen_message_pending;
        }
        this.view.betaMessagePending(this.chat, (Control)this.log, null);
    }
}

