/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class ColumnSubscriptionAutoDownload
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static String COLUMN_ID = "auto-download";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnSubscriptionAutoDownload(String sTableID) {
        super(COLUMN_ID, 3, -2, 100, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidth(100);
        this.setMaxWidth(100);
    }

    public void refresh(TableCell cell) {
        SubscriptionHistory history;
        boolean autoDownload = false;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null && (history = sub.getHistory()) != null) {
            autoDownload = history.isAutoDownload();
        }
        if (!cell.setSortValue(Boolean.valueOf(autoDownload)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (sub.isAutoDownloadSupported()) {
            cell.setText(DisplayFormatters.getYesNo(autoDownload));
        } else {
            cell.setText("");
        }
    }
}

