/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.extlistener;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.BrowserMessageDispatcher;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfoContentNetwork;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.ExternalStimulusListener;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.util.Collections;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.donations.DonationWindow;

public class StimulusRPC {
    public static void hookListeners(final AzureusCore core, final MainWindow mainWindow) {
        ExternalStimulusHandler.addListener(new ExternalStimulusListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean receive(String name, Map values) {
                try {
                    Map decodedMap;
                    String opId;
                    String lId;
                    ClientMessageContext context2;
                    String value;
                    block29: {
                        block34: {
                            block33: {
                                block32: {
                                    block30: {
                                        String url;
                                        block31: {
                                            if (values == null) {
                                                return false;
                                            }
                                            if (!name.equals("AZMSG")) {
                                                return false;
                                            }
                                            Object valueObj = values.get("value");
                                            if (!(valueObj instanceof String)) {
                                                return false;
                                            }
                                            value = (String)valueObj;
                                            context2 = PlatformMessenger.getClientMessageContext();
                                            if (context2 == null) {
                                                return false;
                                            }
                                            String[] splitVal = value.split(";", 5);
                                            if (splitVal.length != 5) {
                                                return false;
                                            }
                                            lId = splitVal[2];
                                            opId = splitVal[3];
                                            decodedMap = JSONUtils.decodeJSON(splitVal[4]);
                                            if (decodedMap == null) {
                                                decodedMap = Collections.EMPTY_MAP;
                                            }
                                            if (!opId.equals("open-url")) break block30;
                                            url = MapUtils.getMapString(decodedMap, "url", null);
                                            if (decodedMap.containsKey("target")) break block31;
                                            context2.debug("no target for url: " + url);
                                            break block29;
                                        }
                                        if (UrlFilter.getInstance().urlIsBlocked(url)) {
                                            context2.debug("url blocked: " + url);
                                            break block29;
                                        } else if (!UrlFilter.getInstance().urlCanRPC(url)) {
                                            context2.debug("url not in whitelistL " + url);
                                            break block29;
                                        } else {
                                            BrowserMessageDispatcher dispatcher;
                                            UIFunctions functions = UIFunctionsManager.getUIFunctions();
                                            if (functions != null) {
                                                functions.bringToFront();
                                            }
                                            if ((dispatcher = context2.getDispatcher()) != null) {
                                                dispatcher.dispatch(new BrowserMessage(lId, opId, decodedMap));
                                                return true;
                                            }
                                            context2.debug("No dispatcher for StimulusRPC" + opId);
                                            return true;
                                        }
                                    }
                                    if (!opId.equals("load-torrent")) break block32;
                                    if (decodedMap.containsKey("b64")) {
                                        String b64 = MapUtils.getMapString(decodedMap, "b64", null);
                                        return TorrentListener.loadTorrentByB64(core, b64);
                                    }
                                    if (decodedMap.containsKey("url")) {
                                        String url = MapUtils.getMapString(decodedMap, "url", null);
                                        boolean blocked = UrlFilter.getInstance().urlIsBlocked(url);
                                        if (blocked) {
                                            Debug.out("stopped loading torrent URL because it's not in whitelist");
                                            return false;
                                        }
                                        boolean playNow = MapUtils.getMapBoolean(decodedMap, "play-now", false);
                                        boolean playPrepare = MapUtils.getMapBoolean(decodedMap, "play-prepare", false);
                                        boolean bringToFront = MapUtils.getMapBoolean(decodedMap, "bring-to-front", true);
                                        long contentNetworkID = MapUtils.getMapLong(decodedMap, "content-network", ConstantsVuze.getDefaultContentNetwork().getID());
                                        ContentNetwork cn = ContentNetworkManagerFactory.getSingleton().getContentNetwork(contentNetworkID);
                                        if (cn == null) {
                                            cn = ConstantsVuze.getDefaultContentNetwork();
                                        }
                                        DownloadUrlInfoContentNetwork dlInfo = new DownloadUrlInfoContentNetwork(url, cn);
                                        dlInfo.setReferer(MapUtils.getMapString(decodedMap, "referer", null));
                                        TorrentUIUtilsV3.loadTorrent(dlInfo, playNow, playPrepare, bringToFront);
                                        return true;
                                    }
                                    break block29;
                                }
                                if (opId.equals("is-ready")) {
                                    return mainWindow.isReady();
                                }
                                if (opId.equals("is-version-ge")) {
                                    if (!decodedMap.containsKey("version")) return false;
                                    String id = MapUtils.getMapString(decodedMap, "id", "client");
                                    String version = MapUtils.getMapString(decodedMap, "version", "");
                                    if (!id.equals("client")) return false;
                                    if (Constants.compareVersions("5.6.1.3_B04", version) < 0) return false;
                                    return true;
                                }
                                if (opId.equals("is-active-tab")) {
                                    if (!decodedMap.containsKey("tab")) return false;
                                    String tabID = MapUtils.getMapString(decodedMap, "tab", "");
                                    if (tabID.length() <= 0) return false;
                                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                                    MdiEntry entry = mdi.getCurrentEntry();
                                    if (entry == null) return false;
                                    return entry.getId().equals(tabID);
                                }
                                if (!"config".equals(lId)) break block33;
                                if ("is-new-install".equals(opId)) {
                                    return COConfigurationManager.isNewInstall();
                                }
                                if ("check-for-updates".equals(opId)) {
                                    ConfigListener.checkForUpdates();
                                    return true;
                                }
                                if ("log-diags".equals(opId)) {
                                    ConfigListener.logDiagnostics();
                                    return true;
                                }
                                break block29;
                            }
                            if (!"display".equals(lId)) break block34;
                            if ("refresh-browser".equals(opId)) {
                                DisplayListener.refreshTab(MapUtils.getMapString(decodedMap, "browser-id", ""));
                                break block29;
                            } else if ("switch-to-tab".equals(opId)) {
                                DisplayListener.switchToTab(MapUtils.getMapString(decodedMap, "target", ""), MapUtils.getMapString(decodedMap, "source-ref", null));
                            }
                            break block29;
                        }
                        if ("show-donation-window".equals(lId)) {
                            DonationWindow.open(true, MapUtils.getMapString(decodedMap, "source-ref", "SRPC"));
                        }
                    }
                    if (System.getProperty("browser.route.all.external.stimuli.for.testing", "false").equalsIgnoreCase("true")) {
                        BrowserMessageDispatcher dispatcher = context2.getDispatcher();
                        if (dispatcher == null) return false;
                        dispatcher.dispatch(new BrowserMessage(lId, opId, decodedMap));
                        return false;
                    }
                    System.err.println("Unhandled external stimulus: " + value);
                    return false;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                return false;
            }

            public int query(String name, Map values) {
                return Integer.MIN_VALUE;
            }
        });
    }
}

