/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.mdi.BaseMDI;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.TabbedEntry;
import com.aelitis.azureus.ui.swt.mdi.TabbedMdiInterface;
import com.aelitis.azureus.ui.swt.mdi.TabbedMdiMaximizeListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTabFolder;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.PluginUISWTSkinObject;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventCancelledException;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.IViewAlwaysInitialize;

public class TabbedMDI
extends BaseMDI
implements TabbedMdiInterface,
AEDiagnosticsEvidenceGenerator,
ParameterListener {
    private CTabFolder tabFolder;
    private LinkedList<MdiEntry> select_history = new LinkedList();
    protected boolean minimized;
    private int iFolderHeightAdj;
    private String props_prefix;
    private DownloadManager maximizeTo;
    private int minimumCharacters = 25;
    protected boolean isMainMDI;
    private Map mapUserClosedTabs;
    private boolean maximizeVisible = false;
    private boolean minimizeVisible = false;
    private TabbedMdiMaximizeListener maximizeListener;

    public TabbedMDI() {
        AEDiagnostics.addEvidenceGenerator(this);
        this.mapUserClosedTabs = new HashMap();
        this.isMainMDI = true;
    }

    public TabbedMDI(Composite parent, String id) {
        this.props_prefix = id;
        this.minimumCharacters = 0;
        this.isMainMDI = false;
        this.setCloseableConfigFile(null);
        SWTSkin skin = SWTSkinFactory.getInstance();
        SWTSkinObjectTabFolder soFolder = new SWTSkinObjectTabFolder(skin, skin.getSkinProperties(), id, "tabfolder.fill", parent);
        this.setMainSkinObject(soFolder);
        soFolder.addListener(this);
        skin.addSkinObject(soFolder);
        String key = this.props_prefix + ".closedtabs";
        this.mapUserClosedTabs = COConfigurationManager.getMapParameter(key, new HashMap());
        COConfigurationManager.addParameterListener(key, (ParameterListener)this);
    }

    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        super.skinObjectCreated(skinObject, params);
        this.creatMDI();
        try {
            UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        String key = this.props_prefix + ".closedtabs";
        COConfigurationManager.removeParameterListener(key, this);
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void creatMDI() {
        this.tabFolder = this.soMain instanceof SWTSkinObjectTabFolder ? ((SWTSkinObjectTabFolder)this.soMain).getTabFolder() : new CTabFolder((Composite)this.soMain.getControl(), 2240);
        this.iFolderHeightAdj = this.tabFolder.computeSize((int)-1, (int)0).y;
        if (this.isMainMDI) {
            COConfigurationManager.addAndFireParameterListener("GUI_SWT_bFancyTab", new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            boolean simple = !COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab");
                            TabbedMDI.this.tabFolder.setSimple(simple);
                        }
                    });
                }
            });
            this.tabFolder.setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
        } else {
            this.tabFolder.setSimple(true);
            this.tabFolder.setMaximizeVisible(this.maximizeVisible);
            this.tabFolder.setMinimizeVisible(this.minimizeVisible);
            this.tabFolder.setUnselectedCloseVisible(false);
        }
        Display display = this.tabFolder.getDisplay();
        float[] hsb = this.tabFolder.getBackground().getRGB().getHSB();
        hsb[2] = (float)((double)hsb[2] * (Constants.isOSX ? 0.9 : 0.97));
        this.tabFolder.setBackground(ColorCache.getColor((Device)display, hsb));
        hsb = this.tabFolder.getForeground().getRGB().getHSB();
        hsb[2] = (float)((double)hsb[2] * (Constants.isOSX ? 1.1 : 0.03));
        this.tabFolder.setForeground(ColorCache.getColor((Device)display, hsb));
        this.tabFolder.setSelectionBackground(new Color[]{display.getSystemColor(25), display.getSystemColor(25), display.getSystemColor(22)}, new int[]{10, 90}, true);
        this.tabFolder.setSelectionForeground(display.getSystemColor(24));
        if (this.minimumCharacters > 0) {
            this.tabFolder.setMinimumCharacters(this.minimumCharacters);
        }
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TabbedEntry entry = (TabbedEntry)event2.item.getData("TabbedEntry");
                TabbedMDI.this.showEntry(entry);
            }
        });
        this.tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TabbedMDI.this.tabFolder.getMinimized()) {
                    TabbedMDI.this.restore();
                    e.button = 0;
                    TabbedMDI.this.tabFolder.notifyListeners(7, null);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (!TabbedMDI.this.tabFolder.getMinimized() && TabbedMDI.this.tabFolder.getMaximizeVisible()) {
                    TabbedMDI.this.minimize();
                }
            }
        });
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void minimize(CTabFolderEvent event2) {
                TabbedMDI.this.minimize();
            }

            public void maximize(CTabFolderEvent event2) {
                if (TabbedMDI.this.maximizeListener != null) {
                    TabbedMDI.this.maximizeListener.maximizePressed();
                }
            }

            public void restore(CTabFolderEvent event_maybe_null) {
                TabbedMDI.this.restore();
            }

            public void close(CTabFolderEvent event2) {
                MdiEntry next;
                final TabbedEntry entry = (TabbedEntry)event2.item.getData("TabbedEntry");
                if (TabbedMDI.this.select_history.remove(entry) && TabbedMDI.this.select_history.size() > 0 && !(next = (MdiEntry)TabbedMDI.this.select_history.getLast()).isDisposed() && next != entry) {
                    CTabItem[] items = TabbedMDI.this.tabFolder.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        CTabItem item = items[i];
                        TabbedEntry scanEntry = TabbedMDI.this.getEntryFromTabItem(item);
                        if (scanEntry != next) continue;
                        TabbedMDI.this.tabFolder.setSelection(item);
                        break;
                    }
                    TabbedMDI.this.showEntry(next);
                }
                if (TabbedMDI.this.props_prefix != null) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            String view_id = entry.getViewID();
                            String key = TabbedMDI.this.props_prefix + ".closedtabs";
                            Map closedtabs = COConfigurationManager.getMapParameter(key, new HashMap());
                            if (!closedtabs.containsKey(view_id)) {
                                closedtabs.put(view_id, entry.getTitle());
                                COConfigurationManager.setParameter(key, closedtabs);
                            }
                        }
                    });
                }
            }
        });
        if (this.isMainMDI) {
            this.tabFolder.getDisplay().addFilter(1, new Listener(){

                public void handleEvent(Event event2) {
                    if (TabbedMDI.this.tabFolder.isDisposed()) {
                        return;
                    }
                    Control focus_control = TabbedMDI.this.tabFolder.getDisplay().getFocusControl();
                    if (focus_control != null && focus_control.getShell() != TabbedMDI.this.tabFolder.getShell()) {
                        return;
                    }
                    int key = event2.character;
                    if ((event2.stateMask & SWT.MOD1) != 0 && event2.character <= '\u001a' && event2.character > '\u0000') {
                        key += 96;
                    }
                    if (key == 27 || event2.keyCode == 0x100000D && event2.stateMask == 262144) {
                        MdiEntry entry = TabbedMDI.this.getCurrentEntry();
                        if (entry != null) {
                            entry.close(false);
                        }
                        event2.doit = false;
                    } else if (event2.keyCode == 0x100000F || event2.character == '\t' && (event2.stateMask & 0x40000) != 0) {
                        if ((event2.stateMask & 0x20000) == 0) {
                            event2.doit = false;
                            TabbedMDI.this.selectNextTab(true);
                        } else if (event2.stateMask == 131072) {
                            TabbedMDI.this.selectNextTab(false);
                            event2.doit = false;
                        }
                    }
                }
            });
        }
        this.tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TabbedMDI.this.saveCloseables();
            }
        });
        this.tabFolder.getTabHeight();
        final Menu menu = new Menu((Control)this.tabFolder);
        this.tabFolder.setMenu(menu);
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu root_menu, MenuEvent event2) {
                Point cursorLocation = event2.display.getCursorLocation();
                Point ptOnControl = TabbedMDI.this.tabFolder.toControl(cursorLocation.x, cursorLocation.y);
                if (ptOnControl.y > TabbedMDI.this.tabFolder.getTabHeight()) {
                    return;
                }
                CTabItem item = TabbedMDI.this.tabFolder.getItem(TabbedMDI.this.tabFolder.toControl(cursorLocation.x, cursorLocation.y));
                boolean need_sep = false;
                if (item == null) {
                    boolean bl = need_sep = TabbedMDI.this.mapUserClosedTabs.size() > 0;
                    if (need_sep) {
                        for (Object id : TabbedMDI.this.mapUserClosedTabs.keySet()) {
                            final String view_id = (String)id;
                            MenuItem mi = new MenuItem(menu, 8);
                            Object oTitle = TabbedMDI.this.mapUserClosedTabs.get(id);
                            String title = oTitle instanceof String && ((String)oTitle).length() > 0 ? (String)oTitle : MessageText.getString(TabbedMDI.this.getViewTitleID(view_id));
                            mi.setText(title);
                            mi.addListener(13, new Listener(){

                                public void handleEvent(Event event2) {
                                    String key = TabbedMDI.this.props_prefix + ".closedtabs";
                                    Map closedtabs = COConfigurationManager.getMapParameter(key, new HashMap());
                                    if (closedtabs.containsKey(view_id)) {
                                        closedtabs.remove(view_id);
                                        COConfigurationManager.setParameter(key, closedtabs);
                                    }
                                    TabbedMDI.this.showEntryByID(view_id);
                                }
                            });
                        }
                    }
                }
                if (need_sep) {
                    new MenuItem(menu, 2);
                }
                TabbedEntry entry = null;
                if (item != null) {
                    entry = TabbedMDI.this.getEntryFromTabItem(item);
                    TabbedMDI.this.showEntry(entry);
                }
                TabbedMDI.this.fillMenu(menu, entry, TabbedMDI.this.isMainMDI ? "sidebar" : TabbedMDI.this.props_prefix);
            }
        });
        CTabFolderRenderer renderer = new CTabFolderRenderer(this.tabFolder){

            protected Point computeSize(int part, int state, GC gc, int wHint, int hHint) {
                TabbedEntry entry;
                gc.setAntialias(1);
                Point pt = super.computeSize(part, state, gc, wHint, hHint);
                if (TabbedMDI.this.tabFolder.isDisposed()) {
                    return pt;
                }
                if (part >= 0 && (entry = TabbedMDI.this.getEntryFromTabItem(TabbedMDI.this.tabFolder.getItem(part))) != null) {
                    Object titleRight;
                    ViewTitleInfo viewTitleInfo = entry.getViewTitleInfo();
                    if (viewTitleInfo != null && (titleRight = viewTitleInfo.getTitleInfoProperty(0)) != null) {
                        Point size = gc.textExtent(titleRight.toString(), 0);
                        pt.x += size.x + 10 + 2;
                    }
                    MdiEntryVitalityImage[] vitalityImages = entry.getVitalityImages();
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    for (MdiEntryVitalityImage mdiEntryVitalityImage : vitalityImages) {
                        String imageID;
                        Image image;
                        if (mdiEntryVitalityImage == null || !mdiEntryVitalityImage.isVisible() || !ImageLoader.isRealImage(image = imageLoader.getImage(imageID = mdiEntryVitalityImage.getImageID()))) continue;
                        pt.x += image.getBounds().x + 5;
                    }
                }
                return pt;
            }

            protected void draw(int part, int state, Rectangle bounds, GC gc) {
                block14: {
                    try {
                        super.draw(part, state, bounds, gc);
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                    if (part < 0) {
                        return;
                    }
                    try {
                        Object titleRight;
                        CTabItem item = TabbedMDI.this.getTabFolder().getItem(part);
                        TabbedEntry entry = TabbedMDI.this.getEntryFromTabItem(item);
                        if (entry == null) {
                            return;
                        }
                        ViewTitleInfo viewTitleInfo = entry.getViewTitleInfo();
                        if (viewTitleInfo == null || (titleRight = viewTitleInfo.getTitleInfoProperty(0)) == null) break block14;
                        String textIndicator = titleRight.toString();
                        int x1IndicatorOfs = 0;
                        int SIDEBAR_SPACING = 0;
                        int x2 = bounds.x + bounds.width;
                        if (item.getShowClose()) {
                            try {
                                Field fldCloseRect = item.getClass().getDeclaredField("closeRect");
                                fldCloseRect.setAccessible(true);
                                Rectangle closeBounds = (Rectangle)fldCloseRect.get(item);
                                if (closeBounds != null && closeBounds.x > 0) {
                                    x2 = closeBounds.x;
                                }
                            }
                            catch (Exception e) {
                                x2 -= 20;
                            }
                        }
                        gc.setAntialias(1);
                        Point textSize = gc.textExtent(textIndicator);
                        int width = textSize.x + 10;
                        int startX = x2 - (x1IndicatorOfs += width + SIDEBAR_SPACING);
                        int textOffsetY = 0;
                        int height = textSize.y + 1;
                        int startY = bounds.y + (bounds.height - height) / 2 + 1;
                        Color default_color = ColorCache.getSchemedColor(gc.getDevice(), "#5b6e87");
                        Object color = viewTitleInfo.getTitleInfoProperty(8);
                        if (color instanceof int[]) {
                            gc.setBackground(ColorCache.getColor(gc.getDevice(), (int[])color));
                        } else {
                            gc.setBackground(default_color);
                        }
                        Color text_color = Colors.white;
                        gc.fillRoundRectangle(startX, startY, width, height, textSize.y * 2 / 3, height * 2 / 3);
                        if (color != null) {
                            int blue;
                            int green;
                            Color bg = gc.getBackground();
                            int red = bg.getRed();
                            double brightness = Math.sqrt((double)(red * red) * 0.299 + (double)((green = bg.getGreen()) * green) * 0.587 + (double)((blue = bg.getBlue()) * blue) * 0.114);
                            if (brightness >= 130.0) {
                                text_color = Colors.black;
                            }
                            gc.setBackground(default_color);
                            gc.drawRoundRectangle(startX, startY, width, height, textSize.y * 2 / 3, height * 2 / 3);
                        }
                        gc.setForeground(text_color);
                        GCStringPrinter.printString(gc, textIndicator, new Rectangle(startX, startY + textOffsetY, width, height), true, false, 0x1000000);
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                }
            }
        };
        this.tabFolder.setRenderer(renderer);
        if (this.minimizeVisible) {
            boolean toMinimize = ConfigurationManager.getInstance().getBooleanParameter(this.props_prefix + ".subViews.minimized");
            this.setMinimized(toMinimize);
        }
    }

    private String getViewTitleID(String view_id) {
        String history_key = "swt.ui.table.tab.view.namecache." + view_id;
        String id = COConfigurationManager.getStringParameter(history_key, "");
        if (id.length() == 0) {
            String test = view_id + ".title.full";
            if (MessageText.keyExists(test)) {
                return test;
            }
            id = "!" + view_id + "!";
        }
        return id;
    }

    private void minimize() {
        this.minimized = true;
        this.tabFolder.setMinimized(true);
        CTabItem[] items = this.tabFolder.getItems();
        String tt = MessageText.getString("label.click.to.restore");
        for (int i = 0; i < items.length; ++i) {
            CTabItem tabItem = items[i];
            tabItem.setToolTipText(tt);
            Control control = tabItem.getControl();
            if (control == null || control.isDisposed()) continue;
            tabItem.getControl().setVisible(false);
        }
        this.tabFolder.getParent().notifyListeners(11, null);
        this.showEntry(null);
        ConfigurationManager configMan = ConfigurationManager.getInstance();
        configMan.setParameter(this.props_prefix + ".subViews.minimized", true);
    }

    private void restore() {
        this.minimized = false;
        this.tabFolder.setMinimized(false);
        CTabItem selection = this.tabFolder.getSelection();
        if (selection != null) {
            TabbedEntry tabbedEntry = this.getEntryFromTabItem(selection);
            this.showEntry(tabbedEntry);
            tabbedEntry.updateUI();
        }
        if (this.tabFolder.getMaximizeVisible()) {
            CTabItem[] items = this.tabFolder.getItems();
            String tt = MessageText.getString("label.dblclick.to.min");
            for (int i = 0; i < items.length; ++i) {
                CTabItem tabItem = items[i];
                tabItem.setToolTipText(tt);
            }
        }
        this.tabFolder.getParent().notifyListeners(11, null);
        ConfigurationManager configMan = ConfigurationManager.getInstance();
        configMan.setParameter(this.props_prefix + ".subViews.minimized", false);
    }

    private void selectNextTab(boolean selectNext) {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        int nextOrPrevious = selectNext ? 1 : -1;
        int index = this.tabFolder.getSelectionIndex() + nextOrPrevious;
        if (index == 0 && selectNext || index == -2 || this.tabFolder.getItemCount() < 2) {
            return;
        }
        if (index == this.tabFolder.getItemCount()) {
            index = 0;
        } else if (index < 0) {
            index = this.tabFolder.getItemCount() - 1;
        }
        CTabItem item = this.tabFolder.getItem(index);
        TabbedEntry entry = this.getEntryFromTabItem(item);
        if (entry != null) {
            this.showEntry(entry);
        }
    }

    protected boolean wasEntryLoadedOnce(String id) {
        boolean loadedOnce = COConfigurationManager.getBooleanParameter("tab.once." + id, false);
        return loadedOnce;
    }

    protected void setEntryLoadedOnce(String id) {
        COConfigurationManager.setParameter("tab.once." + id, true);
    }

    public void showEntry(MdiEntry newEntry) {
        MdiEntrySWT oldEntry;
        if (newEntry == null) {
            return;
        }
        if (newEntry != null) {
            this.select_history.remove(newEntry);
            this.select_history.add(newEntry);
            if (this.select_history.size() > 64) {
                this.select_history.removeFirst();
            }
        }
        if (newEntry == (oldEntry = this.currentEntry) && oldEntry != null) {
            ((BaseMdiEntry)newEntry).show();
            this.triggerSelectionListener(newEntry, newEntry);
            return;
        }
        if (oldEntry != null) {
            oldEntry.hide();
        }
        this.currentEntry = (MdiEntrySWT)newEntry;
        if (this.currentEntry instanceof BaseMdiEntry) {
            ((BaseMdiEntry)newEntry).show();
        }
        this.triggerSelectionListener(newEntry, oldEntry);
    }

    private MdiEntry createEntryFromSkinRef(String parentID, String id, String configID, String title, ViewTitleInfo titleInfo, Object params, boolean closeable, int index) {
        MdiEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id, null);
        entry.setTitle(title);
        entry.setSkinRef(configID, params);
        entry.setViewTitleInfo(titleInfo);
        this.setupNewEntry(entry, id, index, closeable);
        return entry;
    }

    public MdiEntry createEntryFromSkinRef(String parentID, String id, String configID, String title, ViewTitleInfo titleInfo, Object params, boolean closeable, String preferedAfterID) {
        return this.createEntryFromSkinRef(parentID, id, configID, title, titleInfo, params, closeable, "".equals(preferedAfterID) ? 0 : -1);
    }

    public MdiEntry createEntryFromEventListener(String parentEntryID, String parentViewID, UISWTViewEventListener l, String id, boolean closeable, Object datasource, String preferredAfterID) {
        if (this.isEntryClosedByUser(id)) {
            return null;
        }
        MdiEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id, parentViewID);
        try {
            entry.setEventListener(l, true);
        }
        catch (UISWTViewEventCancelledException e) {
            entry.close(true);
            return null;
        }
        entry.setDatasource(datasource);
        entry.setPreferredAfterID(preferredAfterID);
        this.setupNewEntry(entry, id, -1, closeable);
        if (l instanceof IViewAlwaysInitialize) {
            entry.build();
        }
        return entry;
    }

    private boolean isEntryClosedByUser(String id) {
        return this.mapUserClosedTabs.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupNewEntry(final TabbedEntry entry, final String id, final int index, boolean closeable) {
        Map map = this.mapIdToEntry;
        synchronized (map) {
            this.mapIdToEntry.put(id, entry);
        }
        entry.setCloseable(closeable);
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                TabbedMDI.this.swt_setupNewEntry(entry, id, index);
            }
        });
    }

    private void swt_setupNewEntry(TabbedEntry entry, String id, int index) {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        if (index < 0 || index >= this.tabFolder.getItemCount()) {
            index = this.tabFolder.getItemCount();
        }
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0, index);
        cTabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TabbedMDI.this.tabFolder.getItemCount() == 0) {
                    TabbedMDI.this.currentEntry = null;
                }
            }
        });
        cTabItem.setData("TabbedEntry", (Object)entry);
        entry.setSwtItem(cTabItem);
        if (this.tabFolder.getItemCount() == 1) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    if (TabbedMDI.this.currentEntry != null || TabbedMDI.this.tabFolder.isDisposed()) {
                        return;
                    }
                    CTabItem selection = TabbedMDI.this.tabFolder.getSelection();
                    if (selection == null) {
                        return;
                    }
                    TabbedEntry entry = TabbedMDI.this.getEntryFromTabItem(selection);
                    TabbedMDI.this.showEntry(entry);
                }
            });
        }
    }

    private TabbedEntry getEntryFromTabItem(CTabItem item) {
        if (item.isDisposed()) {
            return null;
        }
        return (TabbedEntry)item.getData("TabbedEntry");
    }

    public String getUpdateUIName() {
        String name = "MDI";
        MdiEntry entry = this.getCurrentEntry();
        if (entry != null) {
            name = name + "-" + entry.getId();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        MdiEntrySWT[] entries;
        for (MdiEntrySWT entry : entries = this.getEntriesSWT()) {
            Object var9_8;
            if (entry == null || entry instanceof AEDiagnosticsEvidenceGenerator) continue;
            writer.println("TabbedMdi View (No Generator): " + entry.getId());
            try {
                try {
                    writer.indent();
                    writer.println("Parent: " + entry.getParentID());
                    writer.println("Title: " + entry.getTitle());
                }
                catch (Exception e) {
                    var9_8 = null;
                    writer.exdent();
                    continue;
                }
                var9_8 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                writer.exdent();
                throw throwable;
            }
        }
    }

    public MdiEntrySWT getEntryFromSkinObject(PluginUISWTSkinObject pluginSkinObject) {
        if (pluginSkinObject instanceof SWTSkinObject) {
            for (Control control = ((SWTSkinObject)pluginSkinObject).getControl(); control != null && !control.isDisposed(); control = control.getParent()) {
                Object entry = control.getData("BaseMDIEntry");
                if (!(entry instanceof BaseMdiEntry)) continue;
                BaseMdiEntry mdiEntry = (BaseMdiEntry)entry;
                return mdiEntry;
            }
        }
        return null;
    }

    public MdiEntry createHeader(String id, String title, String preferredAfterID) {
        return null;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void setMaximizeVisible(final boolean visible) {
        this.maximizeVisible = visible;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TabbedMDI.this.tabFolder == null || TabbedMDI.this.tabFolder.isDisposed()) {
                    return;
                }
                TabbedMDI.this.tabFolder.setMaximizeVisible(visible);
            }
        });
    }

    public void setMinimizeVisible(final boolean visible) {
        this.minimizeVisible = visible;
        if (this.minimizeVisible) {
            boolean toMinimize = ConfigurationManager.getInstance().getBooleanParameter(this.props_prefix + ".subViews.minimized");
            this.setMinimized(toMinimize);
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TabbedMDI.this.tabFolder == null || TabbedMDI.this.tabFolder.isDisposed()) {
                    return;
                }
                TabbedMDI.this.tabFolder.setMinimizeVisible(visible);
            }
        });
    }

    public boolean getMinimized() {
        return this.minimized;
    }

    public void setMinimized(final boolean minimized) {
        this.minimized = minimized;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TabbedMDI.this.tabFolder == null || TabbedMDI.this.tabFolder.isDisposed()) {
                    return;
                }
                if (minimized) {
                    TabbedMDI.this.minimize();
                } else {
                    TabbedMDI.this.restore();
                }
            }
        });
    }

    public int getFolderHeight() {
        return this.iFolderHeightAdj;
    }

    public Object dataSourceChanged(SWTSkinObject skinObject, final Object ds) {
        Utils.execSWTThread(new Runnable(){

            public void run() {
                Object[] temp;
                if (TabbedMDI.this.tabFolder == null || TabbedMDI.this.tabFolder.isDisposed()) {
                    return;
                }
                if (ds instanceof Object[] && (temp = (Object[])ds).length == 1) {
                    Object obj = temp[0];
                    if (obj instanceof DownloadManager) {
                        TabbedMDI.this.maximizeTo = (DownloadManager)obj;
                    } else if (obj instanceof Download) {
                        TabbedMDI.this.maximizeTo = PluginCoreUtils.unwrap((Download)obj);
                    }
                }
                TabbedMDI.this.setMaximizeVisible(TabbedMDI.this.maximizeTo != null);
            }
        });
        return super.dataSourceChanged(skinObject, ds);
    }

    public void parameterChanged(String parameterName) {
        if (this.isDisposed()) {
            return;
        }
        this.mapUserClosedTabs = COConfigurationManager.getMapParameter(parameterName, new HashMap());
        for (Object id : this.mapUserClosedTabs.keySet()) {
            String view_id = (String)id;
            if (!this.entryExists(view_id)) continue;
            this.closeEntry(view_id);
        }
    }

    public void setTabbedMdiMaximizeListener(TabbedMdiMaximizeListener l) {
        this.maximizeListener = l;
    }
}

